/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.ttc7.MAREngine;

public class TTCItem
extends DBItem {
    public final boolean DEBUG_TTCItem = false;
    public MAREngine meg;
    private int type;

    protected TTCItem(MAREngine mAREngine, DBType dBType) {
        super(dBType.max_length);
        this.type = dBType.type;
        this.meg = mAREngine;
    }

    protected void setOriginalSize(int n) {
        this.original_size = n;
    }

    public void setArrayData(boolean bl, byte[] byArray) throws SQLException {
        this.is_null = bl;
        if (byArray != null) {
            if ((this.type == 96 || this.type == 1) && byArray.length > this.max_out_size) {
                DBError.check_error(70, new Integer(byArray.length));
            }
            this.data_size = byArray.length;
            this.byte_value = byArray;
            return;
        }
        this.byte_value = new byte[0];
        this.data_size = 0;
    }

    protected boolean isNull() {
        return this.is_null;
    }

    protected int getDataSize() {
        return this.data_size;
    }

    protected void marshal() throws IOException, SQLException {
        this.meg.marshalCLR(this.byte_value, this.data_size);
    }

    protected void marshalPLSQL() throws IOException {
        this.meg.marshalCLR(new byte[0], 0);
    }

    protected void unmarshal() throws IOException, SQLException {
        if (this.byte_value == null) {
            DBError.check_error(401);
        }
        this.original_size = 0;
        this.data_size = 0;
        this.is_null = false;
        if (this.max_out_size == 0) {
            this.is_null = true;
            return;
        }
        int[] nArray = new int[1];
        this.meg.unmarshalCLR(this, nArray);
        this.data_size = nArray[0];
        this.is_null = nArray[0] <= 0;
    }

    public void unmarshalIndicator() throws IOException, SQLException {
        this.original_size = this.meg.processIndicator(this.is_null, this.data_size);
    }

    public void print() {
        System.out.println("           ---- Enter: TTCItem.print --- ");
        System.out.println("             +++ TTCItem.DBItem  Information +++");
        System.out.print("             DBItem.byte_value is: ");
        System.out.print(this.byte_value == null ? " NULL " : "Not NULL");
        System.out.println();
        if (this.byte_value != null) {
            System.out.println("             DBItem.byte_value.length = " + this.byte_value.length);
        }
        System.out.print("             DBItem.stream_value is: ");
        System.out.print(this.stream_value == null ? " NULL " : "Not NULL");
        System.out.println();
        System.out.println("             DBItem.data_size = " + this.data_size);
        System.out.println("             DBItem.original_size = " + this.original_size);
        System.out.println("             DBItem.max_out_size = " + this.max_out_size);
        System.out.println("             +++ End of TTCItem.DBItem  Info.+++");
        System.out.println("           ---- Exit: TTCItem.print --- ");
    }
}

