/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.ttc7.TTCColumn;

public abstract class TTCDataSet {
    protected final boolean DEBUG = false;
    protected TTCColumn[] columns;
    protected int depth;
    protected int marshaledRows;
    protected int unmarshaledRows;
    protected int unmarshaledCols;

    protected TTCDataSet(TTCColumn[] tTCColumnArray, int n) {
        this.columns = tTCColumnArray != null ? tTCColumnArray : new TTCColumn[]{};
        this.depth = n;
    }

    protected void marshalTypes() throws IOException, SQLException {
        int n = 0;
        while (n < this.columns.length) {
            this.columns[n].marshalType();
            ++n;
        }
    }

    protected int numberOfColumns() {
        return this.columns.length;
    }

    public void incrementeUnmarshaledRows() {
        ++this.unmarshaledRows;
    }

    public void incrementUnmarshaledcols() {
        ++this.unmarshaledCols;
    }

    public boolean isLastCol() {
        return this.unmarshaledCols == this.columns.length - 1;
    }

    protected void print() {
        System.out.println("   ---- Enter: TTCDataSet.print --- ");
        System.out.println("     +++ Beginning of Columns Info +++++++ ");
        System.out.println("         columns.length = " + this.columns.length);
        int n = 0;
        while (n < this.columns.length) {
            System.out.println("Column # " + n);
            this.columns[n].print();
            ++n;
        }
        System.out.println("     +++ End of Columns Info +++++++ ");
        System.out.println("     TTCDataSet.depth          =" + this.depth);
        System.out.println("     TTCDataSet.marshaledRows  =" + this.marshaledRows);
        System.out.println("     TTCDataSet.unmarshaledRows=" + this.unmarshaledRows);
        System.out.println("   ---- Exit: TTCDataSet.print --- ");
    }

    protected abstract void marshalRow() throws SQLException, IOException;

    protected abstract boolean unmarshalRow() throws SQLException, IOException;

    protected boolean unmarshalRow(int n, int n2) throws SQLException, IOException {
        return false;
    }

    protected void processIndicator() throws IOException, SQLException {
    }

    protected abstract boolean next() throws SQLException, IOException;
}

