/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.PlsqlTTCColumn;
import oracle.jdbc.ttc7.TTCDataSet;

public class PlsqlTTCDataSet
extends TTCDataSet {
    private PlsqlTTCColumn[] columns;
    private byte[] userIOVector;
    private byte[] realIOVector;

    protected PlsqlTTCDataSet(PlsqlTTCColumn[] plsqlTTCColumnArray, byte[] byArray) {
        super(plsqlTTCColumnArray, plsqlTTCColumnArray.length == 0 ? 0 : 1);
        this.columns = plsqlTTCColumnArray != null ? plsqlTTCColumnArray : new PlsqlTTCColumn[]{};
        this.userIOVector = byArray;
    }

    protected void marshalRow() throws SQLException, IOException {
        if (this.realIOVector == null) {
            DBError.check_error(423);
        }
        int n = 0;
        while (n < this.realIOVector.length) {
            if ((this.realIOVector[n] & 0x20) != 0) {
                this.columns[n].marshal();
            }
            ++n;
        }
        this.marshaledRows = 1;
    }

    protected boolean unmarshalRow() throws SQLException, IOException {
        if (this.realIOVector == null) {
            DBError.check_error(423);
        }
        int n = 0;
        while (n < this.realIOVector.length) {
            if ((this.realIOVector[n] & 0x10) != 0) {
                this.columns[n].unmarshal();
            }
            ++n;
        }
        this.unmarshaledRows = 1;
        return false;
    }

    protected boolean next() {
        return this.realIOVector != null;
    }

    protected void setIOVector(byte[] byArray) {
        this.realIOVector = byArray;
    }

    protected void print() {
        int n;
        System.out.println(" \n   ---- Enter: PlsqlTTCDataSet.print --- ");
        super.print();
        System.out.println("\n      +++ userIOVector info +++++++ ");
        if (this.userIOVector == null) {
            System.out.println(" User IOVector is NULL ");
        } else {
            System.out.println("      userIOVector.length = " + this.userIOVector.length);
            n = 0;
            while (n < this.userIOVector.length) {
                System.out.println("      userIOVector[" + n + "] = " + this.userIOVector[n]);
                ++n;
            }
        }
        System.out.println("      +++ End of userIOVector Info +++++++");
        System.out.println("\n      +++ realIOVector info +++++++");
        if (this.realIOVector == null) {
            System.out.println(" Real IOVector is NULL ");
        } else {
            System.out.println("      realIOVector.length = " + this.realIOVector.length);
            n = 0;
            while (n < this.realIOVector.length) {
                System.out.println("       realIOVector[" + n + "] = " + this.realIOVector[n]);
                ++n;
            }
        }
        System.out.println("      +++ End of realIOVector Info +++++++ ");
        System.out.println("    ---- Exit: PlsqlTTCDataSet.print --- \n");
    }
}

