/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;

public class OracleDataSource
implements DataSource,
Serializable,
Referenceable {
    protected PrintWriter m_pw;
    protected int m_timeout;
    protected String m_databaseName;
    protected String m_dataSourceName;
    protected String m_description;
    protected String m_networkProtocol = "tcp";
    protected int m_portNumber;
    protected String m_user;
    protected String m_password;
    protected String m_serverName;
    protected String m_url;
    protected String m_driverType;
    protected String m_tnsentry;
    private boolean m_url_explicit = false;

    public OracleDataSource() throws SQLException {
        DriverManager.registerDriver(new OracleDriver());
        this.m_dataSourceName = "OracleDataSource";
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.m_user, this.m_password);
    }

    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        this.makeURL();
        this.trace("User us " + string + "URL is " + this.m_url);
        Connection connection = DriverManager.getConnection(this.m_url, string, string2);
        return connection;
    }

    public synchronized int getLoginTimeout() {
        return this.m_timeout;
    }

    public synchronized void setLoginTimeout(int n) {
        this.m_timeout = n;
    }

    public synchronized void setLogWriter(PrintWriter printWriter) {
        this.m_pw = printWriter;
        OracleLog.setLogWriter(printWriter);
    }

    public synchronized PrintWriter getLogWriter() {
        return this.m_pw;
    }

    public synchronized void setTNSEntryName(String string) {
        this.m_tnsentry = string;
    }

    public synchronized String getTNSEntryName() {
        return this.m_tnsentry;
    }

    public synchronized void setDataSourceName(String string) {
        this.m_dataSourceName = string;
    }

    public synchronized String getDataSourceName() {
        return this.m_dataSourceName;
    }

    public synchronized String getDatabaseName() {
        return this.m_databaseName;
    }

    public synchronized void setDatabaseName(String string) {
        this.m_databaseName = string;
    }

    public synchronized void setServerName(String string) {
        this.m_serverName = string;
    }

    public synchronized String getServerName() {
        return this.m_serverName;
    }

    public synchronized void setURL(String string) {
        this.m_url = string;
        if (this.m_url != null) {
            this.m_url_explicit = true;
        }
    }

    public synchronized String getURL() throws SQLException {
        if (!this.m_url_explicit) {
            this.makeURL();
        }
        return this.m_url;
    }

    public synchronized void setUser(String string) {
        this.m_user = string;
    }

    public synchronized String getUser() {
        return this.m_user;
    }

    public synchronized void setPassword(String string) {
        this.m_password = string;
    }

    protected synchronized String getPassword() {
        return this.m_password;
    }

    public synchronized String getDescription() {
        return this.m_description;
    }

    public synchronized void setDescription(String string) {
        this.m_description = string;
    }

    public synchronized String getDriverType() {
        return this.m_driverType;
    }

    public synchronized void setDriverType(String string) {
        this.m_driverType = string;
    }

    public synchronized String getNetworkProtocol() {
        return this.m_networkProtocol;
    }

    public synchronized void setNetworkProtocol(String string) {
        this.m_networkProtocol = string;
    }

    public synchronized void setPortNumber(int n) {
        this.m_portNumber = n;
    }

    public synchronized int getPortNumber() {
        return this.m_portNumber;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        this.addRefProperties(reference);
        return reference;
    }

    protected void addRefProperties(Reference reference) {
        if (this.m_url != null) {
            reference.add(new StringRefAddr("url", this.m_url));
        }
        if (this.m_user != null) {
            reference.add(new StringRefAddr("userName", this.m_user));
        }
        if (this.m_password != null) {
            reference.add(new StringRefAddr("passWord", this.m_password));
        }
        if (this.m_description != null) {
            reference.add(new StringRefAddr("description", this.m_description));
        }
        if (this.m_driverType != null) {
            reference.add(new StringRefAddr("driverType", this.m_driverType));
        }
        if (this.m_serverName != null) {
            reference.add(new StringRefAddr("serverName", this.m_serverName));
        }
        if (this.m_databaseName != null) {
            reference.add(new StringRefAddr("databaseName", this.m_databaseName));
        }
        if (this.m_networkProtocol != null) {
            reference.add(new StringRefAddr("networkProtocol", this.m_networkProtocol));
        }
        if (this.m_portNumber != 0) {
            reference.add(new StringRefAddr("portNumber", Integer.toString(this.m_portNumber)));
        }
        if (this.m_tnsentry != null) {
            reference.add(new StringRefAddr("tnsentryname", this.m_tnsentry));
        }
    }

    private void makeURL() throws SQLException {
        if (this.m_url_explicit) {
            return;
        }
        if (this.m_driverType == null || !this.m_driverType.equals("oci8") && !this.m_driverType.equals("thin") && !this.m_driverType.equals("kprb")) {
            DBError.check_error(67, "OracleDataSource.makeURL");
        }
        if (this.m_driverType.equals("kprb")) {
            this.m_url = "jdbc:oracle:kprb:@";
            return;
        }
        if (this.m_driverType.equals("oci8") && this.m_networkProtocol != null && this.m_networkProtocol.equals("ipc")) {
            this.m_url = "jdbc:oracle:oci8:@";
            return;
        }
        if (this.m_tnsentry != null) {
            this.m_url = "jdbc:oracle:" + this.m_driverType + ":@" + this.m_tnsentry;
            return;
        }
        this.m_url = "jdbc:oracle:" + this.m_driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.m_networkProtocol + ")(PORT=" + this.m_portNumber + ")(HOST=" + this.m_serverName + "))(CONNECT_DATA=(SID=" + this.m_databaseName + ")))";
    }

    protected void trace(String string) {
        if (this.m_pw != null) {
            OracleLog.print(null, 0xFFFFFFF, 1, 32, string);
        }
    }
}

