/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.pool.OracleConnectionCache;
import oracle.jdbc.pool.OracleConnectionEventListener;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionCacheImpl
extends OracleDataSource
implements OracleConnectionCache,
Serializable,
Referenceable {
    private ConnectionPoolDataSource m_cpds;
    private static int _DEFAULT_MIN_LIMIT;
    private static int _DEFAULT_MAX_LIMIT;
    private int _MIN_LIMIT = _DEFAULT_MIN_LIMIT;
    private int _MAX_LIMIT = _DEFAULT_MAX_LIMIT;
    private Stack m_cache = new Stack();
    private Hashtable m_activeCache = new Hashtable();
    private int m_cacheSize = 0;
    private int m_activeSize = 0;
    private int m_cacheScheme = 1;
    public static final int DYNAMIC_SCHEME = 1;
    public static final int FIXED_WAIT_SCHEME = 2;
    public static final int FIXED_RETURN_NULL_SCHEME = 3;
    private OracleConnectionEventListener m_ocel;

    public OracleConnectionCacheImpl() throws SQLException {
        this(null);
    }

    public OracleConnectionCacheImpl(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        this.m_cpds = connectionPoolDataSource;
        this.m_ocel = new OracleConnectionEventListener(this);
        this.m_dataSourceName = "OracleConnectionCacheImpl";
    }

    public void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        if (this.m_cacheSize > 0) {
            DBError.throwSqlException(78);
        }
        this.m_cpds = connectionPoolDataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.m_user, this.m_password);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        OraclePooledConnection oraclePooledConnection;
        this.trace(" getConnection() -start m_cacheSize: " + this.m_cacheSize + " m_activeSize: " + this.m_activeSize + " user: " + string);
        if (!this.m_cache.empty()) {
            this.trace(" Active Count" + this.m_activeSize);
            this.checkCredentials(string, string2);
            oraclePooledConnection = (OraclePooledConnection)this.m_cache.pop();
        } else if (this.m_cacheSize < this._MAX_LIMIT || this.m_cacheScheme == 1) {
            this.trace(" Getting a new one m_cacheSize " + this.m_cacheSize + " m_activeSize " + this.m_activeSize);
            String string3 = null;
            String string4 = null;
            if (this.m_cpds != null) {
                string3 = ((OracleConnectionPoolDataSource)this.m_cpds).getUser();
                string4 = ((OracleConnectionPoolDataSource)this.m_cpds).getPassword();
            }
            if (this.m_cacheSize > 0 && string != null && !string.equals(string3)) {
                DBError.throwSqlException(79);
            } else if (string != null) {
                this.m_user = string;
                if (this.m_cpds != null) {
                    ((OracleConnectionPoolDataSource)this.m_cpds).setUser(string);
                }
            }
            if (this.m_cacheSize > 0 && string2 != null && !string2.equals(string4)) {
                DBError.throwSqlException(79);
            } else if (string2 != null) {
                this.m_password = string2;
                if (this.m_cpds != null) {
                    ((OracleConnectionPoolDataSource)this.m_cpds).setPassword(string2);
                }
            }
            oraclePooledConnection = this.getNewPoolConnection();
            ++this.m_cacheSize;
        } else {
            if (this.m_cacheScheme == 3) {
                return null;
            }
            this.checkCredentials(string, string2);
            while (this.m_cache.empty()) {
                this.trace("Waiting...");
                Thread.currentThread();
                Thread.yield();
            }
            oraclePooledConnection = (OraclePooledConnection)this.m_cache.pop();
        }
        if (oraclePooledConnection != null) {
            oraclePooledConnection.addConnectionEventListener(this.m_ocel);
            this.m_activeCache.put(oraclePooledConnection, oraclePooledConnection);
            ++this.m_activeSize;
            return oraclePooledConnection.getConnection();
        }
        return null;
    }

    private OraclePooledConnection getNewPoolConnection() throws SQLException {
        if (this.m_cpds == null) {
            if (this.m_user == null || this.m_password == null) {
                DBError.throwSqlException(79);
            }
            this.m_cpds = new OracleConnectionPoolDataSource();
            System.out.println("Setting the user name and passwwdd " + this.m_user + "  " + this.m_password);
            ((OracleConnectionPoolDataSource)this.m_cpds).setUser(this.m_user);
            ((OracleConnectionPoolDataSource)this.m_cpds).setPassword(this.m_password);
            ((OracleConnectionPoolDataSource)this.m_cpds).setURL(this.m_url);
        }
        return (OraclePooledConnection)this.m_cpds.getPooledConnection();
    }

    public void reusePooledConnection(PooledConnection pooledConnection) throws SQLException {
        this.trace("Calling reusePooledConnection");
        --this.m_activeSize;
        pooledConnection.removeConnectionEventListener(this.m_ocel);
        this.m_activeCache.remove(pooledConnection);
        if (this.m_cacheSize > this._MAX_LIMIT && this.m_cacheScheme == 1) {
            PooledConnection pooledConnection2 = pooledConnection;
            --this.m_cacheSize;
            pooledConnection2.close();
            pooledConnection2 = null;
            return;
        }
        this.m_cache.push(pooledConnection);
    }

    public void closePooledConnection(PooledConnection pooledConnection) throws SQLException {
        this.trace("Calling closePooledConnection");
        --this.m_activeSize;
        pooledConnection.removeConnectionEventListener(this.m_ocel);
        this.m_activeCache.remove(pooledConnection);
        PooledConnection pooledConnection2 = pooledConnection;
        --this.m_cacheSize;
        pooledConnection2.close();
        pooledConnection2 = null;
    }

    private void detachSingleConnection(PooledConnection pooledConnection) {
        --this.m_activeSize;
        pooledConnection.removeConnectionEventListener(this.m_ocel);
        this.m_activeCache.remove(pooledConnection);
    }

    private void closeSingleConnection(PooledConnection pooledConnection) throws SQLException {
        --this.m_cacheSize;
        pooledConnection.close();
        pooledConnection = null;
    }

    public void close() throws SQLException {
        this.trace(" Close - start - Active Cache Size is " + this.m_activeSize + " Cache Size is " + this.m_cacheSize + " Cache Empty : " + this.m_cache.empty());
        Enumeration enumeration = this.m_activeCache.keys();
        while (enumeration.hasMoreElements()) {
            OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)enumeration.nextElement();
            OraclePooledConnection oraclePooledConnection2 = (OraclePooledConnection)this.m_activeCache.get(oraclePooledConnection);
            this.reusePooledConnection(oraclePooledConnection2);
        }
        while (!this.m_cache.empty()) {
            OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)this.m_cache.pop();
            --this.m_cacheSize;
            oraclePooledConnection.close();
            oraclePooledConnection = null;
        }
        this.m_cache = null;
        this.m_activeCache = null;
    }

    public void setMinLimit(int n) throws SQLException {
        if (n < 0 || n > this._MAX_LIMIT) {
            DBError.throwSqlException(68);
        }
        this._MIN_LIMIT = n;
        if (this.m_cacheSize < this._MIN_LIMIT) {
            int n2 = this.m_cacheSize;
            while (n2 < this._MIN_LIMIT) {
                OraclePooledConnection oraclePooledConnection = this.getNewPoolConnection();
                this.m_cache.push(oraclePooledConnection);
                ++n2;
            }
            this.m_cacheSize = this._MIN_LIMIT;
        }
    }

    public int getMinLimit() {
        return this._MIN_LIMIT;
    }

    public void setMaxLimit(int n) throws SQLException {
        if (n < 0 || n < this._MIN_LIMIT) {
            DBError.throwSqlException(68);
        }
        this._MAX_LIMIT = n;
        if (this.m_cacheSize > this._MAX_LIMIT && this.m_cacheScheme != 1) {
            int n2 = this._MAX_LIMIT;
            while (n2 < this.m_cacheSize) {
                if (this.m_cache.empty()) {
                    DBError.throwSqlException(78);
                } else {
                    ((OraclePooledConnection)this.m_cache.pop()).close();
                }
                ++n2;
            }
            this.m_cacheSize = this._MAX_LIMIT;
        }
    }

    public int getMaxLimit() {
        return this._MAX_LIMIT;
    }

    public int getCacheScheme() {
        return this.m_cacheScheme;
    }

    public void setCacheScheme(int n) throws SQLException {
        if (n == 1 || n == 3 || n == 2) {
            this.m_cacheScheme = n;
            return;
        }
        DBError.throwSqlException(68);
    }

    public int getActiveSize() {
        return this.m_activeSize;
    }

    public int getCacheSize() {
        return this.m_cacheSize;
    }

    private void checkCredentials(String string, String string2) throws SQLException {
        String string3 = null;
        String string4 = null;
        if (this.m_cpds != null) {
            string3 = ((OracleConnectionPoolDataSource)this.m_cpds).getUser();
            string4 = ((OracleConnectionPoolDataSource)this.m_cpds).getPassword();
        }
        if (string != null && !string.equals(string3) || string2 != null && !string2.equals(string4)) {
            this.trace("Cannot create a connection with user as " + string + " as it is doesnt match the existing user " + this.m_user + " Or the Password");
            DBError.throwSqlException(79);
        }
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        super.addRefProperties(reference);
        if (this._MIN_LIMIT != _DEFAULT_MIN_LIMIT) {
            reference.add(new StringRefAddr("minLimit", Integer.toString(this._MIN_LIMIT)));
        }
        if (this._MAX_LIMIT != _DEFAULT_MAX_LIMIT) {
            reference.add(new StringRefAddr("maxLimit", Integer.toString(this._MAX_LIMIT)));
        }
        if (this.m_cacheScheme != 1) {
            reference.add(new StringRefAddr("cacheScheme", Integer.toString(this.m_cacheScheme)));
        }
        return reference;
    }

    static {
        _DEFAULT_MAX_LIMIT = 10;
    }
}

