/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;

public class Util {
    public static final boolean DEBUG = false;
    private static int[] LDSRoundtab;

    static void check_next_byte(InputStream inputStream, byte by) throws SQLException {
        try {
            if (inputStream.read() != by) {
                if (OracleLog.TRACE) {
                    OracleLog.print(null, 1, 4, 16, "DBError.check_error(errNum=" + 47 + ", obj=" + "parseTDS" + ")");
                }
                DBError.throwSqlException(47, "parseTDS");
                return;
            }
        }
        catch (IOException iOException) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, 1, 4, 16, "DBError.check_error(e)");
            }
            DBError.throwSqlException(iOException);
        }
    }

    public static int[] toJavaUnsignedBytes(byte[] byArray) {
        int n = byArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = byArray[n2] < 0 ? byArray[n2] + 256 : byArray[n2];
            ++n2;
        }
        return nArray;
    }

    public static void printByteArrayDec(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            System.out.print(String.valueOf(byArray[n2]) + " ");
            ++n2;
        }
        System.out.println();
    }

    public static void printLongArrayDec(long[] lArray) {
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            System.out.print(String.valueOf(lArray[n2]) + " ");
            ++n2;
        }
        System.out.println();
    }

    public static void printByteArray(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            System.out.print("0x" + Integer.toHexString(byArray[n2]) + " ");
            ++n2;
        }
        System.out.println();
        n2 = 0;
        while (n2 < n) {
            System.out.print(String.valueOf(byArray[n2]) + " ");
            ++n2;
        }
        System.out.println();
    }

    public static void printUnsignedByteArray(byte[] byArray) {
        int n = byArray.length;
        int[] nArray = Util.toJavaUnsignedBytes(byArray);
        int n2 = 0;
        while (n2 < n) {
            System.out.print("0x" + Integer.toHexString(nArray[n2]) + " ");
            ++n2;
        }
        System.out.println();
        n2 = 0;
        while (n2 < n) {
            System.out.print(String.valueOf(nArray[n2]) + " ");
            ++n2;
        }
        System.out.println();
    }

    static byte[] read_bytes(InputStream inputStream, int n) throws SQLException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        try {
            n2 = inputStream.read(byArray);
        }
        catch (IOException iOException) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, 1, 4, 16, "DBError.check_error(e)");
            }
            DBError.throwSqlException(iOException);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    static void write_bytes(OutputStream outputStream, byte[] byArray) throws SQLException {
        try {
            outputStream.write(byArray);
            return;
        }
        catch (IOException iOException) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, 1, 4, 16, "DBError.check_error(e)");
            }
            DBError.throwSqlException(iOException);
            return;
        }
    }

    static void skip_bytes(InputStream inputStream, int n) throws SQLException {
        try {
            int n2 = 0;
            while (n2 < n) {
                inputStream.read();
                ++n2;
            }
            return;
        }
        catch (IOException iOException) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, 1, 4, 16, "DBError.check_error(e)");
            }
            DBError.throwSqlException(iOException);
            return;
        }
    }

    static long read_long(InputStream inputStream) throws SQLException {
        long l = 0L;
        try {
            l = ((inputStream.read() * 256 + inputStream.read()) * 256 + inputStream.read()) * 256 + inputStream.read();
        }
        catch (IOException iOException) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, 1, 4, 16, "DBError.check_error(e)");
            }
            DBError.throwSqlException(iOException);
        }
        return l;
    }

    static short read_short(InputStream inputStream) throws SQLException {
        int n = 0;
        try {
            n = inputStream.read() * 256 + inputStream.read();
        }
        catch (IOException iOException) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, 1, 4, 16, "DBError.check_error(e)");
            }
            DBError.throwSqlException(iOException);
        }
        return (short)n;
    }

    static byte read_byte(InputStream inputStream) throws SQLException {
        int n = 0;
        try {
            n = inputStream.read();
        }
        catch (IOException iOException) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, 1, 4, 16, "DBError.check_error(e)");
            }
            DBError.throwSqlException(iOException);
        }
        return (byte)n;
    }

    public static void write_long(OutputStream outputStream, long l) {
        try {
            outputStream.write((byte)(l / 0x1000000L));
            l -= l / 0x1000000L;
            outputStream.write((byte)(l / 65536L));
            l -= l / 65536L;
            outputStream.write((byte)(l / 256L));
            l -= l / 256L;
            outputStream.write((byte)l);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void write_short(OutputStream outputStream, short s) {
        try {
            outputStream.write((byte)(s / 256));
            s = (short)(s - s / 256);
            outputStream.write((byte)s);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    static void write_long(byte[] byArray, int n, long l) {
        byArray[n] = (byte)(l / 0x1000000L);
        l -= l / 0x1000000L;
        byArray[n + 1] = (byte)(l / 65536L);
        l -= l / 65536L;
        byArray[n + 2] = (byte)(l / 256L);
        l -= l / 256L;
        byArray[n + 3] = (byte)l;
    }

    static void write_short(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 / 256);
        n2 -= n2 / 256;
        byArray[n + 1] = (byte)n2;
    }

    static void write_byte(OutputStream outputStream, byte by) {
        try {
            outputStream.write(by);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    static byte FDO_get_size(byte[] byArray, int n) {
        byte by = Util.FDO_get_entry(byArray, n);
        return (byte)(by >> 3 & 0x1F);
    }

    static byte FDO_get_align(byte[] byArray, int n) {
        byte by = Util.FDO_get_entry(byArray, n);
        return (byte)(by & 7);
    }

    static int LDSRound(int n, int n2) {
        int n3 = LDSRoundtab[n2];
        return (n >> n3) + 1 << n3;
    }

    private static byte FDO_get_entry(byte[] byArray, int n) {
        byte by = byArray[6 + byArray[5] + n];
        return by;
    }

    public static short getUnsignedByte(byte by) {
        if (by < 0) {
            return (short)(by + 256);
        }
        return by;
    }

    public static byte[] serializeObject(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserializeObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return new ObjectInputStream(byteArrayInputStream).readObject();
    }

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[3] = 2;
        nArray[7] = 3;
        LDSRoundtab = nArray;
    }
}

