/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleVSPatch;
import oracle.jdbc.oracore.PatchList;
import oracle.jdbc.oracore.Util;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.STRUCT;

public final class UnpickleContext {
    public static boolean DEBUG;
    public InputStream data_stream;
    public long data_offset;
    public long pickled_data_offset;
    public boolean[] null_bytes;
    public PatchList patch_list;
    public long[] lds_offset_array;
    public boolean big_endian;
    public long current_var_data_offset;

    public UnpickleContext() {
    }

    public UnpickleContext(InputStream inputStream, boolean[] blArray, long[] lArray, boolean bl) {
        this.big_endian = bl;
        this.data_stream = inputStream;
        this.null_bytes = blArray;
        this.patch_list = new PatchList();
        this.lds_offset_array = lArray;
    }

    public byte read_byte() throws SQLException {
        byte[] byArray = this.read_bytes(1);
        return byArray[0];
    }

    public byte[] read_bytes(int n) throws SQLException {
        byte[] byArray = new byte[n];
        this.data_offset += (long)n;
        try {
            this.data_stream.read(byArray);
        }
        catch (IOException iOException) {
            DBError.check_error(iOException);
        }
        return byArray;
    }

    public long read_long() throws SQLException {
        this.data_offset += 4L;
        return Util.read_long(this.data_stream);
    }

    public short read_short() throws SQLException {
        this.data_offset += 2L;
        return Util.read_short(this.data_stream);
    }

    public void skip_to(long l) throws SQLException {
        try {
            if (l > this.data_offset) {
                this.data_stream.skip(l - this.data_offset);
                this.data_offset = l;
                return;
            }
        }
        catch (IOException iOException) {
            DBError.check_error(iOException);
        }
    }

    public boolean is_null(int n) {
        return this.null_bytes[n];
    }

    public void add_patch(long l, Datum datum, int n) {
        OracleVSPatch oracleVSPatch = new OracleVSPatch((int)l, datum, n, null);
        this.patch_list.addElement(oracleVSPatch);
    }

    public void add_patch(long l, Datum datum, OracleTypeADT oracleTypeADT) {
        OracleVSPatch oracleVSPatch = new OracleVSPatch((int)l, datum, 0, oracleTypeADT);
        this.patch_list.addElement(oracleVSPatch);
    }

    public void apply_patches() throws SQLException {
        if (!this.patch_list.list.isEmpty()) {
            int n = this.patch_list.list.size();
            int n2 = 0;
            while (n2 < n) {
                OracleVSPatch oracleVSPatch = (OracleVSPatch)this.patch_list.list.elementAt(n2);
                this.apply_patches_per_type(oracleVSPatch);
                ++n2;
            }
        }
    }

    public void apply_patches_per_type(OracleVSPatch oracleVSPatch) throws SQLException {
        if (oracleVSPatch.data_container instanceof CHAR || oracleVSPatch.data_container instanceof RAW) {
            this.skip_to(oracleVSPatch.logical_offset);
            this.data_offset += 4L;
            long l = Util.read_long(this.data_stream);
            oracleVSPatch.data_container.setBytes(this.read_bytes((int)l));
            oracleVSPatch.data_container.getBytes();
            return;
        }
        if (oracleVSPatch.data_container instanceof BFILE || oracleVSPatch.data_container instanceof BLOB || oracleVSPatch.data_container instanceof CLOB || oracleVSPatch.data_container instanceof REF) {
            this.skip_to(oracleVSPatch.logical_offset);
            byte[] byArray = this.read_bytes(2);
            long l = byArray[0] * 256 + byArray[1];
            byte[] byArray2 = this.read_bytes((int)l);
            byte[] byArray3 = new byte[2 + (int)l];
            byArray3[0] = byArray[0];
            byArray3[1] = byArray[1];
            System.arraycopy(byArray2, 0, byArray3, 2, (int)l);
            oracleVSPatch.data_container.setBytes(byArray3);
            return;
        }
        if (oracleVSPatch.data_container instanceof ARRAY) {
            this.skip_to(oracleVSPatch.logical_offset);
            ((OracleTypeCOLLECTION)oracleVSPatch.type).simpleUnpickle(this, (ARRAY)oracleVSPatch.data_container);
            return;
        }
        if (oracleVSPatch.data_container instanceof STRUCT) {
            this.skip_to(oracleVSPatch.logical_offset);
            oracleVSPatch.type.simpleUnpickle(this, (STRUCT)oracleVSPatch.data_container);
        }
    }
}

