/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeUPT;
import oracle.jdbc.oracore.Util;

public class StreamInfo {
    int null_offset = 0;
    int lds_offset = 0;
    long fixed_data_size = 0L;
    long currentPos = 0L;
    InputStream stream;
    Vector patchNormalPos;
    Vector patchType;
    Vector patchSimplePos;
    Vector patchNormalStyle;

    StreamInfo(InputStream inputStream) {
        this.stream = inputStream;
        this.patchNormalPos = new Vector();
        this.patchType = new Vector();
        this.patchSimplePos = new Vector();
        this.patchNormalStyle = new Vector();
    }

    void skipBytes(int n) throws SQLException {
        this.currentPos += (long)n;
        Util.skip_bytes(this.stream, n);
    }

    void checkNextByte(byte by) throws SQLException {
        ++this.currentPos;
        Util.check_next_byte(this.stream, by);
    }

    byte readByte() throws SQLException {
        ++this.currentPos;
        return Util.read_byte(this.stream);
    }

    short readShort() throws SQLException {
        this.currentPos += 2L;
        return Util.read_short(this.stream);
    }

    long readLong() throws SQLException {
        this.currentPos += 4L;
        return Util.read_long(this.stream);
    }

    void addNormalPatch(long l, byte by, OracleType oracleType) {
        this.patchNormalPos.addElement(new Long(l));
        this.patchType.addElement(oracleType);
        this.patchSimplePos.addElement(null);
        this.patchNormalStyle.addElement(new Integer(by));
    }

    void addSimplePatch(long l, OracleType oracleType) {
        this.patchSimplePos.addElement(new Long(l));
        this.patchType.addElement(oracleType);
        this.patchNormalPos.addElement(null);
        this.patchNormalStyle.addElement(null);
    }

    void Patch(long l, OracleType oracleType) {
        this.Patch(l, oracleType, -1);
    }

    void Patch(long l, OracleType oracleType, int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.patchNormalPos.size()) {
            OracleTypeADT oracleTypeADT;
            Long l2;
            long l3 = 0L;
            long l4 = 0L;
            if (this.patchNormalPos.elementAt(n2) != null && (l4 = (l2 = (Long)this.patchNormalPos.elementAt(n2)).longValue()) == l) {
                bl = true;
                oracleTypeADT = (OracleTypeUPT)this.patchType.elementAt(n2);
                oracleTypeADT.elementType = oracleType;
                this.patchNormalPos.setElementAt(null, n2);
            }
            if (this.patchSimplePos.elementAt(n2) != null && (l3 = (l2 = (Long)this.patchSimplePos.elementAt(n2)).longValue()) == l) {
                bl = true;
                oracleTypeADT = (OracleTypeCOLLECTION)this.patchType.elementAt(n2);
                oracleTypeADT.opcode = n;
                ((OracleTypeCOLLECTION)oracleTypeADT).elementType = oracleType;
                this.patchSimplePos.setElementAt(null, n2);
            }
            ++n2;
        }
    }

    int numberOfPatches() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.patchSimplePos.size()) {
            if (this.patchNormalPos.elementAt(n2) != null || this.patchSimplePos.elementAt(n2) != null) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    byte getUPTStyle(long l) {
        int n = 0;
        while (n < this.patchNormalPos.size()) {
            Long l2;
            long l3;
            if (this.patchNormalPos.elementAt(n) != null && (l3 = (l2 = (Long)this.patchNormalPos.elementAt(n)).longValue()) == l) {
                Integer n2 = (Integer)this.patchNormalStyle.elementAt(n);
                return (byte)n2.intValue();
            }
            ++n;
        }
        return 0;
    }

    long getNextPatchPos() {
        long l = -1L;
        int n = 0;
        while (n < this.patchSimplePos.size()) {
            long l2;
            Long l3;
            long l4;
            if (this.patchNormalPos.elementAt(n) != null && ((l4 = (l3 = (Long)this.patchNormalPos.elementAt(n)).longValue()) < l || l == -1L)) {
                l = l4;
            }
            if (this.patchSimplePos.elementAt(n) != null && ((l2 = (l3 = (Long)this.patchSimplePos.elementAt(n)).longValue()) < l || l == -1L)) {
                l = l2;
            }
            ++n;
        }
        return l;
    }

    int getPatchSystem(long l) {
        int n = 0;
        while (n < this.patchSimplePos.size()) {
            Long l2;
            long l3 = 0L;
            long l4 = 0L;
            if (this.patchNormalPos.elementAt(n) != null) {
                l2 = (Long)this.patchNormalPos.elementAt(n);
                l4 = l2;
            }
            if (this.patchSimplePos.elementAt(n) != null) {
                l2 = (Long)this.patchSimplePos.elementAt(n);
                l3 = l2;
            }
            if (l3 == l) {
                return 1;
            }
            if (l4 == l) {
                return 0;
            }
            ++n;
        }
        return -1;
    }

    String getPatchSystemName(long l) {
        int n = 0;
        while (n < this.patchSimplePos.size()) {
            Long l2;
            long l3 = 0L;
            long l4 = 0L;
            if (this.patchNormalPos.elementAt(n) != null) {
                l2 = (Long)this.patchNormalPos.elementAt(n);
                l4 = l2;
            }
            if (this.patchSimplePos.elementAt(n) != null) {
                l2 = (Long)this.patchSimplePos.elementAt(n);
                l3 = l2;
            }
            if (l3 == l || l4 == l) {
                return ((OracleTypeADT)this.patchType.elementAt((int)n)).sql_name;
            }
            ++n;
        }
        return null;
    }

    void adjustPos(long l) {
        this.currentPos += l;
    }
}

