/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import oracle.sql.Datum;

public final class PickleContext {
    public static final boolean PICKLE81_DEBUG = false;
    public static boolean DEBUG;
    private ByteArrayOutputStream stream_pctx;
    private InputStream instrm_pctx;
    private byte[] lenbuf_pctx = new byte[5];
    private Hashtable htable_pctx;
    static short KOPI20_LN_ELNL;
    static short KOPI20_LN_5BLN;
    static short KOPI20_LN_ATMN;
    static short KOPI20_LN_IEMN;
    static short KOPI20_LN_MAXV;
    static short KOPI20_IF_IS81;
    static short KOPI20_IF_CMSB;
    static short KOPI20_IF_CLSB;
    static short KOPI20_IF_DEGN;
    static short KOPI20_IF_COLL;
    static short KOPI20_IF_NOPS;
    static short KOPI20_IF_ANY;
    static short KOPI20_IF_NONL;
    static short KOPI20_CF_CMSB;
    static short KOPI20_CF_CLSB;
    static short KOPI20_CF_INDX;
    static short KOPI20_CF_NOLN;
    static short KOPI20_VERSION;

    public PickleContext() {
        this.htable_pctx = new Hashtable();
    }

    public PickleContext(byte[] byArray) {
        this.instrm_pctx = new ByteArrayInputStream(byArray);
    }

    public void initStream_pctx(int n) {
        this.stream_pctx = new ByteArrayOutputStream(n);
    }

    public int lenbytes_pctx(int n) {
        if (n <= KOPI20_LN_MAXV) {
            return 1;
        }
        return 5;
    }

    public int writeEltNull_pctx() {
        this.stream_pctx.write(KOPI20_LN_ELNL);
        return 1;
    }

    public int writeAtomicNull_pctx() {
        this.stream_pctx.write(KOPI20_LN_ATMN);
        return 1;
    }

    public int writeIEmbNull_pctx(byte by) {
        this.lenbuf_pctx[0] = (byte)KOPI20_LN_IEMN;
        this.lenbuf_pctx[1] = by;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        return 2;
    }

    public int writeLength_pctx(int n) {
        block3: {
            if (n <= KOPI20_LN_MAXV) {
                this.stream_pctx.write((byte)n);
                return 1;
            }
            this.lenbuf_pctx[0] = (byte)KOPI20_LN_5BLN;
            this.lenbuf_pctx[1] = (byte)(n >> 24);
            this.lenbuf_pctx[2] = (byte)((n &= 0xFFFFFF) >> 16);
            this.lenbuf_pctx[3] = (byte)((n &= 0xFFFF) >> 8);
            this.lenbuf_pctx[4] = (byte)(n &= 0xFF);
            try {
                this.stream_pctx.write(this.lenbuf_pctx);
            }
            catch (IOException iOException) {
                if (!DEBUG) break block3;
                iOException.printStackTrace();
            }
        }
        return 5;
    }

    public int write_data_pctx(byte[] byArray) {
        block2: {
            try {
                this.stream_pctx.write(byArray);
            }
            catch (IOException iOException) {
                if (!DEBUG) break block2;
                iOException.printStackTrace();
            }
        }
        return byArray.length;
    }

    public void registerLength_pctx(Datum datum, int n) {
        this.htable_pctx.put(datum, new Integer(n));
    }

    public int getRegisteredLength_pctx(Datum datum) {
        Integer n = (Integer)this.htable_pctx.get(datum);
        return n;
    }

    public int writeImageHeader_pctx(int n) {
        int n2 = 2;
        this.lenbuf_pctx[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        return n2 += this.writeLength_pctx(n);
    }

    public int writeImageHeader_pctx(int n, int n2) {
        int n3 = 5;
        this.lenbuf_pctx[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_COLL);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        n3 += this.writeLength_pctx(n);
        this.lenbuf_pctx[0] = 1;
        this.lenbuf_pctx[1] = 1;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        this.lenbuf_pctx[0] = 0;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 1);
        return n3 += this.writeLength_pctx(n2);
    }

    public int writeImageHeader_pctx(int n, byte[] byArray) {
        int n2 = byArray.length;
        int n3 = 3 + n2;
        this.lenbuf_pctx[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_DEGN);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        n3 += this.writeLength_pctx(n);
        this.lenbuf_pctx[0] = 0;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 1);
        this.stream_pctx.write(byArray, 0, n2);
        return n3 += this.writeLength_pctx(n2 + 1);
    }

    public byte[] stream2bytes_pctx() {
        return this.stream_pctx.toByteArray();
    }

    public byte readByte_pctx() {
        block2: {
            try {
                this.instrm_pctx.read(this.lenbuf_pctx, 0, 1);
            }
            catch (IOException iOException) {
                if (!DEBUG) break block2;
                iOException.printStackTrace();
            }
        }
        return this.lenbuf_pctx[0];
    }

    public boolean is81format_pctx(byte by) {
        short s;
        short s2 = s = by < 0 ? (short)(by + 256) : (short)by;
        return (s & KOPI20_IF_IS81) != 0;
    }

    public boolean isCollectionImage_pctx(byte by) {
        short s;
        short s2 = s = by < 0 ? (short)(by + 256) : (short)by;
        return (s & KOPI20_IF_COLL) != 0;
    }

    public boolean isDegenerateImage_pctx(byte by) {
        short s;
        short s2 = s = by < 0 ? (short)(by + 256) : (short)by;
        return (s & KOPI20_IF_DEGN) != 0;
    }

    public boolean hasPrefix_pctx(byte by) {
        short s;
        short s2 = s = by < 0 ? (short)(by + 256) : (short)by;
        return (s & KOPI20_IF_NOPS) == 0;
    }

    public boolean readAndCheckVersion_pctx() {
        short s;
        byte by = this.readByte_pctx();
        short s2 = s = by < 0 ? (short)(by + 256) : (short)by;
        return s <= KOPI20_VERSION;
    }

    public boolean isAtomicNull_pctx(byte by) {
        short s;
        short s2 = s = by < 0 ? (short)(by + 256) : (short)by;
        return s == KOPI20_LN_ATMN;
    }

    public boolean isImmEmbNull_pctx(byte by) {
        short s;
        short s2 = s = by < 0 ? (short)(by + 256) : (short)by;
        return s == KOPI20_LN_IEMN;
    }

    public boolean isElementNull_pctx(byte by) {
        short s;
        short s2 = s = by < 0 ? (short)(by + 256) : (short)by;
        return s == KOPI20_LN_ELNL;
    }

    public int readLength_pctx() throws Error {
        short s;
        byte by = this.readByte_pctx();
        short s2 = s = by < 0 ? (short)(by + 256) : (short)by;
        if (s > KOPI20_LN_MAXV) {
            if (s == KOPI20_LN_ELNL) {
                return -1;
            }
            if (s != KOPI20_LN_5BLN) {
                throw new Error("Invalid null flag read");
            }
            return this.readRestOfLength_pctx(by);
        }
        return s;
    }

    public int readRestOfLength_pctx(byte by) {
        block3: {
            short s;
            short s2 = s = by < 0 ? (short)(by + 256) : (short)by;
            if (s != KOPI20_LN_5BLN) {
                return s;
            }
            try {
                this.instrm_pctx.read(this.lenbuf_pctx, 0, 4);
            }
            catch (IOException iOException) {
                if (!DEBUG) break block3;
                iOException.printStackTrace();
            }
        }
        int n = this.lenbuf_pctx[3];
        short s = n < 0 ? (short)(n + 256) : (short)n;
        n = this.lenbuf_pctx[2];
        int n2 = s + ((n < 0 ? (short)(n + 256) : (short)n) << 8);
        n = this.lenbuf_pctx[1];
        int n3 = n2 + ((n < 0 ? (short)(n + 256) : (short)n) << 16);
        n = this.lenbuf_pctx[0];
        n = n3 + ((n < 0 ? (short)(n + 256) : (short)n) << 24);
        return n;
    }

    public byte[] readPrefixSegment_pctx() {
        byte[] byArray;
        block2: {
            int n = this.readLength_pctx();
            byArray = new byte[n];
            try {
                this.instrm_pctx.read(byArray, 0, n);
            }
            catch (IOException iOException) {
                if (!DEBUG) break block2;
                iOException.printStackTrace();
            }
        }
        return byArray;
    }

    public byte[] readDataValue_pctx() {
        byte by = this.readByte_pctx();
        if (this.isElementNull_pctx(by)) {
            return null;
        }
        return this.readDataValue_pctx(by);
    }

    public byte[] readDataValue_pctx(byte by) {
        byte[] byArray;
        block2: {
            int n = this.readRestOfLength_pctx(by);
            byArray = new byte[n];
            try {
                this.instrm_pctx.read(byArray, 0, n);
            }
            catch (IOException iOException) {
                if (!DEBUG) break block2;
                iOException.printStackTrace();
            }
        }
        return byArray;
    }

    public byte[] readDataValue_pctx(int n) {
        byte[] byArray;
        block2: {
            byArray = null;
            byArray = new byte[n];
            try {
                this.instrm_pctx.read(byArray, 0, n);
            }
            catch (IOException iOException) {
                if (!DEBUG) break block2;
                iOException.printStackTrace();
            }
        }
        return byArray;
    }

    static {
        KOPI20_LN_ELNL = (short)255;
        KOPI20_LN_5BLN = (short)254;
        KOPI20_LN_ATMN = (short)253;
        KOPI20_LN_IEMN = (short)252;
        KOPI20_LN_MAXV = (short)245;
        KOPI20_IF_IS81 = (short)128;
        KOPI20_IF_CMSB = (short)64;
        KOPI20_IF_CLSB = (short)32;
        KOPI20_IF_DEGN = (short)16;
        KOPI20_IF_COLL = (short)8;
        KOPI20_IF_NOPS = (short)4;
        KOPI20_IF_ANY = (short)2;
        KOPI20_IF_NONL = 1;
        KOPI20_CF_CMSB = (short)64;
        KOPI20_CF_CLSB = (short)32;
        KOPI20_CF_INDX = (short)16;
        KOPI20_CF_NOLN = (short)8;
        KOPI20_VERSION = 1;
    }
}

