/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleTypeUPT
extends OracleTypeADT {
    public byte UPTcode = 0;
    public OracleType elementType = null;
    static final byte KOPU_UPT_ADT = -6;
    static final byte KOPU_UPT_COLL = -5;
    static final byte KOPU_UPT_REFCUR = 102;

    public OracleTypeUPT(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, oracleConnection);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum datum = null;
        if (object != null) {
            datum = object instanceof ARRAY ? (ARRAY)object : STRUCT.toSTRUCT(object, oracleConnection);
        }
        return datum;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                datumArray = new Datum[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    datumArray[n] = this.toDatum(objectArray[n], oracleConnection);
                    ++n;
                }
            } else {
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public int getTypeCode() {
        switch (this.UPTcode) {
            case -6: {
                return 2002;
            }
            case -5: {
                return 2003;
            }
        }
        return 0;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        this.null_offset = streamInfo.null_offset++;
        this.lds_offset = streamInfo.lds_offset++;
        long l = streamInfo.readLong();
        if (OracleTypeADT.DEBUG) {
            System.out.println("offsetPosition of UPT =" + l);
        }
        this.UPTcode = streamInfo.readByte();
        streamInfo.addNormalPatch(l, this.UPTcode, this);
    }

    public Datum unpicklerec(UnpickleContext unpickleContext) throws SQLException {
        int n = this.null_offset;
        if (unpickleContext.null_bytes[n]) {
            if (OracleTypeADT.DEBUG) {
                System.out.println("====UPT::unpicklerec() is null");
            }
            if (this.UPTcode == -5) {
                unpickleContext.data_offset += 4L;
                Util.read_long(unpickleContext.data_stream);
            }
            return null;
        }
        if (OracleTypeADT.DEBUG) {
            System.out.println("current=" + unpickleContext.data_offset + " moveTo=" + unpickleContext.lds_offset_array[this.lds_offset] + " " + "lds_offset=" + this.lds_offset);
        }
        unpickleContext.skip_to(unpickleContext.lds_offset_array[this.lds_offset]);
        switch (this.UPTcode) {
            case -6: {
                StructDescriptor structDescriptor = null;
                structDescriptor = StructDescriptor.createDescriptor(this.sql_name, this.m_conn);
                STRUCT sTRUCT = new STRUCT(structDescriptor, (Connection)this.m_conn, null);
                if (OracleTypeADT.DEBUG) {
                    System.out.println("====UPT::unpicklerec() for ADT");
                }
                return ((OracleTypeADT)this.elementType).unpickle(unpickleContext, sTRUCT);
            }
            case -5: {
                long l = 0L;
                unpickleContext.data_offset += 4L;
                l = Util.read_long(unpickleContext.data_stream);
                if (OracleTypeADT.DEBUG) {
                    System.out.println("====UPT::unpicklerec() for COLL " + l);
                }
                ArrayDescriptor arrayDescriptor = null;
                arrayDescriptor = ArrayDescriptor.createDescriptor(this.sql_name, this.m_conn);
                ARRAY aRRAY = new ARRAY(arrayDescriptor, (Connection)this.m_conn, null);
                unpickleContext.add_patch(l, (Datum)aRRAY, (OracleTypeCOLLECTION)this.elementType);
                return aRRAY;
            }
        }
        DBError.check_error(48, "upt_type");
        return null;
    }

    protected int pickle81_calcsize(PickleContext pickleContext, Datum datum) throws SQLException {
        if (datum == null) {
            return 1;
        }
        int n = this.elementType.pickle81_calcsize(pickleContext, datum);
        return n + pickleContext.lenbytes_pctx(n);
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        int n = 0;
        if (datum == null) {
            n += pickleContext.writeEltNull_pctx();
        } else {
            int n2 = pickleContext.getRegisteredLength_pctx(datum);
            n += pickleContext.writeLength_pctx(n2);
            n += this.elementType.pickle81(pickleContext, datum);
        }
        return n;
    }

    protected Datum unpickle81rec(PickleContext pickleContext) throws SQLException {
        if (pickleContext.readLength_pctx() == -1) {
            return null;
        }
        return this.unpickle81UPT(pickleContext);
    }

    protected Datum unpickle81rec(PickleContext pickleContext, byte by) throws SQLException {
        pickleContext.readRestOfLength_pctx(by);
        return this.unpickle81UPT(pickleContext);
    }

    private Datum unpickle81UPT(PickleContext pickleContext) throws SQLException {
        if (this.UPTcode == -6) {
            return ((OracleTypeADT)this.elementType).unpickle81(pickleContext);
        }
        if (this.UPTcode == -5) {
            return ((OracleTypeCOLLECTION)this.elementType).unpickle81(pickleContext);
        }
        throw new Error("Unrecognized UPT code");
    }
}

