/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;

public class OracleTypeREF
extends OracleType {
    public static boolean DEBUG;
    public String sql_name;
    OracleConnection connection;

    public OracleTypeREF(String string, OracleConnection oracleConnection) {
        this.sql_name = string;
        this.connection = oracleConnection;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        REF rEF = null;
        if (object != null) {
            if (object instanceof REF) {
                rEF = (REF)object;
            } else {
                DBError.check_error(59, object);
            }
        }
        return rEF;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                datumArray = new Datum[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    datumArray[n] = this.toDatum(objectArray[n], oracleConnection);
                    ++n;
                }
            } else {
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public int getTypeCode() {
        return 2006;
    }

    public void init(OracleConnection oracleConnection) {
        this.connection = this.connection;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext) throws SQLException {
        int n = this.null_offset;
        if (unpickleContext.null_bytes[n]) {
            return null;
        }
        unpickleContext.skip_to(unpickleContext.lds_offset_array[this.lds_offset]);
        unpickleContext.data_offset += 4L;
        long l = Util.read_long(unpickleContext.data_stream);
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor(this.sql_name, this.connection);
        REF rEF = new REF(structDescriptor, this.connection, null);
        unpickleContext.add_patch(l, (Datum)rEF, 0);
        return rEF;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext, boolean bl) throws SQLException {
        if (!bl) {
            return this.unpicklerec(unpickleContext);
        }
        int n = this.null_offset;
        if (unpickleContext.null_bytes[n]) {
            return null;
        }
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor(this.sql_name, this.connection);
        REF rEF = new REF(structDescriptor, this.connection, null);
        byte[] byArray = unpickleContext.read_bytes(2);
        long l = byArray[0] * 256 + byArray[1];
        byte[] byArray2 = unpickleContext.read_bytes((int)l);
        byte[] byArray3 = new byte[2 + (int)l];
        byArray3[0] = byArray[0];
        byArray3[1] = byArray[1];
        System.arraycopy(byArray2, 0, byArray3, 2, (int)l);
        rEF.setBytes(byArray3);
        return rEF;
    }

    protected Datum unpickle81rec(PickleContext pickleContext) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx();
        if (byArray == null) {
            return null;
        }
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor(this.sql_name, this.connection);
        return new REF(structDescriptor, this.connection, byArray);
    }

    protected Datum unpickle81rec(PickleContext pickleContext, byte by) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx(by);
        if (byArray == null) {
            return null;
        }
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor(this.sql_name, this.connection);
        return new REF(structDescriptor, this.connection, byArray);
    }
}

