/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.RAW;

public class OracleTypeRAW
extends OracleType {
    public static boolean DEBUG;
    public int length;

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        RAW rAW = null;
        if (object != null) {
            try {
                rAW = object instanceof RAW ? (RAW)object : new RAW(object);
            }
            catch (SQLException sQLException) {
                DBError.check_error(59, object);
            }
        }
        return rAW;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                datumArray = new Datum[cArray.length];
                int n = 0;
                while (n < cArray.length) {
                    datumArray[n] = this.toDatum(new String(cArray[n]), oracleConnection);
                    ++n;
                }
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                datumArray = new Datum[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    datumArray[n] = this.toDatum(objectArray[n], oracleConnection);
                    ++n;
                }
            } else {
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public int getTypeCode() {
        return -2;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        super.parseTDSrec(streamInfo);
        this.length = streamInfo.readShort();
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        if (datum.getLength() > (long)this.length) {
            DBError.check_error(72, this);
        }
        int n = pickleContext.writeLength_pctx((int)datum.getLength());
        return n += pickleContext.write_data_pctx(datum.shareBytes());
    }

    public Datum unpicklerec(UnpickleContext unpickleContext) throws SQLException {
        int n = this.null_offset;
        if (unpickleContext.null_bytes[n]) {
            return null;
        }
        unpickleContext.skip_to(unpickleContext.lds_offset_array[this.lds_offset]);
        unpickleContext.data_offset += 4L;
        long l = Util.read_long(unpickleContext.data_stream);
        RAW rAW = new RAW();
        unpickleContext.add_patch(l, (Datum)rAW, 0);
        return rAW;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext, boolean bl) throws SQLException {
        if (!bl) {
            return this.unpicklerec(unpickleContext);
        }
        int n = this.null_offset;
        if (unpickleContext.null_bytes[n]) {
            return null;
        }
        unpickleContext.data_offset += 4L;
        long l = Util.read_long(unpickleContext.data_stream);
        return new RAW(unpickleContext.read_bytes((int)l));
    }

    protected Datum unpickle81rec(PickleContext pickleContext) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx();
        if (byArray != null) {
            return new RAW(byArray);
        }
        return null;
    }

    protected Datum unpickle81rec(PickleContext pickleContext, byte by) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx(by);
        if (byArray != null) {
            return new RAW(byArray);
        }
        return null;
    }
}

