/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class OracleTypeNUMBER
extends OracleType {
    int m_precision;
    int m_scale;

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(object, oracleConnection);
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(object, oracleConnection);
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        this.null_offset = streamInfo.null_offset++;
        this.lds_offset = streamInfo.lds_offset++;
        this.m_precision = streamInfo.readByte();
        if (this.m_precision < 0) {
            this.m_precision = 128 - this.m_precision;
        }
        this.m_scale = streamInfo.readByte();
        if (this.m_scale < 0) {
            this.m_scale = 128 - this.m_scale;
        }
    }

    public Datum unpicklerec(UnpickleContext unpickleContext) throws SQLException {
        int n = this.null_offset;
        if (unpickleContext.null_bytes[n]) {
            return null;
        }
        unpickleContext.skip_to(unpickleContext.lds_offset_array[this.lds_offset]);
        byte[] byArray = unpickleContext.read_bytes(22);
        byte by = byArray[0];
        byte[] byArray2 = new byte[by];
        System.arraycopy(byArray, 1, byArray2, 0, by);
        return new NUMBER(byArray2);
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 12);
            this.align_for_lds = Util.FDO_get_align(byArray, 12);
        }
        return this.size_for_lds;
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 12);
            this.align_for_lds = Util.FDO_get_align(byArray, 12);
        }
        return this.align_for_lds;
    }

    protected Datum unpickle81rec(PickleContext pickleContext) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx();
        if (byArray == null) {
            return null;
        }
        return new NUMBER(byArray);
    }

    protected Datum unpickle81rec(PickleContext pickleContext, byte by) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx(by);
        return new NUMBER(byArray);
    }

    public static NUMBER toNUMBER(Object object, OracleConnection oracleConnection) throws SQLException {
        NUMBER nUMBER = null;
        if (object != null) {
            try {
                nUMBER = object instanceof NUMBER ? (NUMBER)object : new NUMBER(object);
            }
            catch (SQLException sQLException) {
                DBError.check_error(59, object);
            }
        }
        return nUMBER;
    }

    public static Datum[] toNUMBERArray(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[] && !(object instanceof char[][])) {
                Object[] objectArray = (Object[])object;
                datumArray = new Datum[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    datumArray[n] = OracleTypeNUMBER.toNUMBER(objectArray[n], oracleConnection);
                    ++n;
                }
            } else {
                datumArray = OracleTypeNUMBER.cArrayToNUMBERArray(object, oracleConnection);
            }
        }
        return datumArray;
    }

    static Datum[] cArrayToNUMBERArray(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof short[]) {
                short[] sArray = (short[])object;
                int n = sArray.length;
                datumArray = new Datum[n];
                int n2 = 0;
                while (n2 < n) {
                    datumArray[n2] = new NUMBER(sArray[n2]);
                    ++n2;
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                int n = nArray.length;
                datumArray = new Datum[n];
                int n3 = 0;
                while (n3 < n) {
                    datumArray[n3] = new NUMBER(nArray[n3]);
                    ++n3;
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                int n = lArray.length;
                datumArray = new Datum[n];
                int n4 = 0;
                while (n4 < n) {
                    datumArray[n4] = new NUMBER(lArray[n4]);
                    ++n4;
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                int n = fArray.length;
                datumArray = new Datum[n];
                int n5 = 0;
                while (n5 < n) {
                    datumArray[n5] = new NUMBER(fArray[n5]);
                    ++n5;
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                int n = dArray.length;
                datumArray = new Datum[n];
                int n6 = 0;
                while (n6 < n) {
                    datumArray[n6] = new NUMBER((float)dArray[n6]);
                    ++n6;
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n = blArray.length;
                datumArray = new Datum[n];
                int n7 = 0;
                while (n7 < n) {
                    datumArray[n7] = new NUMBER(new Boolean(blArray[n7]));
                    ++n7;
                }
            } else if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n = cArray.length;
                datumArray = new Datum[n];
                int n8 = 0;
                while (n8 < n) {
                    datumArray[n8] = new NUMBER(new String(cArray[n8]));
                    ++n8;
                }
            } else {
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public int getPrecision() {
        return this.m_precision;
    }

    public int getScale() {
        return this.m_scale;
    }
}

