/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class OracleTypeFLOAT
extends OracleType {
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(object, oracleConnection);
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(object, oracleConnection);
    }

    public int getTypeCode() {
        return 6;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        this.null_offset = streamInfo.null_offset++;
        this.lds_offset = streamInfo.lds_offset++;
        streamInfo.skipBytes(1);
    }

    public Datum unpicklerec(UnpickleContext unpickleContext) throws SQLException {
        int n = this.null_offset;
        if (unpickleContext.null_bytes[n]) {
            return null;
        }
        unpickleContext.skip_to(unpickleContext.lds_offset_array[this.lds_offset]);
        byte[] byArray = unpickleContext.read_bytes(22);
        byte by = byArray[0];
        byte[] byArray2 = new byte[by];
        System.arraycopy(byArray, 1, byArray2, 0, by);
        return new NUMBER(byArray2);
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 12);
            this.align_for_lds = Util.FDO_get_align(byArray, 12);
        }
        return this.size_for_lds;
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 12);
            this.align_for_lds = Util.FDO_get_align(byArray, 12);
        }
        return this.align_for_lds;
    }

    protected Datum unpickle81rec(PickleContext pickleContext) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx();
        if (byArray == null) {
            return null;
        }
        return new NUMBER(byArray);
    }

    protected Datum unpickle81rec(PickleContext pickleContext, byte by) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx(by);
        return new NUMBER(byArray);
    }
}

