/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.DATE;
import oracle.sql.Datum;

public class OracleTypeDATE
extends OracleType {
    public static boolean DEBUG;

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        DATE dATE = null;
        if (object != null) {
            try {
                dATE = object instanceof DATE ? (DATE)object : new DATE(object);
            }
            catch (SQLException sQLException) {
                DBError.check_error(59, object);
            }
        }
        return dATE;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                datumArray = new Datum[cArray.length];
                int n = 0;
                while (n < cArray.length) {
                    datumArray[n] = this.toDatum(new String(cArray[n]), oracleConnection);
                    ++n;
                }
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                datumArray = new Datum[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    datumArray[n] = this.toDatum(objectArray[n], oracleConnection);
                    ++n;
                }
            } else {
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public int getTypeCode() {
        return 91;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext) throws SQLException {
        int n = this.null_offset;
        if (unpickleContext.null_bytes[n]) {
            return null;
        }
        unpickleContext.skip_to(unpickleContext.lds_offset_array[this.lds_offset]);
        byte[] byArray = this.convert_formats(unpickleContext.read_bytes(8), unpickleContext.big_endian);
        return new DATE(byArray);
    }

    public byte[] convert_formats(byte[] byArray, boolean bl) {
        int n;
        int n2;
        byte[] byArray2 = new byte[7];
        int n3 = byArray[0];
        if (n3 < 0) {
            n3 = 256 + n3;
        }
        if ((n2 = byArray[1]) < 0) {
            n2 = 256 + n2;
        }
        if ((n = bl ? n3 * 256 + n2 : n2 * 256 + n3) < 0) {
            byArray2[0] = (byte)(100 - -n / 100);
            byArray2[1] = (byte)(100 - -n % 100);
        } else {
            byArray2[0] = (byte)(n / 100 + 100);
            byArray2[1] = (byte)(n % 100 + 100);
        }
        byArray2[2] = byArray[2];
        byArray2[3] = byArray[3];
        byArray2[4] = (byte)(byArray[4] + 1);
        byArray2[5] = (byte)(byArray[5] + 1);
        byArray2[6] = (byte)(byArray[6] + 1);
        return byArray2;
    }

    public byte[] convert_back_formats(byte[] byArray, boolean bl) {
        int n;
        byte[] byArray2 = new byte[8];
        int n2 = byArray[0];
        if (n2 < 0) {
            n2 = 256 + n2;
        }
        if ((n = byArray[1]) < 0) {
            n = 256 + n;
        }
        int n3 = (n2 - 100) * 100 + (n - 100);
        if (bl) {
            byArray2[0] = (byte)(n3 / 256);
            byArray2[1] = (byte)(n3 % 256);
        } else {
            byArray2[0] = (byte)(n3 % 256);
            byArray2[1] = (byte)(n3 / 256);
        }
        byArray2[2] = byArray[2];
        byArray2[3] = byArray[3];
        byArray2[4] = (byte)(byArray[4] - 1);
        byArray2[5] = (byte)(byArray[5] - 1);
        byArray2[6] = (byte)(byArray[6] - 1);
        byArray2[7] = 0;
        return byArray2;
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 11);
            this.align_for_lds = Util.FDO_get_align(byArray, 11);
        }
        return this.size_for_lds;
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 11);
            this.align_for_lds = Util.FDO_get_align(byArray, 11);
        }
        return this.align_for_lds;
    }

    protected Datum unpickle81rec(PickleContext pickleContext) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx();
        DATE dATE = null;
        if (byArray != null) {
            dATE = new DATE(byArray);
        }
        return dATE;
    }

    protected Datum unpickle81rec(PickleContext pickleContext, byte by) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx(by);
        return new DATE(byArray);
    }
}

