/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;

public class OracleTypeCOLLECTION
extends OracleTypeADT {
    public static int TYOE_PLSQL_INDEX_TABLE = 1;
    public static int TYPE_NESTED_TABLE = 2;
    public static int TYPE_VARRAY = 3;
    public int usercode = 0;
    public long length = 0L;
    public OracleType elementType = null;

    public OracleTypeCOLLECTION(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, oracleConnection);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        ARRAY aRRAY = null;
        if (object != null) {
            if (object instanceof ARRAY) {
                aRRAY = (ARRAY)object;
            } else {
                DBError.check_error(59, object);
            }
        }
        return aRRAY;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                datumArray = new Datum[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    datumArray[n] = this.toDatum(objectArray[n], oracleConnection);
                    ++n;
                }
            } else {
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public int getTypeCode() {
        return 2003;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        long l = streamInfo.readLong();
        this.length = streamInfo.readLong();
        this.usercode = streamInfo.readByte();
        streamInfo.addSimplePatch(l, this);
    }

    public Datum unpickle(byte[] byArray) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        UnpickleContext unpickleContext = new UnpickleContext(byteArrayInputStream, null, null, this.big_endian);
        return this.unpickle(unpickleContext, (ARRAY)null);
    }

    public void simpleUnpickle(UnpickleContext unpickleContext, ARRAY aRRAY) throws SQLException {
        this.unpickle(unpickleContext, aRRAY);
    }

    public Datum unpickle(UnpickleContext unpickleContext, ARRAY aRRAY) throws SQLException {
        boolean bl;
        ARRAY aRRAY2 = aRRAY;
        if (aRRAY2 == null) {
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(this.sql_name, this.m_conn);
            aRRAY2 = new ARRAY(arrayDescriptor, (Connection)this.m_conn, null);
        }
        unpickleContext.data_offset += 4L;
        long l = Util.read_long(unpickleContext.data_stream);
        if (l == 0L) {
            return aRRAY;
        }
        unpickleContext.read_byte();
        unpickleContext.read_byte();
        unpickleContext.data_offset += 4L;
        long l2 = Util.read_long(unpickleContext.data_stream);
        byte by = unpickleContext.read_byte();
        byte[] byArray = unpickleContext.read_bytes((int)l2 - 1);
        aRRAY2.setLocator(byArray);
        boolean bl2 = bl = (by & 1) == 1;
        if (bl) {
            unpickleContext.data_offset += 4L;
            long l3 = Util.read_long(unpickleContext.data_stream);
            long l4 = unpickleContext.data_offset + l3;
            UnpickleContext unpickleContext2 = new UnpickleContext(unpickleContext.data_stream, null, null, this.big_endian);
            aRRAY2 = (ARRAY)this.unpicklerec(unpickleContext2, aRRAY2);
            unpickleContext.data_offset += unpickleContext2.data_offset;
            if (unpickleContext.data_offset < l4) {
                unpickleContext.skip_to(l4);
            }
        }
        return aRRAY2;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext) throws SQLException {
        return this.unpicklerec(unpickleContext, (ARRAY)null);
    }

    public Datum unpicklerec(UnpickleContext unpickleContext, ARRAY aRRAY) throws SQLException {
        int n;
        ARRAY aRRAY2 = aRRAY;
        if (aRRAY2 == null) {
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(this.sql_name, this.m_conn);
            aRRAY2 = new ARRAY(arrayDescriptor, (Connection)this.m_conn, null);
        }
        unpickleContext.data_offset += 4L;
        long l = Util.read_long(unpickleContext.data_stream);
        if (OracleTypeADT.DEBUG) {
            System.out.println("====COL::unpicklerec() nbelem=" + l);
        }
        if (l != 0L) {
            unpickleContext.lds_offset_array = new long[(int)l + 1];
            unpickleContext.null_bytes = new boolean[(int)l + 1];
            n = 0;
            while ((long)n <= l) {
                unpickleContext.lds_offset_array[n] = 0L;
                unpickleContext.null_bytes[n] = false;
                ++n;
            }
        }
        unpickleContext.read_bytes(1);
        Datum[] datumArray = new Datum[(int)l];
        n = 0;
        while ((long)n < l) {
            boolean bl;
            boolean bl2 = bl = unpickleContext.read_bytes(1)[0] == 1;
            if (OracleTypeADT.DEBUG) {
                System.out.println("===COL::unpicklerec idx=" + n + " " + "isNull=" + bl);
            }
            Datum datum = this.elementType.unpicklerec(unpickleContext, true);
            if (bl) {
                datum = null;
            }
            datumArray[n] = datum;
            ++n;
        }
        aRRAY2.setDatumArray(datumArray);
        return aRRAY2;
    }

    protected int pickle81_calcsize(PickleContext pickleContext, Datum datum) throws SQLException {
        if (OracleTypeADT.PICKLE81_DEBUG) {
            System.out.println("OracleTypeCOLLECTION::pickle81_calcsize");
        }
        ARRAY aRRAY = (ARRAY)datum;
        boolean bl = aRRAY.hasDataSeg();
        int n = 0;
        if (bl) {
            n = 5;
            Datum[] datumArray = aRRAY.getOracleArray();
            n += pickleContext.lenbytes_pctx(datumArray.length);
            int n2 = 0;
            while (n2 < datumArray.length) {
                if (datumArray[n2] == null) {
                    if (OracleTypeADT.PICKLE81_DEBUG) {
                        System.out.println("field is null");
                    }
                    ++n;
                } else {
                    n += this.elementType.pickle81_calcsize(pickleContext, datumArray[n2]);
                }
                ++n2;
            }
        } else {
            n = 3;
            int n3 = aRRAY.getLocator().length;
            n += pickleContext.lenbytes_pctx(n3);
            n += n3;
        }
        if (OracleTypeADT.PICKLE81_DEBUG) {
            System.out.println("COLL::pickle81_calcsize imglen =" + n);
        }
        n += pickleContext.lenbytes_pctx(n + 1);
        pickleContext.registerLength_pctx(aRRAY, n);
        return n;
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        if (OracleTypeADT.PICKLE81_DEBUG) {
            System.out.println("OracleTypeCOLLECTION::pickle81(PickleContext, Datum)");
        }
        ARRAY aRRAY = (ARRAY)datum;
        boolean bl = aRRAY.hasDataSeg();
        int n = 0;
        int n2 = pickleContext.getRegisteredLength_pctx(aRRAY);
        if (bl) {
            Datum[] datumArray = aRRAY.getOracleArray();
            if (this.usercode == TYPE_VARRAY && (long)datumArray.length > this.length) {
                DBError.check_error(71, null);
            }
            n += pickleContext.writeImageHeader_pctx(n2, datumArray.length);
            int n3 = 0;
            while (n3 < datumArray.length) {
                if (datumArray[n3] == null) {
                    if (OracleTypeADT.PICKLE81_DEBUG) {
                        System.out.println("idx " + n3 + "value is null");
                    }
                    n += pickleContext.writeEltNull_pctx();
                } else {
                    if (OracleTypeADT.PICKLE81_DEBUG) {
                        System.out.println("idx " + n3 + " " + this.elementType);
                    }
                    n += this.elementType.pickle81(pickleContext, datumArray[n3]);
                }
                ++n3;
            }
        } else {
            n += pickleContext.writeImageHeader_pctx(n2, aRRAY.getLocator());
        }
        if (n != n2) {
            if (OracleTypeADT.PICKLE81_DEBUG) {
                System.out.println("imglen =" + n + " calclen =" + n2);
            }
            DBError.check_error(1, "Calculated coll. image length mismathes actual");
        }
        return n;
    }

    public Datum unpickle81(PickleContext pickleContext) throws SQLException {
        boolean bl = true;
        ARRAY aRRAY = null;
        byte by = pickleContext.readByte_pctx();
        if (OracleTypeADT.PICKLE81_DEBUG) {
            System.out.println("flags = " + by);
        }
        if (!pickleContext.is81format_pctx(by)) {
            throw new Error("Image is not in 8.1 format");
        }
        if (!pickleContext.hasPrefix_pctx(by)) {
            throw new Error("Image has no prefix segment");
        }
        if (pickleContext.isCollectionImage_pctx(by)) {
            bl = true;
        } else if (pickleContext.isDegenerateImage_pctx(by)) {
            bl = false;
        } else {
            throw new Error("Image is not a collection image");
        }
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(this.sql_name, this.m_conn);
        aRRAY = new ARRAY(arrayDescriptor, (Connection)this.m_conn, null);
        pickleContext.readByte_pctx();
        pickleContext.readLength_pctx();
        int n = pickleContext.readLength_pctx();
        byte by2 = pickleContext.readByte_pctx();
        byte[] byArray = pickleContext.readDataValue_pctx(n - 1);
        aRRAY.setLocator(byArray);
        if (bl) {
            if ((by2 & 1) != 1) {
                throw new Error("Collection Image has out-of-line collection");
            }
            pickleContext.readByte_pctx();
            int n2 = pickleContext.readLength_pctx();
            if (OracleTypeADT.PICKLE81_DEBUG) {
                System.out.println("elem # =" + n2);
            }
            Datum[] datumArray = new Datum[n2];
            int n3 = 0;
            while (n3 < n2) {
                if (OracleTypeADT.PICKLE81_DEBUG) {
                    System.out.println("elem type = " + this.elementType);
                }
                Datum datum = this.elementType.unpickle81rec(pickleContext);
                if (OracleTypeADT.PICKLE81_DEBUG) {
                    System.out.println("elem[" + n3 + "] = " + datum);
                }
                datumArray[n3] = datum;
                ++n3;
            }
            aRRAY.setDatumArray(datumArray);
        }
        return aRRAY;
    }
}

