/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class OracleTypeCLOB
extends OracleType {
    static long fixed_data_size = 86L;
    public static boolean DEBUG;
    OracleConnection m_conn;

    public OracleTypeCLOB(OracleConnection oracleConnection) {
        this.m_conn = oracleConnection;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        CLOB cLOB = null;
        if (object != null) {
            if (object instanceof CLOB) {
                cLOB = (CLOB)object;
            } else {
                DBError.check_error(59, object);
            }
        }
        return cLOB;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                datumArray = new Datum[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    datumArray[n] = this.toDatum(objectArray[n], oracleConnection);
                    ++n;
                }
            } else {
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public int getTypeCode() {
        return 2005;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext) throws SQLException {
        int n = this.null_offset;
        if (unpickleContext.null_bytes[n]) {
            return null;
        }
        unpickleContext.skip_to(unpickleContext.lds_offset_array[this.lds_offset]);
        unpickleContext.data_offset += 4L;
        long l = Util.read_long(unpickleContext.data_stream);
        CLOB cLOB = new CLOB(this.m_conn);
        unpickleContext.add_patch(l, (Datum)cLOB, 0);
        return cLOB;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext, boolean bl) throws SQLException {
        if (!bl) {
            return this.unpicklerec(unpickleContext);
        }
        CLOB cLOB = null;
        long l = unpickleContext.data_offset + fixed_data_size;
        byte[] byArray = unpickleContext.read_bytes(2);
        long l2 = byArray[0] * 256 + byArray[1];
        if (l2 > 0L) {
            byte[] byArray2 = unpickleContext.read_bytes((int)l2);
            byte[] byArray3 = new byte[2 + (int)l2];
            byArray3[0] = byArray[0];
            byArray3[1] = byArray[1];
            System.arraycopy(byArray2, 0, byArray3, 2, (int)l2);
            cLOB = new CLOB(this.m_conn, byArray3);
            if (unpickleContext.data_offset < l) {
                unpickleContext.skip_to(l);
            }
        }
        return cLOB;
    }

    protected Datum unpickle81rec(PickleContext pickleContext) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx();
        if (byArray != null) {
            return new CLOB(this.m_conn, byArray);
        }
        return null;
    }

    protected Datum unpickle81rec(PickleContext pickleContext, byte by) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx(by);
        if (byArray != null) {
            return new CLOB(this.m_conn, byArray);
        }
        return null;
    }
}

