/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

public class OracleTypeCHAR
extends OracleType {
    public static boolean DEBUG;
    int form;
    int charset;
    int length;
    private OracleConnection conn;
    private short pickle_cs_id;
    private CharacterSet pickle_cs;
    static final int SQLCS_IMPLICIT = 1;
    static final int QLCS_NCHAR = 2;
    static final int SQLCS_EXPLICIT = 3;
    static final int SQLCS_FLEXIBLE = 4;
    static final int SQLCS_LIT_NULL = 5;

    public OracleTypeCHAR() throws SQLException {
        DBError.check_error(1, "OracleTypeCHAR");
    }

    public OracleTypeCHAR(OracleConnection oracleConnection) {
        this.form = 0;
        this.charset = 0;
        this.length = 0;
        this.conn = oracleConnection;
        this.pickle_cs_id = 0;
        this.pickle_cs = null;
        try {
            this.pickle_cs_id = this.conn.getStructAttrCsId();
        }
        catch (SQLException sQLException) {
            if (DEBUG) {
                sQLException.printStackTrace();
            }
            this.pickle_cs_id = (short)-1;
        }
        this.pickle_cs = CharacterSet.make(this.pickle_cs_id);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object == null) {
            return null;
        }
        CHAR cHAR = null;
        cHAR = object instanceof CHAR ? (CHAR)object : new CHAR(object, this.pickle_cs);
        return cHAR;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[] && !(object instanceof char[][])) {
                Object[] objectArray = (Object[])object;
                datumArray = new Datum[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    datumArray[n] = this.toDatum(objectArray[n], oracleConnection);
                    ++n;
                }
            } else {
                datumArray = this.cArrayToDatumArray(object, oracleConnection);
            }
        }
        return datumArray;
    }

    private Datum[] cArrayToDatumArray(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n = cArray.length;
                datumArray = new Datum[n];
                int n2 = 0;
                while (n2 < n) {
                    datumArray[n2] = new CHAR(new String(cArray[n2]), this.pickle_cs);
                    ++n2;
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n = blArray.length;
                datumArray = new Datum[n];
                int n3 = 0;
                while (n3 < n) {
                    datumArray[n3] = new CHAR(new Boolean(blArray[n3]), this.pickle_cs);
                    ++n3;
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                int n = sArray.length;
                datumArray = new Datum[n];
                int n4 = 0;
                while (n4 < n) {
                    datumArray[n4] = new CHAR(new Integer(sArray[n4]), this.pickle_cs);
                    ++n4;
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                int n = nArray.length;
                datumArray = new Datum[n];
                int n5 = 0;
                while (n5 < n) {
                    datumArray[n5] = new CHAR(new Integer(nArray[n5]), this.pickle_cs);
                    ++n5;
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                int n = lArray.length;
                datumArray = new Datum[n];
                int n6 = 0;
                while (n6 < n) {
                    datumArray[n6] = new CHAR(new Long(lArray[n6]), this.pickle_cs);
                    ++n6;
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                int n = fArray.length;
                datumArray = new Datum[n];
                int n7 = 0;
                while (n7 < n) {
                    datumArray[n7] = new CHAR(new Float(fArray[n7]), this.pickle_cs);
                    ++n7;
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                int n = dArray.length;
                datumArray = new Datum[n];
                int n8 = 0;
                while (n8 < n) {
                    datumArray[n8] = new CHAR(new Double(dArray[n8]), this.pickle_cs);
                    ++n8;
                }
            } else {
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        super.parseTDSrec(streamInfo);
        try {
            this.length = streamInfo.readShort();
            this.form = streamInfo.readByte();
            this.charset = streamInfo.readShort();
            return;
        }
        catch (SQLException sQLException) {
            DBError.check_error(47, "parseTDS");
            return;
        }
    }

    protected Datum unpickle81rec(PickleContext pickleContext) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx();
        CHAR cHAR = null;
        if (byArray != null) {
            cHAR = new CHAR(byArray, this.pickle_cs);
        }
        return cHAR;
    }

    protected Datum unpickle81rec(PickleContext pickleContext, byte by) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx(by);
        CHAR cHAR = new CHAR(byArray, this.pickle_cs);
        return cHAR;
    }

    protected int pickle81_calcsize(PickleContext pickleContext, Datum datum) throws SQLException {
        return super.pickle81_calcsize(pickleContext, this.getDbCHAR(datum));
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        if (((CHAR)datum).getString().length() > this.length) {
            DBError.check_error(72, this);
        }
        return super.pickle81(pickleContext, this.getDbCHAR(datum));
    }

    private CHAR getDbCHAR(Datum datum) {
        CHAR cHAR = (CHAR)datum;
        CHAR cHAR2 = null;
        if (cHAR.getCharacterSet().getOracleId() == this.pickle_cs_id) {
            cHAR2 = cHAR;
        } else {
            try {
                byte[] byArray = this.pickle_cs.convert(cHAR.getCharacterSet(), cHAR.getBytes(), 0, (int)cHAR.getLength());
                cHAR2 = new CHAR(byArray, this.pickle_cs);
            }
            catch (SQLException sQLException) {
                if (DEBUG) {
                    sQLException.printStackTrace();
                }
                cHAR2 = cHAR;
            }
        }
        return cHAR2;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext) throws SQLException {
        int n = this.null_offset;
        if (unpickleContext.null_bytes[n]) {
            return null;
        }
        unpickleContext.skip_to(unpickleContext.lds_offset_array[this.lds_offset]);
        long l = 0L;
        unpickleContext.data_offset += 4L;
        l = Util.read_long(unpickleContext.data_stream);
        if (l == 0L) {
            unpickleContext.data_offset += 2L;
            Util.read_short(unpickleContext.data_stream);
        }
        CHAR cHAR = null;
        switch (this.form) {
            case 1: {
                cHAR = new CHAR(null, this.pickle_cs);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                cHAR = new CHAR(null, null);
            }
        }
        unpickleContext.add_patch(l, (Datum)cHAR, this.length);
        return cHAR;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext, boolean bl) throws SQLException {
        if (!bl) {
            return this.unpicklerec(unpickleContext);
        }
        CHAR cHAR = null;
        unpickleContext.data_offset += 4L;
        long l = Util.read_long(unpickleContext.data_stream);
        switch (this.form) {
            case 1: {
                cHAR = new CHAR(null, this.pickle_cs);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                cHAR = new CHAR(null, null);
            }
        }
        cHAR.setBytes(unpickleContext.read_bytes((int)l));
        return cHAR;
    }

    public int getLength() {
        return this.length;
    }
}

