/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.BFILE;
import oracle.sql.Datum;

public class OracleTypeBFILE
extends OracleType {
    public static boolean DEBUG;
    static long fixed_data_size;
    OracleConnection m_conn;

    public OracleTypeBFILE(OracleConnection oracleConnection) {
        this.m_conn = oracleConnection;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        BFILE bFILE = null;
        if (object != null) {
            if (object instanceof BFILE) {
                bFILE = (BFILE)object;
            } else {
                DBError.check_error(59, object);
            }
        }
        return bFILE;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                datumArray = new Datum[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    datumArray[n] = this.toDatum(objectArray[n], oracleConnection);
                    ++n;
                }
            } else {
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public int getTypeCode() {
        return -13;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext) throws SQLException {
        int n = this.null_offset;
        if (unpickleContext.null_bytes[n]) {
            return null;
        }
        unpickleContext.skip_to(unpickleContext.lds_offset_array[this.lds_offset]);
        long l = 0L;
        unpickleContext.data_offset += 4L;
        l = Util.read_long(unpickleContext.data_stream);
        BFILE bFILE = new BFILE(this.m_conn);
        unpickleContext.add_patch(l, (Datum)bFILE, 0);
        return bFILE;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext, boolean bl) throws SQLException {
        if (!bl) {
            return this.unpicklerec(unpickleContext);
        }
        BFILE bFILE = null;
        long l = unpickleContext.data_offset + fixed_data_size;
        byte[] byArray = unpickleContext.read_bytes(2);
        long l2 = byArray[0] * 256 + byArray[1];
        if (l2 > 0L) {
            byte[] byArray2 = unpickleContext.read_bytes((int)l2);
            byte[] byArray3 = new byte[2 + (int)l2];
            byArray3[0] = byArray[0];
            byArray3[1] = byArray[1];
            System.arraycopy(byArray2, 0, byArray3, 2, (int)l2);
            bFILE = new BFILE(this.m_conn, byArray3);
            if (unpickleContext.data_offset < l) {
                unpickleContext.skip_to(l);
            }
        }
        return bFILE;
    }

    protected Datum unpickle81rec(PickleContext pickleContext) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx();
        if (byArray != null) {
            return new BFILE(this.m_conn, byArray);
        }
        return null;
    }

    protected Datum unpickle81rec(PickleContext pickleContext, byte by) throws SQLException {
        byte[] byArray = pickleContext.readDataValue_pctx(by);
        if (byArray != null) {
            return new BFILE(this.m_conn, byArray);
        }
        return null;
    }

    static {
        fixed_data_size = 530L;
    }
}

