/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeBFILE;
import oracle.jdbc.oracore.OracleTypeBLOB;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeDATE;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeRAW;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.jdbc.oracore.OracleTypeSINT32;
import oracle.jdbc.oracore.OracleTypeUPT;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleTypeADT
extends OracleType {
    public static boolean DEBUG;
    public static boolean PICKLE81_DEBUG;
    public String sql_name;
    public String m_schemaName;
    public String m_typeName;
    public int version;
    public OracleType[] types;
    public byte[] LDS;
    public long[] lds_offset_array;
    public byte[] TDS;
    public byte[] toid;
    public long tdo_c_state;
    public byte[] fdo;
    public int char_set_if;
    public int char_set_form;
    public boolean big_endian;
    public int flattened_attr_num;
    public int alignment_req;
    public long fixed_data_size;
    public StreamInfo streamInfo;
    public boolean isEmbeddedADT = false;
    OracleConnection m_conn;
    Vector m_attrNames;
    Vector m_attrTypeNames;
    String m_collElemTypeName;
    int opcode;
    private int idx = 1;
    static final int TDS_SIZE = 4;
    static final int TDS_NUMBER = 1;
    static final int KOPM_OTS_SQL_CHAR = 1;
    static final int KOPM_OTS_DATE = 2;
    static final int KOPM_OTS_DECIMAL = 3;
    static final int KOPM_OTS_DOUBLE = 4;
    static final int KOPM_OTS_FLOAT = 5;
    static final int KOPM_OTS_NUMBER = 6;
    static final int KOPM_OTS_SQL_VARCHAR2 = 7;
    static final int KOPM_OTS_SINT32 = 8;
    static final int KOPM_OTS_REF = 9;
    static final int KOPM_OTS_VARRAY = 10;
    static final int KOPM_OTS_UINT8 = 11;
    static final int KOPM_OTS_SINT8 = 12;
    static final int KOPM_OTS_UINT16 = 13;
    static final int KOPM_OTS_UINT32 = 14;
    static final int KOPM_OTS_LOB = 15;
    static final int KOPM_OTS_MLSLABEL = 16;
    static final int KOPM_OTS_CANONICAL = 17;
    static final int KOPM_OTS_OCTET = 18;
    static final int KOPM_OTS_RAW = 19;
    static final int KOPM_OTS_ROWID = 20;
    static final int KOPM_OTS_SINGLE = 21;
    static final int KOPM_OTS_LVARCHAR2 = 22;
    static final int KOPM_OTS_FARRAY = 23;
    static final int KOPM_OTS_LONG_RAW = 24;
    static final int KOPM_OTS_PTR = 25;
    static final int KOPM_OTS_SINT16 = 26;
    static final int KOPM_OTS_UPT = 27;
    static final int KOPM_OTS_COLLECTION = 28;
    static final int KOPM_OTS_CLOB = 29;
    static final int KOPM_OTS_BLOB = 30;
    static final int KOPM_OTS_BFILE = 31;
    static final int KOPT_OP_STARTEMBADT = 39;
    static final int KOPT_OP_ENDEMBADT = 40;
    static final int KOPT_OP_STARTADT = 41;
    static final int KOPT_OP_ENDADT = 42;
    static final int KOPT_OPCODE_START = 38;
    static final int KOPT_OP_VERSION = 38;

    public OracleTypeADT(byte[] byArray, int n, int n2, short s, String string) throws SQLException {
        this(string);
        this.toid = byArray;
        this.version = (byte)n;
        this.char_set_if = n2;
        this.char_set_form = s;
    }

    public OracleTypeADT(String string) {
        this.sql_name = string;
        this.initNames();
    }

    public OracleTypeADT(String string, Connection connection) throws SQLException {
        this(string);
        this.m_conn = (OracleConnection)connection;
    }

    public OracleTypeADT(String string, Connection connection, byte[] byArray) throws SQLException {
        this(string, connection);
        this.fdo = byArray;
        int[] nArray = Util.toJavaUnsignedBytes(byArray);
        int n = nArray[6 + nArray[5] + nArray[6] + 5];
        int n2 = n & 0x10;
        if (n2 < 0) {
            n2 += 256;
        }
        if (n2 > 0) {
            this.big_endian = true;
            return;
        }
        this.big_endian = false;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            return STRUCT.toSTRUCT(object, oracleConnection);
        }
        return null;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                datumArray = new Datum[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    datumArray[n] = this.toDatum(objectArray[n], oracleConnection);
                    ++n;
                }
            } else {
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public int getTypeCode() {
        return 2002;
    }

    public void init(OracleConnection oracleConnection) throws SQLException {
        if (DEBUG) {
            System.out.println("Enter OracleTypeADT::init()");
        }
        this.m_conn = oracleConnection;
        this.fdo = this.m_conn.getFDO();
        this.big_endian = this.m_conn.getBigEndian();
        CallableStatement callableStatement = null;
        try {
            int n;
            callableStatement = this.m_conn.prepareCall("begin :1 := dbms_pickler.get_type_shape (:2, :3, :4, :5, :6, :7); end; ");
            callableStatement.registerOutParameter(1, 2);
            callableStatement.registerOutParameter(4, -4);
            callableStatement.registerOutParameter(5, 4);
            callableStatement.registerOutParameter(6, -4);
            callableStatement.registerOutParameter(7, -4);
            callableStatement.setString(2, this.m_schemaName);
            callableStatement.setString(3, this.m_typeName);
            if (DEBUG) {
                System.out.println("qualified_name=" + this.sql_name + " schema=" + this.m_schemaName + " type=" + this.m_typeName);
            }
            callableStatement.execute();
            if (DEBUG && (n = callableStatement.getInt(1)) != 0) {
                System.out.println("ORA-" + n);
            }
            this.toid = callableStatement.getBytes(4);
            this.version = callableStatement.getInt(5);
            this.TDS = callableStatement.getBytes(6);
            this.flattened_attr_num = Util.getUnsignedByte(this.TDS[8]) * 256 + Util.getUnsignedByte(this.TDS[9]);
            if (DEBUG) {
                System.out.println("flattened_attr_num = " + this.flattened_attr_num);
            }
            this.LDS = callableStatement.getBytes(7);
            this.parseLDS(new ByteArrayInputStream(this.LDS));
            this.parseTDS(new ByteArrayInputStream(this.TDS));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            callableStatement.close();
            throw throwable;
        }
        Object var4_4 = null;
        callableStatement.close();
    }

    public byte[] getTOID() {
        return this.toid;
    }

    public int getVersion() {
        return this.version;
    }

    public int getCharSet() {
        return this.char_set_if;
    }

    public int getCharSetForm() {
        return this.char_set_form;
    }

    public void parseLDS(InputStream inputStream) throws SQLException {
        if (DEBUG) {
            System.out.println("parseLDS");
        }
        Util.read_long(inputStream);
        this.fixed_data_size = Util.read_long(inputStream);
        this.lds_offset_array = new long[this.flattened_attr_num];
        int n = 0;
        while (n < this.flattened_attr_num) {
            this.lds_offset_array[n] = Util.read_long(inputStream);
            if (DEBUG) {
                System.out.println(" " + this.lds_offset_array[n]);
            }
            ++n;
        }
    }

    public void parseTDS(InputStream inputStream) throws SQLException {
        this.streamInfo = new StreamInfo(inputStream);
        this.streamInfo.skipBytes(4);
        this.streamInfo.checkNextByte((byte)38);
        this.version = this.streamInfo.readByte();
        this.streamInfo.skipBytes(5);
        this.streamInfo.checkNextByte((byte)41);
        short s = this.streamInfo.readShort();
        if (s != 0) {
            DBError.check_error(47, "parseTDS");
        }
        this.streamInfo.skipBytes(4);
        this.parseTDSrec(this.streamInfo);
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        Vector<OracleType> vector = new Vector<OracleType>();
        OracleType oracleType = null;
        this.null_offset = streamInfo.null_offset++;
        this.lds_offset = streamInfo.lds_offset;
        while ((oracleType = this.getNextTypeObject(streamInfo)) != null) {
            vector.addElement(oracleType);
        }
        if (this.opcode == 42) {
            this.applyTDSpatches(streamInfo);
        }
        this.types = new OracleType[vector.size()];
        vector.copyInto(this.types);
    }

    private void applyTDSpatches(StreamInfo streamInfo) throws SQLException {
        while (streamInfo.numberOfPatches() != 0) {
            if (DEBUG) {
                System.out.println(String.valueOf(this) + " has patches num =" + streamInfo.numberOfPatches());
            }
            long l = streamInfo.currentPos;
            long l2 = streamInfo.getNextPatchPos();
            if (l2 > l) {
                streamInfo.skipBytes((int)(l2 - l));
            }
            if (l2 < l) {
                DBError.check_error(47, "parseTDS");
            }
            l = streamInfo.currentPos;
            int n = streamInfo.getPatchSystem(l);
            String string = streamInfo.getPatchSystemName(l);
            if (DEBUG) {
                System.out.println("patchSystemName=" + string);
            }
            if (n == 0) {
                streamInfo.readByte();
                byte by = streamInfo.getUPTStyle(l);
                if (by == -6) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(this) + " KOPU_UPT_ADT");
                    }
                    streamInfo.readLong();
                }
                if (by == -5 && DEBUG) {
                    System.out.println(String.valueOf(this) + " KOPU_UPT_COLL");
                }
                OracleTypeADT oracleTypeADT = new OracleTypeADT(string, this.m_conn, this.fdo);
                oracleTypeADT.parseTDS(streamInfo.stream);
                if (by == -6) {
                    oracleTypeADT.generateLDS();
                }
                streamInfo.adjustPos(oracleTypeADT.streamInfo.currentPos);
                streamInfo.Patch(l, oracleTypeADT.cleanup());
            }
            if (n == 1) {
                OracleType oracleType = this.getNextTypeObject(streamInfo);
                streamInfo.Patch(l, oracleType, this.opcode);
            }
            if (n >= 0) continue;
            DBError.check_error(47, "parseTDS");
        }
    }

    public OracleTypeADT cleanup() {
        if (this.types.length == 1) {
            if (this.types[0] instanceof OracleTypeCOLLECTION) {
                OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)this.types[0];
                oracleTypeCOLLECTION.sql_name = this.sql_name;
                oracleTypeCOLLECTION.m_conn = this.m_conn;
                oracleTypeCOLLECTION.LDS = this.LDS;
                oracleTypeCOLLECTION.TDS = this.TDS;
                oracleTypeCOLLECTION.toid = this.toid;
                oracleTypeCOLLECTION.fdo = this.fdo;
                oracleTypeCOLLECTION.version = this.version;
                oracleTypeCOLLECTION.tdo_c_state = this.tdo_c_state;
                oracleTypeCOLLECTION.null_offset = this.null_offset;
                oracleTypeCOLLECTION.big_endian = this.big_endian;
                return oracleTypeCOLLECTION;
            }
            return this;
        }
        return this;
    }

    public OracleType getNextTypeObject(StreamInfo streamInfo) throws SQLException {
        this.opcode = 0;
        try {
            this.opcode = streamInfo.readByte();
        }
        catch (Exception exception) {}
        if (DEBUG) {
            System.out.println("DBG> getNextTypeObject " + this.opcode);
        }
        switch (this.opcode) {
            case 40: 
            case 42: {
                return null;
            }
            case 2: {
                OracleTypeDATE oracleTypeDATE = new OracleTypeDATE();
                oracleTypeDATE.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeDATE;
            }
            case 7: {
                OracleTypeCHAR oracleTypeCHAR = new OracleTypeCHAR(this.m_conn);
                oracleTypeCHAR.setTypeCode(12);
                oracleTypeCHAR.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeCHAR;
            }
            case 1: {
                OracleTypeCHAR oracleTypeCHAR = new OracleTypeCHAR(this.m_conn);
                oracleTypeCHAR.setTypeCode(1);
                oracleTypeCHAR.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeCHAR;
            }
            case 39: {
                String string = this.getAttributeType(this.idx);
                if (DEBUG) {
                    System.out.println(String.valueOf(this.sql_name) + " - " + string);
                }
                OracleTypeADT oracleTypeADT = new OracleTypeADT(string, this.m_conn, this.fdo);
                oracleTypeADT.isEmbeddedADT = true;
                oracleTypeADT.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeADT;
            }
            case 6: {
                OracleTypeNUMBER oracleTypeNUMBER = new OracleTypeNUMBER();
                oracleTypeNUMBER.setTypeCode(2);
                oracleTypeNUMBER.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeNUMBER;
            }
            case 3: {
                OracleTypeNUMBER oracleTypeNUMBER = new OracleTypeNUMBER();
                oracleTypeNUMBER.setTypeCode(3);
                oracleTypeNUMBER.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeNUMBER;
            }
            case 4: {
                OracleTypeNUMBER oracleTypeNUMBER = new OracleTypeNUMBER();
                oracleTypeNUMBER.setTypeCode(8);
                oracleTypeNUMBER.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeNUMBER;
            }
            case 5: {
                OracleTypeFLOAT oracleTypeFLOAT = new OracleTypeFLOAT();
                oracleTypeFLOAT.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeFLOAT;
            }
            case 8: {
                OracleTypeSINT32 oracleTypeSINT32 = new OracleTypeSINT32();
                oracleTypeSINT32.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeSINT32;
            }
            case 9: {
                String string = this.getAttributeType(this.idx);
                if (DEBUG) {
                    System.out.println(String.valueOf(this.sql_name) + " - " + string);
                }
                OracleTypeREF oracleTypeREF = new OracleTypeREF(string, this.m_conn);
                oracleTypeREF.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeREF;
            }
            case 31: {
                OracleTypeBFILE oracleTypeBFILE = new OracleTypeBFILE(this.m_conn);
                oracleTypeBFILE.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeBFILE;
            }
            case 19: {
                OracleTypeRAW oracleTypeRAW = new OracleTypeRAW();
                oracleTypeRAW.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeRAW;
            }
            case 29: {
                OracleTypeCLOB oracleTypeCLOB = new OracleTypeCLOB(this.m_conn);
                oracleTypeCLOB.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeCLOB;
            }
            case 30: {
                OracleTypeBLOB oracleTypeBLOB = new OracleTypeBLOB(this.m_conn);
                oracleTypeBLOB.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeBLOB;
            }
            case 28: {
                String string = this.getAttributeType(this.idx);
                if (DEBUG) {
                    System.out.println(String.valueOf(this.sql_name) + " - " + string);
                }
                OracleTypeCOLLECTION oracleTypeCOLLECTION = new OracleTypeCOLLECTION(string, this.m_conn);
                oracleTypeCOLLECTION.big_endian = this.big_endian;
                oracleTypeCOLLECTION.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeCOLLECTION;
            }
            case 27: {
                String string = this.getAttributeType(this.idx);
                if (DEBUG) {
                    System.out.println(String.valueOf(this.sql_name) + " - " + string);
                }
                OracleTypeUPT oracleTypeUPT = new OracleTypeUPT(string, this.m_conn);
                oracleTypeUPT.big_endian = this.big_endian;
                oracleTypeUPT.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeUPT;
            }
        }
        DBError.check_error(48, "get_next_type");
        return null;
    }

    public byte[] linearize(Datum datum) throws SQLException {
        return this.pickle81(datum);
    }

    public Datum unlinearize(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return null;
        }
        if ((byArray[0] & 0x80) > 0) {
            return this.unpickle81(byArray);
        }
        return this.unpickle(byArray);
    }

    public Datum unpickle(byte[] byArray) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        UnpickleContext unpickleContext = new UnpickleContext(byteArrayInputStream, null, null, this.big_endian);
        return this.unpickle(unpickleContext, null);
    }

    public void simpleUnpickle(UnpickleContext unpickleContext, STRUCT sTRUCT) throws SQLException {
        this.unpickle(unpickleContext, sTRUCT);
    }

    public Datum unpickle(UnpickleContext unpickleContext, STRUCT sTRUCT) throws SQLException {
        Datum datum;
        InputStream inputStream = unpickleContext.data_stream;
        unpickleContext.data_offset += 4L;
        long l = Util.read_long(unpickleContext.data_stream);
        if (l == 0L) {
            return sTRUCT;
        }
        unpickleContext.read_byte();
        unpickleContext.read_byte();
        boolean[] blArray = this.unpickle_nulls(unpickleContext);
        unpickleContext.data_offset += 4L;
        long l2 = Util.read_long(unpickleContext.data_stream);
        if (DEBUG) {
            System.out.println("==ADT data_length=" + l2);
        }
        long l3 = unpickleContext.data_offset + l2;
        if (blArray[0]) {
            unpickleContext.skip_to(l2 + unpickleContext.data_offset);
            datum = null;
        } else {
            UnpickleContext unpickleContext2 = new UnpickleContext(inputStream, blArray, this.lds_offset_array, this.big_endian);
            datum = this.unpicklerec(unpickleContext2, sTRUCT);
            unpickleContext2.apply_patches();
            unpickleContext.data_offset += unpickleContext2.data_offset;
            if (unpickleContext.data_offset < l3) {
                unpickleContext.skip_to(l3);
            }
        }
        return datum;
    }

    public boolean[] unpickle_nulls(UnpickleContext unpickleContext) throws SQLException {
        unpickleContext.data_offset += 4L;
        Util.read_long(unpickleContext.data_stream);
        unpickleContext.data_offset += 4L;
        long l = Util.read_long(unpickleContext.data_stream);
        unpickleContext.data_offset += 2L;
        Util.read_short(unpickleContext.data_stream);
        int n = 0;
        boolean[] blArray = new boolean[(int)(l - 2L) * 4];
        int n2 = 0;
        while ((long)n2 < l - 2L) {
            byte by = unpickleContext.read_byte();
            int n3 = 0;
            while (n3 < 4) {
                blArray[n] = (by & 3) != 0;
                ++n;
                by = (byte)(by >> 2);
                ++n3;
            }
            ++n2;
        }
        if (DEBUG) {
            n2 = 0;
            while (n2 < blArray.length) {
                System.out.println(" " + blArray[n2]);
                ++n2;
            }
        }
        return blArray;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext) throws SQLException {
        return this.unpicklerec(unpickleContext, null);
    }

    public Datum unpicklerec(UnpickleContext unpickleContext, STRUCT sTRUCT) throws SQLException {
        Datum datum;
        int n = this.null_offset;
        if (unpickleContext.null_bytes[n]) {
            if (DEBUG) {
                System.out.println("====ADT::unpicklerec() is null");
            }
            return null;
        }
        if (DEBUG) {
            System.out.println("current=" + unpickleContext.data_offset + " moveTo=" + unpickleContext.lds_offset_array[this.lds_offset]);
        }
        unpickleContext.skip_to(unpickleContext.lds_offset_array[this.lds_offset]);
        Datum[] datumArray = new Datum[this.types.length];
        int n2 = 0;
        while (n2 < this.types.length) {
            if (DEBUG) {
                System.out.println("==" + this.types[n2] + " " + this.types[n2].null_offset);
            }
            datum = this.types[n2].unpicklerec(unpickleContext);
            if (DEBUG) {
                System.out.println("===ADT::unpicklerec idx=" + n2 + " " + datum);
            }
            datumArray[n2] = datum;
            ++n2;
        }
        datum = sTRUCT;
        if (datum == null) {
            StructDescriptor structDescriptor = null;
            structDescriptor = StructDescriptor.createDescriptor(this.sql_name, this.m_conn);
            datum = new STRUCT(structDescriptor, (Connection)this.m_conn, null);
            ((STRUCT)datum).setDatumArray(datumArray);
        } else {
            ((STRUCT)datum).setDatumArray(datumArray);
        }
        return datum;
    }

    public void generateLDS() {
        Vector vector = this.generateLDSrec();
        this.lds_offset_array = new long[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Integer n2 = (Integer)vector.elementAt(n);
            this.lds_offset_array[n] = n2.longValue();
            ++n;
        }
    }

    private Vector generateLDSrec() {
        int n = 0;
        int n2 = 0;
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = 0;
        while (n3 < this.types.length) {
            int n4;
            int n5;
            Vector vector2 = null;
            OracleType oracleType = this.types[n3];
            if (oracleType instanceof OracleTypeADT) {
                vector2 = ((OracleTypeADT)oracleType).generateLDSrec();
                n5 = ((OracleTypeADT)oracleType).alignment_req;
                n4 = (int)((OracleTypeADT)oracleType).fixed_data_size;
            } else {
                n4 = oracleType.getSizeLDS(this.fdo);
                n5 = oracleType.getAlignLDS(this.fdo);
            }
            if ((n & n5) > 0) {
                n = Util.LDSRound(n, n5);
            }
            if (oracleType instanceof OracleTypeADT) {
                int n6 = 0;
                while (n6 < vector2.size()) {
                    Integer n7 = (Integer)vector2.elementAt(n6);
                    Integer n8 = new Integer(n7 + n);
                    vector.addElement(n8);
                    ++n6;
                }
            } else {
                vector.addElement(new Integer(n));
            }
            n += n4;
            if (n5 > n2) {
                n2 = n5;
            }
            ++n3;
        }
        if ((n & n2) > 0) {
            n = Util.LDSRound(n, n2);
        }
        this.alignment_req = n2;
        this.fixed_data_size = n;
        return vector;
    }

    protected int pickle81_calcsize(PickleContext pickleContext, Datum datum) throws SQLException {
        if (PICKLE81_DEBUG) {
            System.out.println("OracleTypeADT::pickle81_calcsize");
        }
        int n = 2 + this.pickle81_calcsizerec(pickleContext, datum, 0);
        n += pickleContext.lenbytes_pctx(n + 1);
        pickleContext.registerLength_pctx(datum, n);
        if (PICKLE81_DEBUG) {
            System.out.println("ADT::pickle81_calcsize imglen =" + n);
        }
        return n;
    }

    private int pickle81_calcsizerec(PickleContext pickleContext, Datum datum, int n) throws SQLException {
        if (PICKLE81_DEBUG) {
            System.out.println("OracleTypeADT::pickle81_calcsizerec " + datum);
        }
        int n2 = 0;
        Datum[] datumArray = ((STRUCT)datum).getOracleAttributes();
        int n3 = datumArray.length;
        int n4 = 0;
        if (this.types[0] instanceof OracleTypeADT && !(this.types[0] instanceof OracleTypeCOLLECTION) && !(this.types[0] instanceof OracleTypeUPT)) {
            n4 = 1;
            if (PICKLE81_DEBUG) {
                System.out.println("Enter first null case for " + this + "........................");
                System.out.println("idx = 0 " + this.types[0] + " " + datumArray[0]);
            }
            if (datumArray[0] == null) {
                if (PICKLE81_DEBUG) {
                    System.out.println("First elem is null with depth =" + n);
                }
                n2 = n > 0 ? (n2 += 2) : ++n2;
            } else {
                if (PICKLE81_DEBUG) {
                    System.out.println("First elem is not null with depth =" + n);
                }
                n2 += ((OracleTypeADT)this.types[0]).pickle81_calcsizerec(pickleContext, datumArray[0], n + 1);
            }
            if (PICKLE81_DEBUG) {
                System.out.println("End first null case for " + this + "........................");
            }
        }
        while (n4 < n3) {
            if (PICKLE81_DEBUG) {
                System.out.println("idx = " + n4 + " " + this.types[n4] + " " + datumArray[n4]);
            }
            if (datumArray[n4] == null) {
                if (PICKLE81_DEBUG) {
                    System.out.println("field is null");
                }
                ++n2;
            } else if (this.types[n4] instanceof OracleTypeADT && !(this.types[n4] instanceof OracleTypeCOLLECTION) && !(this.types[n4] instanceof OracleTypeUPT)) {
                if (PICKLE81_DEBUG) {
                    System.out.println("embeddad ADT");
                }
                n2 += ((OracleTypeADT)this.types[n4]).pickle81_calcsizerec(pickleContext, datumArray[n4], 1);
            } else {
                if (PICKLE81_DEBUG) {
                    System.out.println("not null and not embedded ADT");
                }
                n2 += this.types[n4].pickle81_calcsize(pickleContext, datumArray[n4]);
            }
            ++n4;
        }
        if (PICKLE81_DEBUG) {
            System.out.println("ADT::pickle81_calcsizerec imglen =" + n2);
        }
        return n2;
    }

    public byte[] pickle81(Datum datum) throws SQLException {
        if (PICKLE81_DEBUG) {
            System.out.println("OracleTypeADT::pickle81(Datum)");
        }
        PickleContext pickleContext = new PickleContext();
        int n = this.pickle81_calcsize(pickleContext, datum);
        pickleContext.initStream_pctx(n);
        pickleContext.registerLength_pctx(datum, n);
        this.pickle81(pickleContext, datum);
        byte[] byArray = pickleContext.stream2bytes_pctx();
        if (PICKLE81_DEBUG) {
            Util.printUnsignedByteArray(byArray);
        }
        datum.setShareBytes(byArray);
        return byArray;
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        if (PICKLE81_DEBUG) {
            System.out.println("OracleTypeADT::pickle81(PickleContext, Datum)");
        }
        int n = pickleContext.getRegisteredLength_pctx(datum);
        int n2 = 0;
        n2 += pickleContext.writeImageHeader_pctx(n);
        if ((n2 += this.pickle81rec(pickleContext, datum, 0)) != n) {
            throw new Error("Calculated ADT image length mismatches actual");
        }
        return n2;
    }

    private int pickle81rec(PickleContext pickleContext, Datum datum, int n) throws SQLException {
        if (PICKLE81_DEBUG) {
            System.out.println("OracleTypeADT::pickle81rec(PickleContext, Datum, depth)");
        }
        int n2 = 0;
        Datum[] datumArray = ((STRUCT)datum).getOracleAttributes();
        int n3 = datumArray.length;
        int n4 = 0;
        if (this.types[0] instanceof OracleTypeADT && !(this.types[0] instanceof OracleTypeCOLLECTION) && !(this.types[0] instanceof OracleTypeUPT)) {
            if (PICKLE81_DEBUG) {
                System.out.println("types[0] is OracleTypeADT");
            }
            n4 = 1;
            n2 = datumArray[0] == null ? (n > 0 ? (n2 += pickleContext.writeIEmbNull_pctx((byte)n)) : (n2 += pickleContext.writeAtomicNull_pctx())) : (n2 += ((OracleTypeADT)this.types[0]).pickle81rec(pickleContext, datumArray[0], n + 1));
        }
        while (n4 < n3) {
            if (PICKLE81_DEBUG) {
                System.out.println("index " + n4 + " " + this.types[n4]);
            }
            if (datumArray[n4] == null) {
                if (PICKLE81_DEBUG) {
                    System.out.println("value is null");
                }
                n2 = this.types[n4] instanceof OracleTypeADT && !(this.types[n4] instanceof OracleTypeCOLLECTION) && !(this.types[n4] instanceof OracleTypeUPT) ? (n2 += pickleContext.writeAtomicNull_pctx()) : (n2 += pickleContext.writeEltNull_pctx());
            } else if (this.types[n4] instanceof OracleTypeADT && !(this.types[n4] instanceof OracleTypeCOLLECTION) && !(this.types[n4] instanceof OracleTypeUPT)) {
                if (PICKLE81_DEBUG) {
                    System.out.println("value is ADT");
                }
                n2 += ((OracleTypeADT)this.types[n4]).pickle81rec(pickleContext, datumArray[n4], 1);
            } else {
                if (PICKLE81_DEBUG) {
                    System.out.println("value is not null and not ADT");
                }
                n2 += this.types[n4].pickle81(pickleContext, datumArray[n4]);
            }
            ++n4;
        }
        return n2;
    }

    public Datum unpickle81(byte[] byArray) throws SQLException {
        if (PICKLE81_DEBUG) {
            System.out.println("OracleTypeADT::unpickle81(bytes)");
            Util.printUnsignedByteArray(byArray);
        }
        PickleContext pickleContext = new PickleContext(byArray);
        Datum datum = this.unpickle81(pickleContext);
        datum.setBytes(byArray);
        return datum;
    }

    public Datum unpickle81(PickleContext pickleContext) throws SQLException {
        byte by;
        if (PICKLE81_DEBUG) {
            System.out.println("OracleTypeADT::unpickle81(context)");
        }
        if (!pickleContext.is81format_pctx(by = pickleContext.readByte_pctx())) {
            throw new Error("Image is not in 8.1 format");
        }
        if (pickleContext.isCollectionImage_pctx(by)) {
            throw new Error("Image is a collection image, expecting ADT");
        }
        if (pickleContext.hasPrefix_pctx(by)) {
            throw new Error("Image has prefix segment, none expected");
        }
        if (!pickleContext.readAndCheckVersion_pctx()) {
            throw new Error("Image version is not recognized");
        }
        pickleContext.readLength_pctx();
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor(this.sql_name, this.m_conn);
        STRUCT sTRUCT = new STRUCT(structDescriptor, (Connection)this.m_conn, null);
        Datum[] datumArray = new Datum[this.types.length];
        int n = 0;
        while (n < this.types.length) {
            Datum datum = this.types[n].unpickle81rec(pickleContext);
            if (PICKLE81_DEBUG) {
                System.out.println("index " + n + " = " + this.types[n] + " " + datum);
            }
            datumArray[n] = datum;
            ++n;
        }
        sTRUCT.setDatumArray(datumArray);
        return sTRUCT;
    }

    protected Datum unpickle81rec(PickleContext pickleContext) throws SQLException {
        byte by = pickleContext.readByte_pctx();
        byte by2 = 0;
        if (pickleContext.isAtomicNull_pctx(by)) {
            return null;
        }
        if (pickleContext.isImmEmbNull_pctx(by)) {
            by2 = pickleContext.readByte_pctx();
        }
        return this.unpickle81adt(pickleContext, by, by2);
    }

    protected Datum unpickle81rec(PickleContext pickleContext, byte by) throws SQLException {
        return this.unpickle81adt(pickleContext, by, (byte)0);
    }

    private Datum unpickle81adt(PickleContext pickleContext, byte by, byte by2) throws SQLException {
        Datum[] datumArray = new Datum[this.types.length];
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor(this.sql_name, this.m_conn);
        STRUCT sTRUCT = new STRUCT(structDescriptor, (Connection)this.m_conn, null);
        datumArray[0] = pickleContext.isElementNull_pctx(by) || pickleContext.isImmEmbNull_pctx(by) && by2 == 1 ? null : (pickleContext.isImmEmbNull_pctx(by) ? ((OracleTypeADT)this.types[0]).unpickle81adt(pickleContext, by, (byte)(by2 - 1)) : this.types[0].unpickle81rec(pickleContext, by));
        int n = 1;
        while (n < this.types.length) {
            datumArray[n] = this.types[n].unpickle81rec(pickleContext);
            ++n;
        }
        sTRUCT.setDatumArray(datumArray);
        return sTRUCT;
    }

    public String getAttributeType(int n) throws SQLException {
        if (this.m_attrTypeNames == null) {
            this.initAttrNames();
        }
        if (n < 1) {
            DBError.check_error(1, "Invalid index");
        }
        if (n <= this.m_attrTypeNames.size()) {
            return (String)this.m_attrTypeNames.elementAt(n - 1);
        }
        return this.m_collElemTypeName;
    }

    public String getAttributeName(int n) throws SQLException {
        if (this.m_attrNames == null) {
            this.initAttrNames();
        }
        if (n < 1 || n > this.m_attrNames.size()) {
            DBError.check_error(1, "Invalid index");
        }
        return (String)this.m_attrNames.elementAt(n - 1);
    }

    void initAttrNames() throws SQLException {
        if (DEBUG) {
            System.out.println("initAttrNames::" + this.sql_name);
        }
        if (this.sql_name == null || this.sql_name.length() == 0) {
            DBError.check_error(1, "illegal operations: initAttrNames()");
        }
        this.m_attrNames = new Vector(5);
        this.m_attrTypeNames = new Vector(5);
        this.initADTAttrNames();
        this.initCollElemTypeName();
    }

    private void initCollElemTypeName() throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        String string2 = null;
        preparedStatement = this.m_conn.prepareStatement("SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE TYPE_NAME = ? AND OWNER = ?");
        preparedStatement.setString(1, this.m_typeName);
        preparedStatement.setString(2, this.m_schemaName);
        resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            string = resultSet.getString(1);
            string2 = resultSet.getString(2);
            this.m_collElemTypeName = String.valueOf(string2) + "." + string;
            if (DEBUG) {
                System.out.println("initAttrNames(" + this.idx + ") (case2) =" + string2 + "." + string);
            }
        } else if (DEBUG) {
            System.out.println("initAttrNames(" + this.idx + ") (case3)");
        }
        resultSet.close();
        preparedStatement.close();
    }

    private void initADTAttrNames() throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        preparedStatement = this.m_conn.prepareStatement("SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE OWNER = ? AND TYPE_NAME = ? ORDER BY ATTR_NO");
        preparedStatement.setString(1, this.m_schemaName);
        preparedStatement.setString(2, this.m_typeName);
        resultSet = preparedStatement.executeQuery();
        int n = 0;
        while (resultSet.next()) {
            if (resultSet.getInt(1) != ++n) {
                DBError.check_error(1, "inconsistent ADT attribute");
            }
            string3 = resultSet.getString(2);
            this.m_attrNames.addElement(string3);
            if (DEBUG) {
                System.out.println("ininAttrNames(" + n + ") name =" + string3);
            }
            string = resultSet.getString(3);
            string2 = resultSet.getString(4);
            this.m_attrTypeNames.addElement(String.valueOf(string2) + "." + string);
            if (!DEBUG) continue;
            System.out.println("ininAttrNames(" + n + ") (case1) =" + string2 + "." + string);
        }
        resultSet.close();
        preparedStatement.close();
    }

    private void initNames() {
        int n = this.sql_name.indexOf(".");
        if (n >= 0) {
            this.m_schemaName = this.sql_name.substring(0, n);
            this.m_typeName = this.sql_name.substring(n + 1);
            return;
        }
        this.m_typeName = this.sql_name;
    }

    public void printDebug() {
        System.out.println("OracleTypeADT = " + this);
        System.out.println("sql_name = " + this.sql_name);
        System.out.println("OracleType[] : ");
        if (this.types != null) {
            int n = 0;
            while (n < this.types.length) {
                System.out.println("[" + n + "] = " + this.types[n]);
                ++n;
            }
        } else {
            System.out.println("null");
        }
        System.out.println("LDS : ");
        if (this.LDS != null) {
            Util.printUnsignedByteArray(this.LDS);
        } else {
            System.out.println("null");
        }
        System.out.println("TDS : ");
        if (this.TDS != null) {
            Util.printUnsignedByteArray(this.TDS);
        } else {
            System.out.println("null");
        }
        System.out.println("toid : ");
        if (this.toid != null) {
            Util.printUnsignedByteArray(this.toid);
        } else {
            System.out.println("null");
        }
        System.out.println("fdo : ");
        if (this.fdo != null) {
            Util.printUnsignedByteArray(this.fdo);
        } else {
            System.out.println("null");
        }
        System.out.println("version : " + this.version);
        System.out.println("big_endian : " + (this.big_endian ? "true" : "false"));
        System.out.println("opcode : " + this.opcode);
        System.out.println("tdo_c_state : " + this.tdo_c_state);
    }
}

