/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;

public abstract class OracleType {
    int null_offset = 0;
    int lds_offset = 0;
    int size_for_lds = 0;
    int align_for_lds;
    int m_typeCode;
    int m_dbtypeCode;
    static final int KOPMAP_FLOAT = 2;
    static final int KOPMAP_SB4 = 4;
    static final int KOPMAP_PTR = 5;
    static final int KOPMAP_ORLD = 11;
    static final int KOPMAP_ORLN = 12;

    public abstract Datum toDatum(Object var1, OracleConnection var2) throws SQLException;

    public abstract Datum[] toDatumArray(Object var1, OracleConnection var2) throws SQLException;

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        this.null_offset = streamInfo.null_offset++;
        this.lds_offset = streamInfo.lds_offset++;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext) throws SQLException {
        return null;
    }

    public Datum unpicklerec(UnpickleContext unpickleContext, boolean bl) throws SQLException {
        return this.unpicklerec(unpickleContext);
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 5);
            this.align_for_lds = Util.FDO_get_align(byArray, 5);
        }
        return this.size_for_lds;
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 5);
            this.align_for_lds = Util.FDO_get_align(byArray, 5);
        }
        return this.align_for_lds;
    }

    protected int pickle81_calcsize(PickleContext pickleContext, Datum datum) throws SQLException {
        return (int)(datum.getLength() + (long)pickleContext.lenbytes_pctx((int)datum.getLength()));
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        int n = pickleContext.writeLength_pctx((int)datum.getLength());
        return n += pickleContext.write_data_pctx(datum.shareBytes());
    }

    protected Datum unpickle81rec(PickleContext pickleContext) throws SQLException {
        return null;
    }

    protected Datum unpickle81rec(PickleContext pickleContext, byte by) throws SQLException {
        return null;
    }

    public void setTypeCode(int n) {
        this.m_typeCode = n;
    }

    public int getTypeCode() {
        return this.m_typeCode;
    }

    public void setDBTypeCode(int n) {
        this.m_dbtypeCode = n;
    }

    public int getDBTypeCode() {
        return this.m_dbtypeCode;
    }
}

