/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oracle.jdbc.oracore.Util;

public class NullBytesOutputStream
extends OutputStream {
    public ByteArrayOutputStream barray = new ByteArrayOutputStream();
    int offset;
    byte current_byte;

    public void write(int n) throws IOException {
        this.current_byte = (byte)(this.current_byte | (byte)n << 2 * this.offset);
        ++this.offset;
        if (this.offset == 4) {
            this.barray.write(this.current_byte);
            this.current_byte = 0;
            this.offset = 0;
        }
    }

    public void flush() {
        if (this.offset != 0) {
            this.barray.write(this.current_byte);
            this.offset = 0;
            this.current_byte = 0;
        }
    }

    public void close() {
        this.flush();
    }

    public byte[] toBytes() {
        this.flush();
        int n = this.barray.size() + 4 + 4 + 2;
        byte[] byArray = new byte[n];
        Util.write_long(byArray, 0, n - 4);
        Util.write_long(byArray, 4, n - 8);
        byArray[8] = 2;
        byArray[9] = 1;
        System.arraycopy(this.barray.toByteArray(), 0, byArray, 10, this.barray.size());
        return byArray;
    }
}

