/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetCacheImpl;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc2.Array;
import oracle.jdbc2.Blob;
import oracle.jdbc2.Clob;
import oracle.jdbc2.Ref;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLUtil;
import oracle.sql.STRUCT;

public class ScrollableResultSet
extends BaseResultSet {
    public static boolean DEBUG;
    public OracleConnection m_conn;
    OracleResultSetImpl m_rset;
    ScrollRsetStatement m_scrollStmt;
    ResultSetMetaData m_metadata;
    private int m_type;
    private int m_update;
    private int m_beginColumnIndex;
    private int m_columnCount;
    private int m_wasNull;
    OracleResultSetCache m_cache;
    int m_currentRow;
    private int m_numRowsCached;
    private boolean m_allRowsCached;
    private int m_lastRefetchSz;
    private Vector m_refetchRowids;
    private OraclePreparedStatement m_refetchStmt;
    private int m_usrFetchDirection;

    public ScrollableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n, int n2) throws SQLException {
        this.m_conn = (OracleConnection)scrollRsetStatement.getConnection();
        this.m_rset = oracleResultSetImpl;
        this.m_metadata = null;
        this.m_scrollStmt = scrollRsetStatement;
        this.m_type = n;
        this.m_update = n2;
        this.m_beginColumnIndex = !(n == 1003 && n2 == 1007 || n == 1004 && n2 == 1007 && !false) ? 1 : 0;
        this.m_columnCount = 0;
        this.m_wasNull = -1;
        this.m_cache = scrollRsetStatement.getResultSetCache();
        if (this.m_cache == null) {
            this.m_cache = new OracleResultSetCacheImpl();
        } else {
            try {
                this.m_cache.clear();
            }
            catch (IOException iOException) {
                DBError.throwSqlException(iOException);
            }
        }
        this.m_currentRow = 0;
        this.m_numRowsCached = 0;
        this.m_allRowsCached = false;
        this.m_lastRefetchSz = 0;
        this.m_refetchRowids = null;
        this.m_refetchStmt = null;
        this.m_usrFetchDirection = 1000;
    }

    public synchronized void close() throws SQLException {
        if (this.m_rset != null) {
            this.m_rset.close();
        }
        if (this.m_refetchStmt != null) {
            this.m_refetchStmt.close();
        }
        if (this.m_scrollStmt != null) {
            this.m_scrollStmt.notify_close_rset();
        }
        if (this.m_refetchRowids != null) {
            this.m_refetchRowids.removeAllElements();
        }
        this.m_rset = null;
        this.m_scrollStmt = null;
        this.m_refetchStmt = null;
        this.m_refetchRowids = null;
        this.m_metadata = null;
        this.m_conn = null;
        try {
            this.m_cache.clear();
            this.m_cache.close();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.m_cache = null;
    }

    public synchronized boolean wasNull() throws SQLException {
        if (this.m_wasNull == -1) {
            DBError.throwSqlException(24);
        }
        return this.m_wasNull == 1;
    }

    public synchronized Statement getStatement() throws SQLException {
        return (Statement)((Object)this.m_scrollStmt);
    }

    synchronized void resetBeginColumnIndex() {
        this.m_beginColumnIndex = 0;
    }

    synchronized ResultSet getResultSet() {
        return this.m_rset;
    }

    synchronized int removeRowInCache(int n) throws SQLException {
        if (!this.isEmptyResultSet() && this.isValidRow(n)) {
            this.removeCachedRowAt(n);
            --this.m_numRowsCached;
            if (n >= this.m_currentRow) {
                --this.m_currentRow;
            }
            return 1;
        }
        return 0;
    }

    synchronized int refreshRowsInCache(int n, int n2, int n3) throws SQLException {
        int n4;
        OracleResultSet oracleResultSet;
        block6: {
            oracleResultSet = null;
            n4 = 0;
            n4 = this.get_refetch_size(n, n2, n3);
            try {
                if (n4 <= 0) break block6;
                if (n4 != this.m_lastRefetchSz) {
                    if (this.m_refetchStmt != null) {
                        this.m_refetchStmt.close();
                    }
                    this.m_refetchStmt = this.prepare_refetch_statement(n4);
                    this.m_lastRefetchSz = n4;
                }
                this.prepare_refetch_binds(this.m_refetchStmt, n4);
                oracleResultSet = (OracleResultSet)this.m_refetchStmt.executeQuery();
                this.save_refetch_results(oracleResultSet, n, n4, n3);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (oracleResultSet != null) {
                    oracleResultSet.close();
                }
                throw throwable;
            }
        }
        Object var7_6 = null;
        if (oracleResultSet != null) {
            oracleResultSet.close();
        }
        return n4;
    }

    public synchronized boolean next() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = this.m_currentRow < 1 ? 1 : ++this.m_currentRow;
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return !this.isEmptyResultSet() && this.m_currentRow < 1;
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return !this.isEmptyResultSet() && this.m_currentRow > 0 && !this.isValidRow(this.m_currentRow);
    }

    public synchronized boolean isFirst() throws SQLException {
        return this.m_currentRow == 1;
    }

    public synchronized boolean isLast() throws SQLException {
        return !this.isEmptyResultSet() && this.isValidRow(this.m_currentRow) && !this.isValidRow(this.m_currentRow + 1);
    }

    public synchronized void beforeFirst() throws SQLException {
        if (!this.isEmptyResultSet()) {
            this.m_currentRow = 0;
        }
    }

    public synchronized void afterLast() throws SQLException {
        if (!this.isEmptyResultSet()) {
            if (!this.m_allRowsCached) {
                this.cacheAllRows();
            }
            this.m_currentRow = this.m_numRowsCached + 1;
        }
    }

    public synchronized boolean first() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = 1;
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized boolean last() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (!this.m_allRowsCached) {
            this.cacheAllRows();
        }
        this.m_currentRow = this.m_numRowsCached;
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized int getRow() throws SQLException {
        if (this.isValidRow(this.m_currentRow)) {
            return this.m_currentRow;
        }
        return 0;
    }

    public synchronized boolean absolute(int n) throws SQLException {
        if (n == 0) {
            DBError.throwSqlException(68, "absolute (0)");
        }
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (n > 0) {
            this.m_currentRow = n;
        } else if (n < 0) {
            if (!this.m_allRowsCached) {
                this.cacheAllRows();
            }
            this.m_currentRow = this.m_numRowsCached + 1 + n;
        }
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized boolean relative(int n) throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (this.isValidRow(this.m_currentRow)) {
            this.m_currentRow += n;
            return this.isValidRow(this.m_currentRow);
        }
        DBError.throwSqlException(82, "relative");
        return false;
    }

    public synchronized boolean previous() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (this.isAfterLast()) {
            if (!this.m_allRowsCached) {
                this.cacheAllRows();
            }
            this.m_currentRow = this.m_numRowsCached;
        } else {
            --this.m_currentRow;
        }
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized Datum getOracleObject(int n) throws SQLException {
        Datum datum;
        if (DEBUG) {
            System.out.println("rownum = " + this.m_currentRow + " " + n);
        }
        this.m_wasNull = -1;
        if (!this.isValidRow(this.m_currentRow)) {
            DBError.throwSqlException(11);
        }
        if (n < 1 || n > this.getColumnCount()) {
            DBError.throwSqlException(3);
        }
        this.m_wasNull = (datum = this.getCachedDatumValueAt(this.m_currentRow, n + this.m_beginColumnIndex)) == null ? 1 : 0;
        return datum;
    }

    public synchronized String getString(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.stringValue();
        }
        return null;
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.booleanValue();
        }
        return false;
    }

    public synchronized byte getByte(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.byteValue();
        }
        return 0;
    }

    public synchronized short getShort(int n) throws SQLException {
        long l = this.getLong(n);
        if (l > 65537L || l < -65538L) {
            DBError.check_error(26, "getShort");
        }
        return (short)l;
    }

    public synchronized int getInt(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.intValue();
        }
        return 0;
    }

    public synchronized long getLong(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.longValue();
        }
        return 0L;
    }

    public synchronized float getFloat(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.floatValue();
        }
        return 0.0f;
    }

    public synchronized double getDouble(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.doubleValue();
        }
        return 0.0;
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.bigDecimalValue();
        }
        return null;
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof RAW) {
                return ((RAW)datum).shareBytes();
            }
            DBError.check_error(4, "getBytes");
        }
        return null;
    }

    public synchronized Date getDate(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.dateValue();
        }
        return null;
    }

    public synchronized Time getTime(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.timeValue();
        }
        return null;
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.timestampValue();
        }
        return null;
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.asciiStreamValue();
        }
        return null;
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            DBConversion dBConversion = this.m_conn.conversion;
            byte[] byArray = datum.shareBytes();
            if (datum instanceof RAW) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
            }
            if (datum instanceof CHAR) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
            }
            DBError.check_error(4, "getUnicodeStream");
        }
        return null;
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.binaryStreamValue();
        }
        return null;
    }

    public synchronized Object getObject(int n) throws SQLException {
        return this.getObject(n, this.m_conn.getTypeMap());
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.characterStreamValue();
        }
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 0);
    }

    public synchronized Object getObject(int n, Dictionary dictionary) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return ((STRUCT)datum).toJdbc(dictionary);
            }
            datum.toJdbc();
        }
        return null;
    }

    public synchronized Ref getRef(int n) throws SQLException {
        return this.getREF(n);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        return this.getBLOB(n);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        return this.getCLOB(n);
    }

    public synchronized Array getArray(int n) throws SQLException {
        return this.getARRAY(n);
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public synchronized ResultSet getCursor(int n) throws SQLException {
        DBError.check_error(4, "getCursor");
        return null;
    }

    public synchronized ROWID getROWID(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof ROWID) {
                return (ROWID)datum;
            }
            DBError.check_error(4, "getROWID");
        }
        return null;
    }

    public synchronized NUMBER getNUMBER(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof NUMBER) {
                return (NUMBER)datum;
            }
            DBError.check_error(4, "getNUMBER");
        }
        return null;
    }

    public synchronized DATE getDATE(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof DATE) {
                return (DATE)datum;
            }
            DBError.check_error(4, "getDATE");
        }
        return null;
    }

    public synchronized ARRAY getARRAY(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof ARRAY) {
                return (ARRAY)datum;
            }
            DBError.check_error(4, "getARRAY");
        }
        return null;
    }

    public synchronized STRUCT getSTRUCT(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return (STRUCT)datum;
            }
            DBError.check_error(4, "getSTRUCT");
        }
        return null;
    }

    public synchronized REF getREF(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof REF) {
                return (REF)datum;
            }
            DBError.check_error(4, "getREF");
        }
        return null;
    }

    public synchronized CHAR getCHAR(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof CHAR) {
                return (CHAR)datum;
            }
            DBError.check_error(4, "getCHAR");
        }
        return null;
    }

    public synchronized RAW getRAW(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof RAW) {
                return (RAW)datum;
            }
            DBError.check_error(4, "getRAW");
        }
        return null;
    }

    public synchronized BLOB getBLOB(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof BLOB) {
                return (BLOB)datum;
            }
            DBError.check_error(4, "getBLOB");
        }
        return null;
    }

    public synchronized CLOB getCLOB(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof CLOB) {
                return (CLOB)datum;
            }
            DBError.check_error(4, "getCLOB");
        }
        return null;
    }

    public synchronized BFILE getBFILE(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof BFILE) {
                return (BFILE)datum;
            }
            DBError.check_error(4, "getBFILE");
        }
        return null;
    }

    public synchronized BFILE getBfile(int n) throws SQLException {
        return this.getBFILE(n);
    }

    public synchronized CustomDatum getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        Datum datum = this.getOracleObject(n);
        return customDatumFactory.create(datum, 0);
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        return new OracleResultSetMetaData(this.m_conn, (OracleStatement)this.m_scrollStmt, this.m_beginColumnIndex);
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.m_rset.findColumn(string) - this.m_beginColumnIndex;
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        if (n == 1000) {
            this.m_usrFetchDirection = n;
            return;
        }
        if (n == 1001 || n == 1002) {
            this.m_usrFetchDirection = n;
            this.m_warning = DBError.addSqlWarning(this.m_warning, 87);
            return;
        }
        DBError.throwSqlException(68, "setFetchDirection");
    }

    public synchronized int getFetchDirection() throws SQLException {
        return 1000;
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.m_rset.setFetchSize(n);
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.m_rset.getFetchSize();
    }

    public int getType() throws SQLException {
        return this.m_type;
    }

    public int getConcurrency() throws SQLException {
        return this.m_update;
    }

    public void refreshRow() throws SQLException {
        int n = this.m_type;
        int n2 = this.m_update;
        if (n == 1003 && n2 == 1007 || n == 1004 && n2 == 1007 && !false) {
            DBError.check_error(23, "refreshRow");
        }
        if (this.isValidRow(this.m_currentRow)) {
            n = this.getFetchDirection();
            try {
                this.refreshRowsInCache(this.m_currentRow, this.getFetchSize(), n);
                return;
            }
            catch (SQLException sQLException) {
                DBError.throwSqlException(sQLException, 90, "Unsupported syntax for refreshRow()");
                return;
            }
        }
        DBError.throwSqlException(82, "refreshRow");
    }

    private boolean isEmptyResultSet() throws SQLException {
        if (this.m_numRowsCached != 0) {
            return false;
        }
        if (this.m_numRowsCached == 0 && this.m_allRowsCached) {
            return true;
        }
        return !this.isValidRow(1);
    }

    boolean isValidRow(int n) throws SQLException {
        if (n > 0 && n <= this.m_numRowsCached) {
            return true;
        }
        if (n <= 0) {
            return false;
        }
        return this.cacheRowAt(n);
    }

    private boolean cacheRowAt(int n) throws SQLException {
        if (DEBUG) {
            System.out.println("cacheRowAt (" + n + ") ......");
        }
        while (this.m_numRowsCached < n && this.m_rset.next()) {
            int n2 = 0;
            while (n2 < this.getColumnCount()) {
                byte[] byArray = this.m_rset.getBytes(n2 + 1);
                this.putCachedValueAt(this.m_numRowsCached + 1, n2 + 1, byArray);
                ++n2;
            }
            ++this.m_numRowsCached;
        }
        if (this.m_numRowsCached < n) {
            this.m_allRowsCached = true;
            return false;
        }
        return true;
    }

    private int cacheAllRows() throws SQLException {
        while (this.m_rset.next()) {
            int n = 0;
            while (n < this.getColumnCount()) {
                this.putCachedValueAt(this.m_numRowsCached + 1, n + 1, this.m_rset.getBytes(n + 1));
                ++n;
            }
            ++this.m_numRowsCached;
        }
        this.m_allRowsCached = true;
        return this.m_numRowsCached;
    }

    int getColumnCount() throws SQLException {
        if (this.m_columnCount == 0) {
            if (this.m_rset.statement.defines != null && this.m_rset.statement.defines.data != null) {
                this.m_columnCount = this.m_rset.statement.defines.data.length;
            } else {
                if (this.m_metadata == null) {
                    this.m_metadata = this.m_rset.getMetaData();
                }
                this.m_columnCount = this.m_metadata.getColumnCount();
            }
        }
        return this.m_columnCount;
    }

    private ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.m_metadata == null) {
            this.m_metadata = this.m_rset.getMetaData();
        }
        return this.m_metadata;
    }

    private int getLastRow() throws SQLException {
        if (!this.m_allRowsCached) {
            this.cacheAllRows();
        }
        return this.m_numRowsCached;
    }

    private int get_refetch_size(int n, int n2, int n3) throws SQLException {
        int n4 = n3 == 1001 ? -1 : 1;
        int n5 = 0;
        if (this.m_refetchRowids == null) {
            this.m_refetchRowids = new Vector(10);
        } else {
            this.m_refetchRowids.removeAllElements();
        }
        while (n5 < n2 && this.isValidRow(n + n5 * n4)) {
            this.m_refetchRowids.addElement(this.getCachedDatumValueAt(n + n5 * n4, 1));
            ++n5;
        }
        return n5;
    }

    private OraclePreparedStatement prepare_refetch_statement(int n) throws SQLException {
        if (n < 1) {
            DBError.throwSqlException(68);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_scrollStmt.getRevisedSql().toUpperCase().indexOf("WHERE") == -1) {
            stringBuffer.append(this.m_scrollStmt.getRevisedSql());
            stringBuffer.append(" WHERE ( ROWID = ?");
        } else {
            stringBuffer.append(this.m_scrollStmt.getRevisedSql());
            stringBuffer.append(" AND ( rowid = ?");
        }
        int n2 = 0;
        while (n2 < n - 1) {
            stringBuffer.append(" OR rowid = ?");
            ++n2;
        }
        stringBuffer.append(" )");
        if (DEBUG) {
            System.out.println("refetch sql = " + stringBuffer.toString());
        }
        return (OraclePreparedStatement)this.m_conn.prepareStatement(stringBuffer.toString());
    }

    private void prepare_refetch_binds(OraclePreparedStatement oraclePreparedStatement, int n) throws SQLException {
        int n2;
        int n3 = 0;
        DBDataSet dBDataSet = this.m_scrollStmt.getBinds();
        if (dBDataSet != null) {
            n3 = dBDataSet.types.length;
            n2 = 0;
            while (n2 < n3) {
                oraclePreparedStatement.setItem(n2, (dBDataSet.types != null && n2 >= 0 && n2 < dBDataSet.types.length ? dBDataSet.types[n2] : null).type, dBDataSet.getDBItem((int)n2, (int)0).byte_value);
                ++n2;
            }
        }
        if (DEBUG) {
            System.out.println("numSubQueryBinds = " + n3);
        }
        n2 = 0;
        while (n2 < n) {
            oraclePreparedStatement.setROWID(n3 + n2 + 1, (ROWID)this.m_refetchRowids.elementAt(n2));
            ++n2;
        }
    }

    private void save_refetch_results(OracleResultSet oracleResultSet, int n, int n2, int n3) throws SQLException {
        int n4 = n3 == 1001 ? -1 : 1;
        while (oracleResultSet.next()) {
            ROWID rOWID = oracleResultSet.getROWID(1);
            boolean bl = false;
            int n5 = n;
            while (!bl && n5 < n + n2 * n4) {
                if (((ROWID)this.getCachedDatumValueAt(n5, 1)).stringValue().equals(rOWID.stringValue())) {
                    bl = true;
                    continue;
                }
                n5 += n4;
            }
            if (!bl) continue;
            int n6 = 0;
            while (n6 < this.getColumnCount()) {
                this.putCachedValueAt(n5, n6 + 1, oracleResultSet.getOracleObject(n6 + 1));
                ++n6;
            }
        }
    }

    private Object getCachedValueAt(int n, int n2) throws SQLException {
        try {
            return this.m_cache.get(n, n2);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return null;
        }
    }

    private Datum getCachedDatumValueAt(int n, int n2) throws SQLException {
        Object object = null;
        try {
            object = this.m_cache.get(n, n2);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        Datum datum = null;
        if (object != null) {
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else if (((byte[])object).length > 0) {
                if (this.m_metadata == null) {
                    this.m_metadata = this.m_rset.getMetaData();
                }
                int n3 = this.m_metadata.getColumnType(n2);
                String string = null;
                if (n3 == 2006 || n3 == 2002 || n3 == 2003) {
                    if (this.m_metadata == null) {
                        this.m_metadata = this.m_rset.getMetaData();
                    }
                    string = this.m_metadata.getColumnTypeName(n2);
                }
                datum = SQLUtil.makeDatum(this.m_conn, (byte[])object, SQLUtil.get_internal_type(n3), string);
                try {
                    this.m_cache.put(n, n2, datum);
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                try {
                    this.m_cache.put(n, n2, null);
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            }
        }
        return datum;
    }

    private void putCachedValueAt(int n, int n2, Object object) throws SQLException {
        try {
            this.m_cache.put(n, n2, object);
            return;
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return;
        }
    }

    private void removeCachedRowAt(int n) throws SQLException {
        try {
            this.m_cache.remove(n);
            return;
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return;
        }
    }

    public static boolean needIdentifier(int n, int n2) {
        return (n != 1003 || n2 != 1007) && (n != 1004 || n2 != 1007);
    }

    public static boolean needCache(int n, int n2) {
        return n != 1003 && (n != 1004 || n2 != 1007);
    }

    public static boolean supportRefreshRow(int n, int n2) {
        return n != 1003 && (n != 1004 || n2 != 1007);
    }
}

