/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;

class ResultSetUtil {
    static final int[][] s_allRsetTypes = new int[][]{new int[2], {1003, 1007}, {1003, 1008}, {1004, 1007}, {1004, 1008}, {1005, 1007}, {1005, 1008}};

    static OracleResultSet createScrollResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSet oracleResultSet, int n) throws SQLException {
        switch (n) {
            case 1: {
                return oracleResultSet;
            }
            case 2: {
                return new UpdatableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, s_allRsetTypes[n][0], s_allRsetTypes[n][1]);
            }
            case 3: {
                return new ScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, s_allRsetTypes[n][0], s_allRsetTypes[n][1]);
            }
            case 4: {
                ScrollableResultSet scrollableResultSet = new ScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, s_allRsetTypes[n][0], s_allRsetTypes[n][1]);
                return new UpdatableResultSet(scrollRsetStatement, scrollableResultSet, s_allRsetTypes[n][0], s_allRsetTypes[n][1]);
            }
            case 5: {
                return new SensitiveScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, s_allRsetTypes[n][0], s_allRsetTypes[n][1]);
            }
            case 6: {
                SensitiveScrollableResultSet sensitiveScrollableResultSet = new SensitiveScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, s_allRsetTypes[n][0], s_allRsetTypes[n][1]);
                return new UpdatableResultSet(scrollRsetStatement, sensitiveScrollableResultSet, s_allRsetTypes[n][0], s_allRsetTypes[n][1]);
            }
        }
        DBError.check_error(23, null);
        return null;
    }

    static String addIdentifierToSql(String string) throws SQLException {
        String string2 = string.toLowerCase();
        int n = string2.indexOf("select");
        if (n == -1) {
            DBError.throwSqlException(88);
        }
        return "select rowid," + string.substring(n + "select".length());
    }

    static int getScrollType(int n) {
        return s_allRsetTypes[n][0];
    }

    static int getUpdateConcurrency(int n) {
        return s_allRsetTypes[n][1];
    }

    static int getRsetTypeCode(int n, int n2) throws SQLException {
        int n3 = 0;
        while (n3 < s_allRsetTypes.length) {
            if (s_allRsetTypes[n3][0] == n && s_allRsetTypes[n3][1] == n2) {
                return n3;
            }
            ++n3;
        }
        DBError.throwSqlException(1);
        return 0;
    }

    public static boolean needIdentifier(int n) throws SQLException {
        return n != 1 && n != 3;
    }

    public static boolean needIdentifier(int n, int n2) throws SQLException {
        int n3 = ResultSetUtil.getRsetTypeCode(n, n2);
        return n3 != 1 && n3 != 3;
    }

    public static boolean needCache(int n) throws SQLException {
        return n >= 3;
    }

    public static boolean needCache(int n, int n2) throws SQLException {
        int n3 = ResultSetUtil.getRsetTypeCode(n, n2);
        return n3 >= 3;
    }

    public static boolean supportRefreshRow(int n) throws SQLException {
        return n >= 4;
    }

    public static boolean supportRefreshRow(int n, int n2) throws SQLException {
        int n3 = ResultSetUtil.getRsetTypeCode(n, n2);
        return n3 >= 4;
    }

    ResultSetUtil() {
    }
}

