/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBStatement;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleCancelThread;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.util.RepConversion;
import oracle.jdbc2.BatchUpdateException;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLUtil;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleStatement
implements Statement,
ScrollRsetStatement {
    static final boolean DEBUG = false;
    static final boolean DEBUG_DATASET = false;
    DBColumn[] dbdescription;
    DBDataSet binds_out;
    DBDataSet binds_in;
    public DBDataSet defines;
    OracleConnection connection;
    OracleInputStream streams;
    InputStream[] stream_array;
    OracleResultSetImpl current_result_set;
    boolean process_escapes;
    protected int m_queryTimeout;
    public DBStatement dbstmt;
    int batch;
    int row_prefetch;
    protected int m_currentRank;
    int current_row;
    int valid_rows;
    int max_field_size;
    int max_rows;
    int total_rows_visited;
    boolean got_last_batch;
    boolean first_row;
    boolean clear_params;
    int new_row_prefetch;
    public boolean closed;
    boolean sql_string_changed;
    String sql_query;
    boolean need_to_parse;
    boolean need_to_prepare_define_buffer;
    boolean columns_defined_by_user;
    byte sql_kind;
    byte[] array_sql;
    public int auto_rollback;
    public int wait_option;
    private int m_lastFetchedColumn;
    private DBDataSet m_currentDataSet;
    int default_fetch_direction;
    int default_row_prefetch;
    OracleResultSet m_scrollRset;
    DBType[] m_userDefineTypes;
    OracleResultSetCache m_cache;
    int m_userRsetType;
    int m_realRsetType;
    String m_originalSql;
    String m_revisedSql;
    boolean m_needToAddIdentifier;
    SQLWarning m_warning;
    Hashtable m_refCursorList;
    boolean last_was_column;
    int last_index;
    private Vector m_batchItems = new Vector();

    void initialize(int n, int n2) {
        this.connection.add_statement(this);
        this.current_result_set = null;
        this.streams = null;
        this.last_index = 0;
        this.process_escapes = true;
        this.m_queryTimeout = 0;
        this.auto_rollback = 2;
        this.wait_option = 0;
        this.batch = n;
        this.row_prefetch = n2;
        this.default_row_prefetch = n2;
        this.m_currentRank = 0;
        this.current_row = 0;
        this.valid_rows = 0;
        this.max_rows = 0;
        this.total_rows_visited = 0;
        this.max_field_size = 0;
        this.got_last_batch = false;
        this.binds_in = null;
        this.binds_out = null;
        this.defines = new DBDataSet(this.connection, 0);
        this.stream_array = null;
        this.closed = false;
        this.clear_params = false;
        this.sql_string_changed = true;
        this.need_to_parse = true;
        this.need_to_prepare_define_buffer = true;
        this.columns_defined_by_user = false;
        this.default_fetch_direction = 1000;
        this.m_scrollRset = null;
        this.m_userRsetType = 1;
        this.m_realRsetType = 1;
        this.m_originalSql = null;
        this.m_revisedSql = null;
        this.m_userDefineTypes = null;
        this.m_needToAddIdentifier = false;
        this.m_refCursorList = null;
    }

    public OracleStatement(OracleConnection oracleConnection, int n, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(oracleConnection, 1, 16, 16, "OracleStatement.OracleStatement(conn, batchValue=" + n + ", rowPrefetchValue=" + n2 + ")");
        }
        this.connection = oracleConnection;
        try {
            this.connection.needLine();
            this.dbstmt = this.connection.db_access.open();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.initialize(n, n2);
    }

    public OracleStatement(OracleConnection oracleConnection, int n, int n2, int n3, int n4) throws SQLException {
        this(oracleConnection, n, n2);
        this.m_realRsetType = 0;
        int n5 = this.m_userRsetType = ResultSetUtil.getRsetTypeCode(n3, n4);
        this.m_needToAddIdentifier = n5 != 1 && n5 != 3;
    }

    public OracleStatement(OracleConnection oracleConnection, DBStatement dBStatement, int n, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(oracleConnection, 1, 16, 16, "OracleStatement.OracleStatement(conn, cursorDbstmt, batchValue=" + n + ", rowPrefetchValue=" + n2 + ")");
        }
        this.connection = oracleConnection;
        DBAccess dBAccess = this.connection.db_access;
        this.dbstmt = dBStatement;
        this.initialize(n, n2);
        this.prepare_for_new_result();
        this.current_result_set = new OracleResultSetImpl(this.connection, this);
        try {
            this.connection.needLine();
            this.dbdescription = this.connection.db_access.describe(this.dbstmt);
            this.need_to_parse = false;
            this.doDefaultTypes();
            this.doDefinesFromTypes();
            this.need_to_prepare_define_buffer = false;
            this.connection.needLine();
            this.valid_rows = dBAccess.fetch(this.dbstmt, this.defines.types, this.defines.data, this.row_prefetch);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.checkValidRowsStatus();
    }

    public synchronized ResultSet executeQuery(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.executeQuery(sql)");
            OracleLog.print(this.connection, 1, 16, 32, "SQL: \"" + string + "\"");
        }
        if (this.m_batchItems.size() > 0) {
            DBError.throwSqlException(81, "batch must be either executed or cleared");
        }
        if (this.closed) {
            DBError.throwSqlException(9);
        }
        this.sendBatch();
        this.need_to_parse = true;
        this.sql_string_changed = true;
        this.sql_query = string;
        this.new_row_prefetch = this.default_row_prefetch;
        this.prepare_for_new_result();
        if (this.isRegularResultSet()) {
            this.doExecuteWithTimeout();
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            return this.current_result_set;
        }
        this.m_scrollRset = this.doScrollStmtExecuteQuery(string);
        if (this.m_scrollRset == null) {
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            return this.current_result_set;
        }
        return this.m_scrollRset;
    }

    public synchronized void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.close()");
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.connection.remove_statement(this);
        try {
            if (this.m_refCursorList != null) {
                Enumeration enumeration = this.m_refCursorList.elements();
                while (enumeration.hasMoreElements()) {
                    Statement statement = (Statement)enumeration.nextElement();
                    statement.close();
                    statement = null;
                }
                this.m_refCursorList = null;
                enumeration = null;
            }
            this.scrollStmt_cleanup(true);
            this.m_userDefineTypes = null;
            this.clearWarnings();
            boolean bl = this.connection.XA_wants_error;
            this.connection.XA_wants_error = false;
            this.connection.needLine();
            if (this.current_result_set != null) {
                this.current_result_set.internal_close();
                this.current_result_set = null;
            }
            this.connection.db_access.close(this.dbstmt);
            this.connection.XA_wants_error = bl;
            this.cleanup();
            return;
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return;
        }
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.executeUpdate(sql)");
            OracleLog.print(this.connection, 1, 16, 32, "SQL: \"" + string + "\"");
        }
        if (this.m_batchItems.size() > 0) {
            DBError.throwSqlException(81, "batch must be either executed or cleared");
        }
        if (this.closed) {
            DBError.throwSqlException(9);
        }
        this.sendBatch();
        this.need_to_parse = true;
        this.sql_string_changed = true;
        this.sql_query = string;
        this.new_row_prefetch = this.default_row_prefetch;
        this.prepare_for_new_result();
        if (this.isRegularResultSet()) {
            this.doExecuteWithTimeout();
        } else {
            this.doScrollStmtExecuteQuery(string);
        }
        return this.valid_rows;
    }

    public synchronized boolean execute(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.execute(sql)");
            OracleLog.print(this.connection, 1, 16, 32, "SQL: \"" + string + "\"");
        }
        if (this.m_batchItems.size() > 0) {
            DBError.throwSqlException(81, "batch must be either executed or cleared");
        }
        if (this.closed) {
            DBError.throwSqlException(9);
        }
        this.sendBatch();
        this.need_to_parse = true;
        this.sql_string_changed = true;
        this.sql_query = string;
        this.new_row_prefetch = this.default_row_prefetch;
        this.prepare_for_new_result();
        if (this.isRegularResultSet()) {
            this.doExecuteWithTimeout();
        } else {
            this.doScrollStmtExecuteQuery(string);
        }
        return this.sql_kind == 0;
    }

    public DBColumn[] getDBDescription() throws SQLException {
        return this.dbdescription;
    }

    byte getSqlKind(String string) {
        String string2 = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "\n \t /", true);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("select")) {
                    return 0;
                }
                if (string2.equalsIgnoreCase("begin") || string2.equalsIgnoreCase("call") || string2.equalsIgnoreCase("declare")) {
                    return 1;
                }
                if (string2.equals("/")) {
                    string2 = stringTokenizer.nextToken();
                    while (!string2.equals("*") || !stringTokenizer.nextToken().equals("/")) {
                        string2 = stringTokenizer.nextToken();
                    }
                    continue;
                }
                if (string2.equals("--")) {
                    while (!stringTokenizer.nextToken().equals("\n")) {
                    }
                    continue;
                }
                if (string2.equals("\n") || string2.equals("\t") || string2.equals(" ")) continue;
                return 2;
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        return 2;
    }

    void doDefaultTypes() throws SQLException {
        this.connection.trace("doDefaultTypes");
        int n = this.dbdescription.length;
        int n2 = this.connection.db_access.getNlsRatio();
        this.defines.types = new DBType[n];
        int n3 = 0;
        while (n3 < n) {
            DBType dBType = null;
            DBColumn dBColumn = this.dbdescription[n3];
            switch (dBColumn.type) {
                case 8: {
                    dBType = this.connection.db_access.createDBType(8, false);
                    if (this.max_field_size != 0 && this.max_field_size <= dBType.max_length) {
                        dBType.setMaxSize(this.max_field_size);
                    }
                    DBDataSet dBDataSet = this.defines;
                    if (dBDataSet.types == null || n3 < 0 || n3 >= dBDataSet.types.length) break;
                    dBDataSet.types[n3] = dBType;
                    break;
                }
                case 24: {
                    dBType = this.connection.db_access.createDBType(24, false);
                    if (this.max_field_size != 0) {
                        dBType.setMaxSize(Math.min(this.max_field_size, dBType.max_length));
                    }
                    DBDataSet dBDataSet = this.defines;
                    if (dBDataSet.types == null || n3 < 0 || n3 >= dBDataSet.types.length) break;
                    dBDataSet.types[n3] = dBType;
                    break;
                }
                case 23: {
                    int n4 = dBColumn.max_length;
                    if (this.max_field_size != 0) {
                        n4 = Math.min(this.max_field_size, n4);
                    }
                    dBType = this.connection.db_access.createDBType(dBColumn.type, false);
                    dBType.setMaxSize(n4);
                    DBDataSet dBDataSet = this.defines;
                    if (dBDataSet.types == null || n3 < 0 || n3 >= dBDataSet.types.length) break;
                    dBDataSet.types[n3] = dBType;
                    break;
                }
                case 1: 
                case 96: {
                    int n5 = dBColumn.max_length;
                    n5 = this.max_field_size != 0 && this.max_field_size <= n5 ? this.max_field_size : (n5 *= n2);
                    dBType = this.connection.db_access.createDBType(dBColumn.type, false);
                    dBType.setMaxSize(n5);
                    DBDataSet dBDataSet = this.defines;
                    if (dBDataSet.types == null || n3 < 0 || n3 >= dBDataSet.types.length) break;
                    dBDataSet.types[n3] = dBType;
                    break;
                }
                case 12: {
                    dBType = this.connection.db_access.createDBType(dBColumn.type, false);
                    DBDataSet dBDataSet = this.defines;
                    if (dBDataSet.types == null || n3 < 0 || n3 >= dBDataSet.types.length) break;
                    dBDataSet.types[n3] = dBType;
                    break;
                }
                case 2: 
                case 6: {
                    dBType = this.connection.db_access.createDBType(6, false);
                    DBDataSet dBDataSet = this.defines;
                    if (dBDataSet.types == null || n3 < 0 || n3 >= dBDataSet.types.length) break;
                    dBDataSet.types[n3] = dBType;
                    break;
                }
                case 104: {
                    dBType = this.connection.db_access.createDBType(104, false);
                    DBDataSet dBDataSet = this.defines;
                    if (dBDataSet.types == null || n3 < 0 || n3 >= dBDataSet.types.length) break;
                    dBDataSet.types[n3] = dBType;
                    break;
                }
                case 102: {
                    dBType = this.connection.db_access.createDBType(102, false);
                    DBDataSet dBDataSet = this.defines;
                    if (dBDataSet.types == null || n3 < 0 || n3 >= dBDataSet.types.length) break;
                    dBDataSet.types[n3] = dBType;
                    break;
                }
                case 109: {
                    dBType = this.connection.db_access.createDBType(109, false);
                    dBType.otype = dBColumn.otype;
                    DBDataSet dBDataSet = this.defines;
                    if (dBDataSet.types == null || n3 < 0 || n3 >= dBDataSet.types.length) break;
                    dBDataSet.types[n3] = dBType;
                    break;
                }
                case 111: {
                    dBType = this.connection.db_access.createDBType(111, false);
                    dBType.otype = dBColumn.otype;
                    DBDataSet dBDataSet = this.defines;
                    if (dBDataSet.types == null || n3 < 0 || n3 >= dBDataSet.types.length) break;
                    dBDataSet.types[n3] = dBType;
                    break;
                }
                default: {
                    dBType = this.connection.db_access.createDBType(dBColumn.type, false);
                    dBType.setMaxSize(dBColumn.max_length);
                    DBDataSet dBDataSet = this.defines;
                    if (dBDataSet.types == null || n3 < 0 || n3 >= dBDataSet.types.length) break;
                    dBDataSet.types[n3] = dBType;
                }
            }
            ++n3;
        }
    }

    void doDefinesFromTypes() throws SQLException {
        Object object;
        this.streams = null;
        int n = this.defines.types.length;
        this.connection.trace("doDefinesFromTypes");
        int n2 = 0;
        while (n2 < n) {
            object = this.defines.types[n2];
            if (((DBType)object).is_stream) {
                this.row_prefetch = 1;
                this.stream_array = new InputStream[n];
                break;
            }
            ++n2;
        }
        this.defines.createArrayFromTypes(this.row_prefetch);
        n2 = 0;
        while (n2 < n) {
            DBType dBType = this.defines.types[n2];
            if (dBType.is_stream) {
                OracleInputStream oracleInputStream = new OracleInputStream(this, n2 + 1, this.streams);
                object = this.connection.db_access.createDBItem(dBType);
                ((DBItem)object).defineStreamData(oracleInputStream);
                this.streams = (OracleInputStream)((DBItem)object).stream_value;
                this.defines.setDBItem((DBItem)object, n2, 0);
            } else {
                object = this.connection.db_access.createDBItem(dBType);
                if (dBType.type != 109 && dBType.type != 111) {
                    ((DBItem)object).allocBuffer();
                }
                this.defines.setRowItems(n2, (DBItem)object);
            }
            ++n2;
        }
        if (this.stream_array != null) {
            this.stream_array[0] = null;
            n2 = 1;
            while (n2 < n) {
                this.stream_array[n2] = !this.defines.types[n2 - 1].is_stream ? this.stream_array[n2 - 1] : this.defines.data[n2 - 1].getItem((int)0).stream_value;
                ++n2;
            }
        }
        this.initializeColumnsToFetch(this.defines);
    }

    public synchronized void clearDefines() throws SQLException {
        this.columns_defined_by_user = false;
        this.need_to_prepare_define_buffer = true;
        this.defines = new DBDataSet(this.connection, 0);
        this.stream_array = null;
    }

    public synchronized void defineColumnType(int n, int n2) throws SQLException {
        this.defineColumnType(n, n2, null);
    }

    public synchronized void defineColumnType(int n, int n2, int n3) throws SQLException {
        if (n3 < 0) {
            DBError.throwSqlException(53);
        }
        this.defineColumnType(n, n2, null);
        int n4 = this.max_field_size != 0 ? Math.min(n3, this.max_field_size) : n3;
        this.defines.types[n - 1].max_length = n4 = Math.min(this.defines.types[n - 1].max_length, n4);
    }

    public synchronized void defineColumnType(int n, int n2, String string) throws SQLException {
        DBType[] dBTypeArray;
        if (this.current_result_set != null && !this.current_result_set.closed) {
            DBError.throwSqlException(28);
        }
        if (!this.columns_defined_by_user) {
            this.clearDefines();
            this.columns_defined_by_user = true;
        }
        this.need_to_prepare_define_buffer = true;
        int n3 = this.get_internal_type(n2);
        DBType dBType = this.connection.db_access.createDBType(n3, false);
        switch (n2) {
            case 2002: 
            case 2006: {
                dBTypeArray = StructDescriptor.createDescriptor(string, this.connection);
                dBType.otype = dBTypeArray.getOracleTypeADT();
                break;
            }
            case 2003: {
                dBTypeArray = ArrayDescriptor.createDescriptor(string, this.connection);
                dBType.otype = dBTypeArray.getOracleTypeCOLLECTION();
            }
        }
        if (this.max_field_size != 0) {
            dBType.max_length = Math.min(this.max_field_size, dBType.max_length);
        }
        if (this.defines.types == null) {
            this.defines.types = new DBType[n];
            this.defines.types[n - 1] = dBType;
            return;
        }
        if (this.defines.types.length < n) {
            dBTypeArray = this.defines.types;
            this.defines.types = new DBType[n];
            System.arraycopy(dBTypeArray, 0, this.defines.types, 0, dBTypeArray.length);
            this.defines.types[n - 1] = dBType;
            return;
        }
        this.defines.types[n - 1] = dBType;
    }

    public synchronized void setRowPrefetch(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.setRowPrefetch(value=" + n + ")");
        }
        if (n <= 0) {
            DBError.throwSqlException(20);
        }
        this.new_row_prefetch = n;
    }

    public synchronized int getRowPrefetch() {
        int n;
        int n2 = n = this.new_row_prefetch != 0 ? this.new_row_prefetch : this.row_prefetch;
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.getRowPrefetch() returned " + n);
        }
        return n;
    }

    void checkBindsInAndOut() throws SQLException {
        if (!this.first_row && !this.clear_params) {
            return;
        }
        this.clear_params = false;
        int n = 0;
        if (this.binds_in != null && this.binds_in.types != null) {
            n = this.binds_in.types.length;
        }
        if (this.binds_out != null && this.binds_out.types != null && this.binds_out.types.length > n) {
            n = this.binds_out.types.length;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!(this.binds_in != null && this.binds_in.data != null && n2 < this.binds_in.data.length && this.binds_in.data[n2] != null && this.binds_in.data[n2].getItem(this.m_currentRank) != null || this.binds_out != null && this.binds_out.data != null && n2 < this.binds_out.data.length && this.binds_out.data[n2] != null && this.binds_out.data[n2].getItem(this.m_currentRank) != null)) {
                DBError.throwSqlException(41, new Integer(n2 + 1));
            }
            ++n2;
        }
    }

    void doExecuteOther(boolean bl) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.doExecuteOther(batchForPlsql=" + bl + ")");
            OracleLog.print(this.connection, 1, 16, 32, "Before execute: m_currentRank=" + this.m_currentRank + ", sql_kind=" + this.sql_kind + ", need_to_parse=" + this.need_to_parse);
            if (this.binds_in != null) {
                OracleLog.print(this.connection, 1, 16, 64, "binds_in: " + this.binds_in.getInfoString());
            }
            if (this.binds_out != null) {
                OracleLog.print(this.connection, 1, 16, 64, "binds_out: " + this.binds_out.getInfoString());
            }
        }
        this.connection.needLine();
        this.initializeColumnsToFetch(this.binds_out);
        this.executeNonQuery(bl);
        this.need_to_parse = false;
        this.fetchedFirstColumns();
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 32, "After execute: valid_rows=" + this.valid_rows);
            if (this.binds_out != null) {
                OracleLog.print(this.connection, 1, 16, 64, "binds_out: " + this.binds_out.getInfoString());
            }
        }
        this.checkValidRowsStatus();
    }

    private void executeNonQuery(boolean bl) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.executeNonQuery(batchForPlsql=" + bl + ")");
        }
        int n = this.m_currentRank;
        DBAccess dBAccess = this.connection.db_access;
        DBType[] dBTypeArray = this.binds_in != null ? this.binds_in.types : null;
        DBData[] dBDataArray = this.binds_in != null ? this.binds_in.data : null;
        DBType[] dBTypeArray2 = this.binds_out != null ? this.binds_out.types : null;
        DBData[] dBDataArray2 = this.binds_out != null ? this.binds_out.data : null;
        try {
            if (bl && this.sql_kind == 1 && n > 1) {
                int n2 = 0;
                while (n2 < n) {
                    this.valid_rows = this.need_to_parse ? dBAccess.parseExecuteFetch(this.dbstmt, this.sql_kind, this.array_sql, dBTypeArray, dBDataArray, 1, dBTypeArray2, dBDataArray2, 1) : dBAccess.executeFetch(this.dbstmt, this.sql_kind, dBTypeArray, dBDataArray, 1, dBTypeArray2, dBDataArray2, 1);
                    int n3 = 0;
                    while (n3 < dBDataArray.length) {
                        dBDataArray[n3].removeFirstItem();
                        ++n3;
                    }
                    ++n2;
                }
                return;
            }
            if (this.need_to_parse) {
                this.valid_rows = dBAccess.parseExecuteFetch(this.dbstmt, this.sql_kind, this.array_sql, dBTypeArray, dBDataArray, n, dBTypeArray2, dBDataArray2, n);
                return;
            }
            this.valid_rows = dBAccess.executeFetch(this.dbstmt, this.sql_kind, dBTypeArray, dBDataArray, n, dBTypeArray2, dBDataArray2, n);
            return;
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return;
        }
    }

    private void doExecuteWithBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.doExecuteWithBatch(): m_currentRank=" + this.m_currentRank + ", batch=" + this.batch);
        }
        ++this.m_currentRank;
        if (this.m_currentRank >= this.batch) {
            try {
                this.doExecuteOther(false);
            }
            finally {
                Object var2_1 = null;
                this.cleanupForBatching();
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 32, "End of doExecuteWithBatch(): m_currentRank=" + this.m_currentRank);
        }
    }

    protected final void cleanupForBatching() {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.cleanupForBatching()");
        }
        if (this.binds_in != null && this.binds_in.types != null && this.binds_in.isDynamic()) {
            this.binds_in.clearItems();
        }
        this.m_currentRank = 0;
    }

    void check_defines() throws SQLException {
        if (this.defines.types == null) {
            DBError.throwSqlException(21);
        }
        int n = 0;
        while (n < this.defines.types.length) {
            if (this.defines.types[n] == null) {
                DBError.throwSqlException(22, new Integer(n + 1));
            }
            ++n;
        }
    }

    void check_row_prefetch_changed() throws SQLException {
        int n;
        if (this.defines.types != null) {
            n = this.defines.types.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.defines.types[n2].is_stream) {
                    this.new_row_prefetch = 0;
                    break;
                }
                ++n2;
            }
        }
        if (this.new_row_prefetch != 0) {
            if (this.defines.data == null) {
                this.row_prefetch = this.new_row_prefetch;
                this.new_row_prefetch = 0;
                return;
            }
            if (this.new_row_prefetch != this.row_prefetch) {
                DBDataSet dBDataSet = new DBDataSet(this.connection, this.defines.types.length, this.new_row_prefetch);
                dBDataSet.createArrayFromTypes(this.new_row_prefetch);
                n = 0;
                while (n < this.defines.types.length) {
                    dBDataSet.types[n] = this.defines.types[n];
                    dBDataSet.setRowItems(n, this.defines.data[n].getItem(0));
                    ++n;
                }
                this.defines = dBDataSet;
                this.row_prefetch = this.new_row_prefetch;
                this.new_row_prefetch = 0;
                return;
            }
            this.row_prefetch = this.new_row_prefetch;
            this.new_row_prefetch = 0;
        }
    }

    void doExecuteQuery() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.doExecuteQuery()");
            OracleLog.print(this.connection, 1, 16, 32, "Before query: sql_kind=" + this.sql_kind + ", row_prefetch=" + this.row_prefetch + ", need_to_parse=" + this.need_to_parse + ", need_to_prepare_define_buffer=" + this.need_to_prepare_define_buffer + ", columns_defined_by_user=" + this.columns_defined_by_user);
            if (this.array_sql != null) {
                OracleLog.print(this.connection, 1, 16, 64, "array_sql:\n" + OracleLog.bytesToFormattedStr(this.array_sql, this.array_sql.length, "  "));
            }
            if (this.binds_in != null) {
                OracleLog.print(this.connection, 1, 16, 64, "binds_in: " + this.binds_in.getInfoString());
            }
            if (this.defines != null) {
                OracleLog.print(this.connection, 1, 16, 64, "defines:  " + this.defines.getInfoString());
            }
        }
        DBAccess dBAccess = this.connection.db_access;
        try {
            this.connection.needLine();
            if (this.need_to_parse) {
                if (this.need_to_prepare_define_buffer) {
                    if (this.columns_defined_by_user) {
                        this.check_defines();
                        this.check_row_prefetch_changed();
                        this.doDefinesFromTypes();
                        this.need_to_prepare_define_buffer = false;
                        this.valid_rows = dBAccess.parseExecuteFetch(this.dbstmt, this.sql_kind, this.array_sql, this.binds_in != null ? this.binds_in.types : null, this.binds_in != null ? this.binds_in.data : null, 1, this.defines.types, this.defines.data, this.row_prefetch);
                        this.need_to_parse = false;
                        this.fetchedFirstColumns();
                    } else {
                        this.dbdescription = dBAccess.parseExecuteDescribe(this.dbstmt, this.array_sql, this.binds_in != null ? this.binds_in.types : null, this.binds_in != null ? this.binds_in.data : null);
                        this.need_to_parse = false;
                        this.doDefaultTypes();
                        this.check_row_prefetch_changed();
                        this.doDefinesFromTypes();
                        this.need_to_prepare_define_buffer = false;
                        this.valid_rows = dBAccess.fetch(this.dbstmt, this.defines.types, this.defines.data, this.row_prefetch);
                        this.fetchedFirstColumns();
                    }
                } else {
                    this.check_row_prefetch_changed();
                    this.valid_rows = dBAccess.parseExecuteFetch(this.dbstmt, this.sql_kind, this.array_sql, this.binds_in != null ? this.binds_in.types : null, this.binds_in != null ? this.binds_in.data : null, 1, this.defines.types, this.defines.data, this.row_prefetch);
                    this.fetchedFirstColumns();
                }
            } else if (this.need_to_prepare_define_buffer) {
                if (this.columns_defined_by_user) {
                    this.check_defines();
                    this.check_row_prefetch_changed();
                    this.doDefinesFromTypes();
                    this.need_to_prepare_define_buffer = false;
                    this.valid_rows = dBAccess.executeFetchNeedDefines(this.dbstmt, this.sql_kind, this.binds_in != null ? this.binds_in.types : null, this.binds_in != null ? this.binds_in.data : null, 1, this.defines.types, this.defines.data, this.row_prefetch);
                    this.need_to_parse = false;
                    this.fetchedFirstColumns();
                } else {
                    this.dbdescription = dBAccess.parseExecuteDescribe(this.dbstmt, this.array_sql, this.binds_in != null ? this.binds_in.types : null, this.binds_in != null ? this.binds_in.data : null);
                    this.need_to_parse = false;
                    this.doDefaultTypes();
                    this.check_row_prefetch_changed();
                    this.doDefinesFromTypes();
                    this.need_to_prepare_define_buffer = false;
                    this.valid_rows = dBAccess.fetch(this.dbstmt, this.defines.types, this.defines.data, this.row_prefetch);
                    this.fetchedFirstColumns();
                }
            } else {
                this.check_row_prefetch_changed();
                this.valid_rows = dBAccess.executeFetch(this.dbstmt, this.sql_kind, this.binds_in != null ? this.binds_in.types : null, this.binds_in != null ? this.binds_in.data : null, 1, this.defines.types, this.defines.data, this.row_prefetch);
                this.fetchedFirstColumns();
            }
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 32, "After execute: valid_rows=" + this.valid_rows);
            if (this.defines != null) {
                OracleLog.print(this.connection, 1, 16, 64, "defines:  " + this.defines.getInfoString());
            }
        }
        this.checkValidRowsStatus();
    }

    void checkValidRowsStatus() {
        if (this.valid_rows == -2) {
            this.valid_rows = 1;
            this.connection.holdLine(this);
            if (this.streams != null) {
                this.streams.resetLong();
                return;
            }
        } else if (this.sql_kind == 0 && this.valid_rows < this.row_prefetch) {
            this.got_last_batch = true;
        }
    }

    private void doExecute() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.doExecute()");
        }
        if (this.sql_kind == 0) {
            this.doExecuteQuery();
            return;
        }
        this.doExecuteWithBatch();
    }

    void doExecuteWithTimeout() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.doExecuteWithTimeout()");
        }
        this.checkBindsInAndOut();
        this.first_row = false;
        if (this.sql_string_changed) {
            this.parseSqlKind();
        }
        if (this.m_queryTimeout != 0) {
            OracleCancelThread oracleCancelThread = null;
            try {
                oracleCancelThread = new OracleCancelThread(this, this.m_queryTimeout);
                oracleCancelThread.start();
                this.doExecute();
                return;
            }
            finally {
                Object var3_2 = null;
                oracleCancelThread.stopMe();
            }
        }
        this.doExecute();
    }

    private void cleanup() {
        int n;
        if (this.binds_in != null) {
            this.binds_in.cleanup();
            this.binds_in = null;
        }
        if (this.binds_out != null) {
            this.binds_out.cleanup();
            this.binds_out = null;
        }
        if (this.defines != null) {
            this.defines.cleanup();
            this.defines = null;
        }
        this.streams = null;
        if (this.dbdescription != null) {
            n = 0;
            while (n < this.dbdescription.length) {
                this.dbdescription[n] = null;
                ++n;
            }
            this.dbdescription = null;
        }
        if (this.stream_array != null) {
            n = 0;
            while (n < this.stream_array.length) {
                this.stream_array[n] = null;
                ++n;
            }
            this.stream_array = null;
        }
        this.m_currentDataSet = null;
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        this.max_field_size = n;
    }

    public int getMaxRows() throws SQLException {
        return this.max_rows;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        this.max_rows = n;
    }

    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.connection.trace("Statement.setEscapeProcessing");
        if (bl) {
            this.process_escapes = true;
            return;
        }
        this.process_escapes = false;
    }

    public synchronized int getQueryTimeout() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.getQueryTimeout()");
        }
        return this.m_queryTimeout;
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.setQueryTimeout(max=" + n + ")");
        }
        this.m_queryTimeout = n;
    }

    protected final int parseExecuteFetchWithTimeout(DBStatement dBStatement, byte by, byte[] byArray, DBType[] dBTypeArray, DBData[] dBDataArray, int n, DBType[] dBTypeArray2, DBData[] dBDataArray2, int n2) throws SQLException, IOException {
        int n3 = -1;
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.parseExcuteFetchWithTimeout(...)");
        }
        if (this.m_queryTimeout == 0) {
            n3 = this.connection.db_access.parseExecuteFetch(dBStatement, by, byArray, dBTypeArray, dBDataArray, n, dBTypeArray2, dBDataArray2, n2);
        } else {
            OracleCancelThread oracleCancelThread = null;
            try {
                oracleCancelThread = new OracleCancelThread(this, this.m_queryTimeout);
                oracleCancelThread.start();
                n3 = this.connection.db_access.parseExecuteFetch(dBStatement, by, byArray, dBTypeArray, dBDataArray, n, dBTypeArray2, dBDataArray2, n2);
            }
            finally {
                Object var13_12 = null;
                oracleCancelThread.stopMe();
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.parseExcuteFetchWithTimeout() returned " + n3);
        }
        return n3;
    }

    public void cancel() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.cancel()");
        }
        try {
            if (this.connection.statement_holding_line != null) {
                this.freeLine();
            } else {
                this.connection.db_access.cancel();
            }
            this.connection.releaseLine();
            return;
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return;
        }
    }

    public synchronized void setAutoRollback(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.setAutoRollback(autoRollback=" + n + ")");
        }
        this.connection.needLine();
        this.connection.db_access.setWaitandAutoRollback(this.dbstmt, this.wait_option, n);
        this.auto_rollback = n;
    }

    public synchronized int getAutoRollback() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.getAutoRollback() returned " + this.auto_rollback);
        }
        return this.auto_rollback;
    }

    public synchronized void setWaitOption(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.setWaitOption(waitOption=" + n + ")");
        }
        this.connection.needLine();
        this.connection.db_access.setWaitandAutoRollback(this.dbstmt, n, this.auto_rollback);
        this.wait_option = n;
    }

    public synchronized int getWaitOption() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.getWaitOption() returned " + this.wait_option);
        }
        return this.wait_option;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.getWarnings()");
        }
        return this.m_warning;
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
    }

    public void setCursorName(String string) throws SQLException {
        this.connection.trace("Statement.setCursorName");
        DBError.throwSqlException(23);
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        this.connection.trace("Statement.getResultSet");
        if (this.isRegularResultSet()) {
            if (this.sql_kind == 0) {
                if (this.current_result_set == null) {
                    this.current_result_set = new OracleResultSetImpl(this.connection, this);
                }
                return this.current_result_set;
            }
        } else {
            return this.m_scrollRset;
        }
        return null;
    }

    public synchronized int getUpdateCount() throws SQLException {
        this.connection.trace("Statement.getUpdateCount");
        if (this.sql_kind != 2) {
            return -1;
        }
        return this.valid_rows;
    }

    public boolean getMoreResults() throws SQLException {
        this.connection.trace("Statement.getMoreResults");
        return false;
    }

    public int sendBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.sendBatch()");
        }
        return 0;
    }

    void prepare_for_new_result() throws SQLException {
        this.clearWarnings();
        if (this.streams != null) {
            try {
                this.streams.close();
            }
            catch (IOException iOException) {
                DBError.throwSqlException(iOException);
            }
        }
        if (this.current_result_set != null) {
            this.current_result_set.internal_close();
            this.current_result_set = null;
        }
        this.current_row = -1;
        this.valid_rows = 0;
        this.total_rows_visited = 0;
        this.got_last_batch = false;
        if (!this.columns_defined_by_user && this.need_to_parse) {
            this.need_to_prepare_define_buffer = true;
        }
        if (this.need_to_parse) {
            this.dbdescription = null;
        }
    }

    void end_of_result_set() throws SQLException {
        this.prepare_for_new_result();
        this.clearDefines();
    }

    boolean wasNullValue() throws SQLException {
        if (this.last_index == 0) {
            DBError.throwSqlException(24);
        }
        if (this.sql_kind == 0) {
            DBDataSet dBDataSet = this.defines;
            int n = this.last_index - 1;
            int n2 = this.current_row;
            return dBDataSet.data[n].getItem((int)n2).is_null;
        }
        DBDataSet dBDataSet = this.binds_out;
        int n = this.last_index - 1;
        int n3 = this.m_currentRank;
        return dBDataSet.data[n].getItem((int)n3).is_null;
    }

    void prepare_for_new_get(boolean bl, int n) throws SQLException {
        if (bl) {
            if (this.current_result_set == null || this.current_result_set.closed) {
                DBError.throwSqlException(11);
            }
            if (this.defines == null || n > this.defines.data.length || n <= 0) {
                DBError.throwSqlException(3);
            }
            if (this.current_row < 0) {
                DBError.throwSqlException(14);
            }
        } else if (this.binds_out == null || n > this.binds_out.data.length || n <= 0 || this.binds_out.data[n - 1] == null) {
            DBError.throwSqlException(3);
        }
        if (this.stream_array != null && this.stream_array[n - 1] != null) {
            try {
                this.stream_array[n - 1].close();
            }
            catch (IOException iOException) {
                DBError.throwSqlException(iOException);
            }
        }
        this.last_was_column = bl;
        this.last_index = n;
    }

    byte[] getBytesInternal(boolean bl, int n) throws SQLException {
        DBItem dBItem;
        DBType dBType;
        Object object;
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getBytesInternal(getColumn=" + bl + ", index=" + n + ")");
        }
        --n;
        if (bl) {
            object = this.defines;
            dBType = ((DBDataSet)object).types != null && n >= 0 && n < ((DBDataSet)object).types.length ? ((DBDataSet)object).types[n] : null;
            object = this.defines;
            dBItem = (((DBDataSet)object).data.length < n ? null : ((DBDataSet)object).data[n]).getItem(this.current_row);
        } else {
            object = this.binds_out;
            dBType = ((DBDataSet)object).types != null && n >= 0 && n < ((DBDataSet)object).types.length ? ((DBDataSet)object).types[n] : null;
            object = this.binds_out;
            dBItem = (((DBDataSet)object).data.length < n ? null : ((DBDataSet)object).data[n]).getItem(this.m_currentRank);
        }
        if (dBType.is_stream) {
            object = (OracleInputStream)dBItem.stream_value;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byte[] byArray = new byte[1024];
            try {
                int n2;
                if (((OracleInputStream)object).isClosed()) {
                    DBError.throwSqlException(27);
                }
                while ((n2 = ((OracleBufferedStream)object).read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                DBError.throwSqlException(iOException);
            }
            return byteArrayOutputStream.toByteArray();
        }
        int n3 = dBItem.data_size;
        byte[] byArray = new byte[n3];
        System.arraycopy(dBItem.byte_value, 0, byArray, 0, n3);
        return byArray;
    }

    private int getDataType(boolean bl, int n) {
        DBType dBType = null;
        if (bl) {
            DBDataSet dBDataSet = this.defines;
            int n2 = n - 1;
            dBType = dBDataSet.types != null && n2 >= 0 && n2 < dBDataSet.types.length ? dBDataSet.types[n2] : null;
        } else {
            DBDataSet dBDataSet = this.binds_out;
            int n3 = n - 1;
            DBType dBType2 = dBType = dBDataSet.types != null && n3 >= 0 && n3 < dBDataSet.types.length ? dBDataSet.types[n3] : null;
        }
        if (dBType != null) {
            return dBType.type;
        }
        return -1;
    }

    String getStringValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getStringValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 12: {
                Timestamp timestamp = this.connection.conversion.DateBytesToTimestamp(byArray, byArray.length);
                return timestamp.toString();
            }
            case 2: 
            case 6: {
                NUMBER nUMBER = new NUMBER(byArray);
                return nUMBER.stringValue();
            }
            case 23: 
            case 24: {
                return RepConversion.bArray2String(byArray);
            }
            case 1: 
            case 8: {
                return this.connection.conversion.CharBytesToString(byArray, byArray.length);
            }
            case 96: {
                int n3;
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                if (bl && this.connection.db_access.getNlsRatio() > 1 && this.dbdescription != null && this.dbdescription.length >= n && string != null && (n3 = this.dbdescription[n - 1].max_length) > 0 && string.length() > n3) {
                    return string.substring(0, n3);
                }
                return string;
            }
            case 104: {
                return new String(byArray, 0, 0, byArray.length);
            }
        }
        return null;
    }

    ResultSet getCursorValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getCursorValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        if (this.getDataType(bl, n) != 102) {
            DBError.throwSqlException(4);
        }
        DBAccess dBAccess = this.connection.db_access;
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        DBStatement dBStatement = null;
        try {
            dBStatement = dBAccess.RefCursorBytesToDBStatement(byArray);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        catch (SQLException sQLException) {
            DBError.throwSqlException(62);
        }
        OracleStatement oracleStatement = new OracleStatement(this.connection, dBStatement, 1, this.connection.default_row_prefetch);
        if (this.m_refCursorList == null) {
            this.m_refCursorList = new Hashtable(10);
        }
        this.m_refCursorList.put(oracleStatement, oracleStatement);
        return oracleStatement.getResultSet();
    }

    ROWID getROWIDValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getROWIDValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        if (n2 != 104) {
            DBError.throwSqlException(4);
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        return new ROWID(byArray);
    }

    RAW getRAWValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        if (n2 != 23 && n2 != 24) {
            DBError.throwSqlException(4);
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        return new RAW(byArray);
    }

    CHAR getCHARValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getCHARValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        CharacterSet characterSet = null;
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                characterSet = this.connection.conversion.getAccessCharSetObj();
                break;
            }
            case 23: {
                characterSet = this.connection.conversion.getDbCharSetObj();
                break;
            }
            default: {
                DBError.throwSqlException(4);
            }
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        return new CHAR(byArray, characterSet);
    }

    DATE getDATEValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getDATEValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        if (n2 != 12) {
            DBError.throwSqlException(4);
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        return new DATE(byArray);
    }

    REF getREFValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getREFValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        if (n2 != 111) {
            DBError.throwSqlException(4);
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        DBType dBType = this.get_db_type(bl, n);
        OracleTypeADT oracleTypeADT = (OracleTypeADT)dBType.otype;
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor(oracleTypeADT.sql_name, this.connection);
        return new REF(structDescriptor, this.connection, byArray);
    }

    private Datum getNamedTypeValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getNamedTypeValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        if (n2 != 109) {
            DBError.throwSqlException(4);
        }
        DBType dBType = this.get_db_type(bl, n);
        byte[] byArray = this.getBytesInternal(bl, n);
        String string = ((OracleTypeADT)dBType.otype).sql_name;
        Object object = SQLUtil.getTypeDescriptor(string, this.connection);
        if (object instanceof ArrayDescriptor) {
            return new ARRAY((ArrayDescriptor)object, (Connection)this.connection, byArray);
        }
        return new STRUCT((StructDescriptor)object, (Connection)this.connection, byArray);
    }

    STRUCT getSTRUCTValue(boolean bl, int n) throws SQLException {
        return (STRUCT)this.getNamedTypeValue(bl, n);
    }

    ARRAY getARRAYValue(boolean bl, int n) throws SQLException {
        return (ARRAY)this.getNamedTypeValue(bl, n);
    }

    NUMBER getNUMBERValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getNUMBERValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        if (n2 != 2 && n2 != 6) {
            DBError.throwSqlException(4);
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        return new NUMBER(byArray);
    }

    BLOB getBLOBValue(boolean bl, int n) throws SQLException {
        byte[] byArray;
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getBLOBValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        if (n2 != 113) {
            DBError.throwSqlException(4);
        }
        if ((byArray = this.getBytesInternal(bl, n)) == null) {
            return null;
        }
        return new BLOB(this.connection, byArray);
    }

    CLOB getCLOBValue(boolean bl, int n) throws SQLException {
        byte[] byArray;
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getCLOBValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        if (n2 != 112) {
            DBError.throwSqlException(4);
        }
        if ((byArray = this.getBytesInternal(bl, n)) == null) {
            return null;
        }
        return new CLOB(this.connection, byArray);
    }

    BFILE getBFILEValue(boolean bl, int n) throws SQLException {
        byte[] byArray;
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getBFILEValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        if (n2 != 114) {
            DBError.throwSqlException(4);
        }
        if ((byArray = this.getBytesInternal(bl, n)) == null) {
            return null;
        }
        return new BFILE(this.connection, byArray);
    }

    boolean getBooleanValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getBooleanValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return false;
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        int n2 = this.get_value_type(bl, n);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                if (string == null) {
                    return false;
                }
                return string.length() != 1 || string.charAt(0) != '0';
            }
            case 2: 
            case 6: {
                return DBConversion.NumberBytesToBoolean(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return false;
    }

    byte getByteValue(boolean bl, int n) throws SQLException {
        long l = this.getLongValue(bl, n);
        if (l > 127L || l < -128L) {
            DBError.throwSqlException(26);
        }
        return (byte)l;
    }

    short getShortValue(boolean bl, int n) throws SQLException {
        long l = this.getLongValue(bl, n);
        if (l > 65537L || l < -65538L) {
            DBError.throwSqlException(26);
        }
        return (short)l;
    }

    int getIntValue(boolean bl, int n) throws SQLException {
        long l = this.getLongValue(bl, n);
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            DBError.throwSqlException(26);
        }
        return (int)l;
    }

    long getLongValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getLongValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return 0L;
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return 0L;
        }
        int n2 = this.get_value_type(bl, n);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                long l = 0L;
                try {
                    l = Long.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    DBError.throwSqlException(59);
                }
                return l;
            }
            case 2: 
            case 6: {
                return DBConversion.NumberBytesToLong(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return 0L;
    }

    float getFloatValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getFloatValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return 0.0f;
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return 0.0f;
        }
        int n2 = this.get_value_type(bl, n);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                float f = 0.0f;
                try {
                    f = Float.valueOf(string).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    DBError.throwSqlException(59);
                }
                return f;
            }
            case 2: 
            case 6: {
                return DBConversion.NumberBytesToFloat(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return 0.0f;
    }

    double getDoubleValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getDoubleValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return 0.0;
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return 0.0;
        }
        int n2 = this.get_value_type(bl, n);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                double d = 0.0;
                try {
                    d = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    DBError.throwSqlException(59);
                }
                return d;
            }
            case 2: 
            case 6: {
                return DBConversion.NumberBytesToDouble(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return 0.0;
    }

    BigDecimal getBigDecimalValue(boolean bl, int n, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getBigDecimalValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n3 = this.get_value_type(bl, n);
        switch (n3) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                BigDecimal bigDecimal = new BigDecimal(string);
                return bigDecimal;
            }
            case 2: 
            case 6: {
                return DBConversion.NumberBytesToBigDecimal(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    byte[] getBytesValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getBytesValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        return byArray;
    }

    Date getDateValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getDateValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                return Date.valueOf(string);
            }
            case 12: {
                return this.connection.conversion.DateBytesToDate(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    Time getTimeValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getTimeValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                return Time.valueOf(string);
            }
            case 12: {
                return this.connection.conversion.DateBytesToTime(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    Timestamp getTimestampValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getTimestampValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        int n2 = this.get_value_type(bl, n);
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                return Timestamp.valueOf(string);
            }
            case 12: {
                return this.connection.conversion.DateBytesToTimestamp(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    OracleInputStream getStreamInternal(boolean bl, int n) throws SQLException {
        int n2;
        Object object;
        DBDataSet dBDataSet;
        --n;
        if (bl) {
            dBDataSet = this.defines;
            object = this.defines;
            DBType dBType = ((DBDataSet)object).types != null && n >= 0 && n < ((DBDataSet)object).types.length ? ((DBDataSet)object).types[n] : null;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            object = this.binds_out;
            DBType dBType = ((DBDataSet)object).types != null && n >= 0 && n < ((DBDataSet)object).types.length ? ((DBDataSet)object).types[n] : null;
            n2 = this.m_currentRank;
        }
        object = (dBDataSet.data.length < n ? null : dBDataSet.data[n]).getItem(n2);
        return (OracleInputStream)((DBItem)object).stream_value;
    }

    InputStream getAsciiStreamValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getAsciiStreamValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        DBType dBType = this.get_db_type(bl, n);
        DBConversion dBConversion = this.connection.conversion;
        switch (dBType.type) {
            case 23: 
            case 24: {
                if (dBType.is_stream) {
                    OracleInputStream oracleInputStream = this.getStreamInternal(bl, n);
                    if (oracleInputStream.isClosed()) {
                        DBError.throwSqlException(27);
                    }
                    return dBConversion.ConvertStream(oracleInputStream, 2);
                }
                byte[] byArray = this.getBytesInternal(bl, n);
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 2);
            }
            case 1: 
            case 8: {
                if (dBType.is_stream) {
                    OracleInputStream oracleInputStream = this.getStreamInternal(bl, n);
                    if (oracleInputStream.isClosed()) {
                        DBError.throwSqlException(27);
                    }
                    return dBConversion.ConvertStream(oracleInputStream, 0);
                }
                byte[] byArray = this.getBytesInternal(bl, n);
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 0);
            }
            case 96: {
                int n2;
                if (dBType.is_stream) {
                    OracleInputStream oracleInputStream = this.getStreamInternal(bl, n);
                    if (oracleInputStream.isClosed()) {
                        DBError.throwSqlException(27);
                    }
                    return dBConversion.ConvertStream(oracleInputStream, 0);
                }
                byte[] byArray = this.getBytesInternal(bl, n);
                char[] cArray = new char[byArray.length];
                int n3 = dBConversion.CHARBytesToJavaChars(byArray, byArray.length, cArray);
                if (bl && this.connection.db_access.getNlsRatio() > 1 && n3 > 0 && this.dbdescription != null && this.dbdescription.length >= n && (n2 = this.dbdescription[n - 1].max_length) > 0 && n3 > n2) {
                    n3 = n2;
                }
                n2 = DBConversion.javaCharsToAsciiBytes(cArray, n3, byArray);
                return new ByteArrayInputStream(byArray, 0, n2);
            }
            case 112: 
            case 113: {
                Datum datum = this.getOracleObjectValue(bl, n);
                return datum.asciiStreamValue();
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    InputStream getUnicodeStreamValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getUnicodeStreamValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        DBType dBType = this.get_db_type(bl, n);
        DBConversion dBConversion = this.connection.conversion;
        switch (dBType.type) {
            case 23: 
            case 24: {
                if (dBType.is_stream) {
                    OracleInputStream oracleInputStream = this.getStreamInternal(bl, n);
                    if (oracleInputStream.isClosed()) {
                        DBError.throwSqlException(27);
                    }
                    return dBConversion.ConvertStream(oracleInputStream, 3);
                }
                byte[] byArray = this.getBytesInternal(bl, n);
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
            }
            case 1: 
            case 8: {
                if (dBType.is_stream) {
                    OracleInputStream oracleInputStream = this.getStreamInternal(bl, n);
                    if (oracleInputStream.isClosed()) {
                        DBError.throwSqlException(27);
                    }
                    return dBConversion.ConvertStream(oracleInputStream, 1);
                }
                byte[] byArray = this.getBytesInternal(bl, n);
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
            }
            case 96: {
                int n2;
                if (dBType.is_stream) {
                    OracleInputStream oracleInputStream = this.getStreamInternal(bl, n);
                    if (oracleInputStream.isClosed()) {
                        DBError.throwSqlException(27);
                    }
                    return dBConversion.ConvertStream(oracleInputStream, 1);
                }
                byte[] byArray = this.getBytesInternal(bl, n);
                char[] cArray = new char[byArray.length];
                int n3 = dBConversion.CHARBytesToJavaChars(byArray, byArray.length, cArray);
                if (bl && this.connection.db_access.getNlsRatio() > 1 && n3 > 0 && this.dbdescription != null && this.dbdescription.length >= n && (n2 = this.dbdescription[n - 1].max_length) > 0 && n3 > n2) {
                    n3 = n2;
                }
                byte[] byArray2 = new byte[n3 * 2];
                int n4 = DBConversion.javaCharsToUcs2Bytes(cArray, n3, byArray2);
                return new ByteArrayInputStream(byArray2, 0, n4);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    InputStream getBinaryStreamValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getBinaryStreamValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        DBType dBType = this.get_db_type(bl, n);
        switch (dBType.type) {
            case 1: 
            case 8: 
            case 23: 
            case 24: {
                if (dBType.is_stream) {
                    OracleInputStream oracleInputStream = this.getStreamInternal(bl, n);
                    if (oracleInputStream.isClosed()) {
                        DBError.throwSqlException(27);
                    }
                    return oracleInputStream;
                }
                byte[] byArray = this.getBytesInternal(bl, n);
                return new ByteArrayInputStream(byArray);
            }
            case 96: {
                if (dBType.is_stream) {
                    OracleInputStream oracleInputStream = this.getStreamInternal(bl, n);
                    if (oracleInputStream.isClosed()) {
                        DBError.throwSqlException(27);
                    }
                    return oracleInputStream;
                }
                byte[] byArray = this.getBytesInternal(bl, n);
                if (bl && this.connection.db_access.getNlsRatio() > 1 && byArray != null && this.dbdescription != null && this.dbdescription.length >= n) {
                    char[] cArray = new char[byArray.length];
                    DBConversion dBConversion = this.connection.conversion;
                    int n2 = dBConversion.CHARBytesToJavaChars(byArray, byArray.length, cArray);
                    int n3 = this.dbdescription[n - 1].max_length;
                    if (n3 > 0 && n2 > n3) {
                        n2 = n3;
                    }
                    int n4 = dBConversion.javaCharsToCHARBytes(cArray, n2, byArray);
                    return new ByteArrayInputStream(byArray, 0, n4);
                }
                return new ByteArrayInputStream(byArray);
            }
            case 112: 
            case 113: {
                Datum datum = this.getOracleObjectValue(bl, n);
                return datum.binaryStreamValue();
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    Reader getCharacterStreamValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getCharacterStreamValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        if (this.is_value_null(bl, n)) {
            return null;
        }
        DBType dBType = this.get_db_type(bl, n);
        DBConversion dBConversion = this.connection.conversion;
        switch (dBType.type) {
            case 23: 
            case 24: {
                if (dBType.is_stream) {
                    OracleInputStream oracleInputStream = this.getStreamInternal(bl, n);
                    if (oracleInputStream.isClosed()) {
                        DBError.throwSqlException(27);
                    }
                    return dBConversion.ConvertCharacterStream(oracleInputStream, 8);
                }
                byte[] byArray = this.getBytesInternal(bl, n);
                char[] cArray = new char[byArray.length * 2];
                int n2 = DBConversion.RAWBytesToHexChars(byArray, byArray.length, cArray);
                return new CharArrayReader(cArray, 0, n2);
            }
            case 1: 
            case 8: {
                if (dBType.is_stream) {
                    OracleInputStream oracleInputStream = this.getStreamInternal(bl, n);
                    if (oracleInputStream.isClosed()) {
                        DBError.throwSqlException(27);
                    }
                    return dBConversion.ConvertCharacterStream(oracleInputStream, 9);
                }
                byte[] byArray = this.getBytesInternal(bl, n);
                String string = dBConversion.CharBytesToString(byArray, byArray.length);
                return new StringReader(string);
            }
            case 96: {
                int n3;
                if (dBType.is_stream) {
                    OracleInputStream oracleInputStream = this.getStreamInternal(bl, n);
                    if (oracleInputStream.isClosed()) {
                        DBError.throwSqlException(27);
                    }
                    return dBConversion.ConvertCharacterStream(oracleInputStream, 9);
                }
                byte[] byArray = this.getBytesInternal(bl, n);
                String string = dBConversion.CharBytesToString(byArray, byArray.length);
                if (bl && this.connection.db_access.getNlsRatio() > 1 && this.dbdescription != null && this.dbdescription.length >= n && string != null && (n3 = this.dbdescription[n - 1].max_length) > 0 && string.length() > n3) {
                    string = string.substring(0, n3);
                }
                return new StringReader(string);
            }
            case 112: 
            case 113: {
                Datum datum = this.getOracleObjectValue(bl, n);
                return datum.characterStreamValue();
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    Object getObjectValue(boolean bl, int n) throws SQLException {
        return this.getObjectValue(bl, n, this.connection.getTypeMap());
    }

    Object getObjectValue(boolean bl, int n, Dictionary dictionary) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getObjectValue(getColumn=" + bl + ", index=" + n + ", map)");
        }
        this.prepare_for_new_get(bl, n);
        int n2 = this.get_value_type(bl, n);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                return this.getStringValue(bl, n);
            }
            case 2: 
            case 6: {
                int n3 = this.get_value_scale(bl, n);
                return this.getBigDecimalValue(bl, n, n3);
            }
            case 23: 
            case 24: {
                return this.getBytesValue(bl, n);
            }
            case 12: {
                return this.getTimestampValue(bl, n);
            }
            case 104: {
                return this.getROWIDValue(bl, n);
            }
            case 113: {
                return this.getBLOBValue(bl, n);
            }
            case 112: {
                return this.getCLOBValue(bl, n);
            }
            case 114: {
                return this.getBFILEValue(bl, n);
            }
            case 102: {
                return this.getCursorValue(bl, n);
            }
            case 109: {
                Datum datum = this.getNamedTypeValue(bl, n);
                if (datum instanceof STRUCT) {
                    return ((STRUCT)datum).toJdbc(dictionary);
                }
                return datum;
            }
            case 111: {
                return this.getREFValue(bl, n);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    Datum getOracleObjectValue(boolean bl, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getOracleObjectValue(getColumn=" + bl + ", index=" + n + ")");
        }
        this.prepare_for_new_get(bl, n);
        int n2 = this.get_value_type(bl, n);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                return this.getCHARValue(bl, n);
            }
            case 2: 
            case 6: {
                return this.getNUMBERValue(bl, n);
            }
            case 23: 
            case 24: {
                return this.getRAWValue(bl, n);
            }
            case 12: {
                return this.getDATEValue(bl, n);
            }
            case 104: {
                return this.getROWIDValue(bl, n);
            }
            case 113: {
                return this.getBLOBValue(bl, n);
            }
            case 112: {
                return this.getCLOBValue(bl, n);
            }
            case 114: {
                return this.getBFILEValue(bl, n);
            }
            case 109: {
                return this.getNamedTypeValue(bl, n);
            }
            case 111: {
                return this.getREFValue(bl, n);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    CustomDatum getCustomDatumValue(boolean bl, int n, CustomDatumFactory customDatumFactory) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OracleStatement.getCustomDatumValue(getColumn=" + bl + ", index=" + n + ", factory)");
        }
        Datum datum = this.getOracleObjectValue(bl, n);
        return customDatumFactory.create(datum, 0);
    }

    int get_column_index(String string) throws SQLException {
        if (this.dbdescription == null) {
            DBError.throwSqlException(9);
        }
        int n = this.dbdescription.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.dbdescription[n2].getColumnName().equalsIgnoreCase(string)) {
                return n2 + 1;
            }
            ++n2;
        }
        DBError.throwSqlException(6);
        return 0;
    }

    int get_value_type(boolean bl, int n) {
        if (bl) {
            DBDataSet dBDataSet = this.defines;
            int n2 = n - 1;
            return (dBDataSet.types != null && n2 >= 0 && n2 < dBDataSet.types.length ? dBDataSet.types[n2] : null).type;
        }
        DBDataSet dBDataSet = this.binds_out;
        int n3 = n - 1;
        return (dBDataSet.types != null && n3 >= 0 && n3 < dBDataSet.types.length ? dBDataSet.types[n3] : null).type;
    }

    DBType get_db_type(boolean bl, int n) {
        if (bl) {
            DBDataSet dBDataSet = this.defines;
            int n2 = n - 1;
            if (dBDataSet.types != null && n2 >= 0 && n2 < dBDataSet.types.length) {
                return dBDataSet.types[n2];
            }
            return null;
        }
        DBDataSet dBDataSet = this.binds_out;
        int n3 = n - 1;
        if (dBDataSet.types != null && n3 >= 0 && n3 < dBDataSet.types.length) {
            return dBDataSet.types[n3];
        }
        return null;
    }

    int get_value_scale(boolean bl, int n) {
        return 0;
    }

    boolean is_value_null(boolean bl, int n) throws SQLException {
        if (bl) {
            DBDataSet dBDataSet = this.defines;
            int n2 = n - 1;
            int n3 = this.current_row;
            return dBDataSet.data[n2].getItem((int)n3).is_null;
        }
        DBDataSet dBDataSet = this.binds_out;
        int n4 = n - 1;
        int n5 = this.m_currentRank;
        return dBDataSet.data[n4].getItem((int)n5).is_null;
    }

    int get_internal_type(int n) throws SQLException {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 6;
            }
            case 999: {
                return 999;
            }
            case 1: {
                return 96;
            }
            case 12: {
                return 1;
            }
            case -1: {
                return 8;
            }
            case 91: 
            case 92: 
            case 93: {
                return 12;
            }
            case -3: 
            case -2: {
                return 23;
            }
            case -4: {
                return 24;
            }
            case -8: {
                return 104;
            }
            case 2004: {
                return 113;
            }
            case 2005: {
                return 112;
            }
            case -13: {
                return 114;
            }
            case -10: {
                return 102;
            }
            case 2002: 
            case 2003: {
                return 109;
            }
            case 2006: {
                return 111;
            }
        }
        DBError.throwSqlException(4);
        return 0;
    }

    synchronized void describe() throws SQLException {
        if (this.dbdescription == null) {
            try {
                this.connection.needLine();
                this.dbdescription = this.connection.db_access.describe(this.dbstmt);
                return;
            }
            catch (IOException iOException) {
                DBError.throwSqlException(iOException);
                return;
            }
        }
    }

    void freeLine() throws SQLException {
        if (this.streams != null) {
            try {
                this.streams.close();
                return;
            }
            catch (IOException iOException) {
                DBError.throwSqlException(iOException);
                return;
            }
        }
    }

    private synchronized void initializeColumnsToFetch(DBDataSet dBDataSet) {
        this.m_lastFetchedColumn = 0;
        this.m_currentDataSet = dBDataSet;
    }

    synchronized void fetchedFirstColumns() {
        int n = this.getNextStreamColumn(1);
        if (n > 0) {
            this.m_lastFetchedColumn = n - 1;
            return;
        }
        if (n == 0) {
            this.m_lastFetchedColumn = this.m_currentDataSet.types.length;
            return;
        }
        this.m_lastFetchedColumn = 0;
    }

    private synchronized int[] getNextFetchColumnRange() {
        int[] nArray;
        ++this.m_lastFetchedColumn;
        if (this.m_currentDataSet == null) {
            return null;
        }
        DBType[] dBTypeArray = this.m_currentDataSet.types;
        if (dBTypeArray == null) {
            return null;
        }
        int n = dBTypeArray.length;
        if (this.m_lastFetchedColumn >= n) {
            return null;
        }
        if (dBTypeArray[this.m_lastFetchedColumn].is_stream) {
            return null;
        }
        int n2 = this.getNextStreamColumn(nArray[0]);
        nArray = new int[]{this.m_lastFetchedColumn + 1, n2 > 0 ? n2 - 1 : this.m_currentDataSet.types.length};
        this.m_lastFetchedColumn = nArray[1];
        return nArray;
    }

    private int getNextStreamColumn(int n) {
        DBType[] dBTypeArray;
        int n2 = -1;
        if (this.m_currentDataSet != null && (dBTypeArray = this.m_currentDataSet.types) != null) {
            int n3 = n - 1;
            if (n3 < 0) {
                n3 = 0;
            }
            boolean bl = false;
            while (!bl && n3 < dBTypeArray.length) {
                if (dBTypeArray[n3] != null && dBTypeArray[n3].is_stream) {
                    n2 = n3 + 1;
                    bl = true;
                }
                ++n3;
            }
            if (!bl) {
                n2 = 0;
            }
        }
        return n2;
    }

    synchronized void fetchNextColumns() throws SQLException, IOException {
        int[] nArray = this.getNextFetchColumnRange();
        if (nArray != null) {
            DBAccess dBAccess = this.connection.db_access;
            dBAccess.fetch(this.dbstmt, this.m_currentDataSet.types, this.m_currentDataSet.data, nArray[0], nArray[1]);
        }
    }

    final void ensureOpen() throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(9);
        }
    }

    final int parseSqlKind() throws SQLException {
        String string = this.sql_query;
        string = this.process_escapes ? this.connection.nativeSQL(string) : string;
        this.sql_kind = this.getSqlKind(string);
        this.array_sql = this.connection.conversion.StringToCharBytes(string);
        this.sql_string_changed = false;
        return this.sql_kind;
    }

    final String expandSqlEscapes(String string) throws SQLException {
        if (this.process_escapes) {
            return this.connection.nativeSQL(string);
        }
        return string;
    }

    final byte[] strToDbaccessBytes(String string) throws SQLException {
        return this.connection.conversion.StringToCharBytes(string);
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        if (n == 1000) {
            this.default_fetch_direction = n;
            return;
        }
        if (n == 1001 || n == 1002) {
            this.default_fetch_direction = 1000;
            this.m_warning = DBError.addSqlWarning(this.m_warning, 87);
            return;
        }
        DBError.throwSqlException(68, "setFetchDirection");
    }

    public int getFetchDirection() throws SQLException {
        return this.default_fetch_direction;
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            DBError.throwSqlException(68, "setFetchSize");
            return;
        }
        if (n == 0) {
            this.default_row_prefetch = this.connection.getDefaultRowPrefetch();
            return;
        }
        this.default_row_prefetch = n;
    }

    public int getFetchSize() throws SQLException {
        return this.default_row_prefetch;
    }

    public int getResultSetConcurrency() throws SQLException {
        int n = this.m_userRsetType;
        return ResultSetUtil.s_allRsetTypes[n][1];
    }

    public int getResultSetType() throws SQLException {
        int n = this.m_userRsetType;
        return ResultSetUtil.s_allRsetTypes[n][0];
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public synchronized void setResultSetCache(OracleResultSetCache oracleResultSetCache) throws SQLException {
        try {
            if (oracleResultSetCache == null) {
                DBError.throwSqlException(68);
            }
            if (this.m_cache != null) {
                this.m_cache.close();
            }
            this.m_cache = oracleResultSetCache;
            return;
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return;
        }
    }

    public synchronized OracleResultSetCache getResultSetCache() throws SQLException {
        return this.m_cache;
    }

    private void initBatch() {
    }

    private int getBatchSize() {
        return this.m_batchItems.size();
    }

    private void addBatchItem(String string) {
        this.m_batchItems.addElement(string);
    }

    private String getBatchItem(int n) {
        return (String)this.m_batchItems.elementAt(n);
    }

    private void clearBatchItems() {
        this.m_batchItems.removeAllElements();
    }

    private void checkIfJdbcBatchExists() throws SQLException {
        if (this.m_batchItems.size() > 0) {
            DBError.throwSqlException(81, "batch must be either executed or cleared");
        }
    }

    public synchronized void addBatch(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.addBatch(sql)");
            OracleLog.print(this.connection, 1, 16, 32, "SQL: \"" + string + "\"");
        }
        this.m_batchItems.addElement(string);
    }

    public synchronized void clearBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.clearBatch()");
        }
        this.m_batchItems.removeAllElements();
    }

    public synchronized int[] executeBatch() throws SQLException {
        int n = 0;
        int n2 = this.m_batchItems.size();
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleStatement.executeBatch(): batch size is " + n2);
        }
        if (n2 <= 0) {
            return null;
        }
        int[] nArray = new int[n2];
        String string = null;
        String string2 = null;
        byte[] byArray = null;
        byte by = 0;
        if (this.closed) {
            DBError.throwSqlException(9);
        }
        this.prepare_for_new_result();
        try {
            try {
                this.connection.needLine();
                n = 0;
                while (n < n2) {
                    string = (String)this.m_batchItems.elementAt(n);
                    string2 = this.process_escapes ? this.connection.nativeSQL(string) : string;
                    byArray = this.connection.conversion.StringToCharBytes(string2);
                    by = this.getSqlKind(string2);
                    if (OracleLog.TRACE) {
                        OracleLog.print(this.connection, 1, 16, 32, "batch item " + n + ": stmt_type=" + by);
                        OracleLog.print(this.connection, 1, 16, 32, "expanded SQL: " + string2);
                    }
                    if (by == 0) {
                        DBError.throwBatchUpdateException(80, "invalid SELECT batch command " + n, n, nArray);
                    }
                    nArray[n] = this.parseExecuteFetchWithTimeout(this.dbstmt, by, byArray, null, null, 1, null, null, 1);
                    if (nArray[n] < 0) {
                        DBError.throwBatchUpdateException(81, "command return value " + nArray[n], n, nArray);
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                DBError.throwBatchUpdateException(81, iOException.getMessage(), n, nArray);
            }
            catch (SQLException sQLException) {
                if (sQLException instanceof BatchUpdateException) {
                    throw sQLException;
                }
                DBError.throwBatchUpdateException(81, sQLException.getMessage(), n, nArray);
            }
            Object var9_10 = null;
            this.m_batchItems.removeAllElements();
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.m_batchItems.removeAllElements();
            throw throwable;
        }
        return nArray;
    }

    public DBDataSet getBinds() {
        return null;
    }

    public void notify_close_rset() throws SQLException {
        this.m_scrollRset = null;
        this.end_of_result_set();
    }

    public String getRevisedSql() throws SQLException {
        return this.m_revisedSql;
    }

    public String getOriginalSql() throws SQLException {
        return this.m_originalSql;
    }

    boolean isRegularResultSet() throws SQLException {
        return this.m_userRsetType == 1;
    }

    void scrollStmt_cleanup(boolean bl) throws SQLException {
        if (bl) {
            this.m_originalSql = null;
            this.m_revisedSql = null;
        }
        if (this.m_scrollRset != null) {
            this.m_scrollRset.close();
            this.m_scrollRset = null;
        }
    }

    private OracleResultSet doScrollStmtExecuteQuery(String string) throws SQLException {
        this.scrollStmt_cleanup(true);
        this.parseSqlKind();
        if (this.sql_kind != 0) {
            this.doExecuteWithTimeout();
            return null;
        }
        this.m_originalSql = string;
        boolean bl = true;
        String string2 = null;
        if (!this.m_needToAddIdentifier) {
            this.doExecuteWithTimeout();
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            this.m_realRsetType = this.m_userRsetType;
        } else {
            try {
                this.m_revisedSql = ResultSetUtil.addIdentifierToSql(string);
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.sql_query = this.m_revisedSql;
                this.new_row_prefetch = this.default_row_prefetch;
                this.prepare_for_new_result();
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(1);
                }
                this.doExecuteWithTimeout();
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
            }
            catch (SQLException sQLException) {
                bl = false;
                string2 = sQLException.getMessage();
            }
            if (bl) {
                this.m_realRsetType = this.m_userRsetType;
            } else {
                this.m_realRsetType = this.m_userRsetType > 3 ? 3 : 1;
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.sql_query = string;
                this.new_row_prefetch = this.default_row_prefetch;
                this.prepare_for_new_result();
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(-1);
                }
                this.doExecuteWithTimeout();
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                bl = true;
            }
        }
        if (this.current_result_set != null && bl) {
            if (this.m_userRsetType != this.m_realRsetType) {
                this.m_warning = DBError.addSqlWarning(this.m_warning, 91, string2);
            }
            this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
            return this.m_scrollRset;
        }
        DBError.check_error(1, "Unable to create result set");
        return null;
    }

    void adjustUserDefines(int n) throws SQLException {
        if (n == 1) {
            this.m_userDefineTypes = this.defines.types;
            this.defines.types = new DBType[this.m_userDefineTypes.length + 1];
            this.defines.types[0] = this.connection.db_access.createDBType(104, false);
            System.arraycopy(this.m_userDefineTypes, 0, this.defines.types, 1, this.m_userDefineTypes.length);
            return;
        }
        if (n == -1) {
            this.clearDefines();
            this.columns_defined_by_user = true;
            this.need_to_prepare_define_buffer = true;
            this.defines.types = this.m_userDefineTypes;
        }
    }
}

