/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;

public class OracleSql {
    int current_argument;
    int i;
    int length;
    char c;
    boolean first;
    boolean in_string;
    String odbc_sql;
    StringBuffer oracle_sql = new StringBuffer(128);
    StringBuffer token_buffer = new StringBuffer(32);

    public synchronized String parse(String string) throws SQLException {
        this.current_argument = 1;
        this.i = 0;
        this.first = true;
        this.in_string = false;
        this.oracle_sql.ensureCapacity(this.length);
        this.oracle_sql.setLength(0);
        this.odbc_sql = string;
        this.length = this.odbc_sql.length();
        this.handleODBC();
        if (this.i < this.length) {
            Integer n;
            Integer n2 = n = new Integer(this.i);
            if (OracleLog.TRACE) {
                String string2 = "DBError.check_error(errNum=" + 33 + ", obj=" + n2 + ")";
                OracleLog.print(null, 1, 4, 16, string2);
            }
            DBError.throwSqlException(33, n2);
        }
        return this.oracle_sql.toString();
    }

    void handleODBC() throws SQLException {
        while (this.i < this.length) {
            this.c = this.odbc_sql.charAt(this.i);
            if (this.in_string) {
                this.oracle_sql.append(this.c);
                if (this.c == '\'') {
                    this.in_string = false;
                }
                ++this.i;
                continue;
            }
            switch (this.c) {
                case '\'': {
                    this.oracle_sql.append(this.c);
                    this.in_string = true;
                    ++this.i;
                    this.first = false;
                    break;
                }
                case '{': {
                    this.token_buffer.setLength(0);
                    ++this.i;
                    this.skipSpace();
                    while (this.i < this.length && (Character.isJavaLetterOrDigit(this.c = this.odbc_sql.charAt(this.i)) || this.c == '?')) {
                        this.token_buffer.append(this.c);
                        ++this.i;
                    }
                    this.handleToken(this.token_buffer.toString());
                    this.c = this.odbc_sql.charAt(this.i);
                    if (this.c != '}') {
                        String string;
                        String string2 = string = new String(String.valueOf(this.i) + ": Expecting \"}\" got \"" + this.c + "\"");
                        if (OracleLog.TRACE) {
                            String string3 = "DBError.check_error(errNum=" + 33 + ", obj=" + string2 + ")";
                            OracleLog.print(null, 1, 4, 16, string3);
                        }
                        DBError.throwSqlException(33, string2);
                    }
                    ++this.i;
                    break;
                }
                case '}': {
                    return;
                }
                default: {
                    this.appendChar(this.oracle_sql, this.c);
                    ++this.i;
                    this.first = false;
                }
            }
        }
    }

    void handleToken(String string) throws SQLException {
        String string2;
        if (string.equalsIgnoreCase("?")) {
            this.handleFunction();
            return;
        }
        if (string.equalsIgnoreCase("call")) {
            this.handleCall();
            return;
        }
        if (string.equalsIgnoreCase("ts")) {
            this.handleTimestamp();
            return;
        }
        if (string.equalsIgnoreCase("t")) {
            this.handleTime();
            return;
        }
        if (string.equalsIgnoreCase("d")) {
            this.handleDate();
            return;
        }
        if (string.equalsIgnoreCase("escape")) {
            this.handleEscape();
            return;
        }
        String string3 = string2 = new String(String.valueOf(this.i) + ": " + string);
        if (OracleLog.TRACE) {
            String string4 = "DBError.check_error(errNum=" + 34 + ", obj=" + string3 + ")";
            OracleLog.print(null, 1, 4, 16, string4);
        }
        DBError.throwSqlException(34, string3);
    }

    void handleFunction() throws SQLException {
        String string;
        String string2;
        String string3;
        boolean bl = this.first;
        if (bl) {
            this.oracle_sql.append("BEGIN ");
        }
        this.appendChar(this.oracle_sql, '?');
        this.skipSpace();
        if (this.c != '=') {
            string2 = string3 = new String(String.valueOf(this.i) + ". Expecting \"=\" got \"" + this.c + "\"");
            if (OracleLog.TRACE) {
                string = "DBError.check_error(errNum=" + 33 + ", obj=" + string2 + ")";
                OracleLog.print(null, 1, 4, 16, string);
            }
            DBError.throwSqlException(33, string2);
        }
        ++this.i;
        this.skipSpace();
        if (!this.odbc_sql.startsWith("call", this.i)) {
            string2 = string3 = new String(String.valueOf(this.i) + ". Expecting \"call\"");
            if (OracleLog.TRACE) {
                string = "DBError.check_error(errNum=" + 33 + ", obj=" + string2 + ")";
                OracleLog.print(null, 1, 4, 16, string);
            }
            DBError.throwSqlException(33, string2);
        }
        this.i += 4;
        this.oracle_sql.append(" := ");
        this.skipSpace();
        this.handleODBC();
        if (bl) {
            this.oracle_sql.append("; END;");
        }
    }

    void handleCall() throws SQLException {
        boolean bl = this.first;
        if (bl) {
            this.oracle_sql.append("BEGIN ");
        }
        this.skipSpace();
        this.handleODBC();
        this.skipSpace();
        if (bl) {
            this.oracle_sql.append("; END;");
        }
    }

    void handleTimestamp() throws SQLException {
        this.oracle_sql.append("TO_DATE (");
        this.skipSpace();
        boolean bl = false;
        while (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) != '}') {
            if (!bl) {
                if (this.c == '.') {
                    bl = true;
                } else {
                    this.oracle_sql.append(this.c);
                }
            }
            ++this.i;
        }
        if (bl) {
            this.oracle_sql.append('\'');
        }
        this.oracle_sql.append(", 'YYYY-MM-DD HH24:MI:SS')");
    }

    void handleTime() throws SQLException {
        this.oracle_sql.append("TO_DATE (");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(", 'HH24:MI:SS')");
    }

    void handleDate() throws SQLException {
        this.oracle_sql.append("TO_DATE (");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(", 'YYYY-MM-DD')");
    }

    void handleEscape() throws SQLException {
        this.oracle_sql.append("ESCAPE ");
        this.skipSpace();
        this.handleODBC();
    }

    String nextArgument() {
        String string = ":" + this.current_argument;
        ++this.current_argument;
        return string;
    }

    void appendChar(StringBuffer stringBuffer, char c) {
        if (c == '?') {
            stringBuffer.append(this.nextArgument());
            return;
        }
        stringBuffer.append(c);
    }

    void skipSpace() {
        while (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) == ' ') {
            ++this.i;
        }
    }
}

