/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Dictionary;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc2.Array;
import oracle.jdbc2.Blob;
import oracle.jdbc2.Clob;
import oracle.jdbc2.Ref;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;

public class OracleResultSetImpl
extends BaseResultSet {
    public static final boolean DEBUG = false;
    OracleConnection connection;
    OracleStatement statement;
    boolean closed;
    boolean explicitly_closed;
    public boolean close_statement_on_close;
    private boolean m_emptyRset;

    OracleResultSetImpl(OracleConnection oracleConnection, OracleStatement oracleStatement) throws SQLException {
        this.connection = oracleConnection;
        this.statement = oracleStatement;
        this.close_statement_on_close = false;
        this.closed = false;
        this.explicitly_closed = false;
        this.m_emptyRset = false;
    }

    public synchronized void close() throws SQLException {
        this.internal_close();
        this.explicitly_closed = true;
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.statement.wasNullValue();
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.connection.trace("ResultSet.getMetaData");
        if (this.explicitly_closed) {
            DBError.check_error(10, "getMetaData");
        }
        return new OracleResultSetMetaData(this.connection, this.statement);
    }

    public synchronized Statement getStatement() throws SQLException {
        return this.statement;
    }

    public synchronized boolean next() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 32, 16, "OracleResultSetImpl.next(): closed=" + this.closed);
        }
        if (this.explicitly_closed) {
            DBError.check_error(10, "next");
        }
        if (this.statement.connection == null || this.statement.connection.closed) {
            DBError.check_error(8, "next");
        }
        if (this.statement.closed) {
            DBError.check_error(9, "next");
        }
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 32, 32, "closed=" + this.closed + ", statement.current_row=" + this.statement.current_row + ", statement.total_rows_visited=" + this.statement.total_rows_visited + ", statement.max_rows=" + this.statement.max_rows + ", statement.valid_rows=" + this.statement.valid_rows + ", statement.got_last_batch=" + this.statement.got_last_batch);
        }
        if (this.closed) {
            return false;
        }
        ++this.statement.current_row;
        ++this.statement.total_rows_visited;
        if (this.statement.max_rows != 0 && this.statement.total_rows_visited > this.statement.max_rows) {
            this.internal_close();
            return false;
        }
        if (this.statement.current_row >= this.statement.valid_rows) {
            try {
                if (this.statement.got_last_batch) {
                    this.internal_close();
                    return false;
                }
                this.statement.check_row_prefetch_changed();
                this.prepare_for_new_row();
                this.statement.connection.needLine();
                this.statement.valid_rows = this.connection.db_access.fetch(this.statement.dbstmt, this.statement.defines.types, this.statement.defines.data, this.statement.row_prefetch);
                this.statement.fetchedFirstColumns();
                if (this.statement.valid_rows == 0) {
                    this.internal_close();
                    return false;
                }
                this.statement.current_row = 0;
                this.statement.checkValidRowsStatus();
                return true;
            }
            catch (IOException iOException) {
                DBError.check_error(iOException);
            }
        }
        return true;
    }

    public boolean isBeforeFirst() throws SQLException {
        return !this.isEmptyResultSet() && this.statement.current_row == -1 && !this.closed;
    }

    public boolean isAfterLast() throws SQLException {
        return !this.isEmptyResultSet() && this.closed;
    }

    public boolean isFirst() throws SQLException {
        return this.statement.current_row == 0;
    }

    public boolean isLast() throws SQLException {
        DBError.throwSqlException(75, "isLast");
        return false;
    }

    public int getRow() throws SQLException {
        return this.statement.total_rows_visited;
    }

    public synchronized String getString(int n) throws SQLException {
        return this.statement.getStringValue(true, n);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        return this.statement.getBooleanValue(true, n);
    }

    public synchronized byte getByte(int n) throws SQLException {
        return this.statement.getByteValue(true, n);
    }

    public synchronized short getShort(int n) throws SQLException {
        return this.statement.getShortValue(true, n);
    }

    public synchronized int getInt(int n) throws SQLException {
        return this.statement.getIntValue(true, n);
    }

    public synchronized long getLong(int n) throws SQLException {
        return this.statement.getLongValue(true, n);
    }

    public synchronized float getFloat(int n) throws SQLException {
        return this.statement.getFloatValue(true, n);
    }

    public synchronized double getDouble(int n) throws SQLException {
        return this.statement.getDoubleValue(true, n);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.statement.getBigDecimalValue(true, n, n2);
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        return this.statement.getBytesValue(true, n);
    }

    public synchronized Date getDate(int n) throws SQLException {
        return this.statement.getDateValue(true, n);
    }

    public synchronized Time getTime(int n) throws SQLException {
        return this.statement.getTimeValue(true, n);
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        return this.statement.getTimestampValue(true, n);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        return this.statement.getAsciiStreamValue(true, n);
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        return this.statement.getUnicodeStreamValue(true, n);
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        return this.statement.getBinaryStreamValue(true, n);
    }

    public synchronized Object getObject(int n) throws SQLException {
        return this.statement.getObjectValue(true, n);
    }

    public synchronized ResultSet getCursor(int n) throws SQLException {
        return this.statement.getCursorValue(true, n);
    }

    public synchronized Datum getOracleObject(int n) throws SQLException {
        return this.statement.getOracleObjectValue(true, n);
    }

    public synchronized ROWID getROWID(int n) throws SQLException {
        return this.statement.getROWIDValue(true, n);
    }

    public synchronized NUMBER getNUMBER(int n) throws SQLException {
        return this.statement.getNUMBERValue(true, n);
    }

    public synchronized DATE getDATE(int n) throws SQLException {
        return this.statement.getDATEValue(true, n);
    }

    public synchronized ARRAY getARRAY(int n) throws SQLException {
        return this.statement.getARRAYValue(true, n);
    }

    public synchronized STRUCT getSTRUCT(int n) throws SQLException {
        return this.statement.getSTRUCTValue(true, n);
    }

    public synchronized REF getREF(int n) throws SQLException {
        return this.statement.getREFValue(true, n);
    }

    public synchronized CHAR getCHAR(int n) throws SQLException {
        return this.statement.getCHARValue(true, n);
    }

    public synchronized RAW getRAW(int n) throws SQLException {
        return this.statement.getRAWValue(true, n);
    }

    public synchronized BLOB getBLOB(int n) throws SQLException {
        return this.statement.getBLOBValue(true, n);
    }

    public synchronized CLOB getCLOB(int n) throws SQLException {
        return this.statement.getCLOBValue(true, n);
    }

    public synchronized BFILE getBFILE(int n) throws SQLException {
        return this.statement.getBFILEValue(true, n);
    }

    public synchronized BFILE getBfile(int n) throws SQLException {
        return this.getBFILE(n);
    }

    public synchronized CustomDatum getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        return this.statement.getCustomDatumValue(true, n, customDatumFactory);
    }

    public synchronized Object getObject(int n, Dictionary dictionary) throws SQLException {
        return this.statement.getObjectValue(true, n, dictionary);
    }

    public synchronized Ref getRef(int n) throws SQLException {
        this.connection.trace("ResultSet.getRef");
        return this.getREF(n);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        this.connection.trace("ResultSet.getBlob");
        return this.getBLOB(n);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        this.connection.trace("ResultSet.getClob");
        return this.getCLOB(n);
    }

    public synchronized Array getArray(int n) throws SQLException {
        this.connection.trace("ResultSet.getArray");
        return this.getARRAY(n);
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        return this.statement.getCharacterStreamValue(true, n);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.statement.getBigDecimalValue(true, n, 0);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            DBError.throwSqlException(68);
            return;
        }
        if (n == 0) {
            this.statement.setRowPrefetch(this.connection.getDefaultRowPrefetch());
            return;
        }
        this.statement.setRowPrefetch(n);
    }

    public int getFetchSize() throws SQLException {
        return this.statement.getRowPrefetch();
    }

    void internal_close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 32, 16, "OracleResultSetImpl.internal_close()");
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.statement.got_last_batch && this.statement.valid_rows == 0) {
            this.m_emptyRset = true;
        }
        try {
            this.statement.connection.needLine();
            this.statement.connection.db_access.closeQuery(this.statement.dbstmt);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        catch (SQLException sQLException) {}
        this.statement.end_of_result_set();
        if (this.close_statement_on_close) {
            try {
                this.statement.close();
                return;
            }
            catch (SQLException sQLException) {
                return;
            }
        }
    }

    void prepare_for_new_row() throws SQLException {
        if (this.statement.streams != null) {
            try {
                this.statement.streams.close();
            }
            catch (IOException iOException) {
                DBError.check_error(iOException);
            }
        }
        this.clearWarnings();
    }

    public synchronized int findColumn(String string) throws SQLException {
        this.connection.trace("ResultSet.findColumn");
        return this.statement.get_column_index(string);
    }

    boolean isEmptyResultSet() {
        return this.m_emptyRset || !this.m_emptyRset && this.statement.got_last_batch && this.statement.valid_rows == 0;
    }

    int getValidRows() {
        return this.statement.valid_rows;
    }
}

