/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Vector;
import oracle.jdbc.driver.OracleResultSetCache;

public class OracleResultSetCacheImpl
implements OracleResultSetCache {
    static final boolean DEBUG = false;
    private static int DEFAULT_WIDTH = 5;
    private static int DEFAULT_SIZE = 5;
    Vector m_rows;
    int m_width;

    public OracleResultSetCacheImpl() {
        this(DEFAULT_WIDTH);
    }

    public OracleResultSetCacheImpl(int n) {
        if (n > 0) {
            this.m_width = n;
        }
        this.m_rows = new Vector(DEFAULT_SIZE);
    }

    public void put(int n, int n2, Object object) {
        Vector vector = null;
        while (this.m_rows.size() < n) {
            vector = new Vector(this.m_width);
            this.m_rows.addElement(vector);
        }
        vector = (Vector)this.m_rows.elementAt(n - 1);
        while (vector.size() < n2) {
            vector.addElement(null);
        }
        vector.setElementAt(object, n2 - 1);
    }

    public Object get(int n, int n2) {
        Vector vector = (Vector)this.m_rows.elementAt(n - 1);
        return vector.elementAt(n2 - 1);
    }

    public void remove(int n) {
        this.m_rows.removeElementAt(n - 1);
    }

    public void remove(int n, int n2) {
        this.m_rows.removeElementAt(n - 1);
    }

    public void clear() {
    }

    public void close() {
    }

    public int getLength() {
        return 0;
    }

    public void printDebug() {
        int n = 0;
        while (n < this.m_rows.size()) {
            Vector vector = (Vector)this.m_rows.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                System.out.println("(" + (n + 1) + ", " + (n2 + 1) + ")=" + vector.elementAt(n2));
                ++n2;
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        OracleResultSetCacheImpl oracleResultSetCacheImpl = new OracleResultSetCacheImpl();
        oracleResultSetCacheImpl.put(1, 1, "(1, 1)");
        oracleResultSetCacheImpl.put(1, 2, "(1, 2)");
        oracleResultSetCacheImpl.put(2, 1, "(2, 1)");
        oracleResultSetCacheImpl.printDebug();
        System.out.println("cache.get (1, 1) = " + (String)oracleResultSetCacheImpl.get(1, 1));
        System.out.println("cache.get (1, 2) = " + (String)oracleResultSetCacheImpl.get(1, 2));
        System.out.println("cache.get (2, 1) = " + (String)oracleResultSetCacheImpl.get(2, 1));
    }
}

