/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc2.Array;
import oracle.jdbc2.Blob;
import oracle.jdbc2.Clob;
import oracle.jdbc2.Ref;
import oracle.jdbc2.SQLData;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OraclePreparedStatement
extends OracleStatement
implements PreparedStatement,
ScrollRsetStatement {
    private static int _MIN_ARG_COUNT = 1;
    private DBItem[] last_bind_values;
    private int min_binary_stream_size;
    private int min_ascii_stream_size;
    private DBItem[] tmp_in_first_row_items;
    private DBType[] tmp_in_first_row_types;
    protected DBType[] tmp_out_first_row_types;
    protected int noOfArgs;
    protected int noOfOutParams;
    private boolean check_bind_types = true;
    DBDataSet m_binds;
    boolean m_scrollRsetTypeSolved;
    protected static final int BSTYLE_UNKNOWN = 0;
    protected static final int BSTYLE_ORACLE = 1;
    protected static final int BSTYLE_JDBC = 2;
    protected int m_batchStyle = 0;

    public OraclePreparedStatement(OracleConnection oracleConnection, String string, int n, int n2) throws SQLException {
        this(oracleConnection, string, n, n2, 1003, 1007);
    }

    public OraclePreparedStatement(OracleConnection oracleConnection, String string, int n, int n2, int n3, int n4) throws SQLException {
        super(oracleConnection, n, n2, n3, n4);
        if (OracleLog.TRACE) {
            OracleLog.print(oracleConnection, 1, 16, 16, "OraclePreparedStatement.OraclePreparedStatement(conn, sql, batchValue, rowPrefetchValue)");
        }
        this.noOfArgs = 0;
        this.noOfOutParams = 0;
        this.need_to_parse = true;
        this.sql_string_changed = true;
        this.prepare_for_new_result();
        this.sql_query = string;
        this.m_originalSql = string;
        this.first_row = true;
        this.m_binds = null;
        this.m_scrollRsetTypeSolved = false;
        if (oracleConnection.db_access.getVersionNumber() >= 8000) {
            this.min_binary_stream_size = 2000;
            this.min_ascii_stream_size = 4000;
            return;
        }
        this.min_binary_stream_size = 255;
        this.min_ascii_stream_size = 2000;
    }

    public synchronized void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.close()");
        }
        if (this.closed) {
            return;
        }
        if (this.m_currentRank > 0 && this.m_batchStyle == 2 && true) {
            this.clearBatch();
        } else {
            this.sendBatch();
        }
        super.close();
        if (this.last_bind_values != null) {
            int n = 0;
            while (n < this.last_bind_values.length) {
                this.last_bind_values[n] = null;
                ++n;
            }
            this.last_bind_values = null;
        }
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.executeQuery()");
        }
        if (this.m_currentRank > 0 && this.m_batchStyle == 2 && true) {
            DBError.throwSqlException(81, "batch must be either executed or cleared");
        }
        this.executeUpdate();
        if (this.isRegularResultSet()) {
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            return this.current_result_set;
        }
        if (this.m_scrollRset == null) {
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            this.m_scrollRset = this.current_result_set;
        }
        return this.m_scrollRset;
    }

    public synchronized int executeUpdate() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.executeUpdate()");
        }
        if (this.m_currentRank > 0 && this.m_batchStyle == 2 && true) {
            DBError.throwSqlException(81, "batch must be either executed or cleared");
        }
        if (this.closed) {
            DBError.throwSqlException(9);
        }
        if (this.isRegularResultSet()) {
            this.new_row_prefetch = this.default_row_prefetch;
            this.prepare_for_new_result();
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            this.first_row = false;
            return this.valid_rows;
        }
        if (this.m_scrollRsetTypeSolved) {
            this.new_row_prefetch = this.default_row_prefetch;
            this.prepare_for_new_result();
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            this.first_row = false;
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
            return this.valid_rows;
        }
        return this.doScrollPstmtExecuteUpdate();
    }

    public synchronized boolean execute() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.execute()");
        }
        if (this.m_currentRank > 0 && this.m_batchStyle == 2 && true) {
            DBError.throwSqlException(81, "batch must be either executed or cleared");
        }
        this.executeUpdate();
        return this.sql_kind == 0;
    }

    public synchronized int sendBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.sendBatch()");
            OracleLog.print(this.connection, 1, 16, 32, "Send batch: batch=" + this.batch + ", m_currentRank=" + this.m_currentRank);
        }
        if (this.m_batchStyle == 2 && true) {
            return 0;
        }
        if (this.closed) {
            DBError.throwSqlException(9);
        }
        if (this.m_currentRank <= 0) {
            return this.valid_rows;
        }
        int n = this.batch;
        try {
            --this.m_currentRank;
            if (this.batch != this.m_currentRank) {
                this.batch = this.m_currentRank;
                this.need_to_parse = true;
            }
            this.doExecuteWithTimeout();
        }
        finally {
            Object var3_2 = null;
            if (this.batch != n) {
                this.batch = n;
                this.need_to_parse = true;
            }
        }
        return this.valid_rows;
    }

    public synchronized void setExecuteBatch(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setExecuteBatch(batchValue=" + n + ")");
        }
        this.setOracleBatchStyle();
        this.set_execute_batch(n);
    }

    private synchronized void set_execute_batch(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.setExecuteBatch(batchValue=" + n + "): batch=" + this.batch);
        }
        if (n <= 0) {
            DBError.throwSqlException(42);
        }
        if (n == this.batch) {
            return;
        }
        this.batch = n;
        if (this.first_row) {
            return;
        }
        if (this.m_currentRank > 0) {
            this.sendBatch();
        }
        DBDataSet dBDataSet = this.binds_in;
        this.binds_in = null;
        this.binds_in = new DBDataSet(this.connection, this.noOfArgs, n);
        int n2 = 0;
        while (n2 < this.binds_in.types.length) {
            DBType dBType;
            DBDataSet dBDataSet2 = this.binds_in;
            DBType dBType2 = dBType = dBDataSet.types != null && n2 >= 0 && n2 < dBDataSet.types.length ? dBDataSet.types[n2] : null;
            if (dBDataSet2.types != null && n2 >= 0 && n2 < dBDataSet2.types.length) {
                dBDataSet2.types[n2] = dBType;
            }
            this.binds_in.allocData(n2);
            ++n2;
        }
        this.need_to_parse = true;
        dBDataSet = null;
    }

    public final int getExecuteBatch() {
        return this.batch;
    }

    private void defineParameterType(int n, int n2) throws SQLException {
        DBType dBType = null;
        int n3 = n - 1;
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                dBType = this.getDBType(n3, 6);
                break;
            }
            case 999: {
                dBType = this.getDBType(n3, 999);
                break;
            }
            case 1: {
                dBType = this.getDBType(n3, 96);
                break;
            }
            case 12: {
                dBType = this.getDBType(n3, 1);
                break;
            }
            case -1: {
                dBType = this.getDBType(n3, 8);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                dBType = this.getDBType(n3, 12);
                break;
            }
            case -3: 
            case -2: {
                dBType = this.getDBType(n3, 23);
                break;
            }
            case -4: {
                dBType = this.getDBType(n3, 24);
                break;
            }
            case -8: {
                dBType = this.getDBType(n3, 104);
                break;
            }
            case 2004: {
                dBType = this.getDBType(n3, 113);
                break;
            }
            case 2005: {
                dBType = this.getDBType(n3, 112);
                break;
            }
            case -13: {
                dBType = this.getDBType(n3, 114);
                break;
            }
            case -10: {
                dBType = this.getDBType(n3, 102);
            }
        }
        this.setDBType(n3, dBType);
    }

    public synchronized void defineParameterType(int n, int n2, int n3) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.defineParameterType(param_index=" + n + ", type=" + n2 + ", max_size=" + n3 + ")");
        }
        if (n3 < 0) {
            DBError.throwSqlException(53);
        }
        this.defineParameterType(n, n2);
        int n4 = n3;
        if (this.first_row) {
            this.tmp_in_first_row_types[n - 1].max_length = n4 = Math.min(this.tmp_in_first_row_types[n - 1].max_length, n4);
            return;
        }
        this.binds_in.types[n - 1].max_length = n4 = Math.min(this.binds_in.types[n - 1].max_length, n4);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getMetaData();
        }
        return null;
    }

    protected void setItem(int n, int n2, byte[] byArray) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.setItem(index=" + n + ", type=" + n2 + ", array)");
        }
        this.checkBindTypes(true, n, n2);
        DBType dBType = this.getDBType(n, n2);
        DBItem dBItem = this.getDBItem(n, dBType);
        if (byArray == null) {
            dBItem.setNull();
        } else {
            if (dBType.max_length < byArray.length) {
                dBType.max_length = byArray.length;
            }
            dBItem.setArrayData(false, byArray);
        }
        this.setDBType(n, dBType);
        this.setDBItem(n, dBItem);
    }

    protected void setStreamItem(int n, int n2, InputStream inputStream, int n3) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.setStreamItem(index=" + n + ", type=" + n2 + ", istream, size=" + n3 + ")");
        }
        if (n3 < 0) {
            DBError.throwSqlException(43);
        }
        this.checkBindTypes(true, n, n2);
        DBType dBType = this.getDBType(n, n2);
        DBItem dBItem = this.getDBItem(n, dBType);
        dBItem.setStreamData(false, n3, inputStream);
        this.setDBType(n, dBType);
        this.setDBItem(n, dBItem);
    }

    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.setNull(paramIndex=" + n + ", sqlType=" + n2 + ", sqlName=" + string + ")");
        }
        if (n2 == 2002 || n2 == 2003 || n2 == 2006) {
            Object object;
            int n3 = this.get_internal_type(n2);
            int n4 = n - 1;
            this.checkBindTypes(true, n4, n3);
            DBType dBType = this.getDBType(n4, n3);
            if (n2 == 2002 || n2 == 2006) {
                object = StructDescriptor.createDescriptor(string, this.connection);
                dBType.otype = ((StructDescriptor)object).getOracleTypeADT();
            } else if (n2 == 2003) {
                object = ArrayDescriptor.createDescriptor(string, this.connection);
                dBType.otype = ((ArrayDescriptor)object).getOracleTypeCOLLECTION();
            }
            dBType.max_length = 0;
            object = this.getDBItem(n4, dBType);
            ((DBItem)object).setNull();
            this.setDBType(n4, dBType);
            this.setDBItem(n4, (DBItem)object);
            return;
        }
        this.setNull(n, n2);
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        DBType dBType;
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.setNull(paramIndex=" + n + ", sqlType=" + n2 + ")");
        }
        if (n2 == 2002 || n2 == 2003 || n2 == 2006) {
            DBError.throwSqlException(4, "sqlType=" + n2);
        }
        int n3 = n - 1;
        int n4 = this.get_internal_type(n2);
        this.checkBindTypes(true, n3, n4);
        switch (n4) {
            case 8: {
                dBType = this.getDBType(n3, 1);
                break;
            }
            case 24: {
                dBType = this.getDBType(n3, 23);
                break;
            }
            default: {
                dBType = this.getDBType(n3, n4);
            }
        }
        DBItem dBItem = this.getDBItem(n3, dBType);
        dBItem.setNull();
        this.setDBType(n3, dBType);
        this.setDBItem(n3, dBItem);
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setBoolean(paramIndex=" + n + ", x=" + bl + ")");
        }
        int n2 = n - 1;
        byte[] byArray = DBConversion.BooleanToNumberBytes(bl);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setByte(paramIndex=" + n + ", x=" + by + ")");
        }
        int n2 = n - 1;
        byte[] byArray = DBConversion.ByteToNumberBytes(by);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setShort(paramIndex=" + n + ", x=" + s + ")");
        }
        int n2 = n - 1;
        byte[] byArray = DBConversion.ShortToNumberBytes(s);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setInt(paramIndex=" + n + ", x=" + n2 + ")");
        }
        int n3 = n - 1;
        byte[] byArray = DBConversion.IntToNumberBytes(n2);
        this.setItem(n3, 6, byArray);
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setLong(paramIndex=" + n + ", x=" + l + ")");
        }
        int n2 = n - 1;
        byte[] byArray = DBConversion.LongToNumberBytes(l);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setFloat(paramIndex=" + n + ", x=" + f + ")");
        }
        int n2 = n - 1;
        byte[] byArray = DBConversion.FloatToNumberBytes(f);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setDouble(paramIndex=" + n + ", x=" + d + ")");
        }
        int n2 = n - 1;
        byte[] byArray = DBConversion.DoubleToNumberBytes(d);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setBigDecimal(paramIndex=" + n + ", x=" + bigDecimal + ")");
        }
        int n2 = n - 1;
        byte[] byArray = DBConversion.BigDecimalToNumberBytes(bigDecimal);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setString(int n, String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setString(paramIndex=" + n + ", x=" + string + ")");
        }
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.StringToCharBytes(string);
        this.setItem(n2, 1, byArray);
    }

    public synchronized void setFixedCHAR(int n, String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setFixedCHAR(paramIndex=" + n + ", x=" + string + ")");
        }
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.StringToCharBytes(string);
        this.setItem(n2, 999, byArray);
    }

    public synchronized void setCursor(int n, ResultSet resultSet) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setCursor(paramIndex=" + n + ", rs)");
        }
        int n2 = n - 1;
        DBAccess dBAccess = this.connection.db_access;
        byte[] byArray = null;
        try {
            byArray = dBAccess.DBStatementToRefCursorBytes(((OracleResultSetImpl)resultSet).statement.dbstmt);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.setItem(n2, 102, byArray);
    }

    public synchronized void setROWID(int n, ROWID rOWID) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setROWID(paramIndex=" + n + ", rowid)");
        }
        this.setDatum(n - 1, 104, rOWID);
    }

    public synchronized void setArray(int n, Array array) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setArray(paramIndex=" + n + ", array)");
        }
        this.setARRAY(n, (ARRAY)array);
    }

    public synchronized void setARRAY(int n, ARRAY aRRAY) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setARRAYr(paramIndex=" + n + ", array)");
        }
        if (aRRAY == null) {
            DBError.throwSqlException(68);
        }
        if (aRRAY.getDescriptor() == null) {
            DBError.throwSqlException(61);
        }
        int n2 = n - 1;
        this.checkBindTypes(true, n2, 109);
        byte[] byArray = aRRAY.toBytes();
        DBType dBType = this.getDBType(n2, 109);
        dBType.otype = aRRAY.getDescriptor().getOracleTypeCOLLECTION();
        dBType.max_length = byArray.length;
        DBItem dBItem = this.getDBItem(n2, dBType);
        dBItem.setArrayData(false, byArray);
        this.setDBType(n2, dBType);
        this.setDBItem(n2, dBItem);
    }

    public synchronized void setSTRUCT(int n, STRUCT sTRUCT) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setSTRUCT(paramIndex=" + n + ", struct)");
        }
        int n2 = n - 1;
        if (sTRUCT == null) {
            DBError.throwSqlException(68);
        }
        if (sTRUCT.getDescriptor() == null) {
            DBError.throwSqlException(61);
        }
        this.checkBindTypes(true, n2, 109);
        byte[] byArray = sTRUCT.toBytes();
        DBType dBType = this.getDBType(n2, 109);
        dBType.otype = sTRUCT.getDescriptor().getOracleTypeADT();
        dBType.max_length = byArray.length;
        DBItem dBItem = this.getDBItem(n2, dBType);
        dBItem.setArrayData(false, byArray);
        this.setDBType(n2, dBType);
        this.setDBItem(n2, dBItem);
    }

    public synchronized void setRAW(int n, RAW rAW) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setRAW(paramIndex=" + n + ", raq)");
        }
        this.setDatum(n - 1, 23, rAW);
    }

    public synchronized void setCHAR(int n, CHAR cHAR) throws SQLException {
        if (OracleLog.TRACE) {
            String string = null;
            string = cHAR == null ? "=null" : "(charset=" + String.valueOf(cHAR.getCharacterSet().getOracleId()) + ")";
            OracleLog.print(1, 16, 1, "OraclePreparedStatement.setCHAR(paramIdx=" + n + ", CHAR" + string + ")");
        }
        int n2 = 96;
        if (cHAR != null) {
            short s = (short)cHAR.getCharacterSet().getOracleId();
            n2 = 96;
            if (OracleLog.TRACE) {
                OracleLog.print(1, 8, "OraclePreparedStatement.setCHAR() may not be able to handle charset of " + s);
            }
        }
        this.setDatum(n - 1, n2, cHAR);
    }

    public synchronized void setDATE(int n, DATE dATE) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setDATE(paramIndex=" + n + ", date=" + dATE + ")");
        }
        this.setDatum(n - 1, 12, dATE);
    }

    public synchronized void setNUMBER(int n, NUMBER nUMBER) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setNUMBER(paramIndex=" + n + ", num)");
        }
        this.setDatum(n - 1, 6, nUMBER);
    }

    private void setDatum(int n, int n2, Datum datum) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(1, 16, "OraclePreparedStatement.setDatum(index=" + n + ", type=" + n2 + ", datum)");
        }
        if (datum == null) {
            this.setItem(n, n2, null);
            return;
        }
        this.setItem(n, n2, datum.getBytes());
    }

    public synchronized void setBLOB(int n, BLOB bLOB) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setBLOB(paramIndex=" + n + ", lob)");
        }
        this.setDatum(n - 1, 113, bLOB);
    }

    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        this.setBLOB(n, (BLOB)blob);
    }

    public synchronized void setCLOB(int n, CLOB cLOB) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setCLOB(paramIndex=" + n + ", clob)");
        }
        this.setDatum(n - 1, 112, cLOB);
    }

    public synchronized void setClob(int n, Clob clob) throws SQLException {
        this.setCLOB(n, (CLOB)clob);
    }

    public synchronized void setBFILE(int n, BFILE bFILE) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setBFILE(paramIndex=" + n + ", bfile)");
        }
        this.setDatum(n - 1, 114, bFILE);
    }

    public synchronized void setBfile(int n, BFILE bFILE) throws SQLException {
        this.setBFILE(n, bFILE);
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setBytes(paramIndex=" + n + ", bytes)");
        }
        int n2 = n - 1;
        if (byArray != null) {
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.setItem(n2, 23, byArray2);
            return;
        }
        this.setItem(n2, 23, null);
    }

    public synchronized void setInternalBytes(int n, byte[] byArray, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setInternalBytes(paramIndex=" + n + ", bytes, dbtype=" + n2);
        }
        int n3 = n - 1;
        this.setItem(n3, n2, byArray);
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setDate(paramIndex=" + n + ", date)");
        }
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.DateToDateBytes(date);
        this.setItem(n2, 12, byArray);
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setTime(paramIndex=" + n + ", time)");
        }
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.TimeToDateBytes(time);
        this.setItem(n2, 12, byArray);
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setTimestamp(paramIndex=" + n + ", timestamp)");
        }
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.TimestampToDateBytes(timestamp);
        this.setItem(n2, 12, byArray);
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setAsciiStream(paramIndex=" + n + ", istream, length=" + n2 + ")");
        }
        this.set_execute_batch(1);
        if (inputStream != null) {
            int n3 = n - 1;
            int n4 = this.sql_string_changed ? this.parseSqlKind() : (int)this.sql_kind;
            int n5 = 0;
            n5 = this.connection.conversion.isUcs2CharSet() ? this.min_ascii_stream_size / 2 : this.min_ascii_stream_size;
            if (n4 == 1 || n2 <= n5 || !this.isRegularResultSet()) {
                try {
                    byte[] byArray = new byte[n2];
                    inputStream.read(byArray, 0, n2);
                    byte[] byArray2 = this.connection.conversion.asciiBytesToCHARBytes(byArray);
                    this.setItem(n3, 1, byArray2);
                    return;
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                    return;
                }
            }
            InputStream inputStream2 = this.connection.conversion.ConvertStream(inputStream, 5, n2);
            this.setStreamItem(n3, 8, inputStream2, n2);
            return;
        }
        this.setString(n, null);
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setBinaryStream(paramIndex=" + n + ", istream, length=" + n2 + ")");
        }
        this.set_execute_batch(1);
        if (inputStream != null) {
            int n3;
            int n4 = n - 1;
            int n5 = n3 = this.sql_string_changed ? this.parseSqlKind() : (int)this.sql_kind;
            if (n3 == 1 || n2 <= this.min_binary_stream_size || !this.isRegularResultSet()) {
                try {
                    byte[] byArray = new byte[n2];
                    inputStream.read(byArray, 0, n2);
                    this.setItem(n4, 23, byArray);
                    return;
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                    return;
                }
            }
            this.setStreamItem(n4, 24, inputStream, n2);
            return;
        }
        this.setBytes(n, null);
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setUnicodeStream(paramIndex=" + n + ", istream, length=" + n2 + ")");
        }
        this.set_execute_batch(1);
        if (inputStream != null) {
            int n3 = n - 1;
            InputStream inputStream2 = this.connection.conversion.ConvertStream(inputStream, 4, n2);
            int n4 = this.sql_string_changed ? this.parseSqlKind() : (int)this.sql_kind;
            int n5 = 2 * (this.min_ascii_stream_size / this.connection.db_access.getC2SNlsRatio()) / this.connection.conversion.getMaxCharbyteSize();
            if (n4 == 1 || n2 <= n5 || !this.isRegularResultSet()) {
                try {
                    int n6;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    byte[] byArray = new byte[1024];
                    while ((n6 = inputStream2.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n6);
                    }
                    this.setItem(n3, 1, byteArrayOutputStream.toByteArray());
                    ((OutputStream)byteArrayOutputStream).close();
                    return;
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                    return;
                }
            }
            this.setStreamItem(n3, 8, inputStream2, n2 * this.connection.conversion.getMaxCharbyteSize());
            return;
        }
        this.setString(n, null);
    }

    public synchronized void setCustomDatum(int n, CustomDatum customDatum) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setCustomDataum(paramIndex=" + n + ", customDatum)");
        }
        Datum datum = customDatum.toDatum(this.connection);
        this.setOracleObject(n, datum);
    }

    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setObject(paramIndex=" + n + ", object, targetSqlType=" + n2 + ", scale=" + n3 + ")");
        }
        switch (n2) {
            case 1: {
                if (object instanceof CHAR) {
                    this.setCHAR(n, (CHAR)object);
                    return;
                }
                this.setString(n, (String)object);
                return;
            }
            case 12: {
                this.setString(n, (String)object);
                return;
            }
            case -1: {
                this.setString(n, (String)object);
                return;
            }
            case 2: {
                if (object instanceof NUMBER) {
                    this.setNUMBER(n, (NUMBER)object);
                    return;
                }
                this.setBigDecimal(n, (BigDecimal)object);
                return;
            }
            case 3: {
                this.setBigDecimal(n, (BigDecimal)object);
                return;
            }
            case -7: {
                this.setBoolean(n, (Boolean)object);
                return;
            }
            case -6: {
                this.setByte(n, (byte)((Integer)object).intValue());
                return;
            }
            case 5: {
                this.setShort(n, (short)((Integer)object).intValue());
                return;
            }
            case 4: {
                this.setInt(n, (Integer)object);
                return;
            }
            case -5: {
                this.setLong(n, (Long)object);
                return;
            }
            case 7: {
                this.setFloat(n, ((Float)object).floatValue());
                return;
            }
            case 6: {
                this.setFloat(n, ((Float)object).floatValue());
                return;
            }
            case 8: {
                this.setDouble(n, (Double)object);
                return;
            }
            case -2: {
                if (object instanceof RAW) {
                    this.setRAW(n, (RAW)object);
                    return;
                }
                this.setBytes(n, (byte[])object);
                return;
            }
            case -3: {
                this.setBytes(n, (byte[])object);
                return;
            }
            case -4: {
                this.setBytes(n, (byte[])object);
                return;
            }
            case 91: {
                if (object instanceof DATE) {
                    this.setDATE(n, (DATE)object);
                    return;
                }
                this.setDate(n, (Date)object);
                return;
            }
            case 92: {
                this.setTime(n, (Time)object);
                return;
            }
            case 93: {
                this.setTimestamp(n, (Timestamp)object);
                return;
            }
            case -8: {
                this.setROWID(n, (ROWID)object);
                return;
            }
            case 2004: {
                this.setBLOB(n, (BLOB)object);
                return;
            }
            case 2005: {
                this.setCLOB(n, (CLOB)object);
                return;
            }
            case -13: {
                this.setBFILE(n, (BFILE)object);
                return;
            }
            case -10: {
                this.setCursor(n, (OracleResultSet)object);
                return;
            }
            case 2002: {
                this.setSTRUCT(n, STRUCT.toSTRUCT(object, this.connection));
                return;
            }
            case 2003: {
                this.setARRAY(n, (ARRAY)object);
                return;
            }
            case 2006: {
                this.setREF(n, (REF)object);
                return;
            }
        }
        DBError.throwSqlException(4);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setRefType(int n, REF rEF) throws SQLException {
        this.setREF(n, rEF);
    }

    public synchronized void setRef(int n, Ref ref) throws SQLException {
        this.setREF(n, (REF)ref);
    }

    public synchronized void setREF(int n, REF rEF) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setREF(paramIndex=" + n + ", ref)");
        }
        if (rEF == null) {
            DBError.throwSqlException(68);
        }
        int n2 = n - 1;
        this.checkBindTypes(true, n2, 111);
        if (rEF.getDescriptor() != null) {
            byte[] byArray = rEF.getBytes();
            DBType dBType = this.getDBType(n2, 111);
            dBType.otype = rEF.getDescriptor().getOracleTypeADT();
            dBType.max_length = byArray.length;
            DBItem dBItem = this.getDBItem(n2, dBType);
            dBItem.setArrayData(false, byArray);
            this.setDBType(n2, dBType);
            this.setDBItem(n2, dBItem);
            return;
        }
        DBError.throwSqlException(52);
    }

    public synchronized void setObject(int n, Object object) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setObject(paramIndex=" + n + ", object)");
        }
        if (object instanceof CustomDatum) {
            this.setCustomDatum(n, (CustomDatum)object);
            return;
        }
        int n2 = this.sqlTypeForObject(object);
        this.setObject(n, object, n2, 0);
    }

    public synchronized void setOracleObject(int n, Datum datum) throws SQLException {
        this.setObject(n, datum);
    }

    void end_of_result_set() throws SQLException {
        this.prepare_for_new_result();
    }

    private void get_data_for_columns(int n) throws SQLException {
        int n2;
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.get_data_for_columns()");
        }
        if (this.first_row) {
            if (OracleLog.TRACE) {
                OracleLog.print(this.connection, 1, 16, 32, "First row: noOfArgs=" + this.noOfArgs + ", noOfOutParams=" + this.noOfOutParams + ", m_currentRank=" + this.m_currentRank);
            }
            this.binds_in = new DBDataSet(this.connection, this.noOfArgs, n);
            if (this.noOfOutParams > 0) {
                this.binds_out = new DBDataSet(this.connection, this.noOfArgs, n);
            }
            this.last_bind_values = new DBItem[this.noOfArgs];
            n2 = 0;
            while (n2 < this.noOfArgs) {
                DBType dBType;
                DBDataSet dBDataSet;
                if (this.tmp_in_first_row_types != null && this.tmp_in_first_row_types[n2] != null) {
                    this.last_bind_values[n2] = this.tmp_in_first_row_items[n2];
                    dBDataSet = this.binds_in;
                    dBType = this.tmp_in_first_row_types[n2];
                    if (dBDataSet.types != null && n2 >= 0 && n2 < dBDataSet.types.length) {
                        dBDataSet.types[n2] = dBType;
                    }
                    this.binds_in.allocData(n2);
                }
                if (this.noOfOutParams > 0 && this.tmp_out_first_row_types[n2] != null) {
                    dBDataSet = this.binds_out;
                    dBType = this.tmp_out_first_row_types[n2];
                    if (dBDataSet.types != null && n2 >= 0 && n2 < dBDataSet.types.length) {
                        dBDataSet.types[n2] = dBType;
                    }
                    this.binds_out.allocDataAndItems(n2);
                }
                ++n2;
            }
            if (this.tmp_in_first_row_types != null) {
                n2 = 0;
                while (n2 < this.tmp_in_first_row_types.length) {
                    this.tmp_in_first_row_types[n2] = null;
                    this.tmp_in_first_row_items[n2] = null;
                    ++n2;
                }
                this.tmp_in_first_row_items = null;
                this.tmp_in_first_row_types = null;
            }
            if (this.tmp_out_first_row_types != null) {
                n2 = 0;
                while (n2 < this.tmp_out_first_row_types.length) {
                    this.tmp_out_first_row_types[n2] = null;
                    ++n2;
                }
                this.tmp_out_first_row_types = null;
            }
        }
        boolean bl = this.binds_in.isDynamic();
        n2 = 0;
        while (n2 < this.binds_in.types.length) {
            if (this.last_bind_values[n2] != null) {
                if (bl) {
                    this.binds_in.addDBItem(this.last_bind_values[n2], n2);
                } else {
                    this.binds_in.setDBItem(this.last_bind_values[n2], n2, this.m_currentRank);
                }
            }
            ++n2;
        }
    }

    void checkBindTypes(boolean bl, int n, int n2) throws SQLException {
        DBType dBType;
        DBDataSet dBDataSet;
        DBDataSet dBDataSet2;
        if (n < 0) {
            DBError.throwSqlException(3);
        }
        if (this.first_row || !this.check_bind_types) {
            return;
        }
        if (bl) {
            dBDataSet2 = this.binds_in;
            dBDataSet = this.binds_out;
        } else {
            dBDataSet2 = this.binds_out;
            dBDataSet = this.binds_in;
        }
        if (dBDataSet2.types != null && dBDataSet2.types.length > n) {
            DBType dBType2 = dBType = dBDataSet2.types != null && n >= 0 && n < dBDataSet2.types.length ? dBDataSet2.types[n] : null;
            if (dBType != null && (dBType.type != n2 || dBType.max_length == 0)) {
                this.sendBatch();
                this.need_to_parse = true;
                this.clearDefines();
            }
        }
        if (dBDataSet != null && dBDataSet.types != null && dBDataSet.types.length > n) {
            DBType dBType3 = dBType = dBDataSet.types != null && n >= 0 && n < dBDataSet.types.length ? dBDataSet.types[n] : null;
            if (!(dBType == null || dBType.type == n2 || dBType.type == 96 && n2 == 1 || dBType.type == 1 && n2 == 96)) {
                DBError.throwSqlException(12);
            }
        }
    }

    int sqlTypeForObject(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Datum)) {
            if (object instanceof String) {
                return 12;
            }
            if (object instanceof BigDecimal) {
                return 2;
            }
            if (object instanceof Boolean) {
                return -7;
            }
            if (object instanceof Integer) {
                return 4;
            }
            if (object instanceof Long) {
                return -5;
            }
            if (object instanceof Float) {
                return 6;
            }
            if (object instanceof Double) {
                return 8;
            }
            if (object instanceof byte[]) {
                return -3;
            }
            if (object instanceof Date) {
                return 91;
            }
            if (object instanceof Time) {
                return 92;
            }
            if (object instanceof Timestamp) {
                return 93;
            }
            if (object instanceof SQLData) {
                return 2002;
            }
            if (object instanceof CustomDatum) {
                return 2002;
            }
        } else {
            if (object instanceof BLOB) {
                return 2004;
            }
            if (object instanceof CLOB) {
                return 2005;
            }
            if (object instanceof BFILE) {
                return -13;
            }
            if (object instanceof ROWID) {
                return -8;
            }
            if (object instanceof NUMBER) {
                return 2;
            }
            if (object instanceof DATE) {
                return 91;
            }
            if (object instanceof REF) {
                return 2006;
            }
            if (object instanceof CHAR) {
                return 1;
            }
            if (object instanceof RAW) {
                return -2;
            }
            if (object instanceof ARRAY) {
                return 2003;
            }
            if (object instanceof STRUCT) {
                return 2002;
            }
        }
        return 1111;
    }

    public synchronized void clearParameters() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.clearParameters()");
        }
        this.clear_params = true;
        if (this.first_row && this.tmp_in_first_row_items != null) {
            int n = 0;
            while (n < this.noOfArgs) {
                this.tmp_in_first_row_items[n] = null;
                ++n;
            }
            return;
        }
        int n = 0;
        while (n < this.noOfArgs) {
            this.last_bind_values[n] = null;
            ++n;
        }
        if (this.binds_in != null && this.binds_in.data != null && this.binds_in.data.length != 0) {
            int n2 = 0;
            while (n2 < this.batch) {
                n = 0;
                while (n < this.binds_in.types.length) {
                    if (this.binds_in.data[n] != null) {
                        this.binds_in.setDBItem(null, n, this.m_currentRank);
                    }
                    ++n;
                }
                ++n2;
            }
        }
    }

    protected void alloc_tmp_binds(int n) {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.alloc_tmp_binds(index=" + n + ")");
        }
        boolean bl = false;
        if (this instanceof OracleCallableStatement) {
            bl = true;
        }
        if (this.tmp_in_first_row_types == null || bl && this.tmp_out_first_row_types == null) {
            int n2 = Math.max(n + 1, _MIN_ARG_COUNT);
            this.tmp_in_first_row_items = new DBItem[n2];
            this.tmp_in_first_row_types = new DBType[n2];
            if (bl) {
                this.tmp_out_first_row_types = new DBType[n2];
                return;
            }
        } else if (n >= this.tmp_in_first_row_types.length || bl && n >= this.tmp_out_first_row_types.length) {
            int n3 = this.tmp_in_first_row_types.length;
            int n4 = bl ? this.tmp_out_first_row_types.length : 0;
            int n5 = Math.max(n3, n4);
            n5 = Math.max(n + 1, n5);
            DBItem[] dBItemArray = new DBItem[2 * n5];
            DBType[] dBTypeArray = new DBType[2 * n5];
            DBType[] dBTypeArray2 = null;
            if (bl) {
                dBTypeArray2 = new DBType[2 * n5];
            }
            System.arraycopy(this.tmp_in_first_row_items, 0, dBItemArray, 0, n3);
            System.arraycopy(this.tmp_in_first_row_types, 0, dBTypeArray, 0, n3);
            if (bl) {
                System.arraycopy(this.tmp_out_first_row_types, 0, dBTypeArray2, 0, n4);
            }
            if (bl) {
                this.tmp_out_first_row_types = dBTypeArray2;
            }
            this.tmp_in_first_row_items = dBItemArray;
            this.tmp_in_first_row_types = dBTypeArray;
            dBItemArray = null;
            dBTypeArray = null;
            dBTypeArray2 = null;
        }
    }

    private void printByteArray(byte[] byArray) {
        if (byArray == null) {
            System.out.println("<Null byte array!>");
            return;
        }
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 < 16) {
                System.out.print("0" + Integer.toHexString(n3) + " ");
            } else {
                System.out.print(String.valueOf(Integer.toHexString(n3)) + " ");
            }
            ++n2;
        }
        System.out.println();
    }

    protected DBItem getDBItem(int n, DBType dBType) throws SQLException {
        DBItem dBItem = null;
        if (this.first_row) {
            dBItem = this.connection.db_access.createDBItem(dBType);
        } else {
            dBItem = this.binds_in.getDBItem(n, this.m_currentRank);
            DBItem dBItem2 = null;
            dBItem2 = this.m_currentRank == 0 ? this.binds_in.getDBItem(n, this.batch - 1) : this.binds_in.getDBItem(n, this.m_currentRank - 1);
            if (dBItem == null || dBItem2 != null && dBItem2.equals(dBItem)) {
                dBItem = this.connection.db_access.createDBItem(dBType);
            } else {
                dBItem.reinitialize(dBType.max_length);
            }
        }
        return dBItem;
    }

    protected DBType getDBType(int n, int n2) throws SQLException {
        DBType dBType = null;
        if (this.first_row) {
            if (n + 1 > this.noOfArgs) {
                this.noOfArgs = n + 1;
            }
            this.alloc_tmp_binds(n);
            dBType = this.tmp_in_first_row_types[n];
        } else {
            DBDataSet dBDataSet = this.binds_in;
            DBType dBType2 = dBType = dBDataSet.types != null && n >= 0 && n < dBDataSet.types.length ? dBDataSet.types[n] : null;
        }
        if (dBType == null || dBType.type != n2) {
            if (this.sql_string_changed) {
                this.parseSqlKind();
            }
            dBType = this.connection.db_access.createDBType(n2, true, this.sql_kind == 1);
        }
        return dBType;
    }

    protected void setDBItem(int n, DBItem dBItem) {
        if (this.first_row) {
            this.tmp_in_first_row_items[n] = dBItem;
            return;
        }
        this.last_bind_values[n] = dBItem;
    }

    protected void setDBType(int n, DBType dBType) {
        if (this.first_row) {
            this.tmp_in_first_row_types[n] = dBType;
            return;
        }
        DBDataSet dBDataSet = this.binds_in;
        if (dBDataSet.types != null && n >= 0 && n < dBDataSet.types.length) {
            dBDataSet.types[n] = dBType;
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setCharacterStream(paramIndex=" + n + ", reader, length=" + n2 + ")");
        }
        this.set_execute_batch(1);
        if (reader != null) {
            int n3;
            int n4 = n - 1;
            InputStream inputStream = this.connection.conversion.ConvertStream(reader, 7, n2);
            int n5 = this.min_ascii_stream_size / this.connection.db_access.getC2SNlsRatio() / this.connection.conversion.getMaxCharbyteSize();
            int n6 = n3 = this.sql_string_changed ? this.parseSqlKind() : (int)this.sql_kind;
            if (n3 == 1 || n2 <= n5 || !this.isRegularResultSet()) {
                try {
                    int n7;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    byte[] byArray = new byte[1024];
                    while ((n7 = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n7);
                    }
                    this.setItem(n4, 1, byteArrayOutputStream.toByteArray());
                    ((OutputStream)byteArrayOutputStream).close();
                    return;
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                    return;
                }
            }
            this.setStreamItem(n4, 8, inputStream, n2 * this.connection.conversion.getMaxCharbyteSize());
            return;
        }
        this.setString(n, null);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    public void setCheckBindTypes(boolean bl) {
        this.check_bind_types = bl;
    }

    protected final void setOracleBatchStyle() throws SQLException {
        if (this.m_batchStyle == 2) {
            DBError.throwSqlException(90, "operation cannot be mixed with JDBC-2.0-style batching");
        } else if (this.m_batchStyle == 0 && OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 32, "First detected Oracle-style batching");
        }
        this.m_batchStyle = 1;
    }

    protected final void setJdbcBatchStyle() throws SQLException {
        if (this.m_batchStyle == 1) {
            DBError.throwSqlException(90, "operation cannot be mixed with Oracle-style batching");
        }
        this.m_batchStyle = 2;
    }

    protected final void checkIfJdbcBatchExists() throws SQLException {
        if (this.m_currentRank > 0 && this.m_batchStyle == 2 && true) {
            DBError.throwSqlException(81, "batch must be either executed or cleared");
        }
    }

    private boolean doesJdbcBatchExist() {
        return this.m_currentRank > 0 && this.m_batchStyle == 2;
    }

    private boolean isJdbcBatchStyle() {
        return this.m_batchStyle == 2;
    }

    public synchronized void addBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.addBatch()");
            OracleLog.print(this.connection, 1, 16, 32, "Add batch: m_currentRank=" + this.m_currentRank);
        }
        if (this.m_batchStyle == 0) {
            if (OracleLog.TRACE) {
                OracleLog.print(this.connection, 1, 16, 32, "First detected Jdbc-style batching");
            }
            if (!this.first_row) {
                this.binds_in.transformToDynamic();
            }
        }
        if (this.m_batchStyle == 1) {
            DBError.throwSqlException(90, "operation cannot be mixed with Oracle-style batching");
        }
        this.m_batchStyle = 2;
        this.get_data_for_columns(0);
        int n = 0;
        while (n < this.binds_in.data.length) {
            if (this.binds_in.getDBItem((int)n, (int)this.m_currentRank).stream_value != null) {
                DBError.throwSqlException(90, "streams type cannot be used in batching");
            }
            ++n;
        }
        ++this.m_currentRank;
        this.first_row = false;
    }

    public synchronized void addBatch(String string) throws SQLException {
        DBError.throwSqlException(23);
    }

    public synchronized void clearBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.clearBatch()");
            OracleLog.print(this.connection, 1, 16, 32, "Clear batch: m_currentRank=" + this.m_currentRank);
        }
        if (this.m_batchStyle == 1) {
            DBError.throwSqlException(90, "operation cannot be mixed with Oracle-style batching");
        }
        this.m_batchStyle = 2;
        this.cleanupForBatching();
    }

    public synchronized int[] executeBatch() throws SQLException {
        int n = 0;
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.executeBatch()");
            OracleLog.print(this.connection, 1, 16, 32, "Execute batch: m_currentRank=" + this.m_currentRank);
        }
        if (this.m_batchStyle == 1) {
            DBError.throwSqlException(90, "operation cannot be mixed with Oracle-style batching");
        }
        this.m_batchStyle = 2;
        if (this.m_currentRank == 0) {
            return new int[0];
        }
        int[] nArray = new int[this.m_currentRank];
        if (this.closed) {
            DBError.throwSqlException(9);
        }
        this.new_row_prefetch = this.default_row_prefetch;
        this.prepare_for_new_result();
        this.checkBindsInAndOut();
        if (this.sql_string_changed) {
            this.parseSqlKind();
        }
        if (this.sql_kind == 0) {
            DBError.throwBatchUpdateException(80, 0, null);
        }
        try {
            this.need_to_parse = true;
            this.doExecuteOther(true);
        }
        finally {
            Object var4_3 = null;
            this.cleanupForBatching();
        }
        if (this.valid_rows < 0) {
            n = 0;
            while (n < nArray.length) {
                nArray[n] = -3;
                ++n;
            }
            DBError.throwBatchUpdateException(81, 0, nArray);
        }
        n = 0;
        while (n < nArray.length) {
            nArray[n] = -2;
            ++n;
        }
        return nArray;
    }

    public DBDataSet getBinds() {
        return this.m_binds;
    }

    void scrollStmt_cleanup(boolean bl) throws SQLException {
        this.m_binds = null;
        super.scrollStmt_cleanup(bl);
    }

    private int doScrollPstmtExecuteUpdate() throws SQLException {
        this.scrollStmt_cleanup(false);
        this.parseSqlKind();
        if (this.sql_kind != 0) {
            this.new_row_prefetch = this.default_row_prefetch;
            this.prepare_for_new_result();
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            return this.valid_rows;
        }
        boolean bl = true;
        String string = null;
        if (!this.m_needToAddIdentifier) {
            this.new_row_prefetch = this.default_row_prefetch;
            this.prepare_for_new_result();
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            this.first_row = false;
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            this.m_realRsetType = this.m_userRsetType;
        } else {
            try {
                this.m_revisedSql = ResultSetUtil.addIdentifierToSql(this.m_originalSql);
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.new_row_prefetch = this.default_row_prefetch;
                this.prepare_for_new_result();
                this.sql_query = this.m_revisedSql;
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(1);
                }
                this.prepare_for_new_result();
                this.get_data_for_columns(this.batch);
                this.doExecuteWithTimeout();
                this.m_binds = this.binds_in;
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
            }
            catch (SQLException sQLException) {
                bl = false;
                string = sQLException.getMessage();
                this.m_binds = this.binds_in;
            }
            if (bl) {
                this.m_realRsetType = this.m_userRsetType;
            } else {
                this.m_realRsetType = this.m_userRsetType > 3 ? 3 : 1;
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.new_row_prefetch = this.default_row_prefetch;
                this.prepare_for_new_result();
                this.sql_query = this.m_originalSql;
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(-1);
                }
                this.prepare_for_new_result();
                this.doExecuteWithTimeout();
                this.m_binds = this.binds_in;
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                bl = true;
            }
        }
        if (this.current_result_set == null || !bl) {
            DBError.check_error(1, "Unable to create result set");
        } else {
            if (this.m_userRsetType != this.m_realRsetType) {
                this.m_warning = DBError.addSqlWarning(this.m_warning, 91, string);
            }
            this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
        }
        this.m_scrollRsetTypeSolved = true;
        return this.valid_rows;
    }
}

