/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import oracle.jdbc.driver.OracleConnection;

public class OracleLog {
    public static final int MASK_ALL_SET = 0xFFFFFFF;
    public static final int MAX_VECTOR_BITS = 32;
    public static final int MAX_MODULES = 32;
    public static final int MODULE_ALL = 0xFFFFFFF;
    public static final int MODULE_DRIVER = 1;
    public static final int MODULE_DBACCESS = 2;
    public static final int MODULE_DBCONV = 4;
    public static final int MODULE_JOLT = 8;
    public static final int MODULE_TOTAL = 4;
    public static final String[] ModuleName = new String[]{"DRVR ", "DBAC ", "DBCV ", "JOLT "};
    public static final int SUBMOD_ALL = 0xFFFFFFF;
    public static final int SUBMOD_DEFAULT = 1;
    public static final int SUBMOD_DRVR_LOG = 2;
    public static final int SUBMOD_DRVR_ERR = 4;
    public static final int SUBMOD_DRVR_CONN = 8;
    public static final int SUBMOD_DRVR_STMT = 16;
    public static final int SUBMOD_DRVR_RSET = 32;
    public static final int SUBMOD_DRVR_UTIL = 64;
    public static final int SUBMOD_DBAC_DATA = 2;
    public static final int CATEGORY_ALL = 0xFFFFFFF;
    public static final int USER_OPER = 1;
    public static final int PROG_ERROR = 2;
    public static final int ERROR = 4;
    public static final int WARNING = 8;
    public static final int FUNCTION = 16;
    public static final int DEBUG1 = 32;
    public static final int DEBUG2 = 64;
    public static final int CATEGORY_TOTAL = 7;
    public static final String[] CategoryName = new String[]{"OPER ", "PERR ", "ERRO ", "WARN ", "FUNC ", "DBG1 ", "DBG2 "};
    public static final int CATEGORY_LOW_VOL = 15;
    public static final int CATEGORY_MED_VOL = 63;
    public static final int CATEGORY_HIGH_VOL = 0xFFFFFFF;
    public static final int FIELD_NONE = 0;
    public static final int FIELD_ALL = 0xFFFFFFF;
    public static final int FIELD_TIME = 1;
    public static final int FIELD_MODULE = 2;
    public static final int FIELD_SUBMOD = 4;
    public static final int FIELD_CATEGORY = 8;
    public static final int FIELD_CONN = 16;
    public static final int FIELD_THREAD = 32;
    public static final int FIELD_DEFAULT = 10;
    public static boolean TRACE;
    private static boolean m_initialized;
    private static PrintWriter m_logWriter;
    private static PrintStream m_logStream;
    private static int m_printMask;
    private static int m_moduleMask;
    private static int[] m_submodMasks;
    private static int m_categoryMask;
    private static int m_maxPrintBytes;

    public static boolean isEnabled() {
        return TRACE;
    }

    public static void setLogWriter(PrintWriter printWriter) {
        boolean bl = OracleLog.initialize();
        if (printWriter == null) {
            TRACE = false;
            String string = OracleLog.info();
            OracleLog.print(null, 1, 2, 1, string);
            m_logWriter = printWriter;
            return;
        }
        TRACE = true;
        m_logWriter = printWriter;
        String string = OracleLog.info();
        OracleLog.print(null, 1, 2, 1, string);
        if (bl) {
            OracleLog.print(null, 1, 2, 32, "Properties were ignored in an applet environment");
        }
    }

    public static PrintWriter getLogWriter() {
        return m_logWriter;
    }

    public static void setLogStream(PrintStream printStream) {
        if (printStream == null) {
            OracleLog.setLogWriter(null);
        } else {
            OracleLog.setLogWriter(new PrintWriter(printStream));
        }
        m_logStream = printStream;
    }

    public static PrintStream getLogStream() {
        return m_logStream;
    }

    public static void config(int n, int n2, int n3) {
        m_printMask = n;
        m_moduleMask = n2;
        m_categoryMask = n3;
        String string = "Set logging masks (printMask " + OracleLog.getMaskHexStr(m_printMask) + ", moduleMask " + OracleLog.getMaskHexStr(m_moduleMask) + ", categoryMask " + OracleLog.getMaskHexStr(m_categoryMask) + ")";
        OracleLog.print(null, 1, 2, 1, string);
    }

    public static void setSubmodMask(int n, int n2) {
        int n3 = OracleLog.getBitNumFromVector(n);
        OracleLog.m_submodMasks[n3] = n2;
        String string = "Set logging sub-mask for module " + OracleLog.getMaskHexStr(m_moduleMask) + "(number " + n3 + ") to " + OracleLog.getMaskHexStr(n2);
        OracleLog.print(null, 1, 2, 1, string);
    }

    public static void setMaxPrintBytes(int n) {
        if (n > 0) {
            m_maxPrintBytes = n;
        }
        String string = "Set the maximum number of bytes to be printed to " + m_maxPrintBytes;
        OracleLog.print(null, 1, 2, 1, string);
    }

    private static void setTrace(boolean bl) {
        TRACE = bl;
    }

    private static boolean initialize() {
        boolean bl = false;
        if (m_initialized) {
            return bl;
        }
        m_initialized = true;
        if (ModuleName.length != 4) {
            System.out.println("ERROR: OracleLog.ModuleName[] has " + ModuleName.length + " items (expected " + 4 + ")");
        }
        if (CategoryName.length != 7) {
            System.out.println("ERROR: OracleLog.CategoryName[] has " + ModuleName.length + " items (expected " + 4 + ")");
        }
        try {
            String string = null;
            string = System.getProperty("JdbcTrace");
            if (string != null && string.compareTo("true") == 0) {
                OracleLog.setLogStream(System.out);
            }
            if ((string = System.getProperty("PrintMask")) != null) {
                m_printMask = Integer.parseInt(string);
            }
            if ((string = System.getProperty("ModuleMask")) != null) {
                m_moduleMask = Integer.parseInt(string);
            }
            if ((string = System.getProperty("CategoryMask")) != null) {
                m_categoryMask = Integer.parseInt(string);
            }
            int n = 0;
            while (n < 32) {
                string = System.getProperty("SubmodMask" + n);
                if (string != null) {
                    OracleLog.m_submodMasks[n] = Integer.parseInt(string);
                }
                ++n;
            }
            string = System.getProperty("MaxPrintBytes");
            if (string != null) {
                m_maxPrintBytes = Integer.parseInt(string);
            }
        }
        catch (SecurityException securityException) {
            bl = true;
        }
        return bl;
    }

    public static void print(OracleConnection oracleConnection, int n, int n2, int n3, String string) {
        if (m_logWriter == null) {
            return;
        }
        if ((n & m_moduleMask) != 0 && (n2 & m_submodMasks[OracleLog.getBitNumFromVector(n)]) != 0 && (n3 & m_categoryMask) != 0) {
            StringBuffer stringBuffer = new StringBuffer("");
            if ((m_printMask & 1) != 0) {
                stringBuffer.append(OracleLog.getCurrTimeStr());
            }
            if ((m_printMask & 2) != 0) {
                stringBuffer.append(OracleLog.getModuleName(n));
            }
            if ((m_printMask & 4) != 0) {
                stringBuffer.append(String.valueOf(OracleLog.getBitNumFromVector(n2)) + " ");
            }
            if ((m_printMask & 8) != 0) {
                stringBuffer.append(OracleLog.getCategoryName(n3));
            }
            if ((m_printMask & 0x20) != 0) {
                stringBuffer.append(String.valueOf(Thread.currentThread().getName()) + " ");
            }
            stringBuffer.append(string);
            m_logWriter.println(stringBuffer.toString());
            m_logWriter.flush();
        }
    }

    public static void print(OracleConnection oracleConnection, int n, int n2, String string) {
        OracleLog.print(oracleConnection, n, 1, n2, string);
    }

    public static void print(int n, int n2, int n3, String string) {
        OracleLog.print(null, n, n2, n3, string);
    }

    public static void print(int n, int n2, String string) {
        OracleLog.print(null, n, 1, n2, string);
    }

    public static String info() {
        String string = null;
        string = TRACE ? "Enabled logging (moduleMask " + OracleLog.getMaskHexStr(m_moduleMask) + ", categoryMask " + OracleLog.getMaskHexStr(m_categoryMask) + ")" : "Disabled logging";
        return string;
    }

    public static String getModuleName(int n) {
        String string = null;
        int n2 = 1;
        int n3 = 0;
        while (n3 < 4) {
            if ((n2 & n) != 0) {
                string = ModuleName[n3];
                break;
            }
            n2 <<= 1;
            ++n3;
        }
        return string;
    }

    public static String getCategoryName(int n) {
        String string = null;
        int n2 = 1;
        int n3 = 0;
        while (n3 < 7) {
            if ((n2 & n) != 0) {
                string = CategoryName[n3];
                break;
            }
            n2 <<= 1;
            ++n3;
        }
        return string;
    }

    private static String getCurrTimeStr() {
        Date date = new Date();
        return String.valueOf(date.toString()) + " ";
    }

    private static String getMaskHexStr(int n) {
        String string = Integer.toHexString(n);
        char[] cArray = new char[8 - string.length()];
        int n2 = 0;
        while (n2 < cArray.length) {
            cArray[n2] = 48;
            ++n2;
        }
        String string2 = new String(cArray);
        return new String("0x" + string2 + string);
    }

    public static int getBitNumFromVector(int n) {
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        while (n4 < 32) {
            if ((n & n3) != 0) {
                n2 = n4;
                break;
            }
            n3 <<= 1;
            ++n4;
        }
        return n2;
    }

    public static String bytesToPrintableForm(String string, byte[] byArray) {
        int n = byArray == null ? 0 : byArray.length;
        return OracleLog.bytesToPrintableForm(string, byArray, n);
    }

    public static String bytesToPrintableForm(String string, byte[] byArray, int n) {
        String string2 = null;
        string2 = byArray == null ? String.valueOf(string) + ": null" : String.valueOf(string) + " (" + byArray.length + " bytes):\n" + OracleLog.bytesToFormattedStr(byArray, n, "  ");
        return string2;
    }

    public static String bytesToFormattedStr(byte[] byArray, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null) {
            string = new String("");
        }
        stringBuffer.append(string);
        if (byArray == null) {
            stringBuffer.append("byte [] is null");
            return stringBuffer.toString();
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if (n2 >= m_maxPrintBytes) {
                stringBuffer.append("\n" + string + "... last " + (n - m_maxPrintBytes) + " bytes were not printed to limit the output size");
                break;
            }
            if (n2 > 0 && n2 % 20 == 0) {
                stringBuffer.append("\n" + string);
            }
            if (n2 % 20 == 10) {
                stringBuffer.append(" ");
            }
            if ((n3 = 0xFF & byArray[n2]) <= 15) {
                stringBuffer.append("0");
            }
            stringBuffer.append(String.valueOf(Integer.toHexString(n3)) + " ");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static byte[] strToUcs2Bytes(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        if (cArray == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(cArray, cArray.length);
    }

    public static byte[] charsToUcs2Bytes(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(cArray, cArray.length);
    }

    public static byte[] charsToUcs2Bytes(char[] cArray, int n) {
        if (cArray == null) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        byte[] byArray = new byte[2 * n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3++] = (byte)(cArray[n2] >> 8 & 0xFF);
            byArray[n3++] = (byte)(cArray[n2] & 0xFF);
            ++n2;
        }
        return byArray;
    }

    public static void test() {
        Object object = System.out;
        if (object == null) {
            OracleLog.setLogWriter(null);
        } else {
            OracleLog.setLogWriter(new PrintWriter((OutputStream)object));
        }
        m_logStream = object;
        m_printMask = 10;
        m_moduleMask = 0xFFFFFFF;
        m_categoryMask = 0xFFFFFFF;
        object = "Set logging masks (printMask " + OracleLog.getMaskHexStr(m_printMask) + ", moduleMask " + OracleLog.getMaskHexStr(m_moduleMask) + ", categoryMask " + OracleLog.getMaskHexStr(m_categoryMask) + ")";
        OracleLog.print(null, 1, 2, 1, (String)object);
        if (TRACE) {
            OracleLog.print(null, 1, 2, 1, "User message");
            OracleLog.print(null, 1, 2, 2, "Perror message");
            OracleLog.print(null, 1, 2, 4, "Error message");
            OracleLog.print(null, 1, 2, 8, "Warning message");
            OracleLog.print(null, 1, 2, 16, "Function message");
            OracleLog.print(null, 1, 2, 32, "Debug 1 message");
            OracleLog.print(null, 1, 2, 64, "Debug 2 message");
        }
        if (null == null) {
            OracleLog.setLogWriter(null);
        } else {
            OracleLog.setLogWriter(new PrintWriter(null));
        }
        m_logStream = null;
    }

    static {
        m_logWriter = null;
        m_logStream = null;
        m_printMask = 10;
        m_moduleMask = 0xFFFFFFF;
        m_submodMasks = null;
        m_categoryMask = 0xFFFFFFF;
        m_maxPrintBytes = 200;
        m_submodMasks = new int[32];
        int n = 0;
        while (n < 32) {
            OracleLog.m_submodMasks[n] = 0xFFFFFFF;
            ++n;
        }
    }
}

