/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.sql.SQLName;

public class OracleDatabaseMetaData
implements DatabaseMetaData {
    static String DRIVER_NAME = "Oracle JDBC driver";
    static String DRIVER_VERSION = "8.1.6.0.0";
    static int DRIVER_MAJOR_VERSION = 8;
    static int DRIVER_MINOR_VERSION = 1;
    OracleConnection connection;
    int procedureResultUnknown;
    int procedureNoResult = 1;
    int procedureReturnsResult = 2;
    int procedureColumnUnknown;
    int procedureColumnIn = 1;
    int procedureColumnInOut = 2;
    int procedureColumnOut = 4;
    int procedureColumnReturn = 5;
    int procedureColumnResult = 3;
    int procedureNoNulls;
    int procedureNullable = 1;
    int procedureNullableUnknown = 2;
    int columnNoNulls;
    int columnNullable = 1;
    int columnNullableUnknown = 2;
    static final int bestRowTemporary = 0;
    static final int bestRowTransaction = 1;
    static final int bestRowSession = 2;
    static final int bestRowUnknown = 0;
    static final int bestRowNotPseudo = 1;
    static final int bestRowPseudo = 2;
    int versionColumnUnknown;
    int versionColumnNotPseudo = 1;
    int versionColumnPseudo = 2;
    int importedKeyCascade;
    int importedKeyRestrict = 1;
    int importedKeySetNull = 2;
    int typeNoNulls;
    int typeNullable = 1;
    int typeNullableUnknown = 2;
    int typePredNone;
    int typePredChar = 1;
    int typePredBasic = 2;
    int typeSearchable = 3;
    short tableIndexStatistic;
    short tableIndexClustered = 1;
    short tableIndexHashed = (short)2;
    short tableIndexOther = (short)3;

    public OracleDatabaseMetaData(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        this.connection.trace("allProceduresAreCallable");
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        this.connection.trace("allTablesAreSelectable");
        return false;
    }

    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    public String getUserName() throws SQLException {
        this.connection.trace("getUserName");
        return this.connection.getUserName();
    }

    public boolean isReadOnly() throws SQLException {
        this.connection.trace("isReadOnly");
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        this.connection.trace("nullsAreSortedHigh");
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        this.connection.trace("nullsAreSortedLow");
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        this.connection.trace("nullsAreSortedAtStart");
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        this.connection.trace("nullsAreSortedAtEnd");
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "Oracle";
    }

    public String getDatabaseProductVersion() throws SQLException {
        this.connection.trace("getDatabaseProductVersion");
        try {
            this.connection.needLine();
            byte[] byArray = this.connection.db_access.getVersion();
            return this.connection.conversion.CharBytesToString(byArray, byArray.length);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getDriverName() throws SQLException {
        this.connection.trace("getDriverName");
        return DRIVER_NAME;
    }

    public String getDriverVersion() throws SQLException {
        this.connection.trace("getDriverVersion");
        return DRIVER_VERSION;
    }

    public int getDriverMajorVersion() {
        this.connection.trace("getDriverMajorVersion");
        return DRIVER_MAJOR_VERSION;
    }

    public int getDriverMinorVersion() {
        this.connection.trace("getDriverMinorVersion");
        return DRIVER_MINOR_VERSION;
    }

    public boolean usesLocalFiles() throws SQLException {
        this.connection.trace("usesLocalFiles");
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        this.connection.trace("usesLocalFilePerTable");
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.connection.trace("supportsMixedCaseIdentifiers");
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.connection.trace("storesUpperCaseIdentifiers");
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.connection.trace("storesLowerCaseIdentifiers");
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.connection.trace("storesMixedCaseIdentifiers");
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.connection.trace("supportsMixedCaseQuotedIdentifiers");
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.connection.trace("storesUpperCaseQuotedIdentifiers");
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.connection.trace("storesLowerCaseQuotedIdentifiers");
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.connection.trace("storesMixedCaseQuotedIdentifiers");
        return true;
    }

    public String getIdentifierQuoteString() throws SQLException {
        this.connection.trace("getIdentifierQuoteString");
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        this.connection.trace("getSQLKeywords");
        return "ACCESS, ADD, ALTER, AUDIT, CLUSTER, COLUMN, COMMENT, COMPRESS, CONNECT, DATE, DROP, EXCLUSIVE, FILE, IDENTIFIED, IMMEDIATE, INCREMENT, INDEX, INITIAL, INTERSECT, LEVEL, LOCK, LONG, MAXEXTENTS, MINUS, MODE, NOAUDIT, NOCOMPRESS, NOWAIT, NUMBER, OFFLINE, ONLINE, PCTFREE, PRIOR, all_PL_SQL_reserved_ words";
    }

    public String getNumericFunctions() throws SQLException {
        this.connection.trace("getNumericFunctions");
        return "ABS, CEIL, COS, COSH, EXP, FLOOR, LN, LOG, MOD, POWER, ROUND, SIGN, SIN, SINH, SQRT, TAN, TANH, TRUNC, AVG, COUNT, GLB, LUB, MAX, MIN, STDDEV, SUM, VARIANCE";
    }

    public String getStringFunctions() throws SQLException {
        this.connection.trace("getStringFunctions");
        return "CHR, INITCAP, LOWER, LPAD, LTRIM, NLS,_INITCAP, NLS,_LOWER, NLS,_UPPER, REPLACE, RPAD, RTRIM, SOUNDEX, SUBSTR, SUBSTRB, TRANSLATE, UPPER, ASCII, INSTR, INSTRB, LENGTH, LENGTHB, NLSSORT, CHARTOROWID, CONVERT, HEXTORAW, RAWTOHEX, ROWIDTOCHAR, TO_CHAR, TO_DATE, TO_LABEL, TO_MULTI_BYTE, TO_NUMBER, TO_SINGLE_BYTE";
    }

    public String getSystemFunctions() throws SQLException {
        this.connection.trace("getSystemFunctions");
        return "DUMP, GREATEST, GREATEST_LB, LEAST, LEAST_UB, NVL, UID, USER, USERENV, VSIZE";
    }

    public String getTimeDateFunctions() throws SQLException {
        this.connection.trace("getTimeDateFunctions");
        return "ADD_MONTHS, LAST_DAY, MONTHS_BETWEEN, NEW_TIME, NEXT_DAY, ROUND, SYSDATE, TRUNC";
    }

    public String getSearchStringEscape() throws SQLException {
        this.connection.trace("getSearchStringEscape");
        return "//";
    }

    public String getExtraNameCharacters() throws SQLException {
        this.connection.trace("getExtraNameCharacters");
        return "$#";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.connection.trace("supportsAlterTableWithAddColumn");
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.connection.trace("supportsAlterTableWithDropColumn");
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        this.connection.trace("supportsColumnAliasing");
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        this.connection.trace("nullPlusNonNullIsNull");
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        this.connection.trace("supportsConvert");
        return true;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        this.connection.trace("supportsConvert");
        if (n == n2 || n == 1 || n == 12 || n == -1 || n2 == 1 || n2 == 12 || n2 == -1) {
            return true;
        }
        switch (n) {
            case 2: 
            case 3: {
                return n2 == 92 || n2 == 93 || n2 == 91;
            }
            case 91: 
            case 92: 
            case 93: {
                return n2 == 2 || n2 == 3;
            }
        }
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        this.connection.trace("supportsTableCorrelationNames");
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        this.connection.trace("supportsDifferentTableCorrelationNames");
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        this.connection.trace("supportsExpressionsInOrderBy");
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        this.connection.trace("supportsOrderByUnrelated");
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        this.connection.trace("supportsGroupBy");
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        this.connection.trace("supportsGroupByUnrelated");
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        this.connection.trace("supportsGroupByBeyondSelect");
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        this.connection.trace("supportsLikeEscapeClause");
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        this.connection.trace("supportsMultipleResultSets");
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        this.connection.trace("supportsMultipleTransactions");
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        this.connection.trace("supportsNonNullableColumns");
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        this.connection.trace("supportsMinimumSQLGrammar");
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        this.connection.trace("supportsCoreSQLGrammar");
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        this.connection.trace("supportsExtendedSQLGrammar");
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        this.connection.trace("supportsANSI92EntryLevelSQL");
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        this.connection.trace("supportsANSI92IntermediateSQL");
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        this.connection.trace("supportsANSI92FullSQL");
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        this.connection.trace("supportsIntegrityEnhancementFacility");
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        this.connection.trace("supportsOuterJoins");
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        this.connection.trace("supportsFullOuterJoins");
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        this.connection.trace("supportsLimitedOuterJoins");
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        this.connection.trace("getSchemaTerm");
        return "schema";
    }

    public String getProcedureTerm() throws SQLException {
        this.connection.trace("getProcedureTerm");
        return "procedure";
    }

    public String getCatalogTerm() throws SQLException {
        this.connection.trace("getCatalogTerm");
        return "";
    }

    public boolean isCatalogAtStart() throws SQLException {
        this.connection.trace("isCatalogAtStart");
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        this.connection.trace("getCatalogSeparator");
        return "";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        this.connection.trace("supportsSchemasInDataManipulation");
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        this.connection.trace("supportsSchemasInProcedureCalls");
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        this.connection.trace("supportsSchemasInTableDefinitions");
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        this.connection.trace("supportsSchemasInIndexDefinitions");
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        this.connection.trace("supportsSchemasInPrivilegeDefinitions");
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        this.connection.trace("supportsCatalogsInDataManipulation");
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        this.connection.trace("supportsCatalogsInProcedureCalls");
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        this.connection.trace("supportsCatalogsInTableDefinitions");
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        this.connection.trace("supportsCatalogsInIndexDefinitions");
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        this.connection.trace("supportsCatalogsInPrivilegeDefinitions");
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        this.connection.trace("supportsPositionedDelete");
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        this.connection.trace("supportsPositionedUpdate");
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        this.connection.trace("supportsSelectForUpdate");
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        this.connection.trace("supportsStoredProcedures");
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        this.connection.trace("supportsSubqueriesInComparisons");
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        this.connection.trace("supportsSubqueriesInExists");
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        this.connection.trace("supportsSubqueriesInIns");
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        this.connection.trace("supportsSubqueriesInQuantifieds");
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        this.connection.trace("supportsCorrelatedSubqueries");
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        this.connection.trace("supportsUnion");
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        this.connection.trace("supportsUnionAll");
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        this.connection.trace("supportsOpenCursorsAcrossCommit");
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        this.connection.trace("supportsOpenCursorsAcrossRollback");
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        this.connection.trace("supportsOpenStatementsAcrossCommit");
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        this.connection.trace("supportsOpenStatementsAcrossRollback");
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        this.connection.trace("getMaxBinaryLiteralLength");
        return 1000;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        this.connection.trace("getMaxCharLiteralLength");
        return 2000;
    }

    public int getMaxColumnNameLength() throws SQLException {
        this.connection.trace("getMaxColumnNameLength");
        return 30;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        this.connection.trace("getMaxColumnsInGroupBy");
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        this.connection.trace("getMaxColumnsInIndex");
        return 32;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        this.connection.trace("getMaxColumnsInOrderBy");
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        this.connection.trace("getMaxColumnsInSelect");
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        this.connection.trace("getMaxColumnsInTable");
        return 1000;
    }

    public int getMaxConnections() throws SQLException {
        this.connection.trace("getMaxConnections");
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        this.connection.trace("getMaxCursorNameLength");
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        this.connection.trace("getMaxIndexLength");
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        this.connection.trace("getMaxSchemaNameLength");
        return 30;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        this.connection.trace("getMaxProcedureNameLength");
        return 30;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        this.connection.trace("getMaxCatalogNameLength");
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        this.connection.trace("getMaxRowSize");
        return 2000;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.connection.trace("doesMaxRowSizeIncludeBlobs");
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        this.connection.trace("getMaxStatementLength");
        return 65535;
    }

    public int getMaxStatements() throws SQLException {
        this.connection.trace("getMaxStatements");
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        this.connection.trace("getMaxTableNameLength");
        return 30;
    }

    public int getMaxTablesInSelect() throws SQLException {
        this.connection.trace("getMaxTablesInSelect");
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        this.connection.trace("getMaxUserNameLength");
        return 30;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        this.connection.trace("getDefaultTransactionIsolation");
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        this.connection.trace("supportsTransactions");
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        this.connection.trace("supportsTransactionIsolationLevel");
        return n == 2 || n == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        this.connection.trace("supportsDataDefinitionAndDataManipulationTransactions");
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        this.connection.trace("supportsDataManipulationTransactionsOnly");
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.connection.trace("dataDefinitionCausesTransactionCommit");
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.connection.trace("dataDefinitionIgnoredInTransactions");
        return false;
    }

    public synchronized ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string4 = null;
        String string5 = string2;
        if (string2 == null) {
            string5 = "%";
        } else if (string2.equals("")) {
            string5 = this.getUserName().toUpperCase();
        }
        String string6 = string3;
        if (string3 == null) {
            string6 = "%";
        } else if (string3.equals("")) {
            DBError.throwSqlException(74);
        }
        if (string == null) {
            string4 = "SELECT\n  -- Standalone procedures and functions\n  NULL AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Standalone procedure or function' AS remarks,\n  DECODE(object_type, 'PROCEDURE', 1,\n                      'FUNCTION', 2,\n                      0) AS procedure_type\nFROM all_objects\nWHERE (object_type = 'PROCEDURE' OR object_type = 'FUNCTION')\n  AND owner LIKE ? ESCAPE '/'\n  AND object_name LIKE ? ESCAPE '/'\nUNION ALL SELECT\n  -- Packaged procedures with no arguments\n  package_name AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Packaged procedure' AS remarks,\n  1 AS procedure_type\nFROM all_arguments\nWHERE argument_name IS NULL\n  AND data_type IS NULL\n  AND package_name IS NOT NULL\n  AND owner LIKE ? ESCAPE '/'\n  AND object_name LIKE ? ESCAPE '/'\nUNION ALL SELECT\n  -- Packaged procedures with arguments\n  package_name AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Packaged procedure' AS remarks,\n  1 AS procedure_type\nFROM all_arguments\nWHERE argument_name IS NOT NULL\n  AND position = 1\n  AND position = sequence\n  AND package_name IS NOT NULL\n  AND owner LIKE ? ESCAPE '/'\n  AND object_name LIKE ? ESCAPE '/'\nUNION ALL SELECT\n  -- Packaged functions\n  package_name AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Packaged function' AS remarks,\n  2 AS procedure_type\nFROM all_arguments\nWHERE argument_name IS NULL\n  AND in_out = 'OUT'\n  AND package_name IS NOT NULL\n  AND owner LIKE ? ESCAPE '/'\n  AND object_name LIKE ? ESCAPE '/'\nORDER BY procedure_schem, procedure_name\n";
            this.connection.trace("getProcedures Final SQL statement:\n" + string4);
            preparedStatement = this.connection.prepareStatement(string4);
            preparedStatement.setString(1, string5);
            preparedStatement.setString(2, string6);
            preparedStatement.setString(3, string5);
            preparedStatement.setString(4, string6);
            preparedStatement.setString(5, string5);
            preparedStatement.setString(6, string6);
            preparedStatement.setString(7, string5);
            preparedStatement.setString(8, string6);
        } else if (string.equals("")) {
            string4 = "SELECT\n  -- Standalone procedures and functions\n  NULL AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Standalone procedure or function' AS remarks,\n  DECODE(object_type, 'PROCEDURE', 1,\n                      'FUNCTION', 2,\n                      0) AS procedure_type\nFROM all_objects\nWHERE (object_type = 'PROCEDURE' OR object_type = 'FUNCTION')\n  AND owner LIKE ? ESCAPE '/'\n  AND object_name LIKE ? ESCAPE '/'\n";
            this.connection.trace("getProcedures Final SQL statement:\n" + string4);
            preparedStatement = this.connection.prepareStatement(string4);
            preparedStatement.setString(1, string5);
            preparedStatement.setString(2, string6);
        } else {
            string4 = "SELECT\n  -- Packaged procedures with no arguments\n  package_name AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Packaged procedure' AS remarks,\n  1 AS procedure_type\nFROM all_arguments\nWHERE argument_name IS NULL\n  AND data_type IS NULL\n  AND package_name LIKE ? ESCAPE '/'\n  AND owner LIKE ? ESCAPE '/'\n  AND object_name LIKE ? ESCAPE '/'\nUNION ALL SELECT\n  -- Packaged procedures with arguments\n  package_name AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Packaged procedure' AS remarks,\n  1 AS procedure_type\nFROM all_arguments\nWHERE argument_name IS NOT NULL\n  AND position = 1\n  AND position = sequence\n  AND package_name LIKE ? ESCAPE '/'\n  AND owner LIKE ? ESCAPE '/'\n  AND object_name LIKE ? ESCAPE '/'\nUNION ALL SELECT\n  -- Packaged functions\n  package_name AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Packaged function' AS remarks,\n  2 AS procedure_type\nFROM all_arguments\nWHERE argument_name IS NULL\n  AND in_out = 'OUT'\n  AND package_name LIKE ? ESCAPE '/'\n  AND owner LIKE ? ESCAPE '/'\n  AND object_name LIKE ? ESCAPE '/'\nORDER BY procedure_schem, procedure_name\n";
            this.connection.trace("getProcedures Final SQL statement:\n" + string4);
            preparedStatement = this.connection.prepareStatement(string4);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string5);
            preparedStatement.setString(3, string6);
            preparedStatement.setString(4, string);
            preparedStatement.setString(5, string5);
            preparedStatement.setString(6, string6);
            preparedStatement.setString(7, string);
            preparedStatement.setString(8, string5);
            preparedStatement.setString(9, string6);
        }
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)preparedStatement.executeQuery();
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    public synchronized ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = null;
        PreparedStatement preparedStatement = null;
        String string6 = null;
        String string7 = string2;
        if (string2 == null) {
            string7 = "%";
        } else if (string2.equals("")) {
            string7 = this.getUserName().toUpperCase();
        }
        String string8 = string3;
        if (string3 == null) {
            string8 = "%";
        } else if (string3.equals("")) {
            DBError.throwSqlException(74);
        }
        String string9 = string4;
        if (string4 == null || string4.equals("%")) {
            string9 = "%";
            string6 = "  AND (argument_name LIKE ? ESCAPE '/'\n       OR (argument_name IS NULL\n           AND data_type IS NOT NULL))\n";
        } else if (string4.equals("")) {
            DBError.throwSqlException(74);
        } else {
            string6 = "  AND argument_name LIKE ? ESCAPE '/'\n";
        }
        if (string == null) {
            string5 = "SELECT package_name AS procedure_cat,\n       owner AS procedure_schem,\n       object_name AS procedure_name,\n       argument_name AS column_name,\n       DECODE(position, 0, 5,\n                        DECODE(in_out, 'IN', 1,\n                                       'OUT', 4,\n                                       'IN/OUT', 2,\n                                       0)) AS column_type,\n       DECODE (data_type, 'CHAR', 1,\n                          'VARCHAR2', 12,\n                          'NUMBER', 3,\n                          'LONG', -1,\n                          'DATE', 93,\n                          'RAW', -3,\n                          'LONG RAW', -4,\n                          1111) AS data_type,\n       data_type AS type_name,\n       DECODE (data_precision, NULL, data_length,\n                               data_precision) AS precision,\n       data_length AS length,\n       data_scale AS scale,\n       10 AS radix,\n       1 AS nullable,\n       NULL AS remarks,\n       sequence,\n       overload,\n       default_value\n FROM all_arguments\nWHERE owner LIKE ? ESCAPE '/'\n  AND object_name LIKE ? ESCAPE '/'\n" + string6 + "ORDER BY procedure_schem, procedure_name, overload, sequence\n";
            this.connection.trace("getProcedureColumns Final SQL statement:\n" + string5);
            preparedStatement = this.connection.prepareStatement(string5);
            preparedStatement.setString(1, string7);
            preparedStatement.setString(2, string8);
            preparedStatement.setString(3, string9);
        } else if (string.equals("")) {
            string5 = "SELECT package_name AS procedure_cat,\n       owner AS procedure_schem,\n       object_name AS procedure_name,\n       argument_name AS column_name,\n       DECODE(position, 0, 5,\n                        DECODE(in_out, 'IN', 1,\n                                       'OUT', 4,\n                                       'IN/OUT', 2,\n                                       0)) AS column_type,\n       DECODE (data_type, 'CHAR', 1,\n                          'VARCHAR2', 12,\n                          'NUMBER', 3,\n                          'LONG', -1,\n                          'DATE', 93,\n                          'RAW', -3,\n                          'LONG RAW', -4,\n                          1111) AS data_type,\n       data_type AS type_name,\n       DECODE (data_precision, NULL, data_length,\n                               data_precision) AS precision,\n       data_length AS length,\n       data_scale AS scale,\n       10 AS radix,\n       1 AS nullable,\n       NULL AS remarks,\n       sequence,\n       overload,\n       default_value\n FROM all_arguments\nWHERE owner LIKE ? ESCAPE '/'\n  AND object_name LIKE ? ESCAPE '/'\n  AND package_name IS NULL\n" + string6 + "ORDER BY procedure_schem, procedure_name, overload, sequence\n";
            this.connection.trace("getProcedureColumns Final SQL statement:\n" + string5);
            preparedStatement = this.connection.prepareStatement(string5);
            preparedStatement.setString(1, string7);
            preparedStatement.setString(2, string8);
            preparedStatement.setString(3, string9);
        } else {
            string5 = "SELECT package_name AS procedure_cat,\n       owner AS procedure_schem,\n       object_name AS procedure_name,\n       argument_name AS column_name,\n       DECODE(position, 0, 5,\n                        DECODE(in_out, 'IN', 1,\n                                       'OUT', 4,\n                                       'IN/OUT', 2,\n                                       0)) AS column_type,\n       DECODE (data_type, 'CHAR', 1,\n                          'VARCHAR2', 12,\n                          'NUMBER', 3,\n                          'LONG', -1,\n                          'DATE', 93,\n                          'RAW', -3,\n                          'LONG RAW', -4,\n                          1111) AS data_type,\n       data_type AS type_name,\n       DECODE (data_precision, NULL, data_length,\n                               data_precision) AS precision,\n       data_length AS length,\n       data_scale AS scale,\n       10 AS radix,\n       1 AS nullable,\n       NULL AS remarks,\n       sequence,\n       overload,\n       default_value\n FROM all_arguments\nWHERE owner LIKE ? ESCAPE '/'\n  AND object_name LIKE ? ESCAPE '/'\n  AND package_name LIKE ? ESCAPE '/'\n" + string6 + "ORDER BY procedure_schem, procedure_name, overload, sequence\n";
            this.connection.trace("getProcedureColumns Final SQL statement:\n" + string5);
            preparedStatement = this.connection.prepareStatement(string5);
            preparedStatement.setString(1, string7);
            preparedStatement.setString(2, string8);
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, string9);
        }
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)preparedStatement.executeQuery();
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    public synchronized ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String string4 = "";
        if (stringArray != null) {
            string4 = "  AND c.table_type IN (";
            int n = 0;
            while (n < stringArray.length - 1) {
                string4 = String.valueOf(string4) + "'" + stringArray[n] + "', ";
                ++n;
            }
            string4 = String.valueOf(string4) + "'" + stringArray[n] + "')\n";
        }
        String string5 = this.connection.report_remarks ? "SELECT NULL AS table_cat,\n       c.owner AS table_schem,\n       c.table_name AS table_name,\n       c.table_type AS table_type,\n       k.comments AS table_remarks\nFROM all_catalog c, all_tab_comments k\nWHERE c.owner LIKE ? escape '/'\n  AND c.table_name LIKE ? escape '/'\n" + string4 + "  AND c.owner = k.owner\n" + "  AND c.table_name = k.table_name (+)\n" + "ORDER BY table_type, table_schem, table_name\n" : "SELECT NULL AS table_cat,\n       c.owner AS table_schem,\n       c.table_name AS table_name,\n       c.table_type AS table_type,\n       null AS table_remarks\nFROM all_catalog c\nWHERE c.owner LIKE ? escape '/'\n  AND c.table_name LIKE ? escape '/'\n" + string4 + "ORDER BY table_type, table_schem, table_name\n";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string5);
        preparedStatement.setString(1, string2 == null ? "%" : string2);
        preparedStatement.setString(2, string3 == null ? "%" : string3);
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)preparedStatement.executeQuery();
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    public ResultSet getSchemas() throws SQLException {
        Statement statement = this.connection.createStatement();
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)statement.executeQuery("SELECT username AS table_schem FROM all_users ORDER BY table_schem");
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    public ResultSet getCatalogs() throws SQLException {
        this.connection.trace("getCatalogs");
        Statement statement = this.connection.createStatement();
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)statement.executeQuery("select 'nothing' as table_cat from dual where 1 = 2");
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    public ResultSet getTableTypes() throws SQLException {
        Statement statement = this.connection.createStatement();
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)statement.executeQuery("select 'TABLE' as table_type from dual\nunion select 'VIEW' as table_type from dual\nunion select 'SYNONYM' as table_type from dual\n");
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    public synchronized ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "SELECT NULL AS table_cat,\n";
        string5 = this.connection.include_synonyms ? String.valueOf(string5) + "       DECODE(s.table_owner, NULL, t.owner, s.table_owner)\n              AS table_schem,\n       DECODE(s.synonym_name, NULL, t.table_name, s.synonym_name)\n              AS table_name,\n" : String.valueOf(string5) + "       t.owner AS table_schem,\n       t.table_name AS table_name,\n";
        string5 = String.valueOf(string5) + "       t.column_name AS column_name,\n       DECODE (t.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3,\n               'LONG', -1, 'DATE', 93, 'RAW', -3, 'LONG RAW', -4, 1111)\n              AS data_type,\n       t.data_type AS type_name,\n       DECODE (t.data_precision, null, t.data_length, t.data_precision)\n              AS column_size,\n       0 AS buffer_length,\n       t.data_scale AS decimal_digits,\n       10 AS num_prec_radix,\n       DECODE (t.nullable, 'N', 0, 1) AS nullable,\n";
        string5 = this.connection.report_remarks ? String.valueOf(string5) + "       c.comments AS remarks,\n" : String.valueOf(string5) + "       NULL AS remarks,\n";
        string5 = String.valueOf(string5) + "       t.data_default AS column_def,\n       0 AS sql_data_type,\n       0 AS sql_datetime_sub,\n       t.data_length AS char_octet_length,\n       t.column_id AS ordinal_position,\n       DECODE (t.nullable, 'N', 'NO', 'YES') AS is_nullable\nFROM all_tab_columns t";
        if (this.connection.report_remarks) {
            string5 = String.valueOf(string5) + ", all_col_comments c";
        }
        if (this.connection.include_synonyms) {
            string5 = String.valueOf(string5) + ", all_synonyms s";
        }
        string5 = this.connection.include_synonyms ? String.valueOf(string5) + "\nWHERE t.owner LIKE ? ESCAPE '/'\n  AND (t.table_name LIKE ? ESCAPE '/' OR\n       s.synonym_name LIKE ? ESCAPE '/')\n  AND t.column_name LIKE ? ESCAPE '/'\n" : String.valueOf(string5) + "\nWHERE t.owner LIKE ? ESCAPE '/'\n  AND t.table_name LIKE ? ESCAPE '/'\n  AND t.column_name LIKE ? ESCAPE '/'\n";
        if (this.connection.report_remarks) {
            string5 = String.valueOf(string5) + "  AND t.owner = c.owner (+)\n  AND t.table_name = c.table_name (+)\n  AND t.column_name = c.column_name (+)\n";
        }
        if (this.connection.include_synonyms) {
            string5 = String.valueOf(string5) + "  AND s.table_name (+) = t.table_name\n  AND DECODE(s.owner, t.owner, 'OK',\n                      'PUBLIC', 'OK',\n                      NULL, 'OK',\n                      'NOT OK') = 'OK'";
        }
        string5 = String.valueOf(string5) + "ORDER BY table_schem, table_name, ordinal_position\n";
        this.connection.trace("getColumns final SQL statement is:\n" + string5);
        PreparedStatement preparedStatement = this.connection.prepareStatement(string5);
        if (this.connection.include_synonyms) {
            preparedStatement.setString(1, string2 == null ? "%" : string2);
            preparedStatement.setString(2, string3 == null ? "%" : string3);
            preparedStatement.setString(3, string3 == null ? "%" : string3);
            preparedStatement.setString(4, string4 == null ? "%" : string4);
        } else {
            preparedStatement.setString(1, string2 == null ? "%" : string2);
            preparedStatement.setString(2, string3 == null ? "%" : string3);
            preparedStatement.setString(3, string4 == null ? "%" : string4);
        }
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)preparedStatement.executeQuery();
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    public synchronized ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       table_schema AS table_schem,\n       table_name,\n       column_name,\n       grantor,\n       grantee,\n       privilege,\n       grantable AS is_grantable\nFROM all_col_privs\nWHERE table_schema LIKE ? ESCAPE '/'\n  AND table_name LIKE ? ESCAPE '/'\n  AND column_name LIKE ? ESCAPE '/'\nORDER BY column_name, privilege\n");
        preparedStatement.setString(1, string2 == null ? "%" : string2);
        preparedStatement.setString(2, string3 == null ? "%" : string3);
        preparedStatement.setString(3, string4 == null ? "%" : string4);
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)preparedStatement.executeQuery();
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    public synchronized ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       table_schema AS table_schem,\n       table_name,\n       null as column_name,\n       grantor,\n       grantee,\n       privilege,\n       grantable AS is_grantable\nFROM all_tab_privs\nWHERE table_schema LIKE ? ESCAPE '/'\n  AND table_name LIKE ? ESCAPE '/'\nORDER BY table_schem, table_name, privilege\n");
        preparedStatement.setString(1, string2 == null ? "%" : string2);
        preparedStatement.setString(2, string3 == null ? "%" : string3);
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)preparedStatement.executeQuery();
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    public synchronized ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        this.connection.trace("getBestRowIdentifier");
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT 1 AS scope, 'ROWID' AS column_name, -8 AS data_type,\n       'ROWID' AS type_name, 0 AS column_size, 0 AS buffer_length,\n       0 AS decimal_digits, 2 AS pseudo_column\nFROM DUAL\nWHERE ? = 1\nUNION\nSELECT 2 AS scope,\n       t.column_name,\n       DECODE (t.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3,\n               'LONG', -1, 'DATE', 93, 'RAW', -3, 'LONG RAW', -4, 1111)\n              AS data_type,\n       t.data_type AS type_name,\n       DECODE (t.data_precision, null, t.data_length, t.data_precision)\n              AS column_size,\n       0 AS buffer_length,\n       t.data_scale AS decimal_digits,\n       1 AS pseudo_column\nFROM all_tab_columns t, all_ind_columns i\nWHERE ? = 1\n  AND t.table_name = ?\n  AND t.owner like ? escape '/'\n  AND t.nullable != ?\n  AND t.owner = i.table_owner\n  AND t.table_name = i.table_name\n  AND t.column_name = i.column_name\n");
        switch (n) {
            case 0: {
                preparedStatement.setInt(1, 0);
                preparedStatement.setInt(2, 0);
                break;
            }
            case 1: {
                preparedStatement.setInt(1, 1);
                preparedStatement.setInt(2, 1);
                break;
            }
            case 2: {
                preparedStatement.setInt(1, 0);
                preparedStatement.setInt(2, 1);
            }
        }
        preparedStatement.setString(3, string3);
        preparedStatement.setString(4, string2 == null ? "%" : string2);
        preparedStatement.setString(5, bl ? "X" : "Y");
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)preparedStatement.executeQuery();
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    public synchronized ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT 0 AS scope,\n       t.column_name,\n       DECODE (c.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3,\n               'LONG', -1, 'DATE', 93, 'RAW', -3, 'LONG RAW', -4, 1111)\n              AS data_type,\n       c.data_type AS type_name,\n       DECODE (c.data_precision, null, c.data_length, c.data_precision)\n              AS column_size,\n       0 as buffer_length,\n       c.data_scale as decimal_digits,\n       0 as pseudo_column\nFROM all_trigger_cols t, all_tab_columns c\nWHERE t.table_name = ?\n  AND c.owner like ? escape '/'\n  AND t.table_owner = c.owner\n  AND t.table_name = c.table_name\n  AND t.column_name = c.column_name\n");
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2 == null ? "%" : string2);
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)preparedStatement.executeQuery();
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       c.owner AS table_schem,\n       c.table_name,\n       c.column_name,\n       c.position AS key_seq,\n       c.constraint_name AS pk_name\nFROM all_cons_columns c, all_constraints k\nWHERE k.constraint_type = 'P'\n  AND k.table_name = ?\n  AND k.owner like ? escape '/'\n  AND k.constraint_name = c.constraint_name \n  AND k.table_name = c.table_name \n  AND k.owner = c.owner \nORDER BY column_name\n");
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2 == null ? "%" : string2);
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)preparedStatement.executeQuery();
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    ResultSet keys_query(String string, String string2, String string3, String string4, String string5) throws SQLException {
        int n = 1;
        int n2 = string2 != null ? n++ : 0;
        int n3 = string4 != null ? n++ : 0;
        int n4 = string != null && string.length() > 0 ? n++ : 0;
        int n5 = string3 != null && string3.length() > 0 ? n++ : 0;
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT NULL AS pktable_cat,\n       p.owner as pktable_schem,\n       p.table_name as pktable_name,\n       pc.column_name as pkcolumn_name,\n       NULL as fktable_cat,\n       f.owner as fktable_schem,\n       f.table_name as fktable_name,\n       fc.column_name as fkcolumn_name,\n       fc.position as key_seq,\n       NULL as update_rule,\n       decode (f.delete_rule, 'CASCADE', 0, 1) as delete_rule,\n       f.constraint_name as fk_name,\n       p.constraint_name as pk_name,\n       NULL as deferrability\nFROM all_cons_columns pc, all_constraints p,\n     all_cons_columns fc, all_constraints f\nWHERE 1 = 1\n" + (n2 != 0 ? "  AND p.table_name = ?\n" : "") + (n3 != 0 ? "  AND f.table_name = ?\n" : "") + (n4 != 0 ? "  AND p.owner = ?\n" : "") + (n5 != 0 ? "  AND f.owner = ?\n" : "") + "  AND f.constraint_type = 'R'\n" + "  AND p.owner = f.r_owner\n" + "  AND p.constraint_name = f.r_constraint_name\n" + "  AND p.constraint_type = 'P'\n" + "  AND pc.owner = p.owner\n" + "  AND pc.constraint_name = p.constraint_name\n" + "  AND pc.table_name = p.table_name\n" + "  AND fc.owner = f.owner\n" + "  AND fc.constraint_name = f.constraint_name\n" + "  AND fc.table_name = f.table_name\n" + "  AND fc.position = pc.position\n" + string5);
        if (n2 != 0) {
            preparedStatement.setString(n2, string2);
        }
        if (n3 != 0) {
            preparedStatement.setString(n3, string4);
        }
        if (n4 != 0) {
            preparedStatement.setString(n4, string);
        }
        if (n5 != 0) {
            preparedStatement.setString(n5, string3);
        }
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)preparedStatement.executeQuery();
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    public synchronized ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        this.connection.trace("getImportedKeys");
        return this.keys_query(null, null, string2, string3, "ORDER BY pktable_schem, pktable_name, key_seq");
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        this.connection.trace("getExportedKeys");
        return this.keys_query(string2, string3, null, null, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        this.connection.trace("getCrossReference");
        return this.keys_query(string2, string3, string5, string6, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    public ResultSet getTypeInfo() throws SQLException {
        this.connection.trace("getTypeInfo");
        Statement statement = this.connection.createStatement();
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)statement.executeQuery("select\n 'NUMBER' as type_name, 2 as data_type, 38 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n 'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'CHAR' as type_name, 1 as data_type, 255 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'CHAR' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'VARCHAR2' as type_name, 12 as data_type, 2000 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'VARCHAR2' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'DATE' as type_name, 93 as data_type, 7 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'DATE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'RAW' as type_name, -3 as data_type, 255 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'RAW' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'LONG' as type_name, -1 as data_type, 134217727 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'LONG RAW' as type_name, -4 as data_type, 134217727 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG RAW' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'NUMBER' as type_name, -7 as data_type, 1 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(1)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'NUMBER' as type_name, -6 as data_type, 3 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(3)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'NUMBER' as type_name, 5 as data_type, 5 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(5)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'NUMBER' as type_name, 4 as data_type, 10 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(10)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'NUMBER' as type_name, -5 as data_type, 38 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'FLOAT' as type_name, 6 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'FLOAT' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'REAL' as type_name, 7 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'REAL' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\norder by data_type\n");
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    public synchronized ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        this.connection.trace("getIndexInfo");
        Statement statement = this.connection.createStatement();
        String string4 = "analyze table " + (string2 == null ? "" : String.valueOf(string2) + ".") + string3 + (bl2 ? " estimate statistics" : " compute statistics");
        this.connection.trace(string4);
        statement.executeUpdate(string4);
        String string5 = "select null as table_cat,\n       owner as table_schem,\n       table_name,\n       0 as NON_UNIQUE,\n       null as index_qualifier,\n       null as index_name, 0 as type,\n       0 as ordinal_position, null as column_name,\n       null as asc_or_desc,\n       num_rows as cardinality,\n       blocks as pages,\n       null as filter_condition\nfrom all_tables\nwhere table_name = '" + string3 + "'\n";
        String string6 = "";
        if (string2 != null && string2.length() > 0) {
            string6 = "  and owner = '" + string2 + "'\n";
        }
        String string7 = "select null as table_cat,\n       i.owner as table_schem,\n       i.table_name,\n       decode (i.uniqueness, 'UNIQUE', 0, 1),\n       null as index_qualifier,\n       i.index_name,\n       1 as type,\n       c.column_position as ordinal_position,\n       c.column_name,\n       null as asc_or_desc,\n       i.distinct_keys as cardinality,\n       i.leaf_blocks as pages,\n       null as filter_condition\nfrom all_indexes i, all_ind_columns c\nwhere i.table_name = '" + string3 + "'\n";
        String string8 = "";
        if (string2 != null && string2.length() > 0) {
            string8 = "  and i.owner = '" + string2 + "'\n";
        }
        String string9 = "";
        if (bl) {
            string9 = "  and i.uniqueness = 'UNIQUE'\n";
        }
        String string10 = String.valueOf(string5) + string6 + "union\n" + string7 + string8 + string9 + "  and i.index_name = c.index_name\n  and i.table_owner = c.table_owner\n  and i.table_name = c.table_name\n  and i.owner = c.index_owner\n" + "order by non_unique, type, index_name, ordinal_position\n";
        OracleResultSetImpl oracleResultSetImpl = (OracleResultSetImpl)statement.executeQuery(string10);
        oracleResultSetImpl.close_statement_on_close = true;
        return oracleResultSetImpl;
    }

    SQLException fail() {
        SQLException sQLException = new SQLException("Not implemented yet");
        return sQLException;
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return true;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return true;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return n != 1003;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return n != 1003;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return n == 1005;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        String[] stringArray;
        boolean bl = false;
        if (string3 == null || string3.length() == 0) {
            bl = false;
        } else if (nArray == null) {
            bl = true;
        } else {
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] == 2002) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT NULL AS TYPE_CAT, owner AS TYPE_SCHEM, type_name, NULL AS CLASS_NAME, 'STRUCT' AS DATA_TYPE, NULL AS REMARKS FROM all_types ");
        if (bl) {
            stringBuffer.append("WHERE typecode = 'OBJECT' AND owner LIKE ? ESCAPE '/' AND type_name LIKE ? ESCAPE '/'");
        } else {
            stringBuffer.append("WHERE 1 = 2");
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement(stringBuffer.toString());
        if (bl) {
            stringArray = new String[1];
            String[] stringArray2 = new String[1];
            if (SQLName.parse(string3, stringArray, stringArray2)) {
                preparedStatement.setString(1, stringArray[0]);
                preparedStatement.setString(2, stringArray2[0]);
            } else {
                if (string2 != null) {
                    preparedStatement.setString(1, string2);
                } else {
                    preparedStatement.setNull(1, 12);
                }
                preparedStatement.setString(2, string3);
            }
        }
        stringArray = (OracleResultSetImpl)preparedStatement.executeQuery();
        stringArray.close_statement_on_close = true;
        return stringArray;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public static String getDriverNameInfo() throws SQLException {
        return DRIVER_NAME;
    }

    public static String getDriverVersionInfo() throws SQLException {
        return DRIVER_VERSION;
    }

    public static int getDriverMajorVersionInfo() {
        return DRIVER_MAJOR_VERSION;
    }

    public static int getDriverMinorVersionInfo() {
        return DRIVER_MINOR_VERSION;
    }
}

