/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.ClientDataSupport;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleDatabaseMetaData;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnection
implements Connection,
ClientDataSupport {
    public static final boolean DEBUG = false;
    private static String dll_string = "dll";
    private String url;
    private String user;
    private String password;
    private String database;
    private boolean auto_commit;
    private String protocol;
    public DBAccess db_access;
    public DBConversion conversion;
    public boolean XA_wants_error;
    public boolean UsingXA;
    private byte[] fdo;
    private Boolean big_endian;
    Hashtable statement_table;
    boolean closed;
    int default_batch;
    int default_row_prefetch;
    boolean report_remarks;
    boolean include_synonyms = false;
    int new_row_prefetch;
    private int trans_level;
    Dictionary map;
    Hashtable descriptorCache;
    OracleStatement statement_holding_line;
    OracleDatabaseMetaData m_dbMetaData;
    private boolean physicalStatus;
    private boolean logicalHandle;
    private OraclePooledConnection opc;
    static int DEFAULT_ROW_PREFETCH = 10;
    private static OracleSql s_osql = null;
    private static boolean m_traceEnabled;
    static final int BINARYSTREAM = 0;
    static final int ASCIISTREAM = 1;
    static final int UNICODESTREAM = 2;
    static final int EOJ_NON = 0;
    static final int EOJ_B_TO_A = 1;
    static final int EOJ_B_TO_U = 2;
    static final int EOJ_A_TO_U = 3;
    static final int EOJ_8_TO_A = 4;
    static final int EOJ_8_TO_U = 5;
    static final int EOJ_U_TO_A = 6;
    static final int ASCII_CHARSET = 0;
    static final int NLS_CHARSET = 1;
    public static final int CHAR_TO_ASCII = 0;
    public static final int CHAR_TO_UNICODE = 1;
    public static final int RAW_TO_ASCII = 2;
    public static final int RAW_TO_UNICODE = 3;
    public static final int UNICODE_TO_CHAR = 4;
    public static final int ASCII_TO_CHAR = 5;
    public static final int NONE = 6;
    public static final int JAVACHAR_TO_CHAR = 7;
    public static final int RAW_TO_JAVACHAR = 8;
    public static final int CHAR_TO_JAVACHAR = 9;
    private Hashtable m_clientData;

    public OracleConnection(DBAccess dBAccess, String string, String string2, String string3, String string4, Properties properties) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.OracleConnection(access, ur=\"" + string + "\", us=\"" + string2 + "\", p=\"" + string3 + "\", db=\"" + string4 + "\", info)");
        }
        String string5 = null;
        if (properties != null) {
            string5 = (String)((Hashtable)properties).get("protocol");
        }
        this.initialize(string, string2, string5, dBAccess);
        this.logicalHandle = false;
        try {
            this.needLine();
            this.conversion = this.db_access.logon(string2, string3, string4, properties);
            this.default_row_prefetch = this.db_access.getDefaultPrefetch();
            this.setAutoCommit(true);
            this.db_access.initNls(this);
            return;
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return;
        }
    }

    public OracleConnection(OraclePooledConnection oraclePooledConnection, OracleConnection oracleConnection, boolean bl) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.OracleConnection(par, pc, autoCommit=" + bl + ")");
        }
        this.initialize(oracleConnection.url, oracleConnection.user, oracleConnection.protocol, oracleConnection.db_access);
        this.logicalHandle = true;
        this.opc = oraclePooledConnection;
        this.conversion = oracleConnection.conversion;
        this.setAutoCommit(bl);
    }

    private void initialize(String string, String string2, String string3, DBAccess dBAccess) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.initialize(ur=\"" + string + "\", us=\"" + string2 + "\", access)");
        }
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.initClientDataSupport()");
        }
        this.m_clientData = null;
        this.url = string;
        this.user = string2 != null ? string2.toUpperCase() : string2;
        this.db_access = dBAccess;
        this.protocol = string3;
        this.physicalStatus = true;
        this.default_row_prefetch = DEFAULT_ROW_PREFETCH;
        this.default_batch = 1;
        this.new_row_prefetch = 0;
        this.statement_table = new Hashtable(10);
        this.descriptorCache = new Hashtable(10);
        this.map = new Hashtable(10);
        this.closed = false;
        this.trans_level = 2;
        this.XA_wants_error = false;
        this.UsingXA = false;
        this.fdo = null;
        this.big_endian = null;
    }

    public synchronized void setPhysicalStatus(boolean bl) {
        this.physicalStatus = bl;
    }

    private void checkPhyiscalStatus() throws SQLException {
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.createStatement()");
        }
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        OracleStatement oracleStatement = new OracleStatement(this, 1, this.default_row_prefetch);
        this.add_statement(oracleStatement);
        return oracleStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.prepareStatement(sql)");
            OracleLog.print(this, 1, 8, 32, "SQL: \"" + string + "\"");
        }
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        OraclePreparedStatement oraclePreparedStatement = new OraclePreparedStatement(this, string, this.default_batch, this.default_row_prefetch);
        this.add_statement(oraclePreparedStatement);
        return oraclePreparedStatement;
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.prepareCall(sql)");
            OracleLog.print(this, 1, 8, 32, "SQL: \"" + string + "\"");
        }
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        OracleCallableStatement oracleCallableStatement = new OracleCallableStatement(this, string, 1, this.default_row_prefetch);
        this.add_statement(oracleCallableStatement);
        return oracleCallableStatement;
    }

    public String nativeSQL(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.nativeSQL(sql)");
            OracleLog.print(this, 1, 8, 32, "Input SQL:  \"" + string + "\"");
        }
        if (s_osql == null) {
            s_osql = new OracleSql();
        }
        String string2 = s_osql.parse(string);
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 32, "Output SQL: \"" + string2 + "\"");
        }
        return string2;
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setAutoCommit(autoCommit=" + bl + ")");
        }
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
        if (this.XA_wants_error || this.UsingXA && bl) {
            DBError.throwSqlException(69);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        try {
            this.needLine();
            this.db_access.setAutoCommit(bl);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.auto_commit = bl;
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getAutoCommit() returned " + this.auto_commit);
        }
        return this.auto_commit;
    }

    public synchronized void commit() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.commit()");
        }
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
        if (this.XA_wants_error || this.UsingXA) {
            DBError.throwSqlException(69);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        Enumeration enumeration = this.statement_table.elements();
        while (enumeration.hasMoreElements()) {
            OracleStatement oracleStatement = (OracleStatement)enumeration.nextElement();
            oracleStatement.sendBatch();
        }
        try {
            this.needLine();
            this.db_access.commit();
            return;
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return;
        }
    }

    public synchronized void rollback() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.rollback()");
        }
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
        if (this.XA_wants_error || this.UsingXA) {
            DBError.throwSqlException(69);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        try {
            this.needLine();
            this.db_access.rollback();
            return;
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return;
        }
    }

    public synchronized void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.close()");
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.close_statements();
        if (this.logicalHandle) {
            this.logicalClose();
            return;
        }
        try {
            this.XA_wants_error = false;
            this.needLine();
            this.db_access.logoff();
            this.cleanup();
            return;
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return;
        }
    }

    public synchronized boolean isClosed() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.isClosed() returned " + this.closed);
        }
        return this.closed;
    }

    private void cleanup() {
        this.fdo = null;
        this.db_access = null;
        this.conversion = null;
        this.statement_table = null;
        this.descriptorCache = null;
        this.map = null;
        this.statement_holding_line = null;
        this.opc = null;
        s_osql = null;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getMetaData()");
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        if (this.m_dbMetaData == null) {
            this.m_dbMetaData = new OracleDatabaseMetaData(this);
        }
        return this.m_dbMetaData;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setReadOnly(readOnly=" + bl + ")");
        }
        if (bl) {
            DBError.throwSqlException(29);
        }
    }

    public boolean isReadOnly() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.isReadOnly()");
        }
        return false;
    }

    public void setCatalog(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setCatalog(catalog=\"" + string + "\")");
        }
    }

    public String getCatalog() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getCatalog()");
        }
        return null;
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setTransactionIsolation(level=" + n + ")");
        }
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
        OracleStatement oracleStatement = null;
        oracleStatement = (OracleStatement)this.createStatement();
        switch (n) {
            case 2: {
                oracleStatement.execute("ALTER SESSION SET ISOLATION_LEVEL = READ COMMITTED");
                this.trans_level = 2;
                break;
            }
            case 8: {
                oracleStatement.execute("ALTER SESSION SET ISOLATION_LEVEL = SERIALIZABLE");
                this.trans_level = 8;
                break;
            }
            default: {
                DBError.throwSqlException(30);
            }
        }
        if (oracleStatement != null) {
            oracleStatement.close();
        }
        oracleStatement = null;
    }

    public int getTransactionIsolation() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getTransactionIsolation() returned " + this.trans_level);
        }
        return this.trans_level;
    }

    public synchronized void setAutoClose(boolean bl) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setAutoClose(autoClose=" + bl + ")");
        }
        if (!bl) {
            DBError.throwSqlException(31);
        }
    }

    public boolean getAutoClose() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getAutoClose()");
        }
        return true;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getWarnings()");
        }
        return null;
    }

    public void clearWarnings() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.clearWarnings()");
        }
    }

    public void trace(String string) {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            if (m_traceEnabled) {
                OracleLog.setLogStream(null);
            }
            m_traceEnabled = false;
            return;
        }
        if (!m_traceEnabled) {
            OracleLog.setLogStream(printStream);
        }
        OracleLog.print(1, 32, string);
        m_traceEnabled = true;
    }

    public synchronized void setDefaultRowPrefetch(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setDefaultRowPrefetch(value=" + n + ")");
        }
        if (n <= 0) {
            DBError.throwSqlException(20);
        }
        this.default_row_prefetch = n;
    }

    public synchronized int getDefaultRowPrefetch() {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getDefaultRowPrefetch() returned " + this.default_row_prefetch);
        }
        return this.default_row_prefetch;
    }

    public synchronized void setDefaultExecuteBatch(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setDefaultExecuteBatch(batch=" + n + ")");
        }
        if (n <= 0) {
            DBError.throwSqlException(42);
        }
        this.default_batch = n;
    }

    public synchronized int getDefaultExecuteBatch() {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getDefaultExecuteBatch() returned " + this.default_batch);
        }
        return this.default_batch;
    }

    public synchronized void setRemarksReporting(boolean bl) {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setRemarksReporting(reportRemarks=" + bl + ")");
        }
        this.report_remarks = bl;
    }

    public synchronized boolean getRemarksReporting() {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getRemarksReporting()");
        }
        return this.report_remarks;
    }

    public void setIncludeSynonyms(boolean bl) {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setIncludeSynonyms(synonyms=" + bl + ")");
        }
        this.include_synonyms = bl;
    }

    public boolean getIncludeSynonyms() {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getIncludeSynonyms() returned " + this.include_synonyms);
        }
        return this.include_synonyms;
    }

    synchronized void add_statement(Statement statement) {
        this.statement_table.put(statement, statement);
    }

    synchronized void remove_statement(Statement statement) {
        this.statement_table.remove(statement);
    }

    public synchronized void close_statements() throws SQLException {
        Enumeration enumeration = this.statement_table.elements();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            statement.close();
            statement = null;
        }
    }

    public synchronized void needLine() throws SQLException {
        if (this.XA_wants_error) {
            DBError.throwSqlException(63);
        }
        if (this.statement_holding_line != null) {
            this.statement_holding_line.freeLine();
        }
    }

    public synchronized void holdLine(OracleStatement oracleStatement) {
        this.statement_holding_line = oracleStatement;
    }

    public synchronized void releaseLine() {
        this.statement_holding_line = null;
    }

    public synchronized void startup(String string, int n) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        this.db_access.startup(string, n);
    }

    public synchronized void shutdown(int n) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        this.db_access.shutdown(n);
    }

    public synchronized void archive(int n, int n2, String string) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        this.db_access.archive(n, n2, string);
    }

    public synchronized void registerSQLType(String string, String string2) throws SQLException {
        if (string == null || string2 == null) {
            DBError.throwSqlException(68);
        }
        try {
            this.registerSQLType(string, Class.forName(string2));
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            DBError.throwSqlException(1, "Class not found: " + string2);
            return;
        }
    }

    public synchronized void registerSQLType(String string, Class clazz) throws SQLException {
        if (string == null || clazz == null) {
            DBError.throwSqlException(68);
        }
        if (this.map == null) {
            this.map = new Hashtable(10);
        }
        this.map.put(string, clazz);
        this.map.put(clazz.getName(), string);
    }

    public synchronized String getSQLType(Object object) throws SQLException {
        if (object != null && this.map != null) {
            String string = object.getClass().getName();
            return (String)this.map.get(string);
        }
        return null;
    }

    public synchronized Object getJavaObject(String string) throws SQLException {
        Object var2_2 = null;
        try {
            if (string != null && this.map != null) {
                Class clazz = (Class)this.map.get(string);
                var2_2 = clazz.newInstance();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        return var2_2;
    }

    public synchronized void putDescriptor(String string, Object object) throws SQLException {
        if (string != null) {
            if (this.descriptorCache == null) {
                this.descriptorCache = new Hashtable(10);
            }
            this.descriptorCache.put(string, object);
        }
    }

    public synchronized Object getDescriptor(String string) {
        if (string != null && this.descriptorCache != null) {
            return this.descriptorCache.get(string);
        }
        return null;
    }

    public synchronized void removeDecriptor(String string) {
        if (string != null && this.descriptorCache != null) {
            this.descriptorCache.remove(string);
        }
    }

    public synchronized void removeAllDescriptor() {
        if (this.descriptorCache != null) {
            this.descriptorCache.clear();
        }
    }

    public short getJdbcCsId() throws SQLException {
        if (this.conversion == null) {
            DBError.throwSqlException(65);
        }
        return this.conversion.getAccessCharSet();
    }

    public short getDbCsId() throws SQLException {
        if (this.conversion == null) {
            DBError.throwSqlException(65);
        }
        return this.conversion.getDbCharSet();
    }

    public synchronized short getStructAttrCsId() throws SQLException {
        return this.getDbCsId();
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.createStatement(resultSetType=" + n + ", resultSetConcurrency=" + n2 + ")");
        }
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        OracleStatement oracleStatement = new OracleStatement(this, 1, this.default_row_prefetch, n, n2);
        this.add_statement(oracleStatement);
        return oracleStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.prepareStatement(sql=\"" + string + "\", resultSetType=" + n + ", resultSetConcurrency=" + n2 + ")");
        }
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        OraclePreparedStatement oraclePreparedStatement = new OraclePreparedStatement(this, string, this.default_batch, this.default_row_prefetch, n, n2);
        this.add_statement(oraclePreparedStatement);
        return oraclePreparedStatement;
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.prepareCall(sql=\"" + string + "\", resultSetType=" + n + ", resultSetConcurrency=" + n2 + ")");
        }
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        OracleCallableStatement oracleCallableStatement = new OracleCallableStatement(this, string, 1, this.default_row_prefetch, n, n2);
        this.add_statement(oracleCallableStatement);
        return oracleCallableStatement;
    }

    public synchronized Dictionary getTypeMap() {
        return this.map;
    }

    public synchronized void setTypeMap(Dictionary dictionary) {
        this.map = dictionary;
    }

    public void setUsingXAFlag(boolean bl) {
        this.UsingXA = bl;
    }

    public boolean getUsingXAFlag() {
        return this.UsingXA;
    }

    public synchronized void setXAErrorFlag(boolean bl) {
        this.XA_wants_error = bl;
    }

    public synchronized boolean getXAErrorFlag() {
        return this.XA_wants_error;
    }

    public synchronized void initUserName() throws SQLException {
        if (this.user != null) {
            return;
        }
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
        Statement statement = this.createStatement();
        ((OracleStatement)statement).setRowPrefetch(1);
        try {
            ResultSet resultSet = statement.executeQuery("select USER from dual");
            if (resultSet.next()) {
                this.user = resultSet.getString(1);
            }
            resultSet.close();
            resultSet = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            statement.close();
            statement = null;
            throw throwable;
        }
        Object var3_3 = null;
        statement.close();
        statement = null;
    }

    public synchronized String getUserName() throws SQLException {
        if (this.user == null) {
            this.initUserName();
        }
        return this.user;
    }

    public Properties getDBAccessProperties() throws SQLException {
        if (this.db_access == null) {
            return null;
        }
        return this.db_access.getDBAccessProperties();
    }

    public synchronized void logicalClose() throws SQLException {
        if (this.opc != null && this.physicalStatus) {
            this.opc.logicalClose();
        }
        this.setPhysicalStatus(false);
    }

    public synchronized byte[] getFDO() throws SQLException {
        if (this.fdo == null) {
            CallableStatement callableStatement = null;
            try {
                if (!this.physicalStatus) {
                    DBError.throwSqlException(73);
                }
                callableStatement = this.prepareCall("begin ? := dbms_pickler.get_format (?); end;");
                callableStatement.registerOutParameter(1, 2);
                callableStatement.registerOutParameter(2, -4);
                callableStatement.execute();
                this.fdo = callableStatement.getBytes(2);
            }
            finally {
                Object var3_2 = null;
                if (callableStatement != null) {
                    callableStatement.close();
                }
                callableStatement = null;
            }
        }
        return this.fdo;
    }

    public synchronized boolean getBigEndian() throws SQLException {
        if (this.big_endian == null) {
            int[] nArray = Util.toJavaUnsignedBytes(this.getFDO());
            int n = nArray[6 + nArray[5] + nArray[6] + 5];
            int n2 = n & 0x10;
            if (n2 < 0) {
                n2 += 256;
            }
            this.big_endian = n2 > 0 ? new Boolean(true) : new Boolean(false);
        }
        return this.big_endian;
    }

    private void initClientDataSupport() {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.initClientDataSupport()");
        }
        this.m_clientData = null;
    }

    public synchronized Object getClientData(Object object) {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.getClientData(key)");
            OracleLog.print(this, 1, 8, 32, "key: " + object);
        }
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.get(object);
    }

    public synchronized Object setClientData(Object object, Object object2) {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.setClientData(key, value)");
            OracleLog.print(this, 1, 8, 32, "key:   " + object);
            OracleLog.print(this, 1, 8, 32, "value: " + object2);
        }
        if (this.m_clientData == null) {
            this.m_clientData = new Hashtable();
        }
        return this.m_clientData.put(object, object2);
    }

    public synchronized Object removeClientData(Object object) {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.removeClientData(key)");
            OracleLog.print(this, 1, 8, 32, "key: " + object);
        }
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.remove(object);
    }

    public void printState() {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.printState()");
        }
        try {
            short s = this.getJdbcCsId();
            OracleLog.print(this, 1, 8, 32, "Jdbc character set id is   " + s);
            short s2 = this.getDbCsId();
            OracleLog.print(this, 1, 8, 32, "Db character set id is     " + s2);
            short s3 = this.getStructAttrCsId();
            OracleLog.print(this, 1, 8, 32, "STRUCT character set id is " + s3);
            return;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return;
        }
    }

    public String getProtocolType() {
        return this.protocol;
    }

    public String getURL() {
        return this.url;
    }
}

