/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Dictionary;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc2.Array;
import oracle.jdbc2.Blob;
import oracle.jdbc2.Clob;
import oracle.jdbc2.Ref;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleCallableStatement
extends OraclePreparedStatement
implements CallableStatement {
    public OracleCallableStatement(OracleConnection oracleConnection, String string, int n, int n2) throws SQLException {
        this(oracleConnection, string, n, n2, 1003, 1007);
    }

    public OracleCallableStatement(OracleConnection oracleConnection, String string, int n, int n2, int n3, int n4) throws SQLException {
        super(oracleConnection, string, n, n2, n3, n4);
        if (OracleLog.TRACE) {
            OracleLog.print(oracleConnection, 1, 16, 16, "OracleCallableStatement.OracleCallableStatement(conn, sql, batchValue, rowPrefetchValue) returned");
        }
        this.parseSqlKind();
    }

    public synchronized void registerOutParameter(int n, int n2, String string) throws SQLException {
        Object object;
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleCallableStatement.registerOutParameter(paramIndex=" + n + ", sqlType=" + n2 + ", sqlName=" + string + ")");
        }
        if (n2 != 2002 && n2 != 2003 && n2 != 2006) {
            DBError.throwSqlException(12, "sqlType=" + n2);
        }
        int n3 = this.get_internal_type(n2);
        int n4 = n - 1;
        this.checkBindTypes(false, n4, n3);
        this.batch = 1;
        DBType dBType = this.connection.db_access.createDBType(n3, true);
        if (n2 == 2002 || n2 == 2006) {
            object = StructDescriptor.createDescriptor(string, this.connection);
            dBType.otype = ((StructDescriptor)object).getOracleTypeADT();
        } else if (n2 == 2003) {
            object = ArrayDescriptor.createDescriptor(string, this.connection);
            dBType.otype = ((ArrayDescriptor)object).getOracleTypeCOLLECTION();
        }
        if (this.first_row) {
            if (n > this.noOfArgs) {
                this.noOfArgs = n;
            }
            ++this.noOfOutParams;
            this.alloc_tmp_binds(n4);
            this.tmp_out_first_row_types[n4] = dBType;
            return;
        }
        object = this.binds_out;
        if (((DBDataSet)object).types != null && n4 >= 0 && n4 < ((DBDataSet)object).types.length) {
            ((DBDataSet)object).types[n4] = dBType;
        }
        this.binds_out.allocDataAndItems(n4);
    }

    public synchronized void registerOutParameter(int n, int n2, int n3, int n4) throws SQLException {
        DBType dBType;
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleCallableStatement.registerOutParameter(paramIndex=" + n + ", sqlType=" + n2 + ", scale=" + n3 + ", maxLength=" + n4 + ")");
        }
        if (n2 == 2002 || n2 == 2003 || n2 == 2006) {
            DBError.throwSqlException(12, "sqlType=" + n2);
        }
        int n5 = n - 1;
        int n6 = this.get_internal_type(n2);
        this.checkBindTypes(false, n5, n6);
        this.batch = 1;
        if (n6 == 96 || n6 == 1 || n6 == 999) {
            dBType = this.connection.db_access.createDBType(1, true);
            OracleCallableStatement.overrideDbtypeMaxSize(dBType, this.max_field_size, Short.MAX_VALUE, n4);
        } else if (n6 == 8) {
            dBType = this.connection.db_access.createDBType(1, true);
            OracleCallableStatement.overrideDbtypeMaxSize(dBType, this.max_field_size, 32760, n4);
        } else if (n6 == 24 || n6 == 23) {
            dBType = this.connection.db_access.createDBType(23, true);
            OracleCallableStatement.overrideDbtypeMaxSize(dBType, this.max_field_size, Short.MAX_VALUE, n4);
        } else {
            dBType = n6 == 102 ? this.connection.db_access.createDBType(102, true) : this.connection.db_access.createDBType(n6, true);
        }
        if (this.first_row) {
            if (n > this.noOfArgs) {
                this.noOfArgs = n;
            }
            ++this.noOfOutParams;
            this.alloc_tmp_binds(n5);
            this.tmp_out_first_row_types[n5] = dBType;
            return;
        }
        DBDataSet dBDataSet = this.binds_out;
        if (dBDataSet.types != null && n5 >= 0 && n5 < dBDataSet.types.length) {
            dBDataSet.types[n5] = dBType;
        }
        this.binds_out.allocDataAndItems(n5);
    }

    private static void overrideDbtypeMaxSize(DBType dBType, int n, int n2, int n3) {
        int n4 = n2;
        if (n != 0) {
            n4 = Math.min(n, n4);
        }
        if (n3 != -1) {
            n4 = Math.min(n3, n4);
        }
        dBType.setMaxSize(n4);
    }

    private void resetBatch() {
        this.batch = 1;
    }

    public synchronized void setExecuteBatch(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleCallableStatement.setExecuteBatch(nrows=" + n + ")");
        }
        this.batch = 1;
    }

    public synchronized int sendBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleCallableStatement.sendBatch()");
        }
        return this.valid_rows;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, 0, -1);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n, n2, n3, -1);
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullValue();
    }

    public String getString(int n) throws SQLException {
        return this.getStringValue(false, n);
    }

    public Datum getOracleObject(int n) throws SQLException {
        return this.getOracleObjectValue(false, n);
    }

    public ROWID getROWID(int n) throws SQLException {
        return this.getROWIDValue(false, n);
    }

    public NUMBER getNUMBER(int n) throws SQLException {
        return this.getNUMBERValue(false, n);
    }

    public DATE getDATE(int n) throws SQLException {
        return this.getDATEValue(false, n);
    }

    public REF getREF(int n) throws SQLException {
        return this.getREFValue(false, n);
    }

    public ARRAY getARRAY(int n) throws SQLException {
        return this.getARRAYValue(false, n);
    }

    public STRUCT getSTRUCT(int n) throws SQLException {
        return this.getSTRUCTValue(false, n);
    }

    public CHAR getCHAR(int n) throws SQLException {
        return this.getCHARValue(false, n);
    }

    public RAW getRAW(int n) throws SQLException {
        return this.getRAWValue(false, n);
    }

    public BLOB getBLOB(int n) throws SQLException {
        return this.getBLOBValue(false, n);
    }

    public CLOB getCLOB(int n) throws SQLException {
        return this.getCLOBValue(false, n);
    }

    public BFILE getBFILE(int n) throws SQLException {
        return this.getBFILEValue(false, n);
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.getBooleanValue(false, n);
    }

    public byte getByte(int n) throws SQLException {
        return this.getByteValue(false, n);
    }

    public short getShort(int n) throws SQLException {
        return this.getShortValue(false, n);
    }

    public int getInt(int n) throws SQLException {
        return this.getIntValue(false, n);
    }

    public long getLong(int n) throws SQLException {
        return this.getLongValue(false, n);
    }

    public float getFloat(int n) throws SQLException {
        return this.getFloatValue(false, n);
    }

    public double getDouble(int n) throws SQLException {
        return this.getDoubleValue(false, n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimalValue(false, n, n2);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.getBytesValue(false, n);
    }

    public Date getDate(int n) throws SQLException {
        return this.getDateValue(false, n);
    }

    public Time getTime(int n) throws SQLException {
        return this.getTimeValue(false, n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestampValue(false, n);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getAsciiStreamValue(false, n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.getUnicodeStreamValue(false, n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.getBinaryStreamValue(false, n);
    }

    public Object getObject(int n) throws SQLException {
        return this.getObjectValue(false, n);
    }

    public Object getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        return this.getCustomDatumValue(false, n, customDatumFactory);
    }

    public ResultSet getCursor(int n) throws SQLException {
        return this.getCursorValue(false, n);
    }

    public synchronized void clearParameters() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleCallableStatement.clearParameters()");
        }
        if (this.binds_out != null && this.binds_out.data != null && this.binds_out.data.length != 0) {
            int n = 0;
            while (n < this.binds_out.types.length) {
                if (this.binds_out.data[n] != null) {
                    this.binds_out.setDBItem(null, n, this.m_currentRank);
                }
                ++n;
            }
        }
        super.clearParameters();
    }

    public Object getObject(int n, Dictionary dictionary) throws SQLException {
        return this.getObjectValue(false, n, dictionary);
    }

    public Ref getRef(int n) throws SQLException {
        return this.getREFValue(false, n);
    }

    public Blob getBlob(int n) throws SQLException {
        return this.getBLOBValue(false, n);
    }

    public Clob getClob(int n) throws SQLException {
        return this.getCLOBValue(false, n);
    }

    public Array getArray(int n) throws SQLException {
        return this.getARRAYValue(false, n);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimalValue(false, n, 0);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public void addBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleCallableStatement.addBatch()");
            OracleLog.print(this.connection, 1, 16, 32, "Add batch: noOfOutParams=" + this.noOfOutParams);
        }
        if (this.noOfOutParams > 0) {
            DBError.throwSqlException(90, "Stored procedure with out or inout parameters cannot be batched");
        }
        super.addBatch();
    }
}

