/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Dictionary;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class ArrayLocatorResultSet
extends OracleResultSetImpl {
    static int COUNT_UNLIMITED = -1;
    Dictionary m_map;
    long m_beginIdx;
    int m_count;
    long m_idx;

    public ArrayLocatorResultSet(OracleConnection oracleConnection, ArrayDescriptor arrayDescriptor, byte[] byArray, Dictionary dictionary) throws SQLException {
        this(oracleConnection, arrayDescriptor, byArray, 0L, COUNT_UNLIMITED, dictionary);
    }

    public ArrayLocatorResultSet(OracleConnection oracleConnection, ArrayDescriptor arrayDescriptor, byte[] byArray, long l, int n, Dictionary dictionary) throws SQLException {
        super(oracleConnection, null);
        if (arrayDescriptor == null || oracleConnection == null) {
            DBError.check_error(1, "Invalid arguments");
        }
        this.m_count = n;
        this.m_idx = 0L;
        this.m_beginIdx = l;
        this.m_map = dictionary;
        OraclePreparedStatement oraclePreparedStatement = null;
        ARRAY aRRAY = new ARRAY(arrayDescriptor, (Connection)oracleConnection, null);
        aRRAY.setLocator(byArray);
        oraclePreparedStatement = arrayDescriptor.getBaseType() == 2002 ? (OraclePreparedStatement)oracleConnection.prepareStatement("SELECT ROWNUM, SYS_NC_ROWINFO$ FROM TABLE( CAST(? AS " + arrayDescriptor.getName() + ") )") : (OraclePreparedStatement)oracleConnection.prepareStatement("SELECT ROWNUM, COLUMN_VALUE FROM TABLE( CAST(? AS " + arrayDescriptor.getName() + ") )");
        oraclePreparedStatement.setArray(1, aRRAY);
        oraclePreparedStatement.executeQuery();
        this.statement = oraclePreparedStatement;
    }

    public synchronized boolean next() throws SQLException {
        if (this.m_idx < this.m_beginIdx) {
            while (this.m_idx < this.m_beginIdx) {
                ++this.m_idx;
                if (super.next()) continue;
                return false;
            }
            return true;
        }
        if (this.m_count == COUNT_UNLIMITED) {
            return super.next();
        }
        if (this.m_idx < this.m_beginIdx + (long)this.m_count - 1L) {
            ++this.m_idx;
            return super.next();
        }
        return false;
    }

    public synchronized Object getObject(int n) throws SQLException {
        return this.getObject(n, this.m_map);
    }

    public synchronized int findColumn(String string) throws SQLException {
        this.connection.trace("ResultSet.findColumn");
        if (string.equalsIgnoreCase("index")) {
            return 1;
        }
        if (string.equalsIgnoreCase("value")) {
            return 2;
        }
        DBError.check_error(6, "get_column_index");
        return 0;
    }
}

