/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import oracle.jdbc.oracore.OracleType;

public class DBType {
    public int type;
    public int max_length;
    public boolean is_stream;
    public OracleType otype;
    public static final int FIXED_CHAR = 999;
    public static final int CHAR = 96;
    public static final int VARCHAR = 1;
    public static final int LONG = 8;
    public static final int NUMBER = 2;
    public static final int VARNUM = 6;
    public static final int RAW = 23;
    public static final int LONG_RAW = 24;
    public static final int ROWID = 104;
    public static final int RESULT_SET = 102;
    public static final int DATE = 12;
    public static final int BLOB = 113;
    public static final int CLOB = 112;
    public static final int BFILE = 114;
    public static final int NAMED_TYPE = 109;
    public static final int REF_TYPE = 111;

    public void setFields(int n, short s) {
        this.is_stream = false;
        switch (n) {
            case 96: 
            case 999: {
                if (s >= 8000) {
                    this.max_length = 2000;
                    return;
                }
                this.max_length = 255;
                return;
            }
            case 1: {
                if (s >= 8000) {
                    this.max_length = 4000;
                    return;
                }
                this.max_length = 2000;
                return;
            }
            case 8: {
                this.max_length = Integer.MAX_VALUE;
                this.is_stream = true;
                return;
            }
            case 2: 
            case 6: {
                this.max_length = 22;
                return;
            }
            case 23: {
                if (s >= 8000) {
                    this.max_length = 2000;
                    return;
                }
                this.max_length = 255;
                return;
            }
            case 24: {
                this.max_length = Integer.MAX_VALUE;
                this.is_stream = true;
                return;
            }
            case 104: {
                this.max_length = 128;
                return;
            }
            case 102: {
                this.max_length = 0;
                return;
            }
            case 12: {
                this.max_length = 7;
                return;
            }
            case 112: 
            case 113: {
                this.max_length = 86;
                return;
            }
            case 114: {
                this.max_length = 530;
                return;
            }
            case 111: {
                this.max_length = 4000;
                return;
            }
            case 109: {
                this.max_length = Integer.MAX_VALUE;
                return;
            }
        }
    }

    public DBType(int n, int n2, boolean bl, short s) {
        this.type = n;
        this.setFields(n, s);
        this.max_length = !bl ? Math.min(n2, this.max_length) : n2;
        this.is_stream = bl;
    }

    public DBType() {
    }

    public DBType(int n, short s) {
        this.type = n;
        this.setFields(n, s);
    }

    public DBType(int n, int n2, short s) {
        this.type = n;
        this.setFields(n, s);
        if (n == 102) {
            this.max_length = n2;
            return;
        }
        this.max_length = Math.min(n2, this.max_length);
    }

    public void setMaxSize(int n) {
        this.max_length = n;
    }

    public static String getStringType(int n) {
        switch (n) {
            case 999: {
                return " FIXED_CHAR ";
            }
            case 96: {
                return " CHAR ";
            }
            case 1: {
                return " VARCHAR ";
            }
            case 8: {
                return " LONG ";
            }
            case 2: {
                return " NUMBER ";
            }
            case 6: {
                return " VARNUM ";
            }
            case 23: {
                return " RAW ";
            }
            case 24: {
                return " LONG_RAW ";
            }
            case 104: {
                return " ROWID ";
            }
            case 102: {
                return " RESULT_SET ";
            }
            case 12: {
                return " DATE ";
            }
            case 112: {
                return " CLOB ";
            }
            case 113: {
                return " BLOB ";
            }
            case 114: {
                return " BFILE ";
            }
            case 109: {
                return " NAMED_TYPE ";
            }
            case 111: {
                return " REF_TYPE ";
            }
        }
        return " Type is not set ";
    }
}

