/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import oracle.jdbc.dbaccess.Message;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.util.SQLStateMapping;
import oracle.jdbc.util.SQLStateRange;
import oracle.jdbc2.BatchUpdateException;

public class DBError {
    private static boolean m_loadedMessages;
    private static Message m_message;
    private static String m_msgClassName;
    static final SQLStateMapping[] mappings;
    static final SQLStateRange[] ranges;
    public static final int JDBC_ERROR_BASE = 17000;
    public static final int JDBC_MAX_ERRORS = 500;
    public static final int EOJ_SUCCESS = 0;
    public static final int EOJ_ERROR = 1;
    public static final int EOJ_IOEXCEPTION = 2;
    public static final int EOJ_INVALID_COLUMN_INDEX = 3;
    public static final int EOJ_INVALID_COLUMN_TYPE = 4;
    public static final int EOJ_UNSUPPORTED_COLUMN_TYPE = 5;
    public static final int EOJ_INVALID_COLUMN_NAME = 6;
    public static final int EOJ_INVALID_DYNAMIC_COLUMN = 7;
    public static final int EOJ_CLOSED_CONNECTION = 8;
    public static final int EOJ_CLOSED_STATEMENT = 9;
    public static final int EOJ_CLOSED_RESULTSET = 10;
    public static final int EOJ_EXHAUSTED_RESULTSET = 11;
    public static final int EOJ_TYPE_CONFLICT = 12;
    public static final int EOJ_WAS_NULL = 13;
    public static final int EOJ_RESULTSET_BEFORE_FIRST_ROW = 14;
    public static final int EOJ_STATEMENT_WAS_CANCELLED = 15;
    public static final int EOJ_STATEMENT_TIMED_OUT = 16;
    public static final int EOJ_CURSOR_ALREADY_INITIALIZED = 17;
    public static final int EOJ_INVALID_CURSOR = 18;
    public static final int EOJ_CAN_ONLY_DESCRIBE_A_QUERY = 19;
    public static final int EOJ_INVALID_ROW_PREFETCH = 20;
    public static final int EOJ_MISSING_DEFINES = 21;
    public static final int EOJ_MISSING_DEFINES_AT_INDEX = 22;
    public static final int EOJ_UNSUPPORTED_FEATURE = 23;
    public static final int EOJ_NO_DATA_READ = 24;
    public static final int EOJ_IS_DEFINES_NULL_ERROR = 25;
    public static final int EOJ_NUMERIC_OVERFLOW = 26;
    public static final int EOJ_STREAM_CLOSED = 27;
    public static final int EOJ_NO_NEW_DEFINE_IF_RESULT_SET_NOT_CLOSED = 28;
    public static final int EOJ_READ_ONLY = 29;
    public static final int EOJ_INVALID_TRANSLEVEL = 30;
    public static final int EOJ_AUTO_CLOSE_ONLY = 31;
    public static final int EOJ_ROW_PREFETCH_NOT_ZERO = 32;
    public static final int EOJ_MALFORMED_SQL92 = 33;
    public static final int EOJ_NON_SUPPORTED_SQL92_TOKEN = 34;
    public static final int EOJ_NON_SUPPORTED_CHAR_SET = 35;
    public static final int EOJ_ORACLE_NUMBER_EXCEPTION = 36;
    public static final int EOJ_FAIL_CONVERSION_UTF8_TO_UCS2 = 37;
    public static final int EOJ_CONVERSION_BYTE_ARRAY_ERROR = 38;
    public static final int EOJ_CONVERSION_CHAR_ARRAY_ERROR = 39;
    public static final int EOJ_SUB_SUB_PROTOCOL_ERROR = 40;
    public static final int EOJ_INVALID_IN_OUT_BINDS = 41;
    public static final int EOJ_INVALID_BATCH_VALUE = 42;
    public static final int EOJ_INVALID_STREAM_SIZE = 43;
    public static final int EOJ_DATASET_ITEMS_NOT_ALLOCATED = 44;
    public static final int EOJ_BEYOND_BINDS_BATCH = 45;
    public static final int EOJ_INVALID_RANK = 46;
    public static final int EOJ_TDS_FORMAT_ERROR = 47;
    public static final int EOJ_UNDEFINED_TYPE = 48;
    public static final int EOJ_INCONSISTENT_ADT = 49;
    public static final int EOJ_NOSUCHELEMENT = 50;
    public static final int EOJ_NOT_AN_OBJECT_TYPE = 51;
    public static final int EOJ_INVALID_REF = 52;
    public static final int EOJ_INVALID_SIZE = 53;
    public static final int EOJ_INVALID_LOB_LOCATOR = 54;
    public static final int EOJ_FAIL_CONVERSION_CHARACTER = 55;
    public static final int EOJ_UNSUPPORTED_CHARSET = 56;
    public static final int EOJ_CLOSED_LOB = 57;
    public static final int EOJ_INVALID_NLS_RATIO = 58;
    public static final int EOJ_CONVERSION_JAVA_ERROR = 59;
    public static final int EOJ_FAIL_CREATE_DESC = 60;
    public static final int EOJ_NO_DESCRIPTOR = 61;
    public static final int EOJ_INVALID_REF_CURSOR = 62;
    public static final int EOJ_NOT_IN_A_TRANSACTION = 63;
    public static final int EOJ_DATABASE_IS_NULL = 64;
    public static final int EOJ_CONV_WAS_NULL = 65;
    public static final int EOJ_ACCESS_SPECIFIC_IMPL = 66;
    public static final int EOJ_INVALID_URL = 67;
    public static final int EOJ_INVALID_ARGUMENTS = 68;
    public static final int EOJ_USE_XA_EXPLICIT = 69;
    public static final int EOJ_INVALID_DATASIZE_LENGTH = 70;
    public static final int EOJ_EXCEEDED_VARRAY_LENGTH = 71;
    public static final int EOJ_VALUE_TOO_BIG = 72;
    public static final int EOJ_LOGICAL_CONN_CLOSED = 73;
    public static final int EOJ_INVALID_NAME_PATTERN = 74;
    public static final int EOJ_INVALID_FORWARD_RSET_OP = 75;
    public static final int EOJ_INVALID_READONLY_RSET_OP = 76;
    public static final int EOJ_FAIL_REF_SETVALUE = 77;
    public static final int EOJ_CONNECTIONS_ALREADY_EXIST = 78;
    public static final int EOJ_USER_CREDENTIALS_FAIL = 79;
    public static final int EOJ_INVALID_BATCH_COMMAND = 80;
    public static final int EOJ_BATCH_ERROR = 81;
    public static final int EOJ_NO_CURRENT_ROW = 82;
    public static final int EOJ_NOT_ON_INSERT_ROW = 83;
    public static final int EOJ_ON_INSERT_ROW = 84;
    public static final int EOJ_UPDATE_CONFLICTS = 85;
    public static final int EOJ_NULL_INSERET_ROW_VALUE = 86;
    public static final int WARN_IGNORE_FETCH_DIRECTION = 87;
    public static final int EOJ_UNSUPPORTED_SYNTAX = 88;
    public static final int EOJ_INTERNAL_ERROR = 89;
    public static final int EOJ_OPER_NOT_ALLOWED = 90;
    public static final int WARN_ALTERNATE_RSET_TYPE = 91;
    public static final int EOJ_NO_JDBC_AT_END_OF_CALL = 92;
    public static final int TTC_ERR_BASE = 400;
    public static final int TTC0000 = 401;
    public static final int TTC0001 = 402;
    public static final int TTC0002 = 403;
    public static final int TTC0003 = 404;
    public static final int TTC0004 = 405;
    public static final int TTC0005 = 406;
    public static final int TTC0100 = 407;
    public static final int TTC0101 = 408;
    public static final int TTC0102 = 409;
    public static final int TTC0103 = 410;
    public static final int TTC0104 = 411;
    public static final int TTC0105 = 412;
    public static final int TTC0106 = 413;
    public static final int TTC0107 = 414;
    public static final int TTC0108 = 415;
    public static final int TTC0109 = 416;
    public static final int TTC0110 = 417;
    public static final int TTC0111 = 418;
    public static final int TTC0112 = 419;
    public static final int TTC0113 = 420;
    public static final int TTC0114 = 421;
    public static final int TTC0115 = 422;
    public static final int TTC0116 = 423;
    public static final int TTC0117 = 424;
    public static final int TTC0118 = 425;
    public static final int TTC0119 = 426;
    public static final int TTC0120 = 427;
    public static final int TTC0200 = 428;
    public static final int TTC0201 = 429;
    public static final int TTC0202 = 430;
    public static final int TTC0203 = 431;
    public static final int TTC0204 = 432;
    public static final int TTC0205 = 433;
    public static final int TTC0206 = 434;
    public static final int TTC0207 = 435;
    public static final int TTC0208 = 436;
    public static final int TTC0209 = 437;
    public static final int TTC0210 = 438;
    public static final int TTC0211 = 439;
    public static final int TTC0212 = 440;
    public static final int TTC0213 = 441;
    public static final int TTC0214 = 442;
    public static final int TTC0216 = 443;
    public static final int TTC0217 = 444;

    public static void throwSqlException(String string, String string2, int n) throws SQLException {
        if (OracleLog.TRACE) {
            String string3 = "DBError.throwSqlException(reason=\"" + string + "\", SQLState=" + string2 + ", vendorCode=" + n + ")";
            OracleLog.print(null, 1, 4, 16, string3);
        }
        throw new SQLException(string, string2, n);
    }

    public static void throwSqlException(int n, Object object) throws SQLException {
        String string;
        if (OracleLog.TRACE) {
            string = "DBError.throwSqlException(errNum=" + n + ", obj=" + object + ")";
            OracleLog.print(null, 1, 4, 16, string);
        }
        if (n == 0 || n == 13) {
            return;
        }
        string = DBError.findMessage(n, object);
        if (n >= 500 && OracleLog.TRACE) {
            String string2 = "Error number " + n + " is out of range";
            OracleLog.print(null, 1, 4, 8, string2);
        }
        int n2 = 17000 + n;
        if (OracleLog.TRACE) {
            String string3 = "DBError.throwSqlException(reason=\"" + string + "\", SQLState=" + null + ", vendorCode=" + n2 + ")";
            OracleLog.print(null, 1, 4, 16, string3);
        }
        throw new SQLException(string, null, n2);
    }

    public static void throwSqlException(SQLException sQLException, int n, Object object) throws SQLException {
        String string;
        if (OracleLog.TRACE) {
            string = "DBError.throwSqlException(errNum=" + n + ", obj=" + object + ")";
            OracleLog.print(null, 1, 4, 16, string);
        }
        if (n == 0 || n == 13) {
            return;
        }
        string = DBError.findMessage(n, object);
        if (n >= 500 && OracleLog.TRACE) {
            String string2 = "Error number " + n + " is out of range";
            OracleLog.print(null, 1, 4, 8, string2);
        }
        int n2 = 17000 + n;
        SQLException sQLException2 = new SQLException(string, null, n2);
        sQLException2.setNextException(sQLException);
        throw sQLException2;
    }

    public static void throwSqlException(int n) throws SQLException {
        DBError.throwSqlException(n, null);
    }

    public static void throwSqlException(IOException iOException) throws SQLException {
        int n;
        int n2;
        String string;
        String string2 = iOException.getMessage();
        int n3 = 0;
        if (OracleLog.TRACE) {
            string = "DBError.throwSqlException(e=\"" + string2 + "\")";
            OracleLog.print(null, 1, 4, 16, string);
        }
        if ((n2 = string2.indexOf("ORA-")) != -1 && (n = string2.indexOf(":")) != -1) {
            n2 += 4;
            try {
                n3 = Integer.parseInt(string2.substring(n2, n));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            if (OracleLog.TRACE) {
                OracleLog.print(null, 1, 4, 8, "Unable to find ORA number from exception");
            }
            DBError.throwSqlException(2, string2);
        }
        if (OracleLog.TRACE) {
            string = "DBError.throwSqlException(reason=\"" + string2 + "\", SQLState=" + null + ", vendorCode=" + n3 + ")";
            OracleLog.print(null, 1, 4, 16, string);
        }
        throw new SQLException(string2, null, n3);
    }

    public static void addSqlException(SQLException sQLException, String string, String string2, int n) {
        Object object;
        if (OracleLog.TRACE) {
            object = "DBError.addSqlException(ex, \"" + string + "\", SQLState=" + string2 + ", vendorCode=" + n + ")";
            OracleLog.print(null, 1, 4, 16, (String)object);
        }
        object = new SQLException(string, string2, n);
        sQLException.setNextException((SQLException)object);
    }

    public static void throwBatchUpdateException(String string, String string2, int n, int n2, int[] nArray) throws BatchUpdateException {
        String string3;
        int n3 = 0;
        int[] nArray2 = null;
        if (OracleLog.TRACE) {
            string3 = "DBError.throwBatchUpdateException(reason=\"" + string + "\", SQLState=" + string2 + ", vendorCode=" + n + ", nSuccess=" + n2 + ", updateCounts)";
            OracleLog.print(null, 1, 4, 16, string3);
        }
        if (n2 < 0) {
            if (OracleLog.TRACE) {
                string3 = "Invalid argument nSuccess of " + n2 + " (expected >= 0)";
                OracleLog.print(null, 1, 4, 2, string3);
            }
            n2 = 0;
        }
        if (nArray == null) {
            nArray2 = new int[]{};
        } else if (n2 >= nArray.length) {
            nArray2 = nArray;
        } else {
            nArray2 = new int[n2];
            n3 = 0;
            while (n3 < n2) {
                nArray2[n3] = nArray[n3];
                ++n3;
            }
        }
        throw new BatchUpdateException(string, string2, n, nArray2);
    }

    public static void throwBatchUpdateException(int n, Object object, int n2, int[] nArray) throws BatchUpdateException {
        String string;
        if (OracleLog.TRACE) {
            string = "DBError.throwBatchUpdateException(errNum=" + n + ", obj=" + object + ", nSuccess=" + n2 + ", updateCounts)";
            OracleLog.print(null, 1, 4, 16, string);
        }
        if (n == 0) {
            return;
        }
        string = DBError.findMessage(n, object);
        if (n >= 500 && OracleLog.TRACE) {
            String string2 = "Error number " + n + " is out of range";
            OracleLog.print(null, 1, 4, 8, string2);
        }
        int n3 = 17000 + n;
        DBError.throwBatchUpdateException(string, null, n3, n2, nArray);
    }

    public static void throwBatchUpdateException(int n, int n2, int[] nArray) throws BatchUpdateException {
        DBError.throwBatchUpdateException(n, null, n2, nArray);
    }

    public static void SQLToIOException(SQLException sQLException) throws IOException {
        throw new IOException(sQLException.getMessage());
    }

    static String findMessage(int n, Object object) {
        String string;
        String string2;
        block9: {
            string2 = null;
            string = null;
            if (OracleLog.TRACE) {
                String string3 = "DBError.findMessage(errNum=" + n + ", obj=" + object + ")";
                OracleLog.print(null, 1, 4, 16, string3);
            }
            if (!m_loadedMessages) {
                String string4;
                try {
                    try {
                        m_message = (Message)Class.forName(m_msgClassName).newInstance();
                        m_loadedMessages = true;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    Object var5_6 = null;
                    if (m_loadedMessages || !OracleLog.TRACE) break block9;
                    string4 = "Failed to load class " + m_msgClassName;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (!m_loadedMessages && OracleLog.TRACE) {
                        String string5 = "Failed to load class " + m_msgClassName;
                        OracleLog.print(null, 1, 4, 8, string5);
                    }
                    throw throwable;
                }
                OracleLog.print(null, 1, 4, 8, string4);
            }
        }
        string2 = DBError.getMsgKey(n);
        string = m_message == null ? (object == null ? String.valueOf(string2) + ": (no message for error)" : String.valueOf(string2) + ": (no message for error) " + object) : m_message.msg(string2, object);
        return string;
    }

    public static SQLWarning newSqlWarning(String string, String string2, int n) throws SQLException {
        return DBError.addSqlWarning(null, string, string2, n);
    }

    public static SQLWarning newSqlWarning(int n, Object object) throws SQLException {
        return DBError.addSqlWarning(null, n, object);
    }

    public static SQLWarning newSqlWarning(int n) throws SQLException {
        return DBError.addSqlWarning(null, n, null);
    }

    public static SQLWarning addSqlWarning(SQLWarning sQLWarning, String string, String string2, int n) throws SQLException {
        Object object;
        if (OracleLog.TRACE) {
            object = "DBError.newSqlWarning(reason=\"" + string + "\", SQLState=" + string2 + ", vendorCode=" + n + ")";
            OracleLog.print(null, 1, 4, 16, (String)object);
        }
        object = new SQLWarning(string, string2, n);
        if (sQLWarning != null) {
            sQLWarning.setNextWarning((SQLWarning)object);
            return sQLWarning;
        }
        return object;
    }

    public static SQLWarning addSqlWarning(SQLWarning sQLWarning, int n, Object object) throws SQLException {
        String string;
        if (OracleLog.TRACE) {
            string = "DBError.newSqlWarning(errNum=" + n + ", obj=" + object + ")";
            OracleLog.print(null, 1, 4, 16, string);
        }
        if (n == 0 || n == 13) {
            return sQLWarning;
        }
        string = DBError.findMessage(n, object);
        if (n >= 500 && OracleLog.TRACE) {
            String string2 = "Error number " + n + " is out of range";
            OracleLog.print(null, 1, 4, 8, string2);
        }
        int n2 = 17000 + n;
        return DBError.addSqlWarning(sQLWarning, "Warning: " + string, null, n2);
    }

    public static SQLWarning addSqlWarning(SQLWarning sQLWarning, int n) throws SQLException {
        return DBError.addSqlWarning(sQLWarning, n, null);
    }

    public static void check_error(IOException iOException) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, 1, 4, 16, "DBError.check_error(e)");
        }
        DBError.throwSqlException(iOException);
    }

    public static void check_error(int n, Object object) throws SQLException {
        if (OracleLog.TRACE) {
            String string = "DBError.check_error(errNum=" + n + ", obj=" + object + ")";
            OracleLog.print(null, 1, 4, 16, string);
        }
        DBError.throwSqlException(n, object);
    }

    public static void check_error(int n) throws SQLException {
        if (OracleLog.TRACE) {
            String string = "DBError.check_error(errNum=" + n + ")";
            OracleLog.print(null, 1, 4, 16, string);
        }
        DBError.throwSqlException(n, null);
    }

    public static String ErrorToSQLState(int n) {
        int n2 = 0;
        while (n2 < mappings.length) {
            if (n == DBError.mappings[n2].err) {
                return DBError.mappings[n2].SQLState;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < ranges.length) {
            if (n > DBError.ranges[n3].low && n <= DBError.ranges[n3].high) {
                return DBError.ranges[n3].SQLState;
            }
            ++n3;
        }
        return "99999";
    }

    static int getVendorCode(int n) {
        if (n >= 500 && OracleLog.TRACE) {
            String string = "Error number " + n + " is out of range";
            OracleLog.print(null, 1, 4, 8, string);
        }
        return 17000 + n;
    }

    static String getMsgKey(int n) {
        if (n >= 500 && OracleLog.TRACE) {
            String string = "Error number " + n + " is out of range";
            OracleLog.print(null, 1, 4, 8, string);
        }
        int n2 = 17000 + n;
        String string = "ORA-" + Integer.toString(n2);
        return string;
    }

    public static void test() {
        OracleLog.config(0, 1, 32);
        OracleLog.setSubmodMask(1, 4);
        OracleLog.setLogStream(System.out);
        try {
            if (OracleLog.TRACE) {
                OracleLog.print(null, 1, 4, 16, "DBError.throwSqlException(reason=\"exception_message_1\", SQLState=sql_state_1, vendorCode=" + 25 + ")");
            }
            throw new SQLException("exception_message_1", "sql_state_1", 25);
        }
        catch (SQLException sQLException) {
            IOException iOException;
            OracleLog.print(null, 1, 4, 32, "SQLException:");
            String string = "  message  = \"" + sQLException.getMessage() + "\"";
            OracleLog.print(null, 1, 4, 32, string);
            string = "  SQLState = \"" + sQLException.getSQLState() + "\"";
            OracleLog.print(null, 1, 4, 32, string);
            string = "  errCode  = " + sQLException.getErrorCode();
            OracleLog.print(null, 1, 4, 32, string);
            try {
                DBError.throwSqlException(412, new String("object_string"));
            }
            catch (SQLException sQLException2) {
                OracleLog.print(null, 1, 4, 32, "SQLException:");
                string = "  message  = \"" + sQLException2.getMessage() + "\"";
                OracleLog.print(null, 1, 4, 32, string);
                string = "  SQLState = \"" + sQLException2.getSQLState() + "\"";
                OracleLog.print(null, 1, 4, 32, string);
                string = "  errCode  = " + sQLException2.getErrorCode();
                OracleLog.print(null, 1, 4, 32, string);
            }
            try {
                DBError.throwSqlException(6, null);
            }
            catch (SQLException sQLException3) {
                OracleLog.print(null, 1, 4, 32, "SQLException:");
                string = "  message  = \"" + sQLException3.getMessage() + "\"";
                OracleLog.print(null, 1, 4, 32, string);
                string = "  SQLState = \"" + sQLException3.getSQLState() + "\"";
                OracleLog.print(null, 1, 4, 32, string);
                string = "  errCode  = " + sQLException3.getErrorCode();
                OracleLog.print(null, 1, 4, 32, string);
            }
            try {
                DBError.throwSqlException(999, null);
            }
            catch (SQLException sQLException4) {
                OracleLog.print(null, 1, 4, 32, "SQLException:");
                string = "  message  = \"" + sQLException4.getMessage() + "\"";
                OracleLog.print(null, 1, 4, 32, string);
                string = "  SQLState = \"" + sQLException4.getSQLState() + "\"";
                OracleLog.print(null, 1, 4, 32, string);
                string = "  errCode  = " + sQLException4.getErrorCode();
                OracleLog.print(null, 1, 4, 32, string);
            }
            try {
                DBError.throwSqlException(13, null);
            }
            catch (SQLException sQLException5) {
                OracleLog.print(null, 1, 4, 32, "SQLException:");
                string = "  message  = \"" + sQLException5.getMessage() + "\"";
                OracleLog.print(null, 1, 4, 32, string);
                string = "  SQLState = \"" + sQLException5.getSQLState() + "\"";
                OracleLog.print(null, 1, 4, 32, string);
                string = "  errCode  = " + sQLException5.getErrorCode();
                OracleLog.print(null, 1, 4, 32, string);
            }
            try {
                iOException = new IOException("ORA-00601: cleanup lock conflict");
                DBError.throwSqlException(iOException);
            }
            catch (SQLException sQLException6) {
                OracleLog.print(null, 1, 4, 32, "SQLException:");
                string = "  message  = \"" + sQLException6.getMessage() + "\"";
                OracleLog.print(null, 1, 4, 32, string);
                string = "  SQLState = \"" + sQLException6.getSQLState() + "\"";
                OracleLog.print(null, 1, 4, 32, string);
                string = "  errCode  = " + sQLException6.getErrorCode();
                OracleLog.print(null, 1, 4, 32, string);
            }
            try {
                iOException = new IOException("some unknown io exception");
                DBError.throwSqlException(iOException);
                return;
            }
            catch (SQLException sQLException7) {
                OracleLog.print(null, 1, 4, 32, "SQLException:");
                string = "  message  = \"" + sQLException7.getMessage() + "\"";
                OracleLog.print(null, 1, 4, 32, string);
                string = "  SQLState = \"" + sQLException7.getSQLState() + "\"";
                OracleLog.print(null, 1, 4, 32, string);
                string = "  errCode  = " + sQLException7.getErrorCode();
                OracleLog.print(null, 1, 4, 32, string);
                return;
            }
        }
    }

    public static void printSqlException(SQLException sQLException) {
        OracleLog.print(null, 1, 4, 32, "SQLException:");
        String string = "  message  = \"" + sQLException.getMessage() + "\"";
        OracleLog.print(null, 1, 4, 32, string);
        string = "  SQLState = \"" + sQLException.getSQLState() + "\"";
        OracleLog.print(null, 1, 4, 32, string);
        string = "  errCode  = " + sQLException.getErrorCode();
        OracleLog.print(null, 1, 4, 32, string);
    }

    static {
        m_message = null;
        m_msgClassName = "oracle.jdbc.dbaccess.Message11";
        mappings = new SQLStateMapping[]{new SQLStateMapping(0, "00000"), new SQLStateMapping(1, "23000"), new SQLStateMapping(22, "42000"), new SQLStateMapping(100, "02000"), new SQLStateMapping(251, "42000"), new SQLStateMapping(1025, "22023"), new SQLStateMapping(1031, "42000"), new SQLStateMapping(1095, "02000"), new SQLStateMapping(1402, "44000"), new SQLStateMapping(1403, "02000"), new SQLStateMapping(1405, "22002"), new SQLStateMapping(1406, "22001"), new SQLStateMapping(1410, "24000"), new SQLStateMapping(1411, "22022"), new SQLStateMapping(1422, "21000"), new SQLStateMapping(1424, "22025"), new SQLStateMapping(1425, "22019"), new SQLStateMapping(1426, "22003"), new SQLStateMapping(1427, "21000"), new SQLStateMapping(1438, "22003"), new SQLStateMapping(1455, "22003"), new SQLStateMapping(1457, "22003"), new SQLStateMapping(1476, "22012"), new SQLStateMapping(1488, "22023"), new SQLStateMapping(8006, "24000")};
        ranges = new SQLStateRange[]{new SQLStateRange(17, 21, "61000"), new SQLStateRange(23, 35, "61000"), new SQLStateRange(49, 68, "61000"), new SQLStateRange(100, 120, "62000"), new SQLStateRange(149, 159, "63000"), new SQLStateRange(199, 369, "64000"), new SQLStateRange(369, 429, "60000"), new SQLStateRange(429, 439, "67000"), new SQLStateRange(439, 569, "62000"), new SQLStateRange(569, 599, "69000"), new SQLStateRange(599, 899, "60000"), new SQLStateRange(899, 999, "42000"), new SQLStateRange(999, 1099, "72000"), new SQLStateRange(1000, 1003, "24000"), new SQLStateRange(1099, 1250, "64000"), new SQLStateRange(1399, 1401, "23000"), new SQLStateRange(1401, 1478, "72000"), new SQLStateRange(1478, 1480, "22024"), new SQLStateRange(1480, 1489, "72000"), new SQLStateRange(1489, 1493, "42000"), new SQLStateRange(1493, 1499, "72000"), new SQLStateRange(1499, 1699, "72000"), new SQLStateRange(1699, 1799, "42000"), new SQLStateRange(1799, 1899, "22008"), new SQLStateRange(1899, 2099, "42000"), new SQLStateRange(2090, 2092, "40000"), new SQLStateRange(2139, 2289, "42000"), new SQLStateRange(2289, 2299, "23000"), new SQLStateRange(2375, 2399, "61000"), new SQLStateRange(2399, 2419, "72000"), new SQLStateRange(2419, 2424, "42000"), new SQLStateRange(2424, 2449, "72000"), new SQLStateRange(2449, 2499, "42000"), new SQLStateRange(2699, 2899, "63000"), new SQLStateRange(2999, 3099, "0A000"), new SQLStateRange(3099, 3199, "63000"), new SQLStateRange(3275, 3299, "42000"), new SQLStateRange(3999, 4019, "22023"), new SQLStateRange(4019, 4039, "61000"), new SQLStateRange(4039, 4059, "42000"), new SQLStateRange(4059, 4069, "72000"), new SQLStateRange(4069, 4099, "42000"), new SQLStateRange(5999, 6149, "66000"), new SQLStateRange(6199, 6249, "63000"), new SQLStateRange(6249, 6429, "66000"), new SQLStateRange(6429, 6449, "60000"), new SQLStateRange(6499, 6599, "65000"), new SQLStateRange(6510, 6511, "24000"), new SQLStateRange(6599, 6999, "66000"), new SQLStateRange(6999, 7199, "69000"), new SQLStateRange(7199, 7999, "60000"), new SQLStateRange(7999, 8190, "72000"), new SQLStateRange(9699, 9999, "60000"), new SQLStateRange(9999, 10999, "90000"), new SQLStateRange(11999, 12019, "72000"), new SQLStateRange(12299, 12499, "72000"), new SQLStateRange(12699, 21999, "72000"), new SQLStateRange(12099, 12299, "66000"), new SQLStateRange(12499, 12599, "66000")};
    }
}

