/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.PrintStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;

public class DBDataSet {
    public static final int DYNAMIC_ALLOC = 0;
    private OracleConnection m_connection;
    private boolean m_dynamic = false;
    private int m_arrayDepth;
    public DBData[] data;
    public DBType[] types;

    public DBDataSet(OracleConnection oracleConnection, int n) {
        if (OracleLog.TRACE) {
            OracleLog.print(oracleConnection, 2, 2, 16, "DBDataSet.DBDataSet(conn, nrows=" + n + ")");
        }
        this.m_connection = oracleConnection;
        this.m_dynamic = false;
        this.m_arrayDepth = n;
        this.data = null;
        this.types = null;
    }

    public DBDataSet(OracleConnection oracleConnection, int n, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(oracleConnection, 2, 2, 16, "DBDataSet.DBDataSet(conn, ncols=" + n + ", nrows=" + n2 + ")");
        }
        if (n2 < 0) {
            DBError.throwSqlException(89, "argument nrows is " + n2);
        }
        if (n2 == 0) {
            this.m_dynamic = true;
            this.m_arrayDepth = 0;
        } else {
            this.m_dynamic = false;
            this.m_arrayDepth = n2;
        }
        this.m_connection = oracleConnection;
        this.data = new DBData[n];
        this.types = new DBType[n];
    }

    public final boolean isDynamic() {
        return this.m_dynamic;
    }

    public void transformToDynamic() {
        if (OracleLog.TRACE) {
            OracleLog.print(this.m_connection, 2, 2, 16, "DBDataSet.transformToDynamic()");
        }
        if ((this.data == null || this.types == null) && OracleLog.TRACE) {
            OracleLog.print(this.m_connection, 2, 2, 8, "Possible problem: data=" + this.data + ", types=" + this.types);
        }
        this.m_dynamic = true;
        this.m_arrayDepth = 0;
        this.cleanData();
        int n = 0;
        while (n < this.types.length) {
            this.allocData(n);
            ++n;
        }
    }

    public final void createArrayFromTypes(int n) throws SQLException {
        if (this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        if (this.types == null) {
            DBError.throwSqlException(21);
        }
        if (this.types.length == 0) {
            DBError.throwSqlException(21);
        }
        this.m_arrayDepth = n;
        int n2 = this.types.length;
        this.data = new DBData[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.data[n3] = new DBData(this.m_arrayDepth);
            ++n3;
        }
    }

    public final void allocData(int n) {
        if (this.data[n] != null) {
            return;
        }
        this.data[n] = this.m_dynamic ? new DBData() : new DBData(this.m_arrayDepth);
    }

    public final void allocDataAndItems(int n) throws SQLException {
        if (this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this.allocData(n);
        this.allocItemsAndBuffers(n);
    }

    private void allocItemsAndBuffers(int n) throws SQLException {
        int n2 = 0;
        int n3 = this.data[n].getNItems();
        DBType dBType = this.types[n];
        n2 = 0;
        while (n2 < n3) {
            this.data[n].setItem(n2, this.m_connection.db_access.createDBItem(dBType));
            if (!dBType.is_stream && dBType.type != 109 && dBType.type != 111) {
                this.data[n].getItem(n2).allocBuffer();
            }
            ++n2;
        }
    }

    public final DBItem getDBItem(int n, int n2) throws SQLException {
        if (this.data == null || this.data[n] == null) {
            return null;
        }
        return this.data[n].getItem(n2);
    }

    public final void setDBItem(DBItem dBItem, int n, int n2) throws SQLException {
        if (this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        if (this.data[n] == null) {
            DBError.throwSqlException(44);
        }
        this.data[n].setItem(n2, dBItem);
    }

    public final int addDBItem(DBItem dBItem, int n) throws SQLException {
        if (!this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        if (this.data[n] == null) {
            DBError.throwSqlException(44);
        }
        return this.data[n].addItem(dBItem);
    }

    public final void setRowItems(int n, DBItem dBItem) throws SQLException {
        if (this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this.data[n].setItem(0, dBItem);
        int n2 = 1;
        while (n2 < this.m_arrayDepth) {
            DBItem dBItem2 = dBItem.clone(this.types[n], this.m_connection.db_access);
            this.data[n].setItem(n2, dBItem2);
            ++n2;
        }
    }

    public final DBData getData(int n) {
        if (this.data.length < n) {
            return null;
        }
        return this.data[n];
    }

    public final byte[] getBytes(int n, int n2) throws SQLException {
        if (this.data.length < n) {
            return null;
        }
        return this.data[n].getItem(n2).getBytes();
    }

    public final boolean isNull(int n, int n2) throws SQLException {
        return this.data[n].getItem((int)n2).is_null;
    }

    public final DBType getType(int n) {
        if (this.types != null && n >= 0 && n < this.types.length) {
            return this.types[n];
        }
        return null;
    }

    public final void setType(int n, DBType dBType) {
        if (this.types != null && n >= 0 && n < this.types.length) {
            this.types[n] = dBType;
        }
    }

    public final void clearItems() {
        if (this.data == null) {
            return;
        }
        int n = 0;
        while (n < this.data.length) {
            if (this.data[n] != null) {
                this.data[n].clearItems();
            }
            ++n;
        }
    }

    public final void cleanup() {
        this.cleanTypes();
        this.types = null;
        this.cleanData();
        this.data = null;
    }

    private final void cleanTypes() {
        if (this.types != null) {
            int n = 0;
            while (n < this.types.length) {
                this.types[n] = null;
                ++n;
            }
        }
    }

    private final void cleanData() {
        if (this.data != null) {
            int n = 0;
            while (n < this.data.length) {
                if (this.data[n] != null) {
                    this.data[n].cleanup();
                    this.data[n] = null;
                }
                ++n;
            }
        }
    }

    public final void print(PrintStream printStream) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(2, 2, 32, "Printing " + this.getInfoString());
        }
    }

    public final String getInfoString() throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(String.valueOf(this) + "\n" + "  DBDataSet.m_dynamic=" + this.m_dynamic + "\n" + "  DBDataSet.m_arrayDepth=" + this.m_arrayDepth + " (valid only when m_dynamic=false)\n");
        if (this.types == null) {
            stringBuffer.append("  DBDataSet.types is null");
        } else {
            stringBuffer.append("  DBDataSet.types.length=" + this.types.length);
            n = 0;
            while (n < this.types.length) {
                if (this.types[n] == null) {
                    stringBuffer.append("\n    types[" + n + "]=null");
                } else {
                    stringBuffer.append("\n    types[" + n + "].type=" + DBType.getStringType(this.types[n].type) + " (max_length=" + this.types[n].max_length + ")");
                }
                ++n;
            }
        }
        stringBuffer.append("\n");
        if (this.data == null) {
            stringBuffer.append("  DBDataSet.data is null");
        } else {
            stringBuffer.append("  DBDataSet.data.length=" + this.data.length);
            n = 0;
            while (n < this.data.length) {
                if (this.data[n] == null) {
                    stringBuffer.append("\n    data[" + n + "]=null");
                } else {
                    int n2 = 0;
                    while (n2 < this.data[n].getNItems()) {
                        DBItem dBItem = this.data[n].getItem(n2);
                        if (dBItem == null) {
                            stringBuffer.append("\n    data[" + n + "].items[" + n2 + "]=null");
                        } else {
                            stringBuffer.append("\n    data[" + n + "].items[" + n2 + "] has " + dBItem.data_size + " bytes:\n");
                            if (dBItem.byte_value != null) {
                                stringBuffer.append(OracleLog.bytesToFormattedStr(dBItem.byte_value, dBItem.data_size, "    "));
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

