/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.driver.OracleLog;

public class DBData {
    private boolean m_dynamic = false;
    private DBItem[] m_items;
    private Vector m_vector;

    public DBData(int n) {
        if (OracleLog.TRACE) {
            OracleLog.print(2, 2, 16, "DBData.DBData(nItems=" + n + ")");
        }
        this.m_dynamic = false;
        this.m_items = new DBItem[n];
    }

    public void setItem(int n, DBItem dBItem) throws SQLException {
        if (this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this.checkItemNumber(n);
        this.m_items[n] = dBItem;
    }

    public DBData() {
        if (OracleLog.TRACE) {
            OracleLog.print(2, 2, 16, "DBData.DBData()");
        }
        this.m_dynamic = true;
        this.m_vector = new Vector();
    }

    public int addItem(DBItem dBItem) throws SQLException {
        if (!this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this.m_vector.addElement(dBItem);
        return this.m_vector.size();
    }

    public void removeFirstItem() throws SQLException {
        if (!this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this.m_vector.removeElementAt(0);
    }

    public final boolean isDynamic() {
        return this.m_dynamic;
    }

    public final void clearItems() {
        if (this.m_dynamic) {
            if (this.m_vector != null) {
                this.m_vector.removeAllElements();
                return;
            }
        } else if (this.m_items != null) {
            int n = 0;
            while (n < this.m_items.length) {
                this.m_items[n] = null;
                ++n;
            }
        }
    }

    public final void cleanup() {
        if (OracleLog.TRACE) {
            OracleLog.print(2, 2, 16, "DBData.cleanup()");
        }
        this.clearItems();
        this.m_vector = null;
        this.m_items = null;
    }

    public int getNItems() {
        if (this.m_dynamic) {
            return this.m_vector.size();
        }
        return this.m_items.length;
    }

    public DBItem getItem(int n) throws SQLException {
        DBItem dBItem = null;
        if (this.m_dynamic) {
            if (n < 0) {
                DBError.throwSqlException(46);
            } else {
                dBItem = n >= this.getNItems() ? null : (DBItem)this.m_vector.elementAt(n);
            }
        } else {
            this.checkItemNumber(n);
            dBItem = this.m_items[n];
        }
        return dBItem;
    }

    private void checkItemNumber(int n) throws SQLException {
        if (n < 0 || n >= this.getNItems()) {
            if (OracleLog.TRACE) {
                OracleLog.print(2, 2, 2, "Invalid item number " + n + " (range 0.." + this.getNItems() + ")");
            }
            DBError.throwSqlException(46);
        }
    }
}

