/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.util.RepConversion;
import oracle.sql.CharacterSet;
import oracle.sql.NUMBER;

public class DBConversion {
    public static final short DBCS_CHARSET = -1;
    public static final short UCS2_CHARSET = -5;
    public static final short ASCII_CHARSET = 1;
    public static final short ISO_LATIN_1_CHARSET = 31;
    public static final short AL24UTFFSS_CHARSET = 870;
    public static final short UTF8_CHARSET = 871;
    protected short m_dbCharSet;
    protected short m_charSet;
    private CharacterSet m_databaseCs;
    private CharacterSet m_accessCs;
    private CharacterSet m_asciiCs;

    public DBConversion(short s, short s2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.DBConversion( svrCharSet=" + s + ", accessCharSet=" + s2 + ")");
        }
        switch (s2) {
            default: {
                DBConversion.unexpectedCharset(s2);
            }
            case -5: 
            case -1: 
            case 1: 
            case 31: 
            case 870: 
            case 871: 
        }
        this.m_dbCharSet = s;
        this.m_charSet = s2;
        this.m_databaseCs = CharacterSet.make(this.m_dbCharSet);
        if (s2 == -1) {
            this.m_accessCs = this.m_databaseCs;
            return;
        }
        this.m_accessCs = CharacterSet.make(this.m_charSet);
    }

    public short getDbCharSet() {
        return this.m_dbCharSet;
    }

    public short getAccessCharSet() {
        if (this.m_charSet == -1) {
            return this.m_dbCharSet;
        }
        return this.m_charSet;
    }

    public CharacterSet getDbCharSetObj() {
        return this.m_databaseCs;
    }

    public CharacterSet getAccessCharSetObj() {
        return this.m_accessCs;
    }

    public static boolean isAccessCharSetSupported(short s) {
        boolean bl = false;
        switch (s) {
            case -5: 
            case -1: 
            case 1: 
            case 31: 
            case 870: 
            case 871: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static byte[] stringToAccessCharBytes(String string, short s) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.stringToAcessCharBytes(str, charset=" + s + ")");
            OracleLog.print(4, 64, OracleLog.bytesToPrintableForm("UCS-2 bytes", OracleLog.strToUcs2Bytes(string)));
        }
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        switch (s) {
            case -5: {
                byArray = DBConversion.stringToUcs2Bytes(string);
                break;
            }
            case 1: 
            case 31: {
                byArray = DBConversion.stringToAsciiBytes(string);
                break;
            }
            case 870: 
            case 871: {
                byArray = DBConversion.stringToUtf8Bytes(string);
                break;
            }
            default: {
                DBConversion.unexpectedCharset(s);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(4, 64, OracleLog.bytesToPrintableForm("DBAccess bytes", byArray));
        }
        return byArray;
    }

    public byte[] StringToCharBytes(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.StringToCharBytes(str)");
        }
        if (this.m_charSet == -1) {
            byte[] byArray = this.m_databaseCs.convertWithReplacement(string);
            if (OracleLog.TRACE) {
                OracleLog.print(4, 64, OracleLog.bytesToPrintableForm("UCS-2 bytes", OracleLog.strToUcs2Bytes(string)));
                OracleLog.print(4, 64, OracleLog.bytesToPrintableForm("DBAccess bytes", byArray));
            }
            return byArray;
        }
        return DBConversion.stringToAccessCharBytes(string, this.m_charSet);
    }

    public String CharBytesToString(byte[] byArray, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.CharBytesToString(bytes[], nbytes=" + n + ")");
            OracleLog.print(4, 64, OracleLog.bytesToPrintableForm("DBAccess bytes:", byArray, n));
        }
        String string = null;
        switch (this.m_charSet) {
            case -5: {
                string = DBConversion.ucs2BytesToString(byArray, n);
                break;
            }
            case 1: 
            case 31: {
                string = new String(byArray, 0, 0, n);
                break;
            }
            case 870: 
            case 871: {
                string = DBConversion.utf8BytesToString(byArray, n);
                break;
            }
            case -1: {
                string = this.m_databaseCs.toStringWithReplacement(byArray, 0, n);
                break;
            }
            default: {
                DBConversion.unexpectedCharset(this.m_charSet);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(4, 64, OracleLog.bytesToPrintableForm("UCS-2 bytes", OracleLog.strToUcs2Bytes(string)));
        }
        return string;
    }

    public int javaCharsToCHARBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        int n2 = 0;
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.javaCharsToCHARBytes(chars[], nchars=" + n + ", bytes[])");
            OracleLog.print(4, 64, OracleLog.bytesToPrintableForm("UCS-2 bytes", OracleLog.charsToUcs2Bytes(cArray, n)));
        }
        switch (this.m_charSet) {
            case -5: {
                n2 = DBConversion.javaCharsToUcs2Bytes(cArray, n, byArray);
                break;
            }
            case 1: 
            case 31: {
                n2 = DBConversion.javaCharsToAsciiBytes(cArray, n, byArray);
                break;
            }
            case 870: 
            case 871: {
                n2 = DBConversion.javaCharsToUtf8Bytes(cArray, n, byArray);
                break;
            }
            case -1: {
                n2 = this.javaCharsToDbCsBytes(cArray, n, byArray);
                break;
            }
            default: {
                DBConversion.unexpectedCharset(this.m_charSet);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(4, 64, OracleLog.bytesToPrintableForm("DBAccess bytes:", byArray, n2));
        }
        return n2;
    }

    public char CHARBytesToJavaChar(byte[] byArray, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 64, "DBConversion.CHARBytesToJavaChar(bytes[], byteIndex=" + n + ")");
        }
        char[] cArray = new char[1];
        this.CHARBytesToJavaChar(byArray, n, cArray, 0);
        return cArray[0];
    }

    public int CHARBytesToJavaChar(byte[] byArray, int n, char[] cArray, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 64, "DBConversion.CHARBytesToJavaChar(bytes[], byteIndex=" + n + ", chars[], charIndex=" + n2 + ")");
        }
        char c = '\u0000';
        int n3 = 0;
        int n4 = 0;
        switch (this.m_charSet) {
            case -5: {
                c = (char)(byArray[n] << 8 | byArray[n + 1] & 0xFF);
                n3 = 2;
                break;
            }
            case 1: 
            case 31: {
                byte by = byArray[n];
                c = (char)(0xFF & by);
                n3 = 1;
                break;
            }
            case 870: 
            case 871: {
                c = DBConversion.utf8BytesToChar(byArray, n);
                n3 = DBConversion.getUtfLen(c);
                break;
            }
            default: {
                DBConversion.unexpectedCharset(this.m_charSet);
            }
        }
        cArray[n2] = c;
        n4 = n + n3;
        if (OracleLog.TRACE) {
            byte[] byArray2 = new byte[n3];
            int n5 = 0;
            while (n5 < n3) {
                byArray2[n5] = byArray[n + n5];
                ++n5;
            }
            char[] cArray2 = new char[]{c};
            OracleLog.print(4, 64, "DBAccess byte:        " + OracleLog.bytesToFormattedStr(byArray2, n3, null));
            OracleLog.print(4, 64, "UCS-2 character byte: " + OracleLog.bytesToFormattedStr(OracleLog.charsToUcs2Bytes(cArray2), 1, null));
        }
        return n4;
    }

    public int CHARBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        int n2 = 0;
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.CHARBytesToJavaChars(bytes[], nbytes=" + n + "chars[])");
            OracleLog.print(4, 64, OracleLog.bytesToPrintableForm("DBAccess bytes:", byArray, n));
        }
        switch (this.m_charSet) {
            case -5: {
                n2 = DBConversion.ucs2BytesToJavaChars(byArray, n, cArray);
                break;
            }
            case 1: 
            case 31: {
                n2 = DBConversion.asciiBytesToJavaChars(byArray, n, cArray);
                break;
            }
            case 870: 
            case 871: {
                n2 = DBConversion.utf8BytesToJavaChars(byArray, n, cArray);
                break;
            }
            case -1: {
                n2 = this.dbCsBytesToJavaChars(byArray, n, cArray);
                break;
            }
            default: {
                DBConversion.unexpectedCharset(this.m_charSet);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(4, 64, OracleLog.bytesToPrintableForm("UCS-2 bytes", OracleLog.charsToUcs2Bytes(cArray, n2)));
        }
        return n2;
    }

    public int CHARBytesToJavaChars(byte[] byArray, int[] nArray, char[] cArray) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.CHARBytesToJavaChars(bytes[], nbytes=" + nArray + "chars[])");
        }
        int n = 0;
        switch (this.m_charSet) {
            case -5: {
                n = DBConversion.ucs2BytesToJavaChars(byArray, nArray[0], cArray);
                nArray[0] = nArray[0] % 2;
                break;
            }
            case 1: 
            case 31: {
                n = DBConversion.asciiBytesToJavaChars(byArray, nArray[0], cArray);
                nArray[0] = 0;
                break;
            }
            case 870: 
            case 871: {
                n = DBConversion.utf8BytesToJavaChars(byArray, nArray, cArray);
                break;
            }
            case -1: {
                n = this.dbCsBytesToJavaChars(byArray, nArray[0], cArray);
                nArray[0] = 0;
                break;
            }
            default: {
                DBConversion.unexpectedCharset(this.m_charSet);
            }
        }
        return n;
    }

    public byte[] asciiBytesToCHARBytes(byte[] byArray) {
        byte[] byArray2 = null;
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.asciiBytesToCHARBytes(bytes[])");
            OracleLog.print(4, 64, OracleLog.bytesToPrintableForm("ASCII bytes:", byArray));
        }
        switch (this.m_charSet) {
            case -5: {
                byArray2 = new byte[byArray.length * 2];
                int n = 0;
                int n2 = 0;
                while (n < byArray.length) {
                    byArray2[n2++] = 0;
                    byArray2[n2++] = byArray[n];
                    ++n;
                }
                break;
            }
            case -1: {
                if (this.m_asciiCs == null) {
                    this.m_asciiCs = CharacterSet.make(1);
                }
                try {
                    byArray2 = this.m_databaseCs.convert(this.m_asciiCs, byArray, 0, byArray.length);
                }
                catch (SQLException sQLException) {
                    OracleLog.print(4, 8, "DBCS_CHARSET case got exception: " + sQLException.getMessage());
                }
                break;
            }
            default: {
                byArray2 = byArray;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(4, 64, OracleLog.bytesToPrintableForm("DBAccess bytes:", byArray2));
        }
        return byArray2;
    }

    public int javaCharsToDbCsBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        int n2 = 0;
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.javaCharsToDbCsBytes(chars[], nchars=" + n + ", bytes[])");
        }
        DBConversion.catchCharsLen(cArray, n);
        String string = new String(cArray, 0, n);
        byte[] byArray2 = this.m_databaseCs.convertWithReplacement(string);
        string = null;
        if (byArray2 != null) {
            n2 = byArray2.length;
            DBConversion.catchBytesLen(byArray, n2);
            int n3 = 0;
            while (n3 < n2) {
                byArray[n3] = byArray2[n3];
                ++n3;
            }
            byArray2 = null;
        }
        return n2;
    }

    public int dbCsBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        int n2 = 0;
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.dbCsBytesToJavaChars(bytes[], nbytes=" + n + ", chars[])");
        }
        DBConversion.catchBytesLen(byArray, n);
        String string = this.m_databaseCs.toStringWithReplacement(byArray, 0, n);
        if (string != null) {
            n2 = string.length();
            DBConversion.catchCharsLen(cArray, n2);
            string.getChars(0, n2, cArray, 0);
            string = null;
        }
        return n2;
    }

    public static byte[] stringToUcs2Bytes(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.stringToUcs2Bytes(str)");
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        byte[] byArray = new byte[2 * n];
        DBConversion.javaCharsToUcs2Bytes(cArray, n, byArray);
        return byArray;
    }

    public static String ucs2BytesToString(byte[] byArray, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.ucs2BytesToString(bytes[], nbytes=" + n + ")");
        }
        char[] cArray = new char[n / 2];
        DBConversion.ucs2BytesToJavaChars(byArray, n, cArray);
        return new String(cArray);
    }

    public static int javaCharsToUcs2Bytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.javaCharsToUcs2Bytes(chars[], nchars=" + n + ", bytes[])");
        }
        DBConversion.catchCharsLen(cArray, n);
        DBConversion.catchBytesLen(byArray, n * 2);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3++] = (byte)(cArray[n2] >> 8 & 0xFF);
            byArray[n3++] = (byte)(cArray[n2] & 0xFF);
            ++n2;
        }
        return n3;
    }

    public static char ucs2BytesToChar(byte[] byArray, int n) {
        return (char)(byArray[n] << 8 | byArray[n + 1] & 0xFF);
    }

    public static int ucs2BytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        int n2 = n / 2;
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.ucs2BytesToJavaChars(bytes[], nbytes=" + n + ", chars[])");
        }
        DBConversion.catchBytesLen(byArray, n);
        DBConversion.catchCharsLen(cArray, n2);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = byArray[n4++] << 8;
            cArray[n3] = (char)(n5 | byArray[n4++] & 0xFF);
            ++n3;
        }
        return n2;
    }

    public static byte[] stringToAsciiBytes(String string) {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.stringToAsciiBytes(str)");
        }
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, string.length(), byArray, 0);
        return byArray;
    }

    public static int javaCharsToAsciiBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.javaCharsToAsciiBytes(chars[], nchars=" + n + ", bytes[])");
        }
        DBConversion.catchCharsLen(cArray, n);
        DBConversion.catchBytesLen(byArray, n);
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)cArray[n2];
            ++n2;
        }
        return n;
    }

    public static int asciiBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.asciiBytesToJavaChars(bytes[], nbytes=" + n + ", chars[])");
        }
        DBConversion.catchBytesLen(byArray, n);
        DBConversion.catchCharsLen(cArray, n);
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            cArray[n2] = (char)(0xFF & by);
            ++n2;
        }
        return n;
    }

    private static char byteToChar(byte by) {
        return (char)(0xFF & by);
    }

    private static byte[] stringToUtf8Bytes(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.stringToUtf8Bytes(str)");
        }
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return DBConversion.javaCharsToUtf8Bytes(cArray);
    }

    private static int javaCharsToUtf8Bytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.javaCharsToUtf8Bytes(chars[], nchars=" + n + ", bytes[])");
        }
        int n2 = byArray.length;
        DBConversion.catchCharsLen(cArray, n);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if ((c & 0xFF80) == 0) {
                if (n4 >= n2) break;
                byArray[n4++] = (byte)c;
            } else if ((c & 0xF800) == 0) {
                if (n4 + 1 >= n2) break;
                byArray[n4++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
            } else {
                if (n4 + 2 >= n2) break;
                byArray[n4++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
            }
            ++n3;
        }
        if (n3 < n) {
            if (OracleLog.TRACE) {
                OracleLog.print(4, 2, "Output buffer of " + n2 + " bytes is too small for " + n + " characters");
            }
            DBError.check_error(39, "javaCharsToUtf8Bytes");
        }
        return n4;
    }

    private static byte[] javaCharsToUtf8Bytes(char[] cArray) {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.javaCharsToUtf8Bytes(chars[])");
        }
        int n = cArray.length;
        int n2 = DBConversion.stringUTFLength(cArray);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if ((c & 0xFF80) == 0) {
                byArray[n4++] = (byte)c;
            } else if ((c & 0xF800) == 0) {
                byArray[n4++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
            } else {
                byArray[n4++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
            }
            ++n3;
        }
        return byArray;
    }

    private static String utf8BytesToString(byte[] byArray, int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.utf8BytesToString(bytes[], nbytes=" + n + ")");
        }
        char[] cArray = new char[n];
        int n2 = DBConversion.utf8BytesToJavaChars(byArray, n, cArray);
        return new String(cArray, 0, n2);
    }

    private static char utf8BytesToChar(byte[] byArray, int n) throws SQLException {
        int n2 = n;
        int n3 = byArray.length;
        char c = '\u0000';
        if ((byArray[n2] & 0x80) == 0) {
            c = (char)byArray[n2];
        } else if ((byArray[n2] & 0x20) == 0) {
            if (n3 < n2 + 2 || (byArray[n2 + 1] & 0x80) != 128) {
                if (OracleLog.TRACE) {
                    OracleLog.print(4, 8, "Error occurred during the UTF-8 conversion process");
                }
                DBError.check_error(37, "failUTF8Conv");
            }
            c = (char)((byArray[n2] & 0x1F) << 6 | byArray[n2 + 1] & 0x3F);
        } else {
            if (n3 < n2 + 3 || (byArray[n2 + 1] & 0x80) != 128 || (byArray[n2 + 2] & 0x80) != 128) {
                if (OracleLog.TRACE) {
                    OracleLog.print(4, 8, "Error occurred during the UTF-8 conversion process");
                }
                DBError.check_error(37, "failUTF8Conv");
            }
            c = (char)((byArray[n2] & 0xF) << 12 | (byArray[n2 + 1] & 0x3F) << 6 | byArray[n2 + 2] & 0x3F);
        }
        return c;
    }

    private static int utf8BytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.utf8BytesToChars(bytes[], nbytes=" + n + ", chars[])");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (n2 >= cArray.length) {
                DBError.check_error(39, "JavaCharsToCHARBytes");
            }
            if ((byArray[n3] & 0x80) == 0) {
                cArray[n2] = (char)byArray[n3];
                ++n3;
            } else if ((byArray[n3] & 0x20) == 0) {
                if (n < n3 + 2 || (byArray[n3 + 1] & 0x80) != 128) {
                    if (OracleLog.TRACE) {
                        OracleLog.print(4, 8, "Error occurred during the UTF-8 conversion process");
                    }
                    DBError.check_error(37, "failUTF8Conv");
                }
                cArray[n2] = (char)((byArray[n3] & 0x1F) << 6 | byArray[n3 + 1] & 0x3F);
                n3 += 2;
            } else {
                if (n < n3 + 3 || (byArray[n3 + 1] & 0x80) != 128 || (byArray[n3 + 2] & 0x80) != 128) {
                    if (OracleLog.TRACE) {
                        OracleLog.print(4, 8, "Error occurred during the UTF-8 conversion process");
                    }
                    DBError.check_error(37, "failUTF8Conv");
                }
                cArray[n2] = (char)((byArray[n3] & 0xF) << 12 | (byArray[n3 + 1] & 0x3F) << 6 | byArray[n3 + 2] & 0x3F);
                n3 += 3;
            }
            ++n2;
        }
        return n2;
    }

    private static int utf8BytesToJavaChars(byte[] byArray, int[] nArray, char[] cArray) throws SQLException {
        int n = nArray[0];
        if (OracleLog.TRACE) {
            OracleLog.print(4, 16, "DBConversion.utf8BytesToChars(bytes[], nbytes=" + n + ", chars[])");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (n2 >= cArray.length) {
                DBError.check_error(39, "JavaCharsToCHARBytes");
            }
            if ((byArray[n3] & 0x80) == 0) {
                cArray[n2] = (char)byArray[n3];
                ++n3;
            } else if ((byArray[n3] & 0x20) == 0) {
                if (n3 + 2 > n) break;
                if ((byArray[n3 + 1] & 0x80) != 128) {
                    if (OracleLog.TRACE) {
                        OracleLog.print(4, 8, "Error occurred during the UTF-8 conversion process");
                    }
                    DBError.check_error(37, "failUTF8Conv");
                }
                cArray[n2] = (char)((byArray[n3] & 0x1F) << 6 | byArray[n3 + 1] & 0x3F);
                n3 += 2;
            } else {
                if (n3 + 3 > n) break;
                if ((byArray[n3 + 1] & 0x80) != 128 || (byArray[n3 + 2] & 0x80) != 128) {
                    if (OracleLog.TRACE) {
                        OracleLog.print(4, 8, "Error occurred during the UTF-8 conversion process");
                    }
                    DBError.check_error(37, "failUTF8Conv");
                }
                cArray[n2] = (char)((byArray[n3] & 0xF) << 12 | (byArray[n3 + 1] & 0x3F) << 6 | byArray[n3 + 2] & 0x3F);
                n3 += 3;
            }
            ++n2;
        }
        nArray[0] = n - n3;
        return n2;
    }

    private static int stringUTFLength(char[] cArray) {
        int n = 0;
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            n = (c & 0xFF80) == 0 ? ++n : ((c & 0xF800) == 0 ? (n += 2) : (n += 3));
            ++n3;
        }
        return n;
    }

    private static void failUTF8Conv() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 8, "Error occurred during the UTF-8 conversion process");
        }
        DBError.check_error(37, "failUTF8Conv");
    }

    public static byte[] BigDecimalToNumberBytes(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            return null;
        }
        NUMBER nUMBER = new NUMBER(bigDecimal);
        return nUMBER.toBytes();
    }

    public static BigDecimal NumberBytesToBigDecimal(byte[] byArray, int n) throws SQLException {
        NUMBER nUMBER = new NUMBER(byArray);
        return nUMBER.bigDecimalValue();
    }

    public static byte NumberBytesToByte(byte[] byArray, int n) throws SQLException {
        NUMBER nUMBER = new NUMBER(byArray);
        return nUMBER.byteValue();
    }

    public static byte[] ByteToNumberBytes(byte by) {
        NUMBER nUMBER = new NUMBER(by);
        return nUMBER.toBytes();
    }

    public static short NumberBytesToShort(byte[] byArray, int n) throws SQLException {
        NUMBER nUMBER = new NUMBER(byArray);
        return nUMBER.shortValue();
    }

    public static byte[] ShortToNumberBytes(short s) {
        NUMBER nUMBER = new NUMBER(s);
        return nUMBER.toBytes();
    }

    public static int NumberBytesToInt(byte[] byArray, int n) throws SQLException {
        NUMBER nUMBER = new NUMBER(byArray);
        return nUMBER.intValue();
    }

    public static byte[] IntToNumberBytes(int n) {
        NUMBER nUMBER = new NUMBER(n);
        return nUMBER.toBytes();
    }

    public static long NumberBytesToLong(byte[] byArray, int n) throws SQLException {
        NUMBER nUMBER = new NUMBER(byArray);
        return nUMBER.longValue();
    }

    public static byte[] LongToNumberBytes(long l) {
        NUMBER nUMBER = new NUMBER(l);
        return nUMBER.toBytes();
    }

    public static float NumberBytesToFloat(byte[] byArray, int n) {
        NUMBER nUMBER = new NUMBER(byArray);
        return nUMBER.floatValue();
    }

    public static byte[] FloatToNumberBytes(float f) {
        NUMBER nUMBER = new NUMBER(f);
        return nUMBER.toBytes();
    }

    public static double NumberBytesToDouble(byte[] byArray, int n) {
        NUMBER nUMBER = new NUMBER(byArray);
        return nUMBER.doubleValue();
    }

    public static byte[] DoubleToNumberBytes(double d) throws SQLException {
        NUMBER nUMBER = new NUMBER(d);
        return nUMBER.toBytes();
    }

    public static byte[] BooleanToNumberBytes(boolean bl) {
        NUMBER nUMBER = bl ? new NUMBER(1) : new NUMBER(0);
        return nUMBER.toBytes();
    }

    public static boolean NumberBytesToBoolean(byte[] byArray, int n) throws SQLException {
        NUMBER nUMBER = new NUMBER(byArray);
        return nUMBER.booleanValue();
    }

    public Date DateBytesToDate(byte[] byArray, int n) {
        int[] nArray = new int[7];
        int n2 = 0;
        while (n2 < 7) {
            nArray[n2] = byArray[n2] < 0 ? byArray[n2] + 256 : byArray[n2];
            ++n2;
        }
        int n3 = (nArray[0] - 100) * 100 + (nArray[1] - 100) - 1900;
        return new Date(n3, nArray[2] - 1, nArray[3]);
    }

    public byte[] DateToDateBytes(Date date) {
        if (date == null) {
            return null;
        }
        byte[] byArray = new byte[7];
        int n = date.getYear() + 1900;
        byArray[0] = (byte)(100 + n / 100);
        byArray[1] = (byte)(n % 100 + 100);
        byArray[2] = (byte)(date.getMonth() + 1);
        byArray[3] = (byte)date.getDate();
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        return byArray;
    }

    public Time DateBytesToTime(byte[] byArray, int n) {
        int[] nArray = new int[7];
        int n2 = 0;
        while (n2 < 7) {
            nArray[n2] = byArray[n2] < 0 ? byArray[n2] + 256 : byArray[n2];
            ++n2;
        }
        return new Time(nArray[4] - 1, nArray[5] - 1, nArray[6] - 1);
    }

    public byte[] TimeToDateBytes(Time time) {
        if (time == null) {
            return null;
        }
        byte[] byArray = new byte[]{119, 100, 1, 1, (byte)(time.getHours() + 1), (byte)(time.getMinutes() + 1), (byte)(time.getSeconds() + 1)};
        return byArray;
    }

    public Timestamp DateBytesToTimestamp(byte[] byArray, int n) {
        int[] nArray = new int[7];
        int n2 = 0;
        while (n2 < 7) {
            nArray[n2] = byArray[n2] < 0 ? byArray[n2] + 256 : byArray[n2];
            ++n2;
        }
        int n3 = (nArray[0] - 100) * 100 + (nArray[1] - 100) - 1900;
        return new Timestamp(n3, nArray[2] - 1, nArray[3], nArray[4] - 1, nArray[5] - 1, nArray[6] - 1, 0);
    }

    public byte[] TimestampToDateBytes(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        byte[] byArray = new byte[7];
        int n = timestamp.getYear() + 1900;
        byArray[0] = (byte)(100 + n / 100);
        byArray[1] = (byte)(n % 100 + 100);
        byArray[2] = (byte)(timestamp.getMonth() + 1);
        byArray[3] = (byte)timestamp.getDate();
        byArray[4] = (byte)(timestamp.getHours() + 1);
        byArray[5] = (byte)(timestamp.getMinutes() + 1);
        byArray[6] = (byte)(timestamp.getSeconds() + 1);
        return byArray;
    }

    public static boolean isCharSetMultibyte(short s) {
        switch (s) {
            case 1: 
            case 31: {
                return false;
            }
            case -5: 
            case -1: 
            case 870: 
            case 871: {
                return true;
            }
        }
        return false;
    }

    public static int requestLength(int n, int n2) {
        switch (n2) {
            case 0: {
                return n;
            }
            case 1: {
                return n / 2;
            }
            case 5: {
                return n;
            }
            case 4: {
                return n * 2;
            }
            case 2: {
                return n / 2;
            }
            case 3: {
                return n / 4;
            }
        }
        return n;
    }

    public int getMaxCharbyteSize() {
        switch (this.m_charSet) {
            case 1: {
                return 1;
            }
            case 31: {
                return 1;
            }
            case 870: 
            case 871: {
                return 3;
            }
            case -5: {
                return 2;
            }
            case -1: {
                return 4;
            }
        }
        return 1;
    }

    public boolean isUcs2CharSet() {
        return this.m_charSet == -5;
    }

    public static int RAWBytesToHexChars(byte[] byArray, int n, char[] cArray) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            cArray[n3++] = (char)RepConversion.nibbleToHex((byte)(byArray[n2] >> 4 & 0xF));
            cArray[n3++] = (char)RepConversion.nibbleToHex((byte)(byArray[n2] & 0xF));
            ++n2;
        }
        return n3;
    }

    public InputStream ConvertStream(InputStream inputStream, int n) {
        return new OracleConversionInputStream(this, inputStream, n);
    }

    public InputStream ConvertStream(InputStream inputStream, int n, int n2) {
        return new OracleConversionInputStream(this, inputStream, n, n2);
    }

    public InputStream ConvertStream(Reader reader, int n, int n2) {
        return new OracleConversionInputStream(this, reader, n, n2);
    }

    public Reader ConvertCharacterStream(InputStream inputStream, int n) throws SQLException {
        return new OracleConversionReader(this, inputStream, n);
    }

    protected static void unexpectedCharset(short s) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(4, 2, "Unexpected character set " + s + "is encountered");
        }
        DBError.check_error(35, "DBConversion");
    }

    protected static void catchBytesLen(byte[] byArray, int n) throws SQLException {
        if (n > byArray.length) {
            if (OracleLog.TRACE) {
                OracleLog.print(4, 2, "Invalid byte array length of " + byArray.length + "(expected " + n + ")");
            }
            DBError.check_error(39, "catchBytesLen");
        }
    }

    protected static void catchCharsLen(char[] cArray, int n) throws SQLException {
        if (n > cArray.length) {
            if (OracleLog.TRACE) {
                OracleLog.print(4, 2, "Invalid char array length of " + cArray.length + "(expected " + n + ")");
            }
            DBError.check_error(39, "catchCharsLen");
        }
    }

    public static int getUtfLen(char c) {
        int n = 0;
        n = (c & 0xFF80) == 0 ? 1 : ((c & 0xF800) == 0 ? 2 : 3);
        return n;
    }
}

