/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Properties;
import oracle.gss.util.NLSLocale;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBStatement;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public abstract class DBAccess {
    public static final short ORACLE8_PROD_VERSION = 8030;
    public static final byte IS_SELECT = 0;
    public static final byte IS_PLSQL_BLOCK = 1;
    public static final byte IS_OTHER = 2;
    public static final byte BIND_IN = 1;
    public static final byte BIND_OUT = 16;

    public abstract DBConversion logon(String var1, String var2, String var3, Properties var4) throws SQLException, IOException;

    public abstract void logoff() throws SQLException, IOException;

    public abstract void commit() throws SQLException, IOException;

    public abstract void rollback() throws SQLException, IOException;

    public abstract void setAutoCommit(boolean var1) throws SQLException, IOException;

    public abstract DBStatement open() throws SQLException, IOException;

    public abstract void closeQuery(DBStatement var1) throws SQLException, IOException;

    public abstract void close(DBStatement var1) throws SQLException, IOException;

    public abstract DBColumn[] describe(DBStatement var1) throws SQLException, IOException;

    public abstract DBColumn[] parseExecuteDescribe(DBStatement var1, byte[] var2, DBType[] var3, DBData[] var4) throws SQLException, IOException;

    public abstract int executeFetch(DBStatement var1, byte var2, DBType[] var3, DBData[] var4, int var5, DBType[] var6, DBData[] var7, int var8) throws SQLException, IOException;

    public int executeFetchNeedDefines(DBStatement dBStatement, byte by, DBType[] dBTypeArray, DBData[] dBDataArray, int n, DBType[] dBTypeArray2, DBData[] dBDataArray2, int n2) throws SQLException, IOException {
        return this.executeFetch(dBStatement, by, dBTypeArray, dBDataArray, n, dBTypeArray2, dBDataArray2, n2);
    }

    public abstract int parseExecuteFetch(DBStatement var1, byte var2, byte[] var3, DBType[] var4, DBData[] var5, int var6, DBType[] var7, DBData[] var8, int var9) throws SQLException, IOException;

    public abstract int fetch(DBStatement var1, DBType[] var2, DBData[] var3, int var4) throws SQLException, IOException;

    public abstract int read(DBStatement var1, byte[] var2, int var3) throws SQLException, IOException;

    public abstract byte[] getVersion() throws SQLException, IOException;

    public abstract short getVersionNumber() throws SQLException;

    public abstract int getDefaultPrefetch();

    public abstract int getDefaultStreamChunkSize();

    public abstract void cancel() throws SQLException, IOException;

    public abstract DBStatement RefCursorBytesToDBStatement(byte[] var1) throws SQLException, IOException;

    public abstract byte[] DBStatementToRefCursorBytes(DBStatement var1) throws SQLException, IOException;

    public void setWaitandAutoRollback(DBStatement dBStatement, int n, int n2) throws SQLException {
        DBError.check_error(66, "setWaitandAutoRollback");
    }

    public void startup(String string, int n) throws SQLException {
        DBError.check_error(66, "startup");
    }

    public void shutdown(int n) throws SQLException {
        DBError.check_error(66, "shutdown");
    }

    public void archive(int n, int n2, String string) throws SQLException {
        DBError.check_error(66, "archive");
    }

    public void getOracleTypeADT(OracleTypeADT oracleTypeADT) throws SQLException {
    }

    public abstract void getObjectValueFromRef(DBItem var1, DBType var2, DBItem var3, DBType var4) throws SQLException;

    public abstract void setObjectValueFromRef(DBItem var1, DBType var2, DBItem var3, DBType var4) throws SQLException;

    public abstract DBType createDBType(int var1, boolean var2) throws SQLException;

    public DBType createDBType(int n, boolean bl, boolean bl2) throws SQLException {
        return this.createDBType(n, bl);
    }

    public abstract DBItem createDBItem(DBType var1);

    public abstract int fetch(DBStatement var1, DBType[] var2, DBData[] var3, int var4, int var5) throws SQLException, IOException;

    public abstract long lobWrite(BLOB var1, long var2, byte[] var4) throws SQLException;

    public abstract long lobWrite(CLOB var1, long var2, char[] var4) throws SQLException;

    public abstract long lobRead(BLOB var1, long var2, long var4, byte[] var6) throws SQLException;

    public abstract long lobRead(BFILE var1, long var2, long var4, byte[] var6) throws SQLException;

    public abstract long lobRead(CLOB var1, long var2, long var4, char[] var6) throws SQLException;

    public abstract long lobLength(BLOB var1) throws SQLException;

    public abstract long lobLength(BFILE var1) throws SQLException;

    public abstract long lobLength(CLOB var1) throws SQLException;

    public abstract long hasPattern(BLOB var1, byte[] var2, long var3) throws SQLException;

    public abstract long hasPattern(CLOB var1, char[] var2, long var3) throws SQLException;

    public abstract long hasPattern(BFILE var1, byte[] var2, long var3) throws SQLException;

    public abstract long isSubLob(BLOB var1, BLOB var2, long var3) throws SQLException;

    public abstract long isSubLob(CLOB var1, CLOB var2, long var3) throws SQLException;

    public abstract long isSubLob(BFILE var1, BFILE var2, long var3) throws SQLException;

    public abstract void fileOpen(BFILE var1) throws SQLException;

    public abstract boolean fileIsOpen(BFILE var1) throws SQLException;

    public abstract boolean fileExists(BFILE var1) throws SQLException;

    public abstract String fileGetName(BFILE var1) throws SQLException;

    public abstract String fileGetDirAlias(BFILE var1) throws SQLException;

    public abstract void fileClose(BFILE var1) throws SQLException;

    public abstract long getLobChunkSize(BLOB var1) throws SQLException;

    public abstract long getLobChunkSize(CLOB var1) throws SQLException;

    public Properties getDBAccessProperties() throws SQLException {
        DBError.check_error(66, "getDBAccessProperties");
        return null;
    }

    public int getNlsRatio() {
        return 1;
    }

    public int getC2SNlsRatio() {
        return 1;
    }

    public void initNls(OracleConnection oracleConnection) throws SQLException {
    }

    protected void setNlsParamsClient(OracleConnection oracleConnection) throws SQLException {
        Statement statement;
        block10: {
            if (OracleLog.TRACE) {
                OracleLog.print(oracleConnection, 2, 16, "DBAccess.setNlsParamsClient()");
            }
            statement = null;
            ResultSet resultSet = null;
            String string = null;
            try {
                try {
                    String string2;
                    statement = oracleConnection.createStatement();
                    NLSLocale nLSLocale = NLSLocale.getInstance();
                    String string3 = nLSLocale.getNLSLanguage(Locale.getDefault());
                    if (string3 != null) {
                        statement.execute("ALTER SESSION SET NLS_LANGUAGE = '" + string3 + "'");
                    }
                    if ((string2 = nLSLocale.getNLSTerritory(Locale.getDefault())) != null) {
                        statement.execute("ALTER SESSION SET NLS_TERRITORY = '" + string2 + "'");
                    }
                    ((OracleStatement)statement).setRowPrefetch(1);
                    resultSet = statement.executeQuery("SELECT VALUE FROM NLS_INSTANCE_PARAMETERS WHERE PARAMETER ='NLS_DATE_FORMAT'");
                    if (resultSet.next() && (string = resultSet.getString(1)) != null) {
                        statement.execute("ALTER SESSION SET NLS_DATE_FORMAT = '" + string + "'");
                    }
                    if (OracleLog.TRACE) {
                        OracleLog.print(oracleConnection, 2, 1, "DBAccess.setNlsParamsClient(): NLSLanguage=" + string3 + ", NLSTerritory=" + string2 + ", DateFormat=" + string);
                    }
                }
                catch (SQLException sQLException) {
                }
                Object var6_8 = null;
                if (statement == null) break block10;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (statement != null) {
                    statement.close();
                }
                statement = null;
                throw throwable;
            }
            statement.close();
        }
        statement = null;
    }
}

