/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public abstract class NLSLocale {
    static final int JDK_1_1_4 = 1;
    static final int JDK_1_1_6 = 2;
    private static final int JDK_LATEST_VERSION = 2;
    private static final String CLASSNAME_PREFIX = "oracle.gss.util.NLSLocale";
    private static final String CLASSNAME_SUFFIX = "000";
    private static final int JDK_VERSION_MAX_LENGTH = 5;
    private int m_jdkVersion;
    private Hashtable m_NLSLang2JavaLang;
    private Hashtable m_NLSTerr2JavaTerr;
    private Hashtable m_NLSLocale2JavaLocale;
    private Hashtable m_NLSCharset2JavaCharset;
    private Hashtable m_JavaCharset2NLSCharset;
    private Hashtable m_JavaLocale2NLSLocale;
    private Hashtable m_JavaLocale2NLSLang;
    private Hashtable m_JavaLang2NLSLang;
    private Hashtable m_JavaTerr2NLSTerr;
    private static Hashtable m_jdk2NlsVersion = new Hashtable();
    private static Hashtable m_NLSLocaleInstances;

    NLSLocale() {
    }

    static NLSLocale getInstance(int n) {
        NLSLocale nLSLocale = null;
        Integer n2 = new Integer(n);
        if (n > 2) {
            return null;
        }
        if (m_NLSLocaleInstances == null) {
            m_NLSLocaleInstances = new Hashtable();
        } else {
            nLSLocale = (NLSLocale)m_NLSLocaleInstances.get(n2);
            if (nLSLocale != null) {
                return nLSLocale;
            }
        }
        String string = CLASSNAME_PREFIX;
        String string2 = Integer.toHexString(n);
        string = String.valueOf(string) + CLASSNAME_SUFFIX.substring(0, CLASSNAME_SUFFIX.length() - string2.length()) + string2;
        try {
            Class<?> clazz = Class.forName(string);
            nLSLocale = (NLSLocale)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        if (nLSLocale != null) {
            m_NLSLocaleInstances.put(n2, nLSLocale);
        }
        return nLSLocale;
    }

    public static NLSLocale getInstance() {
        Integer n;
        String string = System.getProperty("java.version");
        if (string.length() > 5) {
            string = string.substring(0, 5);
        }
        int n2 = (n = (Integer)m_jdk2NlsVersion.get(string)) != null ? n : 2;
        return NLSLocale.getInstance(n2);
    }

    public Locale getJavaLocale(String string) {
        String string2 = string.toUpperCase(Locale.US);
        Locale locale = (Locale)this.getNLSLoc2JavaLocTable().get(string2);
        if (locale == null) {
            String string3;
            String string4;
            int n = string2.indexOf("_");
            if (n > -1) {
                string4 = string2.substring(0, n);
                string3 = string2.substring(n + 1);
            } else {
                string4 = string2;
                string3 = "";
            }
            locale = this.getJavaLocale(string4, string3);
        }
        return locale;
    }

    public Locale getJavaLocale(String string, String string2) {
        Locale locale = null;
        String string3 = string.toUpperCase(Locale.US);
        String string4 = string2.toUpperCase(Locale.US);
        String string5 = string3.compareTo("") == 0 ? "" : this.getJavaLanguage(string3);
        if (string5 != null) {
            if (string4.compareTo("") == 0) {
                locale = new Locale(string5, "");
            } else {
                String string6 = this.getJavaTerritory(string4);
                if (string6 != null) {
                    locale = new Locale(string5, string6);
                }
            }
        }
        return locale;
    }

    public String getJavaLanguage(String string) {
        return (String)this.getNLSLang2JavaLangTable().get(string.toUpperCase(Locale.US));
    }

    public String getJavaTerritory(String string) {
        return (String)this.getNLSTerr2JavaTerrTable().get(string.toUpperCase(Locale.US));
    }

    public Enumeration enumNLSLocales() {
        return this.getNLSLoc2JavaLocTable().keys();
    }

    public Enumeration enumJavaLocales() {
        return this.getJavaLoc2NLSLocTable().keys();
    }

    public String getJavaCharset(String string) {
        return (String)this.getNLSCS2JavaCSTable().get(string.toUpperCase(Locale.US));
    }

    public String getNLSCharset(String string) {
        return (String)this.getJavaCS2NLSCSTable().get(string);
    }

    public Enumeration enumNLSCharsets() {
        return this.getNLSCS2JavaCSTable().keys();
    }

    public Enumeration enumJavaCharsets() {
        return this.getJavaCS2NLSCSTable().keys();
    }

    public String getNLSLocale() {
        return this.getNLSLocale(Locale.getDefault());
    }

    public String getNLSLocale(Locale locale) {
        String string = (String)this.getJavaLoc2NLSLocTable().get(locale);
        if (string == null) {
            String string2 = this.getNLSLanguage(locale);
            String string3 = locale.getCountry();
            if (string3.compareTo("") == 0) {
                return string2;
            }
            String string4 = this.getNLSTerritory(string3);
            if (string2 != null && string4 != null) {
                string = String.valueOf(string2) + "_" + string4;
            }
        }
        return string;
    }

    public String getNLSLanguage(Locale locale) {
        String string = null;
        string = (String)this.getJavaLoc2NLSLangTable().get(locale);
        if (string == null) {
            string = this.getNLSLanguage(locale.getLanguage());
        }
        return string;
    }

    public String getNLSTerritory(Locale locale) {
        int n;
        String string;
        String string2 = locale.getCountry();
        if (string2.compareTo("") == 0 && (string = this.getNLSLocale(locale)) != null && (n = string.indexOf(95)) != -1) {
            return string.substring(n + 1);
        }
        return this.getNLSTerritory(locale.getCountry());
    }

    public String getNLSLanguage(String string) {
        return (String)this.getJavaLang2NLSLangTable().get(string);
    }

    public String getNLSTerritory(String string) {
        return (String)this.getJavaTerr2NLSTerrTable().get(string);
    }

    Hashtable getNLSLang2JavaLangTable() {
        if (this.m_NLSLang2JavaLang == null) {
            this.m_NLSLang2JavaLang = this.createNLSLang2JavaLang();
        }
        return this.m_NLSLang2JavaLang;
    }

    Hashtable getNLSTerr2JavaTerrTable() {
        if (this.m_NLSTerr2JavaTerr == null) {
            this.m_NLSTerr2JavaTerr = this.createNLSTerr2JavaTerr();
        }
        return this.m_NLSTerr2JavaTerr;
    }

    Hashtable getNLSLoc2JavaLocTable() {
        if (this.m_NLSLocale2JavaLocale == null) {
            this.m_NLSLocale2JavaLocale = this.createNLSLocale2JavaLocale();
        }
        return this.m_NLSLocale2JavaLocale;
    }

    Hashtable getNLSCS2JavaCSTable() {
        if (this.m_NLSCharset2JavaCharset == null) {
            this.m_NLSCharset2JavaCharset = this.createNLSCharset2JavaCharset();
        }
        return this.m_NLSCharset2JavaCharset;
    }

    Hashtable getJavaCS2NLSCSTable() {
        if (this.m_JavaCharset2NLSCharset == null) {
            this.m_JavaCharset2NLSCharset = this.createJavaCharset2NLSCharset();
        }
        return this.m_JavaCharset2NLSCharset;
    }

    Hashtable getJavaLoc2NLSLocTable() {
        if (this.m_JavaLocale2NLSLocale == null) {
            this.m_JavaLocale2NLSLocale = this.createJavaLocale2NLSLocale();
        }
        return this.m_JavaLocale2NLSLocale;
    }

    Hashtable getJavaLoc2NLSLangTable() {
        if (this.m_JavaLocale2NLSLang == null) {
            this.m_JavaLocale2NLSLang = this.createJavaLocale2NLSLang();
        }
        return this.m_JavaLocale2NLSLang;
    }

    Hashtable getJavaLang2NLSLangTable() {
        if (this.m_JavaLang2NLSLang == null) {
            this.m_JavaLang2NLSLang = this.createJavaLang2NLSLang();
        }
        return this.m_JavaLang2NLSLang;
    }

    Hashtable getJavaTerr2NLSTerrTable() {
        if (this.m_JavaTerr2NLSTerr == null) {
            this.m_JavaTerr2NLSTerr = this.createJavaTerr2NLSTerr();
        }
        return this.m_JavaTerr2NLSTerr;
    }

    abstract Hashtable createNLSLang2JavaLang();

    abstract Hashtable createNLSTerr2JavaTerr();

    abstract Hashtable createNLSLocale2JavaLocale();

    abstract Hashtable createNLSCharset2JavaCharset();

    abstract Hashtable createJavaCharset2NLSCharset();

    abstract Hashtable createJavaLocale2NLSLocale();

    abstract Hashtable createJavaLocale2NLSLang();

    abstract Hashtable createJavaLang2NLSLang();

    abstract Hashtable createJavaTerr2NLSTerr();

    static {
        m_jdk2NlsVersion.put("1.1", new Integer(1));
        m_jdk2NlsVersion.put("1.1.1", new Integer(1));
        m_jdk2NlsVersion.put("1.1.2", new Integer(1));
        m_jdk2NlsVersion.put("1.1.3", new Integer(1));
        m_jdk2NlsVersion.put("1.1.4", new Integer(1));
        m_jdk2NlsVersion.put("1.1.5", new Integer(1));
        m_jdk2NlsVersion.put("1.1.6", new Integer(2));
        m_jdk2NlsVersion.put("1.1.7", new Integer(2));
        m_jdk2NlsVersion.put("1.1.8", new Integer(2));
    }
}

