/*
 * Decompiled with CFR 0.152.
 */
package lmt;

import java.sql.SQLException;
import java.util.Vector;
import lmt.Concept;
import lmt.Debug;
import lmt.MorphNoun;
import lmt.SQLConnection;
import lmt.Session;
import lmt.SyntaxNoun;
import lmt.Util;

public class Term {
    String term_id;
    String term_string;
    String pos;
    String type_phrase;
    String phrase_head;
    String active;
    Vector conceptVector;
    SQLConnection con;

    public Term(SQLConnection sQLConnection) {
        this.con = sQLConnection;
        this.reset();
    }

    public void reset() {
        this.term_id = "";
        this.term_string = "";
        this.pos = "";
        this.type_phrase = "";
        this.phrase_head = "";
        this.active = "T";
        this.conceptVector = new Vector();
    }

    public String getTermID() {
        return this.term_id;
    }

    public void setTermID(String string) {
        if (string == null) {
            string = "";
        }
        this.term_id = string;
    }

    public String getTermString() {
        return this.term_string;
    }

    public void setTermString(String string) {
        if (string == null) {
            string = "";
        }
        this.term_string = string;
    }

    public void setPos(String string) {
        if (string == null) {
            string = "";
        }
        this.pos = string;
    }

    public String getPos() {
        return this.pos;
    }

    public void setTypePhrase(String string) {
        if (string == null) {
            string = "";
        }
        this.type_phrase = string;
    }

    public String getTypePhrase() {
        return this.type_phrase;
    }

    public void setPhraseHead(String string) {
        if (string == null) {
            string = "";
        }
        this.phrase_head = string;
    }

    public String getPhraseHead() {
        return this.phrase_head;
    }

    public void setActive(String string) {
        if (string == null) {
            string = "";
        }
        this.active = string;
    }

    public String getActive() {
        return this.active;
    }

    public Vector getConcepts() {
        if (this.conceptVector.size() == 0) {
            this.conceptVector = Concept.fetchConcepts(this);
        }
        return this.conceptVector;
    }

    public void setConcepts(Vector vector) {
        this.conceptVector = vector;
    }

    public SQLConnection getConn() {
        return this.con;
    }

    public boolean isEmpty() {
        return this.term_id.length() == 0;
    }

    public static Vector fetchAllTerms(SQLConnection sQLConnection) {
        Vector<Term> vector = new Vector<Term>();
        if (!sQLConnection.connect()) {
            return null;
        }
        String string = "SELECT * FROM LMT_TERMS ORDER BY TERM_STRING";
        Debug.debug("-- fetchAllTerms: " + string);
        try {
            SQLConnection.Result result = sQLConnection.query(string);
            while (result != null && result.hasData()) {
                Term term = new Term(sQLConnection);
                term.setTermID(result.rs.getString(1));
                term.setTermString(result.rs.getString(2));
                term.setPos(Term.changePosForUI(result.rs.getString(3)));
                term.setTypePhrase(result.rs.getString(4));
                term.setPhraseHead(result.rs.getString(5));
                term.setActive(result.rs.getString(6));
                vector.add(term);
            }
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
            return null;
        }
        return vector;
    }

    public synchronized int fetchTerm() {
        Vector vector = new Vector();
        if (!this.con.connect()) {
            return 8;
        }
        String string = "SELECT * FROM LMT_TERMS WHERE ";
        string = string + "term_id = '" + this.term_id + "'";
        Debug.debug("-- fetchTerm: " + string);
        try {
            SQLConnection.Result result = this.con.query(string);
            if (result != null && result.hasData()) {
                this.setTermString(result.rs.getString(2));
                this.setPos(Term.changePosForUI(result.rs.getString(3)));
                this.setTypePhrase(result.rs.getString(4));
                this.setPhraseHead(result.rs.getString(5));
                this.setActive(result.rs.getString(6));
            }
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
            return 2;
        }
        this.conceptVector = Concept.fetchConcepts(this);
        return 1;
    }

    public Vector searchTerms() {
        String string = "SELECT POS, TERM_STRING, TERM_ID FROM LMT_TERMS WHERE ";
        Vector vector = new Vector();
        string = this.term_string.indexOf("%%") >= 0 ? string + "term_string LIKE '%\\%%' escape '\\'" : (this.term_string.indexOf("%") >= 0 || this.term_string.indexOf("_") >= 0 ? string + "term_string LIKE '" + Util.replaceSingleQuote(this.term_string) + "'" : string + "term_string = '" + Util.replaceSingleQuote(this.term_string) + "'");
        if (!this.pos.equals("ANY")) {
            string = string + " AND POS = '" + Term.changePosForDB(this.pos) + "'";
        }
        string = string + " order by term_string";
        try {
            SQLConnection.Result result = this.con.query(string);
            while (result != null && result.hasData()) {
                Vector<String> vector2 = new Vector<String>();
                vector2.addElement(Term.changePosForUI(result.rs.getString(1)));
                vector2.addElement(result.rs.getString(2));
                vector2.addElement(result.rs.getString(3));
                vector.addElement(vector2);
            }
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
        Debug.debug("-- searchTerms: " + string);
        return vector;
    }

    public synchronized boolean deleteTerms(Vector vector) {
        Debug.debug("-- deleteTerms for batch mode: delete " + vector.size() + " terms");
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            String string = (String)vector2.elementAt(2);
            Debug.debug("-- delete term: term_id = " + string);
            boolean bl = this.con.callProcedure("DeleteTerm", string);
            if (bl) continue;
            System.out.println("-- Fail to delete a term (term_id=" + string + ")");
            return false;
        }
        return true;
    }

    public synchronized int batchChange(Vector vector) {
        int n;
        Debug.debug("-- updateTerms for batch mode: update " + vector.size() + " terms");
        for (n = 0; n < vector.size(); ++n) {
            Term term = (Term)vector.elementAt(n);
            if (!term.isDuplicate()) continue;
            return 3;
        }
        this.con.setAutoCommit(false);
        this.con.setTransactionIsolation(8);
        n = 1;
        for (int i = 0; i < vector.size(); ++i) {
            Term term = (Term)vector.elementAt(i);
            if (term.update() != 1) {
                n = 0;
                break;
            }
            Vector vector2 = term.getConcepts();
            for (int j = 0; j < vector2.size(); ++j) {
                Concept concept = (Concept)vector2.elementAt(j);
                if (concept.update() == 1) continue;
                n = 0;
                break;
            }
            if (n == 0) break;
        }
        if (n != 0) {
            this.con.commit();
        } else {
            this.con.rollback();
        }
        this.con.setAutoCommit(true);
        return n != 0 ? 1 : 2;
    }

    public static String changePosForDB(String string) {
        String string2 = "N";
        if (string != null) {
            string2 = string.equals("NOUN") ? "N" : (string.equals("VERB") ? "V" : (string.equals("ADVERB") ? "ADV" : string));
        }
        return string2;
    }

    public static String changePosForUI(String string) {
        String string2 = "NOUN";
        if (string != null) {
            string2 = string.equals("N") ? "NOUN" : (string.equals("V") ? "VERB" : (string.equals("ADV") ? "ADVERB" : string));
        }
        return string2;
    }

    public int insert() {
        if (this.isDuplicate()) {
            return 3;
        }
        this.term_id = this.con.getNewID("TERM_ID");
        String string = this.makeInsertQuery();
        Debug.debug("-- Term inserted : " + string);
        return this.con.insert(string);
    }

    public int insert(Concept concept) {
        if (this.isDuplicate()) {
            return 3;
        }
        String[] stringArray = new String[2];
        this.term_id = this.con.getNewID("TERM_ID");
        stringArray[0] = this.makeInsertQuery();
        concept.setTermID(this.term_id);
        concept.setConceptID(this.con.getNewID("CONCEPT_ID"));
        stringArray[1] = concept.makeInsertQuery();
        Debug.debug("-- Term inserted : " + stringArray[0]);
        Debug.debug("-- Concept inserted : " + stringArray[1]);
        boolean bl = this.con.transaction(stringArray);
        if (!bl) {
            return 2;
        }
        if (this.isNounPhrase()) {
            this.copyFeatures();
        }
        return 1;
    }

    public int delete(Session session) {
        Debug.debug("-- Term deleted: term_id - " + this.term_id);
        if (!this.isExistent()) {
            return 4;
        }
        if (!this.con.connect()) {
            return 8;
        }
        this.con.setAutoCommit(false);
        this.con.setTransactionIsolation(8);
        boolean bl = false;
        bl = session.releaseLock();
        if (bl) {
            bl = this.con.callProcedure("DeleteTerm", this.term_id);
        }
        if (bl) {
            this.con.commit();
        } else {
            this.con.rollback();
        }
        this.con.setAutoCommit(true);
        return bl ? 1 : 2;
    }

    public int update() {
        if (!this.isExistent()) {
            return 4;
        }
        String string = this.makeUpdateQuery();
        return this.con.update(string);
    }

    public boolean isDuplicate() {
        String string = "SELECT * FROM LMT_TERMS WHERE ";
        string = string + " term_string = '" + Util.replaceSingleQuote(this.term_string) + "'";
        string = string + " AND POS = '" + Term.changePosForDB(this.pos) + "'";
        Debug.debug("-- isDuplicated : " + string);
        return this.con.isExistent(string);
    }

    public boolean isDuplicate2() {
        String string = "SELECT * FROM LMT_TERMS WHERE ";
        string = string + " term_string = '" + Util.replaceSingleQuote(this.term_string) + "'";
        string = string + " AND POS = '" + Term.changePosForDB(this.pos) + "'";
        string = string + " AND NOT(TERM_ID = '" + this.term_id + "')";
        Debug.debug("-- isDuplicated : " + string);
        return this.con.isExistent(string);
    }

    public boolean isExistent() {
        String string = "SELECT * FROM LMT_TERMS WHERE ";
        string = string + " term_id = '" + this.term_id + "'";
        return this.con.isExistent(string);
    }

    public void makeUpdateQuery(Vector vector) {
        vector.addElement(this.makeUpdateQuery());
    }

    String makeUpdateQuery() {
        String string = "UPDATE LMT_TERMS SET";
        string = string + " term_string = '" + Util.replaceSingleQuote(this.term_string) + "',";
        string = string + " pos = '" + Term.changePosForDB(this.pos) + "',";
        string = string + " type_phrase = '" + this.type_phrase + "',";
        string = string + " phrase_head = '" + this.phrase_head + "'";
        string = string + " WHERE term_id ='" + this.term_id + "'";
        return string;
    }

    String makeInsertQuery() {
        String string = "INSERT INTO LMT_TERMS VALUES (";
        string = string + "'" + this.term_id + "',";
        string = string + "'" + Util.replaceSingleQuote(this.term_string) + "',";
        string = string + "'" + Term.changePosForDB(this.pos) + "',";
        string = string + "'" + this.type_phrase + "',";
        string = string + "'" + this.phrase_head + "',";
        string = string + "'" + this.active + "')";
        return string;
    }

    public boolean isNounPhrase() {
        return this.pos.equals("NOUN") && this.phrase_head.equals("99");
    }

    public void copyFeatures() {
        Object object;
        Debug.debug("\n-----------copyFeatures-----------");
        if (!this.con.connect()) {
            return;
        }
        Term term = new Term(this.con);
        int n = this.term_string.lastIndexOf(" ");
        term.setTermString(this.term_string.substring(n + 1));
        term.setPos("NOUN");
        String string = "SELECT term_id FROM LMT_TERMS WHERE POS = 'N'";
        string = string + " AND term_string = '" + term.getTermString() + "'";
        Debug.debug("-- fetchTerm: " + string);
        try {
            object = this.con.query(string);
            if (object == null || !((SQLConnection.Result)object).hasData()) {
                return;
            }
            term.setTermID(((SQLConnection.Result)object).rs.getString(1));
            Debug.debug("------ root term_id: " + term.getTermID());
            ((SQLConnection.Result)object).close();
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
            return;
        }
        object = term.getConcepts();
        Concept concept = (Concept)((Vector)object).elementAt(0);
        if (((Vector)object).size() >= 1) {
            MorphNoun morphNoun;
            Debug.debug("\n-----------new_conceptVector ");
            Concept concept2 = (Concept)this.getConcepts().elementAt(0);
            SyntaxNoun syntaxNoun = (SyntaxNoun)concept.getSyntax();
            if (syntaxNoun != null) {
                concept2.syntax = syntaxNoun.cloneSyntax();
                concept2.syntax.setConceptID(concept2.getConceptID());
                ((SyntaxNoun)concept2.syntax).update();
            }
            if ((morphNoun = (MorphNoun)concept.getMorphology()) != null) {
                concept2.morph = morphNoun.cloneMorph();
                concept2.morph.setConceptID(concept2.getConceptID());
                ((MorphNoun)concept2.morph).update();
            }
        }
    }
}

