/*
 * Decompiled with CFR 0.152.
 */
package lmt;

import java.util.Vector;
import lmt.Debug;
import lmt.SQLConnection;
import lmt.SyntaxAdj;
import lmt.SyntaxAdv;
import lmt.SyntaxConj;
import lmt.SyntaxNoun;
import lmt.SyntaxPronoun;
import lmt.SyntaxQuant;
import lmt.SyntaxSym;
import lmt.SyntaxVerb;

public class Syntax {
    String concept_id;
    String abbreviation;
    String acronym;
    String complement_s;
    String complement_x;
    String complement_ap;
    String active;
    SQLConnection con;

    Syntax(SQLConnection sQLConnection, String string) {
        this.con = sQLConnection;
        this.concept_id = string;
        string = "";
        this.abbreviation = "";
        this.acronym = "";
        this.complement_s = "";
        this.complement_x = "";
        this.complement_ap = "";
        this.active = "";
    }

    public String getConceptID() {
        return this.concept_id;
    }

    public void setConceptID(String string) {
        if (string == null) {
            string = "";
        }
        this.concept_id = string;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String string) {
        if (string == null) {
            string = "";
        }
        this.abbreviation = string;
    }

    public String getAcronym() {
        return this.acronym;
    }

    public void setAcronym(String string) {
        if (string == null) {
            string = "";
        }
        this.acronym = string;
    }

    public String getComplementS() {
        return this.complement_s;
    }

    public void setComplementS(String string) {
        if (string == null) {
            string = "";
        }
        this.complement_s = string;
    }

    public String getComplementX() {
        return this.complement_x;
    }

    public void setComplementX(String string) {
        if (string == null) {
            string = "";
        }
        this.complement_x = string;
    }

    public String getComplementAP() {
        return this.complement_ap;
    }

    public void setComplementAP(String string) {
        if (string == null) {
            string = "";
        }
        this.complement_ap = string;
    }

    public void setActive(String string) {
        if (string == null) {
            string = "";
        }
        this.active = string;
    }

    public static Syntax fetchSyntax(SQLConnection sQLConnection, String string, String string2) {
        Syntax syntax = null;
        Debug.debug("-- pos: " + string);
        if (string == null) {
            return syntax;
        }
        if (string.equals("VERB")) {
            syntax = SyntaxVerb.fetchSyntax(sQLConnection, string2);
        } else if (string.equals("NOUN") || string.equals("PROP") || string.equals("UNIT")) {
            syntax = SyntaxNoun.fetchSyntax(sQLConnection, string2);
        } else if (string.equals("PRON")) {
            syntax = SyntaxPronoun.fetchSyntax(sQLConnection, string2);
        } else if (string.equals("ADVERB")) {
            syntax = SyntaxAdv.fetchSyntax(sQLConnection, string2);
        } else if (string.equals("ADJ")) {
            syntax = SyntaxAdj.fetchSyntax(sQLConnection, string2);
        } else if (string.equals("CONJ")) {
            syntax = SyntaxConj.fetchSyntax(sQLConnection, string2);
        } else if (string.equals("QUANT")) {
            syntax = SyntaxQuant.fetchSyntax(sQLConnection, string2);
        } else if (string.equals("SYM")) {
            syntax = SyntaxSym.fetchSyntax(sQLConnection, string2);
        }
        return syntax;
    }

    public void makeQuery(Vector vector, String string) {
        if (string.equals("VERB")) {
            ((SyntaxVerb)this).makeQuery(vector);
        } else if (string.equals("NOUN") || string.equals("PROP") || string.equals("UNIT")) {
            ((SyntaxNoun)this).makeQuery(vector);
        } else if (string.equals("PRON")) {
            ((SyntaxPronoun)this).makeQuery(vector);
        } else if (string.equals("ADVERB")) {
            ((SyntaxAdv)this).makeQuery(vector);
        } else if (string.equals("ADJ")) {
            ((SyntaxAdj)this).makeQuery(vector);
        } else if (string.equals("CONJ")) {
            ((SyntaxConj)this).makeQuery(vector);
        } else if (string.equals("QUANT")) {
            ((SyntaxQuant)this).makeQuery(vector);
        } else if (string.equals("SYM")) {
            ((SyntaxSym)this).makeQuery(vector);
        }
    }
}

