/*
 * Decompiled with CFR 0.152.
 */
package lmt;

import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import lmt.Debug;
import lmt.SQLConnection;
import lmt.Term;

public class Session {
    public static int EXTRA_TIME = 15000;
    String session_id;
    String lockType;
    String timestamp;
    int timeout;
    boolean hasLock;
    SQLConnection con;

    public Session(String string, SQLConnection sQLConnection) {
        this.con = sQLConnection;
        this.session_id = string;
        this.lockType = "X";
        this.timestamp = "";
        this.hasLock = false;
        this.timeout = 0;
    }

    public String getSessionID() {
        return this.session_id;
    }

    public void setSessionID(String string) {
        this.session_id = string;
    }

    public String getLockType() {
        return this.lockType;
    }

    public void setLockType(String string) {
        if (string == null) {
            string = "";
        }
        this.lockType = string;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String string) {
        if (string == null) {
            string = "";
        }
        this.timestamp = string;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public int checkLock(Term term) {
        int n = 0;
        if (this.timeout == 0) {
            return 6;
        }
        this.con.setAutoCommit(false);
        this.con.setTransactionIsolation(2);
        String string = "SELECT LOCK_TYPE, TIMESTAMP FROM LMT_LOCKS ";
        string = string + "WHERE TERM_ID='" + term.getTermID() + "' for update nowait";
        Debug.debug("-- checkLock: " + string);
        try {
            SQLConnection.Result result = this.con.query(string);
            if (result == null || !result.hasData()) {
                this.con.setAutoCommit(true);
                if (result != null) {
                    result.close();
                }
                return 6;
            }
            this.setLockType(result.rs.getString(1));
            this.setTimestamp(result.rs.getString(2));
            this.timestamp = this.timestamp.substring(0, this.timestamp.length() - 2);
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            System.err.println("ERROR: " + sQLException);
            this.con.setAutoCommit(true);
            return 2;
        }
        if (this.validTimestamp()) {
            Debug.debug("++ checkLock : term locked");
            n = 5;
        } else {
            string = "UPDATE LMT_LOCKS SET ";
            string = string + "session_id='" + this.session_id + "',";
            string = string + "timestamp = SYSDATE ";
            string = string + "WHERE TERM_ID='" + term.getTermID() + "'";
            Debug.debug("-- checkLock update the previous lock: " + string);
            n = this.con.update(string) == 1 ? 7 : 2;
        }
        this.con.commit();
        this.con.setAutoCommit(true);
        return n;
    }

    public int getLock(Term term) {
        if (this.timeout == 0) {
            return 1;
        }
        String string = "INSERT INTO LMT_LOCKS VALUES (";
        string = string + "'" + this.session_id + "',";
        string = string + "'" + term.getTermID() + "',";
        string = string + "SYSDATE,";
        string = string + "'" + this.lockType + "')";
        Debug.debug("-- getLock: " + string);
        int n = this.con.update(string);
        if (n == 1) {
            this.hasLock = true;
        }
        return n;
    }

    public boolean releaseLock() {
        if (this.timeout == 0) {
            return true;
        }
        if (!this.hasLock || this.session_id.length() == 0) {
            return false;
        }
        String string = "DELETE FROM LMT_LOCKS WHERE session_id = '" + this.session_id + "'";
        Debug.debug("-- releaseLock: " + string);
        int n = this.con.updateQuery(string);
        if (n <= 1) {
            this.hasLock = false;
        }
        return !this.hasLock;
    }

    boolean validTimestamp() {
        Date date;
        Date date2;
        Object object;
        String string = "";
        String string2 = "SELECT to_char(sysdate, 'YYYY-MM-DD HH24:MI:SS') NOW from dual";
        try {
            object = this.con.query(string2);
            if (object == null || !((SQLConnection.Result)object).hasData()) {
                if (object != null) {
                    ((SQLConnection.Result)object).close();
                }
                return true;
            }
            string = ((SQLConnection.Result)object).rs.getString(1);
            if (object != null) {
                ((SQLConnection.Result)object).close();
            }
            Debug.debug("-- strCurTime: " + string);
        }
        catch (SQLException sQLException) {
            Debug.debug("++ validTimestamp error");
            System.err.println("ERROR: " + sQLException);
            return true;
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date2 = ((DateFormat)object).parse(this.timestamp);
            date = ((DateFormat)object).parse(string);
        }
        catch (Exception exception) {
            Debug.debug("++ validTimestamp: parse error");
            return true;
        }
        long l = date2.getTime();
        long l2 = date.getTime();
        Debug.debug("-- savedTime : " + l);
        Debug.debug("-- curTime   : " + l2);
        Debug.debug("-- timeout   : " + this.timeout * 60 * 1000);
        Debug.debug("-- extra time: " + EXTRA_TIME);
        return l + (long)(this.timeout * 60 * 1000) + (long)EXTRA_TIME >= l2;
    }

    public int renewTimestamp(Term term) {
        if (this.timeout == 0) {
            return 1;
        }
        String string = "UPDATE LMT_LOCKS SET TIMESTAMP=SYSDATE WHERE SESSION_ID='" + this.session_id + "'";
        int n = this.con.update(string);
        if (n == 2) {
            n = this.getLock(term);
        }
        return n;
    }

    public void makeQueryForUpdateTimestamp(Vector vector) {
        String string = "UPDATE LMT_LOCKS SET TIMESTAMP=SYSDATE WHERE SESSION_ID='" + this.session_id + "'";
        vector.addElement(string);
    }
}

