/*
 * Decompiled with CFR 0.152.
 */
package lmt;

import java.sql.SQLException;
import java.util.Vector;
import lmt.Debug;
import lmt.SQLConnection;
import lmt.Util;

public class SemanticVerb {
    SQLConnection con;
    String semantic_id;
    String concept_id;
    String classes;
    String active;

    SemanticVerb(String string, SQLConnection sQLConnection) {
        this.concept_id = string;
        this.con = sQLConnection;
        this.semantic_id = "";
        this.classes = "";
        this.active = "T";
    }

    public String getSemanticID() {
        return this.semantic_id;
    }

    public void setSemanticID(String string) {
        if (string == null) {
            string = "";
        }
        this.semantic_id = string;
    }

    public String getConceptID() {
        return this.concept_id;
    }

    public void setConceptID(String string) {
        if (string == null) {
            string = "";
        }
        this.concept_id = string;
    }

    public String getClasses() {
        return this.classes;
    }

    public void setClasses(String string) {
        if (string == null) {
            string = "";
        }
        this.classes = string;
    }

    public void setActive(String string) {
        if (string == null) {
            string = "";
        }
        this.active = string;
    }

    public static SemanticVerb fetchSemanticVerb(SQLConnection sQLConnection, String string) {
        SemanticVerb semanticVerb = new SemanticVerb(string, sQLConnection);
        semanticVerb.setConceptID(string);
        String string2 = "SELECT * FROM LMT_SEM_VERB WHERE ";
        string2 = string2 + " CONCEPT_ID = '" + string + "'";
        try {
            SQLConnection.Result result = sQLConnection.query(string2);
            if (result != null && result.hasData()) {
                semanticVerb.setSemanticID(result.rs.getString(1));
                semanticVerb.setConceptID(result.rs.getString(2));
                semanticVerb.setClasses(result.rs.getString(3));
                semanticVerb.setActive(result.rs.getString(4));
            }
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
        Debug.debug("-- fetchSemanticVerb: " + string2);
        return semanticVerb;
    }

    public int insert() {
        String string = this.makeInsertQuery();
        System.out.println("-- Sem-verb insertion : " + string);
        return this.con.insert(string);
    }

    public int update() {
        if (!this.isExistent()) {
            return this.insert();
        }
        Vector vector = new Vector();
        this.makeQuery(vector);
        System.out.println("-- Definition update : " + vector.elementAt(0));
        return this.con.update(vector);
    }

    public boolean isExistent() {
        String string = "SELECT * FROM LMT_SEM_VERB WHERE ";
        string = string + " concept_id = '" + this.concept_id + "'";
        string = string + " AND semantic_id = '" + this.semantic_id + "'";
        return this.con.isExistent(string);
    }

    public void makeQuery(Vector vector) {
        String string = this.isExistent() ? this.makeUpdateQuery() : this.makeInsertQuery();
        vector.addElement(string);
    }

    String makeInsertQuery() {
        this.semantic_id = this.con.getNewID("SEMANTIC_ID");
        String string = "INSERT INTO LMT_SEM_VERB VALUES (";
        string = string + "'" + this.semantic_id + "',";
        string = string + "'" + this.concept_id + "',";
        string = string + "'" + Util.replaceSingleQuote(this.classes) + "',";
        string = string + "'" + this.active + "')";
        return string;
    }

    String makeUpdateQuery() {
        String string = "UPDATE LMT_SEM_VERB SET";
        string = string + " class = '" + Util.replaceSingleQuote(this.classes) + "'";
        string = string + " WHERE concept_id = '" + this.concept_id + "'";
        string = string + " AND semantic_id = '" + this.semantic_id + "'";
        return string;
    }
}

