/*
 * Decompiled with CFR 0.152.
 */
package lmt;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import lmt.Debug;
import oracle.jdbc.driver.OracleDriver;

public class SQLConnection {
    private Connection myConnection;
    private String myDriverName;
    private String myURL;
    private String username;
    private String password;
    private boolean connected = false;

    public SQLConnection(String string) {
        this.myURL = "jdbc:oracle:thin:LMTUSER/LMTU52574@" + string;
        this.username = "LMTUSER";
        this.password = "LMTU52574";
        this.myConnection = null;
    }

    public void close() {
        if (this.connected) {
            try {
                this.myConnection.close();
                this.myConnection = null;
                this.connected = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean connect() {
        if (this.connected) {
            return true;
        }
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            Debug.debug("-- registerDriver: success");
        }
        catch (Exception exception) {
            System.out.println("-- registerDriver fail");
            System.out.println("SQLException: " + exception.getMessage());
            this.connected = false;
            return false;
        }
        try {
            this.myConnection = DriverManager.getConnection(this.myURL, this.username, this.password);
            System.out.println("-- getConnection: success");
            this.connected = true;
            return true;
        }
        catch (SQLException sQLException) {
            System.out.println("-- getConnection fail");
            System.out.println("SQLException: " + sQLException.getMessage());
            this.connected = false;
            return false;
        }
    }

    public synchronized ResultSet query2(String string) {
        if (!this.connected && !this.connect()) {
            System.out.println("ResultSet is null because db is not connected");
            return null;
        }
        try {
            Statement statement = this.myConnection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            return resultSet;
        }
        catch (SQLException sQLException) {
            System.out.println("Error in JDBC connection");
            System.out.println("SQLException: " + sQLException.getMessage());
            return null;
        }
    }

    public synchronized Result query(String string) {
        if (!this.connected && !this.connect()) {
            System.out.println("ResultSet is null because db is not connected");
            return null;
        }
        try {
            Result result = new Result();
            result.s = this.myConnection.createStatement();
            result.rs = result.s.executeQuery(string);
            return result;
        }
        catch (SQLException sQLException) {
            System.out.println("Error in JDBC connection");
            System.out.println("SQLException: " + sQLException.getMessage());
            return null;
        }
    }

    public synchronized boolean callProcedure(String string, String string2) {
        try {
            String string3 = "{call " + string + "(?)}";
            CallableStatement callableStatement = this.myConnection.prepareCall(string3);
            callableStatement.setString(1, string2);
            callableStatement.execute();
            callableStatement.close();
            return true;
        }
        catch (SQLException sQLException) {
            System.out.println("Error in stored procedure");
            System.err.println("ERROR: " + sQLException);
            this.rollback();
            return false;
        }
    }

    public synchronized boolean transaction(String[] stringArray) {
        try {
            this.myConnection.setAutoCommit(false);
            Statement statement = this.myConnection.createStatement();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = statement.executeUpdate(stringArray[i]);
                    if (n != 0) continue;
                    statement.close();
                    this.rollback();
                    this.myConnection.setAutoCommit(true);
                    return false;
                }
            }
            this.myConnection.commit();
            this.myConnection.setAutoCommit(true);
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            System.out.println("Error in transaction");
            System.out.println("SQLException: " + sQLException.getMessage());
            this.rollback();
            this.setAutoCommit(true);
            return false;
        }
    }

    public synchronized boolean save(Vector vector) {
        try {
            this.myConnection.setAutoCommit(false);
            Statement statement = this.myConnection.createStatement();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    statement.executeUpdate((String)vector.elementAt(i));
                }
            }
            this.myConnection.commit();
            this.myConnection.setAutoCommit(true);
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            System.out.println("Error in transaction");
            System.out.println("SQLException: " + sQLException.getMessage());
            this.rollback();
            this.setAutoCommit(true);
            return false;
        }
    }

    public void setAutoCommit(boolean bl) {
        try {
            this.myConnection.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            System.out.println("Error in setAutoCommit");
            System.out.println("SQLException: " + sQLException.getMessage());
        }
    }

    public void commit() {
        try {
            this.myConnection.commit();
        }
        catch (SQLException sQLException) {
            System.out.println("Error in commit");
            System.out.println("SQLException: " + sQLException.getMessage());
        }
    }

    public void rollback() {
        try {
            this.myConnection.rollback();
            System.out.println("-- rollback");
        }
        catch (SQLException sQLException) {
            System.out.println("Error in rollback");
            System.out.println("SQLException: " + sQLException.getMessage());
        }
    }

    public void setTransactionIsolation(int n) {
        try {
            this.myConnection.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            System.out.println("Error in setTransactionIsolation");
            System.out.println("SQLException: " + sQLException.getMessage());
        }
    }

    public int insert(String string) {
        return this.update(string);
    }

    public int insert(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            n = this.updateQuery(stringArray[i]);
            if (n == 1) continue;
            return 2;
        }
        return 1;
    }

    public int delete(String string) {
        return this.update(string);
    }

    public synchronized int update(String string) {
        if (!this.connected && !this.connect()) {
            return 8;
        }
        try {
            Statement statement = this.myConnection.createStatement();
            Debug.debug("-- " + string);
            int n = statement.executeUpdate(string);
            statement.close();
            if (n == 1) {
                return 1;
            }
            return 2;
        }
        catch (SQLException sQLException) {
            System.out.println("update: Error in JDBC connection");
            System.out.println("message: " + sQLException.getMessage());
            return 2;
        }
    }

    public synchronized int update(Vector vector) {
        if (!this.connected && !this.connect()) {
            return 8;
        }
        try {
            this.myConnection.setAutoCommit(false);
            this.myConnection.setTransactionIsolation(8);
            Statement statement = this.myConnection.createStatement();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Debug.debug("-- " + vector.elementAt(i));
                    int n = statement.executeUpdate((String)vector.elementAt(i));
                    if (n == 1) continue;
                    this.myConnection.rollback();
                    this.myConnection.setAutoCommit(true);
                    statement.close();
                    return 2;
                }
            }
            this.myConnection.commit();
            this.myConnection.setAutoCommit(true);
            statement.close();
            return 1;
        }
        catch (SQLException sQLException) {
            System.out.println("Error in transaction");
            System.out.println("SQLException: " + sQLException.getMessage());
            this.rollback();
            this.setAutoCommit(true);
            return 2;
        }
    }

    public synchronized int updateQuery(String string) {
        if (!this.connected && !this.connect()) {
            return 8;
        }
        try {
            Statement statement = this.myConnection.createStatement();
            int n = statement.executeUpdate(string);
            statement.close();
            return n;
        }
        catch (SQLException sQLException) {
            System.out.println("update: Error in JDBC connection");
            System.out.println("SQLException: " + sQLException.getMessage());
            return -1;
        }
    }

    public synchronized boolean isExistent(String string) {
        if (!this.connected && !this.connect()) {
            return false;
        }
        try {
            boolean bl;
            Statement statement = this.myConnection.createStatement();
            if (statement == null) {
                return false;
            }
            ResultSet resultSet = statement.executeQuery(string);
            boolean bl2 = bl = resultSet != null && resultSet.next();
            if (resultSet != null) {
                resultSet.close();
            }
            statement.close();
            return bl;
        }
        catch (SQLException sQLException) {
            System.out.println("Error in transaction");
            System.out.println("SQLException: " + sQLException.getMessage());
            return false;
        }
    }

    public synchronized String getNewID(String string) {
        String string2 = "";
        String string3 = "SELECT " + string + ".NEXTVAL FROM DUAL";
        if (!this.connected && !this.connect()) {
            System.out.println("Error in generating a new id because the socket is not connected");
            return string2;
        }
        try {
            Statement statement = this.myConnection.createStatement();
            if (statement == null) {
                return "";
            }
            ResultSet resultSet = statement.executeQuery(string3);
            if (resultSet != null && resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            if (resultSet != null) {
                resultSet.close();
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("Error in transaction");
            System.out.println("SQLException: " + sQLException.getMessage());
        }
        Debug.debug("-- " + string3);
        Debug.debug("-- new " + string + ":" + string2);
        return string2;
    }

    public class Result {
        private Statement s;
        public ResultSet rs;

        public boolean hasData() {
            try {
                return this.rs != null && this.rs.next();
            }
            catch (SQLException sQLException) {
                return false;
            }
        }

        public void close() {
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                if (this.s != null) {
                    this.s.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

