/*
 * Decompiled with CFR 0.152.
 */
package lmt;

import java.sql.SQLException;
import java.util.Vector;
import lmt.Concept;
import lmt.Debug;
import lmt.Definition;
import lmt.SQLConnection;
import lmt.Term;
import lmt.Util;

public class PendingTerm {
    public static final String STATUS_ACCEPT = "A";
    public static final String STATUS_REJECT = "R";
    public static final String STATUS_PENDING = "P";
    String term_id = "";
    String term_string = "";
    String status = "";
    String alternative = "";
    String username = "";
    String source = "";
    String active = "";
    Vector examples = new Vector();
    SQLConnection con;

    public PendingTerm(SQLConnection sQLConnection) {
        this();
        this.con = sQLConnection;
    }

    public PendingTerm() {
    }

    public String getTermID() {
        return this.term_id;
    }

    void setTermID(String string) {
        if (string == null) {
            string = "";
        }
        this.term_id = string;
    }

    public String getTermString() {
        return this.term_string;
    }

    public void setTermString(String string) {
        if (string == null) {
            string = "";
        }
        this.term_string = string;
    }

    public void setStatus(String string) {
        if (string == null) {
            string = "";
        }
        this.status = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setAlternative(String string) {
        if (string == null) {
            string = "";
        }
        this.alternative = string;
    }

    public String getAlternative() {
        return this.alternative;
    }

    public void setUserName(String string) {
        if (string == null) {
            string = "";
        }
        this.username = string;
    }

    public String getUserName() {
        return this.username;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        if (string == null) {
            string = "";
        }
        this.source = string;
    }

    public void setActive(String string) {
        if (string == null) {
            string = "";
        }
        this.active = string;
    }

    public String getActive() {
        return this.active;
    }

    public void setExamples(Vector vector) {
        this.examples = vector;
    }

    public Vector getExamples() {
        return this.examples;
    }

    public SQLConnection getConn() {
        return this.con;
    }

    public synchronized Vector fetchTerms(String string) {
        String string2 = "SELECT * FROM LMT_PENDING_TERMS WHERE status = '" + string + "'";
        string2 = string2 + " ORDER BY term_string";
        Vector<PendingTerm> vector = new Vector<PendingTerm>();
        try {
            SQLConnection.Result result = this.con.query(string2);
            while (result != null && result.hasData()) {
                PendingTerm pendingTerm = new PendingTerm(this.con);
                pendingTerm.setTermID(result.rs.getString(1));
                pendingTerm.setTermString(result.rs.getString(2));
                pendingTerm.setStatus(result.rs.getString(3));
                pendingTerm.setAlternative(result.rs.getString(4));
                pendingTerm.setUserName(result.rs.getString(5));
                pendingTerm.setSource(result.rs.getString(6));
                pendingTerm.setActive(result.rs.getString(7));
                vector.addElement(pendingTerm);
            }
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
        Debug.debug("-- fetch pending terms: " + string2);
        Debug.debug("   size of pending terms: " + vector.size());
        return vector;
    }

    public synchronized Vector fetchExamples() {
        return this.fetchExamples(this.term_id);
    }

    private synchronized Vector fetchExamples(String string) {
        String string2 = "SELECT context_id, example FROM lmt_pending_term_contexts ";
        string2 = string2 + " WHERE pending_term_id = '" + string + "'";
        Vector<Context> vector = new Vector<Context>();
        try {
            SQLConnection.Result result = this.con.query(string2);
            while (result != null && result.hasData()) {
                Context context = new Context();
                context.setContextID(result.rs.getString(1));
                context.setExample(result.rs.getString(2));
                vector.addElement(context);
            }
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
        Debug.debug("-- getTermExamples: " + string2);
        return vector;
    }

    public synchronized boolean updateTermStatus(String string) {
        Debug.debug("-- updateTerm");
        String string2 = "UPDATE LMT_PENDING_TERMS SET status = '" + string + "' ";
        string2 = string2 + "WHERE pending_term_id = '" + this.term_id + "'";
        Debug.debug("-- " + string2);
        System.out.println("-- " + string2);
        int n = this.con.update(string2);
        return n == 1;
    }

    public synchronized boolean updateAlternativeTerm(String string) {
        Debug.debug("-- updateTerm");
        String string2 = "UPDATE LMT_PENDING_TERMS SET alternative = '" + string + "' ";
        string2 = string2 + "WHERE pending_term_id = '" + this.term_id + "'";
        Debug.debug("-- " + string2);
        int n = this.con.update(string2);
        return n == 1;
    }

    public boolean isExistent() {
        String string = "SELECT * FROM LMT_PENDING_TERMS";
        string = string + " WHERE term_string = '" + this.term_string + "'";
        return this.con.isExistent(string);
    }

    public boolean isExistentInLMT() {
        String string = "SELECT * FROM LMT_TERMS";
        string = string + " WHERE term_string = '" + this.term_string + "'";
        return this.con.isExistent(string);
    }

    public int acceptTerm(Term term) {
        int n;
        String string = this.con.getNewID("TERM_ID");
        term.setTermID(string);
        Concept concept = new Concept(term.getConn(), term.getPos());
        String string2 = this.con.getNewID("CONCEPT_ID");
        concept.setConceptID(string2);
        concept.setTermID(string);
        concept.setCteEntry("T");
        concept.setDateCreated(Util.getTime());
        concept.setDateUpdated(concept.getDateCreated());
        concept.setAuthorCreating(this.username);
        concept.setAuthorUpdating(this.username);
        concept.setAmbiguity("N");
        concept.setConceptSymbol(Concept.generateConceptSymbol(term));
        concept.setSource(this.source);
        if (term.isDuplicate()) {
            return 3;
        }
        if (concept.isDuplicate()) {
            return 3;
        }
        Definition definition = new Definition(term.getConn(), string2);
        String string3 = this.con.getNewID("DEFINITION_ID");
        definition.setConceptID(string2);
        definition.setDefinitionID(string3);
        definition.setUsageDefinition("no definition");
        definition.setCteUsage("T");
        String[] stringArray = new String[this.examples.size()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            Context context = (Context)this.examples.elementAt(n2);
            stringArray[n2] = "INSERT INTO LMT_EXAMPLES VALUES (";
            int n3 = n2;
            stringArray[n3] = stringArray[n3] + "'" + this.con.getNewID("EXAMPLE_ID") + "',";
            int n4 = n2;
            stringArray[n4] = stringArray[n4] + "'" + string3 + "',";
            int n5 = n2;
            stringArray[n5] = stringArray[n5] + "'" + Util.replaceSingleQuote(context.getExample()) + "',";
            int n6 = n2++;
            stringArray[n6] = stringArray[n6] + "'T')";
        }
        String[] stringArray2 = new String[4 + stringArray.length];
        stringArray2[0] = "UPDATE LMT_PENDING_TERMS SET status = 'A', term_string = '" + Util.replaceSingleQuote(this.term_string) + "' WHERE pending_term_id = '" + this.term_id + "'";
        stringArray2[1] = term.makeInsertQuery();
        stringArray2[2] = concept.makeInsertQuery();
        stringArray2[3] = definition.makeInsertQuery();
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n + 4] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            Debug.debug("-- " + stringArray2[n]);
        }
        n = this.con.transaction(stringArray2) ? 1 : 0;
        if (n == 0) {
            return 2;
        }
        if (term.isNounPhrase()) {
            term.copyFeatures();
        }
        return 1;
    }

    public int insert() {
        int n;
        if (this.isExistent()) {
            return 3;
        }
        String[] stringArray = new String[1 + this.examples.size()];
        this.term_id = this.con.getNewID("PENDING_TERM_ID");
        stringArray[0] = "INSERT INTO LMT_PENDING_TERMS VALUES (";
        stringArray[0] = stringArray[0] + "'" + this.term_id + "',";
        stringArray[0] = stringArray[0] + "'" + Util.replaceSingleQuote(this.term_string) + "',";
        stringArray[0] = stringArray[0] + "'" + this.status + "',";
        stringArray[0] = stringArray[0] + "'" + this.alternative + "',";
        stringArray[0] = stringArray[0] + "'" + this.username + "',";
        stringArray[0] = stringArray[0] + "'" + this.source + "',";
        stringArray[0] = stringArray[0] + "'" + this.active + "')";
        for (n = 0; n < this.examples.size(); ++n) {
            Context context = (Context)this.examples.elementAt(n);
            context.setContextID(this.con.getNewID("CONTEXT_ID"));
            stringArray[n + 1] = "INSERT INTO LMT_PENDING_TERM_CONTEXTS VALUES (";
            int n2 = n + 1;
            stringArray[n2] = stringArray[n2] + "'" + context.getContextID() + "',";
            int n3 = n + 1;
            stringArray[n3] = stringArray[n3] + "'" + this.term_id + "',";
            int n4 = n + 1;
            stringArray[n4] = stringArray[n4] + "'" + context.getExample() + "',";
            int n5 = n + 1;
            stringArray[n5] = stringArray[n5] + "'" + this.active + "')";
        }
        n = this.con.transaction(stringArray) ? 1 : 0;
        return n != 0 ? 1 : 2;
    }

    public boolean delete() {
        Debug.debug("-- Term deleted: term_id - " + this.term_id);
        String[] stringArray = new String[2];
        stringArray[0] = "DELETE FROM LMT_PENDING_TERM_CONTEXTS ";
        stringArray[0] = stringArray[0] + "WHERE PENDING_TERM_ID = '" + this.term_id + "'";
        stringArray[1] = "DELETE FROM LMT_PENDING_TERMS ";
        stringArray[1] = stringArray[1] + "WHERE pending_term_id = '" + this.term_id + "'";
        for (int i = 0; i < stringArray.length; ++i) {
            Debug.debug("-- sql: " + stringArray[i]);
        }
        return this.con.transaction(stringArray);
    }

    public boolean update() {
        int n;
        String[] stringArray = new String[1 + this.examples.size()];
        stringArray[0] = this.makeUpdateQuery();
        for (n = 0; n < this.examples.size(); ++n) {
            Context context = (Context)this.examples.elementAt(n);
            stringArray[n + 1] = "UPDATE LMT_PENDING_TERM_CONTEXTS SET ";
            int n2 = n + 1;
            stringArray[n2] = stringArray[n2] + " example = '" + context.getExample() + "'";
            int n3 = n + 1;
            stringArray[n3] = stringArray[n3] + " WHERE context_id ='" + context.getContextID() + "'";
            int n4 = n + 1;
            stringArray[n4] = stringArray[n4] + " AND   pending_term_id ='" + this.term_id + "'";
        }
        for (n = 0; n < stringArray.length; ++n) {
            Debug.debug("-- sql: " + stringArray[n]);
        }
        return this.con.transaction(stringArray);
    }

    public boolean updateTermString() {
        String string = "UPDATE LMT_PENDING_TERMS SET";
        string = string + " term_string = '" + Util.replaceSingleQuote(this.term_string) + "'";
        return this.con.update(string = string + " WHERE pending_term_id ='" + this.term_id + "'") == 1;
    }

    String makeUpdateQuery() {
        String string = "UPDATE LMT_PENDING_TERMS SET";
        string = string + " term_string = '" + Util.replaceSingleQuote(this.term_string) + "',";
        string = string + " status = '" + this.status + "',";
        string = string + " alternative = '" + this.alternative + "',";
        string = string + " username = '" + this.username + "', ";
        string = string + " source = '" + this.source + "'";
        string = string + " WHERE pending_term_id ='" + this.term_id + "'";
        return string;
    }

    public synchronized Vector fetchTerms() {
        String string = "SELECT pending_term_id FROM LMT_PENDING_TERMS WHERE term_string = '" + this.term_string + "'";
        Vector<PendingTerm> vector = new Vector<PendingTerm>();
        try {
            SQLConnection.Result result = this.con.query(string);
            while (result != null && result.hasData()) {
                PendingTerm pendingTerm = new PendingTerm(this.con);
                pendingTerm.setTermID(result.rs.getString(1));
                vector.addElement(pendingTerm);
            }
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
        Debug.debug("-- fetchTerms: " + string);
        return vector;
    }

    public synchronized Vector searchTerms(String string, String string2) {
        String string3 = "SELECT pending_term_id, term_string FROM LMT_PENDING_TERMS WHERE ";
        string3 = string.indexOf("%%") >= 0 ? string3 + "term_string LIKE '%\\%%' escape '\\'" : (string.indexOf("%") >= 0 || string.indexOf("_") >= 0 ? string3 + "term_string LIKE '" + Util.replaceSingleQuote(string) + "'" : string3 + "term_string = '" + Util.replaceSingleQuote(string) + "'");
        string3 = string3 + " and status = '" + string2 + "' order by term_string";
        Vector<PendingTerm> vector = new Vector<PendingTerm>();
        try {
            SQLConnection.Result result = this.con.query(string3);
            while (result != null && result.hasData()) {
                PendingTerm pendingTerm = new PendingTerm(this.con);
                pendingTerm.setTermID(result.rs.getString(1));
                pendingTerm.setTermString(result.rs.getString(2));
                vector.addElement(pendingTerm);
            }
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
        Debug.debug("-- fetchTerms: " + string3);
        return vector;
    }

    public class Context {
        String context_id = "";
        String pending_term_id = "";
        String example = "";
        String active = "T";

        Context() {
        }

        public String getContextID() {
            return this.context_id;
        }

        public void setContextID(String string) {
            if (string == null) {
                string = "";
            }
            this.context_id = string;
        }

        public String getExample() {
            return this.example;
        }

        public void setExample(String string) {
            if (string == null) {
                string = "";
            }
            this.example = string;
        }
    }
}

