/*
 * Decompiled with CFR 0.152.
 */
package lmt;

import java.sql.SQLException;
import java.util.Vector;
import lmt.Concept;
import lmt.Debug;
import lmt.MorphAdj;
import lmt.MorphNoun;
import lmt.MorphVerb;
import lmt.Morphology;
import lmt.SQLConnection;
import lmt.Term;
import lmt.Util;

public class NCRI {
    String ncri_id;
    String concept_id;
    String ncri_term_string;
    String ncri_pos;
    String ncri_concept_symbol;
    String ncri_type_phrase;
    String ncri_phrase_head;
    String active;
    Morphology morph;
    SQLConnection con;

    public NCRI(SQLConnection sQLConnection) {
        this.con = sQLConnection;
        this.ncri_id = "";
        this.concept_id = "";
        this.ncri_term_string = "";
        this.ncri_pos = "";
        this.ncri_concept_symbol = "*NCRI";
        this.ncri_type_phrase = "";
        this.ncri_phrase_head = "";
        this.active = "T";
        this.morph = null;
    }

    public NCRI(Term term, Concept concept, SQLConnection sQLConnection) {
        this(sQLConnection);
        this.concept_id = concept.getConceptID();
        this.ncri_term_string = term.getTermString();
        this.ncri_pos = term.getPos();
        this.ncri_type_phrase = term.getTypePhrase();
        this.ncri_phrase_head = term.getPhraseHead();
    }

    public String getNcriID() {
        return this.ncri_id;
    }

    public void setNcriID(String string) {
        if (string == null) {
            string = "";
        }
        this.ncri_id = string;
    }

    public String getConceptID() {
        return this.concept_id;
    }

    public void setConceptID(String string) {
        if (string == null) {
            string = "";
        }
        this.concept_id = string;
    }

    public String getNcriTermString() {
        return this.ncri_term_string;
    }

    public void setNcriTermString(String string) {
        if (string == null) {
            string = "";
        }
        this.ncri_term_string = string;
    }

    public String getNcriPos() {
        return this.ncri_pos;
    }

    public void setNcriPos(String string) {
        if (string == null) {
            string = "";
        }
        this.ncri_pos = string;
    }

    public String getNcriConceptSymbol() {
        return this.ncri_concept_symbol;
    }

    public void setNcriConceptSymbol(String string) {
        if (string == null) {
            string = "";
        }
        this.ncri_concept_symbol = string;
    }

    public String getNcriTypePhrase() {
        return this.ncri_type_phrase;
    }

    public void setNcriTypePhrase(String string) {
        if (string == null) {
            string = "";
        }
        this.ncri_type_phrase = string;
    }

    public String getNcriPhraseHead() {
        return this.ncri_phrase_head;
    }

    public void setNcriPhraseHead(String string) {
        this.ncri_phrase_head = string == null ? "" : string;
    }

    public void setMorphology(Morphology morphology) {
        this.morph = morphology;
    }

    public void setActive(String string) {
        this.active = string;
    }

    public Morphology getMorphology() {
        this.morph = Morphology.fetchMorph(this.con, this.ncri_pos, "-" + this.ncri_id);
        if (this.morph == null) {
            if (this.ncri_pos.equals("ADJ") || this.ncri_pos.equals("ADVERB")) {
                this.morph = new MorphAdj(this.con, "-" + this.ncri_id);
            } else if (this.ncri_pos.equals("VERB") || this.ncri_pos.equals("AUX")) {
                this.morph = new MorphVerb(this.con, "-" + this.ncri_id);
            } else if (this.ncri_pos.equals("NOUN") || this.ncri_pos.equals("PROP") || this.ncri_pos.equals("UNIT")) {
                this.morph = new MorphNoun(this.con, "-" + this.ncri_id);
            }
        }
        return this.morph;
    }

    public static Vector fetchNCRI(SQLConnection sQLConnection, String string) {
        Vector<NCRI> vector = new Vector<NCRI>();
        String string2 = "SELECT * FROM LMT_NCRI WHERE ";
        string2 = string2 + " CONCEPT_ID = '" + string + "'";
        string2 = string2 + " ORDER BY NCRI_ID";
        try {
            SQLConnection.Result result = sQLConnection.query(string2);
            while (result != null && result.hasData()) {
                NCRI nCRI = new NCRI(sQLConnection);
                nCRI.setNcriID(result.rs.getString(1));
                nCRI.setConceptID(result.rs.getString(2));
                nCRI.setNcriTermString(result.rs.getString(3));
                nCRI.setNcriPos(Term.changePosForUI(result.rs.getString(4)));
                nCRI.setNcriConceptSymbol(result.rs.getString(5));
                nCRI.setNcriTypePhrase(result.rs.getString(6));
                nCRI.setNcriPhraseHead(result.rs.getString(7));
                nCRI.setActive(result.rs.getString(8));
                vector.addElement(nCRI);
                nCRI.getMorphology();
            }
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            Debug.debug("SQLException: " + sQLException.getMessage());
        }
        Debug.debug("-- fetchNCRI: " + string2);
        return vector;
    }

    public int insert() {
        if (this.isDuplicate()) {
            return 3;
        }
        this.ncri_id = this.con.getNewID("NCRI_ID");
        String string = "INSERT INTO LMT_NCRI VALUES (";
        string = string + "'" + this.ncri_id + "',";
        string = string + "'" + this.concept_id + "',";
        string = string + "'" + Util.replaceSingleQuote(this.ncri_term_string) + "',";
        string = string + "'" + Term.changePosForDB(this.ncri_pos) + "',";
        string = string + "'" + this.ncri_concept_symbol + "',";
        string = string + "'" + this.ncri_type_phrase + "',";
        string = string + "'" + this.ncri_phrase_head + "',";
        string = string + "'" + this.active + "')";
        Debug.debug("-- NCRI insertion : " + string);
        return this.con.insert(string);
    }

    public int delete() {
        boolean bl = this.con.callProcedure("DeleteNCRI", this.ncri_id);
        Debug.debug("-- delete ncri: " + bl);
        if (bl) {
            return 1;
        }
        return 2;
    }

    public int update() {
        if (!this.isExistent()) {
            return 4;
        }
        String string = "UPDATE LMT_NCRI SET";
        string = string + " ncri_term_string = '" + Util.replaceSingleQuote(this.ncri_term_string) + "',";
        string = string + " ncri_pos = '" + Term.changePosForDB(this.ncri_pos) + "',";
        string = string + " ncri_concept_symbol = '" + this.ncri_concept_symbol + "',";
        string = string + " ncri_type_phrase = '" + this.ncri_type_phrase + "',";
        string = string + " ncri_phrase_head = '" + this.ncri_phrase_head + "'";
        string = string + " WHERE concept_id = '" + this.concept_id + "'";
        string = string + " AND ncri_id = '" + this.ncri_id + "'";
        Debug.debug("-- NCRI update : " + string);
        return this.con.update(string);
    }

    public static int update(SQLConnection sQLConnection, Vector vector) {
        Vector vector2 = new Vector();
        NCRI.makeQuery(vector2, vector);
        return sQLConnection.update(vector2);
    }

    public boolean isExistent() {
        String string = "SELECT * FROM LMT_NCRI WHERE ";
        string = string + " concept_id = '" + this.concept_id + "'";
        string = string + " AND ncri_id = '" + this.ncri_id + "'";
        return this.con.isExistent(string);
    }

    public boolean isDuplicate() {
        String string = "SELECT * FROM LMT_NCRI WHERE ";
        string = string + " ncri_term_string = '" + Util.replaceSingleQuote(this.ncri_term_string) + "'";
        string = string + " AND ncri_pos = '" + Term.changePosForDB(this.ncri_pos) + "'";
        string = string + " AND concept_id = '" + this.concept_id + "'";
        return this.con.isExistent(string);
    }

    public static void makeQuery(Vector vector, Vector vector2) {
        if (vector2 == null) {
            return;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            NCRI nCRI = (NCRI)vector2.elementAt(i);
            String string = "UPDATE LMT_NCRI SET";
            string = string + " ncri_term_string = '" + Util.replaceSingleQuote(nCRI.getNcriTermString()) + "',";
            string = string + " ncri_pos = '" + Term.changePosForDB(nCRI.getNcriPos()) + "',";
            string = string + " ncri_concept_symbol = '" + nCRI.getNcriConceptSymbol() + "',";
            string = string + " ncri_type_phrase = '" + nCRI.getNcriTypePhrase() + "',";
            string = string + " ncri_phrase_head = '" + nCRI.getNcriPhraseHead() + "'";
            string = string + " WHERE concept_id = '" + nCRI.getConceptID() + "'";
            string = string + " AND ncri_id = '" + nCRI.getNcriID() + "'";
            vector.addElement(string);
            if (nCRI.morph == null) continue;
            nCRI.morph.setConceptID("-" + nCRI.getNcriID());
            nCRI.morph.makeQuery(vector, nCRI.getNcriPos());
        }
    }
}

