/*
 * Decompiled with CFR 0.152.
 */
package lmt;

import java.sql.SQLException;
import java.util.Vector;
import lmt.Debug;
import lmt.Morphology;
import lmt.SQLConnection;
import lmt.Util;

public class MorphNoun
extends Morphology {
    String plural;
    String gensg;
    String genpl;
    String irr_plural;
    String irr_gensg;
    String irr_genpl;
    SQLConnection con;

    public MorphNoun(SQLConnection sQLConnection, String string) {
        this.con = sQLConnection;
        this.concept_id = string;
        this.plural = "";
        this.gensg = "";
        this.genpl = "";
        this.irr_plural = "";
        this.irr_gensg = "";
        this.irr_genpl = "";
    }

    public String getPlural() {
        return this.plural;
    }

    public void setPlural(String string) {
        if (string == null) {
            string = "";
        }
        this.plural = string;
    }

    public String getGensg() {
        return this.gensg;
    }

    public void setGensg(String string) {
        if (string == null) {
            string = "";
        }
        this.gensg = string;
    }

    public String getGenpl() {
        return this.genpl;
    }

    public void setGenpl(String string) {
        if (string == null) {
            string = "";
        }
        this.genpl = string;
    }

    public String getIrrPlural() {
        return this.irr_plural;
    }

    public void setIrrPlural(String string) {
        if (string == null) {
            string = "";
        }
        this.irr_plural = string;
    }

    public String getIrrGensg() {
        return this.irr_gensg;
    }

    public void setIrrGensg(String string) {
        if (string == null) {
            string = "";
        }
        this.irr_gensg = string;
    }

    public String getIrrGenpl() {
        return this.irr_genpl;
    }

    public void setIrrGenpl(String string) {
        if (string == null) {
            string = "";
        }
        this.irr_genpl = string;
    }

    public static MorphNoun fetchMorph(SQLConnection sQLConnection, String string) {
        MorphNoun morphNoun = new MorphNoun(sQLConnection, string);
        try {
            String string2 = "SELECT * FROM LMT_MORPH_NOUN_PU WHERE ";
            string2 = string2 + " CONCEPT_ID = '" + string + "'";
            Debug.debug("-- fetchMorphNoun : " + string2);
            SQLConnection.Result result = sQLConnection.query(string2);
            if (result != null && result.hasData()) {
                morphNoun.setPlural(result.rs.getString(2));
                morphNoun.setGensg(result.rs.getString(3));
                morphNoun.setGenpl(result.rs.getString(4));
                morphNoun.setActive(result.rs.getString(5));
            }
            if (result != null) {
                result.close();
            }
            string2 = "SELECT * FROM LMT_IRR_MORPH_NOUN_PU WHERE";
            string2 = string2 + " CONCEPT_ID = '" + string + "'";
            Debug.debug("-- fetchIrrMorphNoun : " + string2);
            result = sQLConnection.query(string2);
            if (result != null && result.hasData()) {
                morphNoun.setIrrPlural(result.rs.getString(2));
                morphNoun.setIrrGensg(result.rs.getString(3));
                morphNoun.setIrrGenpl(result.rs.getString(4));
                morphNoun.setIrrActive(result.rs.getString(5));
            }
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            Debug.debug("SQLException: " + sQLException.getMessage());
        }
        return morphNoun;
    }

    public int insert() {
        String[] stringArray = this.makeInsertQuery();
        Debug.debug("-- MorphNoun insertion : " + stringArray[0]);
        Debug.debug("-- MorphIrrNoun insertion : " + stringArray[1]);
        return this.con.insert(stringArray);
    }

    public int update() {
        if (!this.isExistent()) {
            return this.insert();
        }
        Vector vector = new Vector();
        this.makeQuery(vector);
        return this.con.update(vector);
    }

    public boolean isExistent() {
        String string = "SELECT * FROM LMT_MORPH_NOUN_PU WHERE ";
        string = string + " concept_id = '" + this.concept_id + "'";
        return this.con.isExistent(string);
    }

    public void makeQuery(Vector vector) {
        String[] stringArray = this.isExistent() ? this.makeUpdateQuery() : this.makeInsertQuery();
        vector.addElement(stringArray[0]);
        vector.addElement(stringArray[1]);
    }

    String[] makeInsertQuery() {
        String[] stringArray = new String[2];
        stringArray[0] = "INSERT INTO LMT_MORPH_NOUN_PU VALUES (";
        stringArray[0] = stringArray[0] + "'" + this.concept_id + "',";
        stringArray[0] = stringArray[0] + "'" + this.plural + "',";
        stringArray[0] = stringArray[0] + "'" + this.gensg + "',";
        stringArray[0] = stringArray[0] + "'" + this.genpl + "',";
        stringArray[0] = stringArray[0] + "'T')";
        stringArray[1] = "INSERT INTO LMT_IRR_MORPH_NOUN_PU VALUES (";
        stringArray[1] = stringArray[1] + "'" + this.concept_id + "',";
        stringArray[1] = stringArray[1] + "'" + Util.replaceSingleQuote(this.irr_plural) + "',";
        stringArray[1] = stringArray[1] + "'" + Util.replaceSingleQuote(this.irr_gensg) + "',";
        stringArray[1] = stringArray[1] + "'" + Util.replaceSingleQuote(this.irr_genpl) + "',";
        stringArray[1] = stringArray[1] + "'T')";
        return stringArray;
    }

    String[] makeUpdateQuery() {
        String[] stringArray = new String[2];
        stringArray[0] = "UPDATE LMT_MORPH_NOUN_PU SET";
        stringArray[0] = stringArray[0] + " plural = '" + this.plural + "',";
        stringArray[0] = stringArray[0] + " gensg = '" + this.gensg + "',";
        stringArray[0] = stringArray[0] + " genpl = '" + this.genpl + "'";
        stringArray[0] = stringArray[0] + " WHERE concept_id = '" + this.concept_id + "'";
        stringArray[1] = "UPDATE LMT_IRR_MORPH_NOUN_PU SET";
        stringArray[1] = stringArray[1] + " plural_string = '" + Util.replaceSingleQuote(this.irr_plural) + "',";
        stringArray[1] = stringArray[1] + " gensg_string = '" + Util.replaceSingleQuote(this.irr_gensg) + "',";
        stringArray[1] = stringArray[1] + " genpl_string = '" + Util.replaceSingleQuote(this.irr_genpl) + "'";
        stringArray[1] = stringArray[1] + " WHERE concept_id = '" + this.concept_id + "'";
        return stringArray;
    }

    public MorphNoun cloneMorph() {
        MorphNoun morphNoun = new MorphNoun(this.con, this.concept_id);
        morphNoun.setPlural(this.plural);
        morphNoun.setGensg(this.gensg);
        morphNoun.setGenpl(this.genpl);
        morphNoun.setIrrPlural(this.irr_plural);
        morphNoun.setIrrGensg(this.irr_gensg);
        morphNoun.setIrrGenpl(this.irr_genpl);
        return morphNoun;
    }
}

