/*
 * Decompiled with CFR 0.152.
 */
package lmt;

import java.sql.SQLException;
import java.util.Vector;
import lmt.Debug;
import lmt.Example;
import lmt.RelatedTerm;
import lmt.SQLConnection;
import lmt.Util;

public class Definition {
    String definition_id;
    String concept_id;
    String usage_definition;
    String cte_usage;
    String audience;
    String active;
    Vector relatedTerms;
    Vector examples;
    SQLConnection con;

    public Definition(SQLConnection sQLConnection, String string) {
        this.con = sQLConnection;
        this.definition_id = "";
        this.concept_id = string;
        this.usage_definition = "";
        this.cte_usage = "";
        this.audience = "";
        this.active = "";
        this.examples = new Vector();
        this.relatedTerms = new Vector();
    }

    public String getDefinitionID() {
        return this.definition_id;
    }

    public void setDefinitionID(String string) {
        if (string == null) {
            string = "";
        }
        this.definition_id = string;
    }

    public String getConceptID() {
        return this.concept_id;
    }

    public void setConceptID(String string) {
        if (string == null) {
            string = "";
        }
        this.concept_id = string;
    }

    public String getUsageDefinition() {
        return this.usage_definition;
    }

    public void setUsageDefinition(String string) {
        if (string == null) {
            string = "";
        }
        this.usage_definition = string;
    }

    public String getCteUsage() {
        return this.cte_usage;
    }

    public void setCteUsage(String string) {
        if (string == null) {
            string = "";
        }
        this.cte_usage = string;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String string) {
        if (string == null) {
            string = "";
        }
        this.audience = string;
    }

    public void setActive(String string) {
        this.active = string;
    }

    public Vector getExamples() {
        if (this.examples == null) {
            this.examples = Example.fetch(this.con, this.definition_id);
        }
        return this.examples;
    }

    public void setExamples(Vector vector) {
        this.examples = vector;
    }

    public Vector getRelatedTerms() {
        if (this.relatedTerms == null) {
            this.relatedTerms = RelatedTerm.fetch(this.con, this.definition_id);
        }
        return this.relatedTerms;
    }

    public void setRelatedTerms(Vector vector) {
        this.relatedTerms = vector;
    }

    public static Vector fetchDefinitions(SQLConnection sQLConnection, String string) {
        Vector<Definition> vector = new Vector<Definition>();
        String string2 = "SELECT * FROM LMT_DEFINITIONS WHERE ";
        string2 = string2 + " CONCEPT_ID = '" + string + "'";
        string2 = string2 + " ORDER BY DEFINITION_ID";
        Debug.debug("-- fetchDefinitions: " + string2);
        try {
            SQLConnection.Result result = sQLConnection.query(string2);
            while (result != null && result.hasData()) {
                Definition definition = new Definition(sQLConnection, string);
                String string3 = result.rs.getString(1);
                definition.setDefinitionID(string3);
                definition.setUsageDefinition(result.rs.getString(3));
                definition.setCteUsage(result.rs.getString(4));
                definition.setAudience(result.rs.getString(5));
                definition.setActive(result.rs.getString(6));
                definition.setExamples(Example.fetch(sQLConnection, string3));
                definition.setRelatedTerms(RelatedTerm.fetch(sQLConnection, string3));
                vector.addElement(definition);
            }
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            Debug.debug("SQLException(in fetchDefinitions): " + sQLException.getMessage());
        }
        return vector;
    }

    public int insert() {
        if (this.isCteSelected() && this.cte_usage.equals("T")) {
            return 3;
        }
        this.definition_id = this.con.getNewID("DEFINITION_ID");
        this.active = "T";
        String string = "INSERT INTO LMT_DEFINITIONS VALUES (";
        string = string + "'" + this.definition_id + "',";
        string = string + "'" + this.concept_id + "',";
        string = string + "'" + Util.replaceSingleQuote(this.usage_definition) + "',";
        string = string + "'" + this.cte_usage + "',";
        string = string + "'" + this.audience + "',";
        string = string + "'" + this.active + "')";
        Debug.debug("-- Definition insertion : " + string);
        return this.con.insert(string);
    }

    public int delete() {
        if (!this.isExistent()) {
            return 4;
        }
        Debug.debug("-- Definition delete : ");
        boolean bl = this.con.callProcedure("DeleteUsage", this.definition_id);
        if (bl) {
            if (this.relatedTerms != null) {
                this.relatedTerms.removeAllElements();
            }
            if (this.examples != null) {
                this.examples.removeAllElements();
            }
            return 1;
        }
        return 2;
    }

    public static int update(SQLConnection sQLConnection, Vector vector) {
        if (vector == null || vector.size() == 0) {
            return 1;
        }
        Vector vector2 = new Vector();
        Definition.makeQuery(vector2, vector);
        return sQLConnection.update(vector2);
    }

    public boolean isExistent() {
        String string = "SELECT * FROM LMT_DEFINITIONS WHERE ";
        string = string + " concept_id = '" + this.concept_id + "'";
        string = string + " AND definition_id = '" + this.definition_id + "'";
        return this.con.isExistent(string);
    }

    public boolean isCteSelected() {
        String string = "SELECT * FROM LMT_DEFINITIONS ";
        string = string + " WHERE concept_id = '" + this.concept_id + "'";
        string = string + " AND cte_usage = 'T'";
        string = string + " AND NOT(definition_id = '" + this.definition_id + "')";
        Debug.debug("-- isOneCte : " + string);
        return this.con.isExistent(string);
    }

    public static void makeQuery(Vector vector, Vector vector2) {
        if (vector2 == null) {
            return;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            Definition definition = (Definition)vector2.elementAt(i);
            String string = "UPDATE LMT_DEFINITIONS SET";
            string = string + " usage_definition = '" + Util.replaceSingleQuote(definition.getUsageDefinition()) + "',";
            string = string + " cte_usage = '" + definition.getCteUsage() + "'";
            string = string + " WHERE concept_id = '" + definition.getConceptID() + "'";
            string = string + " AND definition_id = '" + definition.getDefinitionID() + "'";
            vector.addElement(string);
        }
    }

    public String makeInsertQuery() {
        String string = "INSERT INTO LMT_DEFINITIONS VALUES (";
        string = string + "'" + this.definition_id + "',";
        string = string + "'" + this.concept_id + "',";
        string = string + "'" + this.usage_definition + "',";
        string = string + "'" + this.cte_usage + "',";
        string = string + "'" + this.audience + "',";
        string = string + "'" + this.active + "')";
        return string;
    }
}

